/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.KnowledgeBaseFactoryService;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.definition.process.Process;
import org.drools.definition.process.WorkflowProcess;
import org.drools.event.process.DefaultProcessEventListener;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.process.ProcessStartedEvent;
import org.drools.event.process.ProcessVariableChangedEvent;
import org.drools.impl.KnowledgeBaseFactoryServiceImpl;
import org.drools.io.ResourceFactory;
import org.drools.process.core.datatype.impl.type.ObjectDataType;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.drools.xml.SemanticModule;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.core.Association;
import org.jbpm.bpmn2.core.DataStore;
import org.jbpm.bpmn2.core.Definitions;
import org.jbpm.bpmn2.handler.ReceiveTaskHandler;
import org.jbpm.bpmn2.handler.SendTaskHandler;
import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNExtensionsSemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleBPMNProcessTest
extends JbpmBpmn2TestCase {
    private Logger logger = LoggerFactory.getLogger(SimpleBPMNProcessTest.class);

    protected void setUp() {
        String testName = this.getName();
        if (testName.startsWith("testEventBasedSplit") || testName.startsWith("testTimerBoundaryEvent") || testName.startsWith("testIntermediateCatchEventTimer") || testName.startsWith("testTimerStart")) {
            this.persistence = false;
        }
        super.setUp();
    }

    public void testMinimalProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Minimal");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testMinimalProcessImplicit() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcessImplicit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Minimal");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testImplicitEndParallel() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ParallelSplit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testMinimalProcessWithGraphical() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcessWithGraphical.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Minimal");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testMinimalProcessWithDIGraphical() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcessWithDIGraphical.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Minimal");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testCompositeProcessWithDIGraphical() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-CompositeProcessWithDIGraphical.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Composite");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testScriptTask() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ScriptTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testImport() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-Import.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Import");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testRuleTask() throws Exception {
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        ((PackageBuilderConfiguration)conf).initSemanticModules();
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNSemanticModule());
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        XmlProcessReader processReader = new XmlProcessReader(((PackageBuilderConfiguration)conf).getSemanticModules(), ((Object)((Object)this)).getClass().getClassLoader());
        List processes = processReader.read(SimpleBPMNProcessTest.class.getResourceAsStream("/BPMN2-RuleTask.bpmn2"));
        SimpleBPMNProcessTest.assertNotNull((Object)processes);
        SimpleBPMNProcessTest.assertEquals((int)1, (int)processes.size());
        RuleFlowProcess p = (RuleFlowProcess)processes.get(0);
        SimpleBPMNProcessTest.assertNotNull((Object)p);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)p))), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-RuleTask.drl"), ResourceType.DRL);
        if (!kbuilder.getErrors().isEmpty()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                this.logger.error(error.toString());
            }
            throw new IllegalArgumentException("Errors while parsing knowledge base");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ProcessInstance processInstance = ksession.startProcess("RuleTask");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.restoreSession(ksession, true);
        ksession.fireAllRules();
        SimpleBPMNProcessTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testRuleTask2() throws Exception {
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        ((PackageBuilderConfiguration)conf).initSemanticModules();
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNSemanticModule());
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        XmlProcessReader processReader = new XmlProcessReader(((PackageBuilderConfiguration)conf).getSemanticModules(), ((Object)((Object)this)).getClass().getClassLoader());
        List processes = processReader.read(SimpleBPMNProcessTest.class.getResourceAsStream("/BPMN2-RuleTask2.bpmn2"));
        SimpleBPMNProcessTest.assertNotNull((Object)processes);
        SimpleBPMNProcessTest.assertEquals((int)1, (int)processes.size());
        RuleFlowProcess p = (RuleFlowProcess)processes.get(0);
        SimpleBPMNProcessTest.assertNotNull((Object)p);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)p))), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-RuleTask2.drl"), ResourceType.DRL);
        if (!kbuilder.getErrors().isEmpty()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                this.logger.error(error.toString());
            }
            throw new IllegalArgumentException("Errors while parsing knowledge base");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "SomeString");
        ProcessInstance processInstance = ksession.startProcess("RuleTask", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.restoreSession(ksession, true);
        ksession.fireAllRules();
        SimpleBPMNProcessTest.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testDataObject() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-DataObject.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = ksession.startProcess("Evaluation", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testDataStore() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-DataStore.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Evaluation");
        Definitions def = (Definitions)processInstance.getProcess().getMetaData().get("Definitions");
        SimpleBPMNProcessTest.assertNotNull((Object)def.getDataStores());
        SimpleBPMNProcessTest.assertTrue((def.getDataStores().size() == 1 ? 1 : 0) != 0);
        DataStore dataStore = (DataStore)def.getDataStores().get(0);
        SimpleBPMNProcessTest.assertEquals((String)"employee", (String)dataStore.getId());
        SimpleBPMNProcessTest.assertEquals((String)"employeeStore", (String)dataStore.getName());
        SimpleBPMNProcessTest.assertEquals((String)String.class.getCanonicalName(), (String)((ObjectDataType)dataStore.getType()).getClassName());
    }

    public void testAssociation() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-Association.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Evaluation");
        Definitions def = (Definitions)processInstance.getProcess().getMetaData().get("Definitions");
        SimpleBPMNProcessTest.assertNotNull((Object)def.getAssociations());
        SimpleBPMNProcessTest.assertTrue((def.getAssociations().size() == 1 ? 1 : 0) != 0);
        Association assoc = (Association)def.getAssociations().get(0);
        SimpleBPMNProcessTest.assertEquals((String)"_1234", (String)assoc.getId());
        SimpleBPMNProcessTest.assertEquals((String)"_1", (String)assoc.getSourceRef());
        SimpleBPMNProcessTest.assertEquals((String)"_2", (String)assoc.getTargetRef());
    }

    public void testUserTaskWithDataStoreScenario() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithDataStore.xml");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.startProcess("UserProcess");
    }

    public void testEvaluationProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("RegisterRequest", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = ksession.startProcess("Evaluation", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testEvaluationProcess2() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess2.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = ksession.startProcess("com.sample.evaluation", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testEvaluationProcess3() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess3.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("RegisterRequest", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "john2");
        ProcessInstance processInstance = ksession.startProcess("Evaluation", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testUserTask() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-UserTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        WorkItem workItem = workItemHandler.getWorkItem();
        SimpleBPMNProcessTest.assertNotNull((Object)workItem);
        SimpleBPMNProcessTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testLane() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-Lane.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        WorkItem workItem = workItemHandler.getWorkItem();
        SimpleBPMNProcessTest.assertNotNull((Object)workItem);
        SimpleBPMNProcessTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("ActorId", "mary");
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), results);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        workItem = workItemHandler.getWorkItem();
        SimpleBPMNProcessTest.assertNotNull((Object)workItem);
        SimpleBPMNProcessTest.assertEquals((Object)"mary", (Object)workItem.getParameter("ActorId"));
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testExclusiveSplit() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "First");
        params.put("y", "Second");
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testExclusiveSplitXPathAdvanced() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitXPath-advanced.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, Object> params = new HashMap<String, Object>();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element hi = doc.createElement("hi");
        Element ho = doc.createElement("ho");
        hi.appendChild(ho);
        Attr attr = doc.createAttribute("value");
        ho.setAttributeNode(attr);
        attr.setValue("a");
        params.put("x", hi);
        params.put("y", "Second");
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testExclusiveSplitXPathAdvanced2() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitXPath-advanced-vars-not-signaled.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, Object> params = new HashMap<String, Object>();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element hi = doc.createElement("hi");
        Element ho = doc.createElement("ho");
        hi.appendChild(ho);
        Attr attr = doc.createAttribute("value");
        ho.setAttributeNode(attr);
        attr.setValue("a");
        params.put("x", hi);
        params.put("y", "Second");
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testExclusiveSplitXPathAdvancedWithVars() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitXPath-advanced-with-vars.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, Object> params = new HashMap<String, Object>();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element hi = doc.createElement("hi");
        Element ho = doc.createElement("ho");
        hi.appendChild(ho);
        Attr attr = doc.createAttribute("value");
        ho.setAttributeNode(attr);
        attr.setValue("a");
        params.put("x", hi);
        params.put("y", "Second");
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testExclusiveSplitPriority() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitPriority.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "First");
        params.put("y", "Second");
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testExclusiveSplitDefault() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitDefault.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "NotFirst");
        params.put("y", "Second");
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testInclusiveSplit() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testInclusiveSplitDefault() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitDefault.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", -5);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testEventBasedSplit() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testEventBasedSplitBefore() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
    }

    public void testEventBasedSplitAfter() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
    }

    public void testEventBasedSplit2() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit2.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        Thread.sleep(800L);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.fireAllRules();
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Thread.sleep(800L);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.fireAllRules();
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testEventBasedSplit3() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit3.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        Person jack = new Person();
        jack.setName("Jack");
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.insert((Object)jack);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testEventBasedSplit4() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit4.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("Message-YesMessage", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        processInstance = ksession.startProcess("com.sample.test");
        ksession.signalEvent("Message-NoMessage", (Object)"NoValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testEventBasedSplit5() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit5.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ReceiveTaskHandler receiveTaskHandler = new ReceiveTaskHandler((KnowledgeRuntime)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        receiveTaskHandler.setKnowledgeRuntime((KnowledgeRuntime)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        receiveTaskHandler.messageReceived("YesMessage", (Object)"YesValue");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        receiveTaskHandler.messageReceived("NoMessage", (Object)"NoValue");
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        receiveTaskHandler.setKnowledgeRuntime((KnowledgeRuntime)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        processInstance = ksession.startProcess("com.sample.test");
        receiveTaskHandler.messageReceived("NoMessage", (Object)"NoValue");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        receiveTaskHandler.messageReceived("YesMessage", (Object)"YesValue");
    }

    public void testCallActivity() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivity.bpmn2"), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivitySubProcess.bpmn2"), ResourceType.BPMN2);
        if (!kbuilder.getErrors().isEmpty()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                this.logger.error(error.toString());
            }
            throw new IllegalArgumentException("Errors while parsing knowledge base");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        ProcessInstance processInstance = ksession.startProcess("ParentProcess", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
        SimpleBPMNProcessTest.assertEquals((Object)"new value", (Object)((WorkflowProcessInstance)processInstance).getVariable("y"));
    }

    public void testSubProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-SubProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                SimpleBPMNProcessTest.this.logger.debug(event.toString());
            }

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                SimpleBPMNProcessTest.this.logger.debug(event.toString());
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                SimpleBPMNProcessTest.this.logger.debug(event.toString());
            }
        });
        ProcessInstance processInstance = ksession.startProcess("SubProcess");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testMultiInstanceLoopCharacteristicsProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MultiInstanceLoopCharacteristicsProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        ProcessInstance processInstance = ksession.startProcess("MultiInstanceLoopCharacteristicsProcess", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testMultiInstanceLoopCharacteristicsTask() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-MultiInstanceLoopCharacteristicsTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        ProcessInstance processInstance = ksession.startProcess("MultiInstanceLoopCharacteristicsTask", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testEscalationBoundaryEvent() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EscalationBoundaryEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("EscalationBoundaryEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testEscalationBoundaryEventInterrupting() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EscalationBoundaryEventInterrupting.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("EscalationBoundaryEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testErrorBoundaryEvent() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ErrorBoundaryEventInterrupting.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("ErrorBoundaryEvent");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testTimerBoundaryEventDuration() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventDuration.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("TimerBoundaryEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        ksession = this.restoreSession(ksession, true);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testTimerBoundaryEventCycle1() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventCycle1.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("TimerBoundaryEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        ksession = this.restoreSession(ksession, true);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testTimerBoundaryEventCycle2() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventCycle2.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("TimerBoundaryEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        ksession.abortProcessInstance(processInstance.getId());
        Thread.sleep(1000L);
    }

    public void testTimerBoundaryEventInterrupting() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventInterrupting.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("TimerBoundaryEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        ksession = this.restoreSession(ksession, true);
        this.logger.debug("Firing timer");
        ksession.fireAllRules();
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testAdHocSubProcess() throws Exception {
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        ((PackageBuilderConfiguration)conf).initSemanticModules();
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNSemanticModule());
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        XmlProcessReader processReader = new XmlProcessReader(((PackageBuilderConfiguration)conf).getSemanticModules(), ((Object)((Object)this)).getClass().getClassLoader());
        List processes = processReader.read(SimpleBPMNProcessTest.class.getResourceAsStream("/BPMN2-AdHocSubProcess.bpmn2"));
        SimpleBPMNProcessTest.assertNotNull((Object)processes);
        SimpleBPMNProcessTest.assertEquals((int)1, (int)processes.size());
        RuleFlowProcess p = (RuleFlowProcess)processes.get(0);
        SimpleBPMNProcessTest.assertNotNull((Object)p);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)p))), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-AdHocSubProcess.drl"), ResourceType.DRL);
        if (!kbuilder.getErrors().isEmpty()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                this.logger.error(error.toString());
            }
            throw new IllegalArgumentException("Errors while parsing knowledge base");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("AdHocSubProcess");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        SimpleBPMNProcessTest.assertNull((Object)workItem);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.fireAllRules();
        this.logger.debug("Signaling Hello2");
        ksession.signalEvent("Hello2", null, processInstance.getId());
        workItem = workItemHandler.getWorkItem();
        SimpleBPMNProcessTest.assertNotNull((Object)workItem);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
    }

    public void testAdHocSubProcessAutoComplete() throws Exception {
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        ((PackageBuilderConfiguration)conf).initSemanticModules();
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNSemanticModule());
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        XmlProcessReader processReader = new XmlProcessReader(((PackageBuilderConfiguration)conf).getSemanticModules(), ((Object)((Object)this)).getClass().getClassLoader());
        List processes = processReader.read(SimpleBPMNProcessTest.class.getResourceAsStream("/BPMN2-AdHocSubProcessAutoComplete.bpmn2"));
        SimpleBPMNProcessTest.assertNotNull((Object)processes);
        SimpleBPMNProcessTest.assertEquals((int)1, (int)processes.size());
        RuleFlowProcess p = (RuleFlowProcess)processes.get(0);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)p))), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-AdHocSubProcess.drl"), ResourceType.DRL);
        if (!kbuilder.getErrors().isEmpty()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                this.logger.error(error.toString());
            }
            throw new IllegalArgumentException("Errors while parsing knowledge base");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("AdHocSubProcess");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        SimpleBPMNProcessTest.assertNull((Object)workItem);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.fireAllRules();
        workItem = workItemHandler.getWorkItem();
        SimpleBPMNProcessTest.assertNotNull((Object)workItem);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testAdHocProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-AdHocProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("AdHocProcess");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.logger.debug("Triggering node");
        ksession.signalEvent("Task1", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        ksession.signalEvent("User1", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        ksession.insert((Object)new Person());
        ksession.signalEvent("Task3", null, processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testIntermediateCatchEventSignal() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventSignal.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.signalEvent("MyMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testIntermediateCatchEventMessage() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventMessage.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.signalEvent("Message-HelloMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testIntermediateCatchEventTimerDuration() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerDuration.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.fireAllRules();
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testIntermediateCatchEventTimerCycle1() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerCycle1.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.fireAllRules();
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testIntermediateCatchEventTimerCycle2() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerCycle2.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        ksession.abortProcessInstance(processInstance.getId());
        Thread.sleep(1000L);
    }

    public void testIntermediateCatchEventCondition() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventCondition.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        Person person = new Person();
        person.setName("Jack");
        ksession.insert((Object)person);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testErrorEndEventProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ErrorEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("ErrorEndEvent");
        this.assertProcessInstanceAborted(processInstance.getId(), ksession);
    }

    public void testEscalationEndEventProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EscalationEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("EscalationEndEvent");
        this.assertProcessInstanceAborted(processInstance.getId(), ksession);
    }

    public void testEscalationIntermediateThrowEventProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventEscalation.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("EscalationIntermediateThrowEvent");
        this.assertProcessInstanceAborted(processInstance.getId(), ksession);
    }

    public void testCompensateIntermediateThrowEventProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventCompensate.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("CompensateIntermediateThrowEvent");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testCompensateEndEventProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-CompensateEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("CompensateEndEvent");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "Task", "CompensateEvent", "CompensateEvent2", "Compensate", "EndEvent");
    }

    public void testServiceTask() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ServiceProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("ServiceProcess", params);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        SimpleBPMNProcessTest.assertEquals((Object)"Hello john!", (Object)processInstance.getVariable("s"));
    }

    public void testSendTask() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-SendTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("SendTask", params);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testReceiveTask() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ReceiveTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ReceiveTaskHandler receiveTaskHandler = new ReceiveTaskHandler((KnowledgeRuntime)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("ReceiveTask");
        SimpleBPMNProcessTest.assertEquals((int)1, (int)processInstance.getState());
        ksession = this.restoreSession(ksession, true);
        receiveTaskHandler.messageReceived("HelloMessage", (Object)"Hello john!");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testConditionalStart() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ConditionalStart.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Person person = new Person();
        person.setName("jack");
        ksession.insert((Object)person);
        ksession.fireAllRules();
        person = new Person();
        person.setName("john");
        ksession.insert((Object)person);
        ksession.fireAllRules();
    }

    public void testTimerStart() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-TimerStart.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        Thread.sleep(250L);
        SimpleBPMNProcessTest.assertEquals((int)0, (int)list.size());
        for (int i = 0; i < 5; ++i) {
            ksession.fireAllRules();
            Thread.sleep(500L);
        }
        SimpleBPMNProcessTest.assertEquals((int)5, (int)list.size());
    }

    public void testTimerStartCron() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-TimerStartCron.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        Thread.sleep(500L);
        for (int i = 0; i < 5; ++i) {
            ksession.fireAllRules();
            Thread.sleep(1000L);
        }
        SimpleBPMNProcessTest.assertEquals((int)6, (int)list.size());
    }

    public void testSignalStart() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-SignalStart.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        ksession.signalEvent("MySignal", (Object)"NewValue");
        SimpleBPMNProcessTest.assertEquals((int)1, (int)list.size());
    }

    public void testSignalStartDynamic() throws Exception {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        KnowledgeBase kbase2 = this.createKnowledgeBase("BPMN2-SignalStart.bpmn2");
        kbase.addKnowledgePackages(kbase2.getKnowledgePackages());
        final ArrayList list = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        ksession.signalEvent("MySignal", (Object)"NewValue");
        SimpleBPMNProcessTest.assertEquals((int)1, (int)list.size());
    }

    public void testSignalEnd() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-SignalEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ksession.startProcess("SignalEndEvent", params);
    }

    public void testMessageStart() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MessageStart.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.signalEvent("Message-HelloMessage", (Object)"NewValue");
    }

    public void testMessageEnd() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MessageEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = ksession.startProcess("MessageEndEvent", params);
        SimpleBPMNProcessTest.assertEquals((int)2, (int)processInstance.getState());
    }

    public void testMessageIntermediateThrow() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventMessage.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = ksession.startProcess("MessageIntermediateEvent", params);
        SimpleBPMNProcessTest.assertEquals((int)2, (int)processInstance.getState());
    }

    public void testSignalIntermediateThrow() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventSignal.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = ksession.startProcess("SignalIntermediateEvent", params);
        SimpleBPMNProcessTest.assertEquals((int)2, (int)processInstance.getState());
    }

    public void testNoneIntermediateThrow() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventNone.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("NoneIntermediateEvent", null);
        SimpleBPMNProcessTest.assertEquals((int)2, (int)processInstance.getState());
    }

    public void testXpathExpression() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-XpathExpression.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<instanceMetadata><user approved=\"false\" /></instanceMetadata>".getBytes()));
        HashMap<String, Document> params = new HashMap<String, Document>();
        params.put("instanceMetadata", document);
        ProcessInstance processInstance = ksession.startProcess("XPathProcess", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testOnEntryExitScript() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-OnEntryExitScriptProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new SystemOutWorkItemHandler());
        ArrayList myList = new ArrayList();
        ksession.setGlobal("list", myList);
        ProcessInstance processInstance = ksession.startProcess("OnEntryExitScriptProcess");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
        SimpleBPMNProcessTest.assertEquals((int)4, (int)myList.size());
    }

    public void testXORGateway() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-gatewayTest.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<instanceMetadata><user approved=\"false\" /></instanceMetadata>".getBytes()));
        HashMap<String, Node> params = new HashMap<String, Node>();
        params.put("instanceMetadata", document);
        params.put("startMessage", DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<task subject='foobar2'/>".getBytes())).getFirstChild());
        ProcessInstance processInstance = ksession.startProcess("process", params);
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testDataInputAssociations() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataInputAssociations.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((Object)"hello world", (Object)workItem.getParameter("coId"));
            }
        });
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
        HashMap<String, Node> params = new HashMap<String, Node>();
        params.put("instanceMetadata", document.getFirstChild());
        ProcessInstance processInstance = ksession.startProcess("process", params);
    }

    public void testDataInputAssociationsWithStringObject() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataInputAssociations-string-object.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((Object)"hello", (Object)workItem.getParameter("coId"));
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instanceMetadata", "hello");
        ProcessInstance processInstance = ksession.startProcess("process", params);
    }

    public void FIXMEtestDataInputAssociationsWithLazyLoading() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataInputAssociations-lazy-creating.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((String)"mydoc", (String)((Element)workItem.getParameter("coId")).getNodeName());
                Assert.assertEquals((String)"mynode", (String)((Element)workItem.getParameter("coId")).getFirstChild().getNodeName());
                Assert.assertEquals((String)"user", (String)((Element)workItem.getParameter("coId")).getFirstChild().getFirstChild().getNodeName());
                Assert.assertEquals((String)"hello world", (String)((Element)workItem.getParameter("coId")).getFirstChild().getFirstChild().getAttributes().getNamedItem("hello").getNodeValue());
            }
        });
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
        HashMap<String, Node> params = new HashMap<String, Node>();
        params.put("instanceMetadata", document.getFirstChild());
        ProcessInstance processInstance = ksession.startProcess("process", params);
    }

    public void FIXMEtestDataInputAssociationsWithString() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataInputAssociations-string.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((Object)"hello", (Object)workItem.getParameter("coId"));
            }
        });
        ProcessInstance processInstance = ksession.startProcess("process", null);
    }

    public void testDataInputAssociationsWithStringWithoutQuotes() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataInputAssociations-string-no-quotes.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((Object)"hello", (Object)workItem.getParameter("coId"));
            }
        });
        ProcessInstance processInstance = ksession.startProcess("process", null);
    }

    public void testDataInputAssociationsWithXMLLiteral() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataInputAssociations-xml-literal.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((String)"id", (String)((Node)workItem.getParameter("coId")).getNodeName());
                Assert.assertEquals((String)"some text", (String)((Node)workItem.getParameter("coId")).getFirstChild().getTextContent());
            }
        });
        ProcessInstance processInstance = ksession.startProcess("process", null);
    }

    public void FIXMEtestDataInputAssociationsWithTwoAssigns() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataInputAssociations-two-assigns.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((String)"foo", (String)((Element)workItem.getParameter("Comment")).getNodeName());
            }
        });
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
        HashMap<String, Node> params = new HashMap<String, Node>();
        params.put("instanceMetadata", document.getFirstChild());
        ProcessInstance processInstance = ksession.startProcess("process", params);
    }

    public void testDataOutputAssociationsforHumanTask() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataOutputAssociations-HumanTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                DocumentBuilder builder;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    builder = factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    throw new RuntimeException(e);
                }
                HashMap<String, Element> results = new HashMap<String, Element>();
                Document processMetadaDoc = builder.newDocument();
                Element processMetadata = processMetadaDoc.createElement("previoustasksowner");
                processMetadaDoc.appendChild(processMetadata);
                processMetadata.setAttribute("primaryname", "my_result");
                results.put("output", processMetadata);
                mgr.completeWorkItem(workItem.getId(), results);
            }
        });
        HashMap params = new HashMap();
        ProcessInstance processInstance = ksession.startProcess("process", params);
    }

    public void testDataOutputAssociations() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataOutputAssociations.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                try {
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
                    HashMap<String, Node> params = new HashMap<String, Node>();
                    params.put("output", document.getFirstChild());
                    mgr.completeWorkItem(workItem.getId(), params);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        });
        ProcessInstance processInstance = ksession.startProcess("process", null);
    }

    public void testDataOutputAssociationsXmlNode() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataOutputAssociations-xml-node.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                try {
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
                    HashMap<String, Node> params = new HashMap<String, Node>();
                    params.put("output", document.getFirstChild());
                    mgr.completeWorkItem(workItem.getId(), params);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        });
        ProcessInstance processInstance = ksession.startProcess("process", null);
    }

    public void testLinkIntermediateEvent() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateLinkEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("linkEventProcessExample");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testLinkEventCompositeProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-LinkEventCompositeProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Composite");
        SimpleBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    private KnowledgeBase createKnowledgeBase(String process) throws Exception {
        KnowledgeBaseFactory.setKnowledgeBaseServiceFactory((KnowledgeBaseFactoryService)new KnowledgeBaseFactoryServiceImpl());
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        ((PackageBuilderConfiguration)conf).initSemanticModules();
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNSemanticModule());
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNExtensionsSemanticModule());
        XmlProcessReader processReader = new XmlProcessReader(((PackageBuilderConfiguration)conf).getSemanticModules(), ((Object)((Object)this)).getClass().getClassLoader());
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        List processes = processReader.read(SimpleBPMNProcessTest.class.getResourceAsStream("/" + process));
        for (Process p : processes) {
            RuleFlowProcess ruleFlowProcess = (RuleFlowProcess)p;
            this.logger.debug(XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)ruleFlowProcess));
            kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)ruleFlowProcess))), ResourceType.BPMN2);
        }
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new InputStreamReader(SimpleBPMNProcessTest.class.getResourceAsStream("/" + process))), ResourceType.BPMN2);
        if (!kbuilder.getErrors().isEmpty()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                this.logger.error(error.toString());
            }
            throw new IllegalArgumentException("Errors while parsing knowledge base");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    private KnowledgeBase createKnowledgeBaseWithoutDumper(String process) throws Exception {
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        ((PackageBuilderConfiguration)conf).initSemanticModules();
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNSemanticModule());
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNExtensionsSemanticModule());
        XmlProcessReader processReader = new XmlProcessReader(((PackageBuilderConfiguration)conf).getSemanticModules(), ((Object)((Object)this)).getClass().getClassLoader());
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new InputStreamReader(SimpleBPMNProcessTest.class.getResourceAsStream("/" + process))), ResourceType.BPMN2);
        if (!kbuilder.getErrors().isEmpty()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                this.logger.error(error.toString());
            }
            throw new IllegalArgumentException("Errors while parsing knowledge base");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }
}

