/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.persistence;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.KnowledgeBase;
import org.drools.WorkingMemory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.definition.KnowledgePackage;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.AgendaGroupPoppedEvent;
import org.drools.event.AgendaGroupPushedEvent;
import org.drools.event.BeforeActivationFiredEvent;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.event.RuleFlowGroupActivatedEvent;
import org.drools.event.RuleFlowGroupDeactivatedEvent;
import org.drools.event.process.DefaultProcessEventListener;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.process.ProcessStartedEvent;
import org.drools.impl.EnvironmentFactory;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.io.ResourceFactory;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;
import org.jbpm.process.audit.JPAWorkingMemoryDbLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimerCycleOnBinaryPackageTest {
    private PoolingDataSource ds = new PoolingDataSource();

    @Before
    public void setUp() {
        this.ds.setUniqueName("jdbc/testDS1");
        this.ds.setClassName("org.h2.jdbcx.JdbcDataSource");
        this.ds.setMaxPoolSize(3);
        this.ds.setAllowLocalTransactions(true);
        this.ds.getDriverProperties().put("user", "sa");
        this.ds.getDriverProperties().put("password", "sasa");
        this.ds.getDriverProperties().put("URL", "jdbc:h2:mem:mydb");
        this.ds.init();
    }

    @After
    public void tearDown() {
        this.ds.close();
    }

    @Test
    public void testStartTimerCycleFromDisc() throws Exception {
        KnowledgeBase kbase = this.readKnowledgeBaseFromDisc();
        Environment env = EnvironmentFactory.newEnvironment();
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)emf);
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
        new JPAWorkingMemoryDbLogger((KnowledgeRuntimeEventManager)ksession);
        int sessionId = ksession.getId();
        final ArrayList list = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getStatefulKnowledgesession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        Assert.assertEquals((long)2L, (long)list.size());
        System.out.println("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KnowledgeBase)kbase, null, (Environment)env);
        new JPAWorkingMemoryDbLogger((KnowledgeRuntimeEventManager)ksession);
        final ArrayList list2 = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list2.add(event.getProcessInstance().getId());
            }
        });
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getStatefulKnowledgesession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        Assert.assertEquals((long)3L, (long)list2.size());
        ksession.dispose();
        emf.close();
    }

    @Test
    public void testStartTimerCycleFromClassPath() throws Exception {
        KnowledgeBase kbase = this.readKnowledgeBase();
        Environment env = EnvironmentFactory.newEnvironment();
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)emf);
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
        new JPAWorkingMemoryDbLogger((KnowledgeRuntimeEventManager)ksession);
        int sessionId = ksession.getId();
        final ArrayList list = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getStatefulKnowledgesession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        Assert.assertEquals((long)2L, (long)list.size());
        System.out.println("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KnowledgeBase)kbase, null, (Environment)env);
        new JPAWorkingMemoryDbLogger((KnowledgeRuntimeEventManager)ksession);
        final ArrayList list2 = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list2.add(event.getProcessInstance().getId());
            }
        });
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getStatefulKnowledgesession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        Assert.assertEquals((long)3L, (long)list2.size());
        ksession.dispose();
        emf.close();
    }

    @Test
    public void testStartTimerCycleFromDiscDRL() throws Exception {
        KnowledgeBase kbase = this.readKnowledgeBaseFromDiscDRL();
        Environment env = EnvironmentFactory.newEnvironment();
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)emf);
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
        new JPAWorkingMemoryDbLogger((KnowledgeRuntimeEventManager)ksession);
        int sessionId = ksession.getId();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getStatefulKnowledgesession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        Assert.assertEquals((long)2L, (long)list.size());
        System.out.println("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KnowledgeBase)kbase, null, (Environment)env);
        new JPAWorkingMemoryDbLogger((KnowledgeRuntimeEventManager)ksession);
        ArrayList list2 = new ArrayList();
        ksession.setGlobal("list", list2);
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getStatefulKnowledgesession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        Assert.assertEquals((long)3L, (long)list2.size());
        ksession.dispose();
        emf.close();
    }

    @Test
    public void testStartTimerCycleFromClasspathDRL() throws Exception {
        KnowledgeBase kbase = this.readKnowledgeBaseDRL();
        Environment env = EnvironmentFactory.newEnvironment();
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)emf);
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
        new JPAWorkingMemoryDbLogger((KnowledgeRuntimeEventManager)ksession);
        int sessionId = ksession.getId();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getStatefulKnowledgesession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        Assert.assertEquals((long)2L, (long)list.size());
        System.out.println("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KnowledgeBase)kbase, null, (Environment)env);
        new JPAWorkingMemoryDbLogger((KnowledgeRuntimeEventManager)ksession);
        ArrayList list2 = new ArrayList();
        ksession.setGlobal("list", list2);
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getStatefulKnowledgesession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        Assert.assertEquals((long)3L, (long)list2.size());
        ksession.dispose();
        emf.close();
    }

    private KnowledgeBase readKnowledgeBaseFromDisc() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-StartTimerCycle.bpmn2"), ResourceType.BPMN2);
        File packageFile = null;
        Iterator i$ = kbuilder.getKnowledgePackages().iterator();
        if (i$.hasNext()) {
            KnowledgePackage pkg = (KnowledgePackage)i$.next();
            packageFile = new File(System.getProperty("java.io.tmpdir") + File.separator + pkg.getName() + ".pkg");
            this.writePackage(pkg, packageFile);
        }
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newFileResource(packageFile), ResourceType.PKG);
        return kbuilder.newKnowledgeBase();
    }

    private KnowledgeBase readKnowledgeBase() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-StartTimerCycle.bpmn2"), ResourceType.BPMN2);
        return kbuilder.newKnowledgeBase();
    }

    private KnowledgeBase readKnowledgeBaseFromDiscDRL() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"rules-timer.drl"), ResourceType.DRL);
        File packageFile = null;
        Iterator i$ = kbuilder.getKnowledgePackages().iterator();
        if (i$.hasNext()) {
            KnowledgePackage pkg = (KnowledgePackage)i$.next();
            packageFile = new File(System.getProperty("java.io.tmpdir") + File.separator + pkg.getName() + ".pkg");
            this.writePackage(pkg, packageFile);
        }
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newFileResource(packageFile), ResourceType.PKG);
        return kbuilder.newKnowledgeBase();
    }

    private KnowledgeBase readKnowledgeBaseDRL() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"rules-timer.drl"), ResourceType.DRL);
        return kbuilder.newKnowledgeBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePackage(KnowledgePackage kpackage, File p1file) throws IOException, FileNotFoundException {
        FileOutputStream out = new FileOutputStream(p1file);
        try {
            DroolsStreamUtils.streamOut((OutputStream)out, (Object)kpackage);
        }
        finally {
            out.close();
        }
    }

    private static class TriggerRulesEventListener
    implements AgendaEventListener {
        private StatefulKnowledgeSession ksession;

        public TriggerRulesEventListener(StatefulKnowledgeSession ksession) {
            this.ksession = ksession;
        }

        public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
            this.ksession.fireAllRules();
        }

        public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
        }

        public void beforeActivationFired(BeforeActivationFiredEvent event, WorkingMemory workingMemory) {
        }

        public void afterActivationFired(AfterActivationFiredEvent event, WorkingMemory workingMemory) {
        }

        public void agendaGroupPopped(AgendaGroupPoppedEvent event, WorkingMemory workingMemory) {
        }

        public void agendaGroupPushed(AgendaGroupPushedEvent event, WorkingMemory workingMemory) {
        }

        public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
        }

        public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
            workingMemory.fireAllRules();
        }

        public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
        }

        public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
        }
    }
}

