/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.definition.process.WorkflowProcess;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.io.ResourceFactory;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.persistence.util.PersistenceUtil;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.xml.SemanticModule;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.SimpleBPMNProcessTest;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.process.audit.JPAProcessInstanceDbLog;
import org.jbpm.process.audit.JPAWorkingMemoryDbLogger;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hibernate4ProcessPersistenceTest {
    Logger logger = LoggerFactory.getLogger(Hibernate4ProcessPersistenceTest.class);
    HashMap<String, Object> context = new HashMap();

    @Before
    public void setUp() {
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
    }

    @After
    public void tearDown() {
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testLane() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-Lane.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("ActorId", "mary");
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), results);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"mary", (Object)workItem.getParameter("ActorId"));
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    @Test
    public void testAdHocSubProcessAutoComplete() throws Exception {
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        ((PackageBuilderConfiguration)conf).initSemanticModules();
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNSemanticModule());
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        XmlProcessReader processReader = new XmlProcessReader(((PackageBuilderConfiguration)conf).getSemanticModules(), this.getClass().getClassLoader());
        List processes = processReader.read(SimpleBPMNProcessTest.class.getResourceAsStream("/BPMN2-AdHocSubProcessAutoComplete.bpmn2"));
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((int)1, (int)processes.size());
        RuleFlowProcess p = (RuleFlowProcess)processes.get(0);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)p))), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-AdHocSubProcess.drl"), ResourceType.DRL);
        if (!kbuilder.getErrors().isEmpty()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                this.logger.error(error.toString());
            }
            throw new IllegalArgumentException("Errors while parsing knowledge base");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("AdHocSubProcess");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNull((Object)workItem);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.fireAllRules();
        workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    protected KnowledgeBase createKnowledgeBase(String ... process) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (String p : process) {
            kbuilder.add(ResourceFactory.newClassPathResource((String)p), ResourceType.BPMN2);
        }
        return kbuilder.newKnowledgeBase();
    }

    public void assertProcessInstanceCompleted(long processInstanceId, StatefulKnowledgeSession ksession) {
        Assert.assertNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    public void assertNodeTriggered(long processInstanceId, String ... nodeNames) {
        ArrayList<String> names = new ArrayList<String>();
        for (String nodeName : nodeNames) {
            names.add(nodeName);
        }
        List logs = JPAProcessInstanceDbLog.findNodeInstances((long)processInstanceId);
        if (logs != null) {
            for (NodeInstanceLog l : logs) {
                String nodeName;
                nodeName = l.getNodeName();
                if (l.getType() != 0 && l.getType() != 1 || !names.contains(nodeName)) continue;
                names.remove(nodeName);
            }
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            Assert.fail((String)("Node(s) not executed: " + s));
        }
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KnowledgeBase kbase) {
        Environment env = PersistenceUtil.createEnvironment(this.context);
        StatefulKnowledgeSession result = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
        new JPAWorkingMemoryDbLogger((KnowledgeRuntimeEventManager)result);
        JPAProcessInstanceDbLog.setEnvironment((Environment)result.getEnvironment());
        return result;
    }

    protected StatefulKnowledgeSession restoreSession(StatefulKnowledgeSession ksession, boolean noCache) {
        int id = ksession.getId();
        KnowledgeBase kbase = ksession.getKnowledgeBase();
        Environment env = null;
        env = PersistenceUtil.createEnvironment(this.context);
        KnowledgeSessionConfiguration config = ksession.getSessionConfiguration();
        StatefulKnowledgeSession result = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, (KnowledgeSessionConfiguration)config, (Environment)env);
        new JPAWorkingMemoryDbLogger((KnowledgeRuntimeEventManager)result);
        return result;
    }

    public void assertProcessInstanceActive(long processInstanceId, StatefulKnowledgeSession ksession) {
        Assert.assertNotNull((Object)ksession.getProcessInstance(processInstanceId));
    }
}

