/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import org.drools.KnowledgeBase;
import org.drools.event.process.DefaultProcessEventListener;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.process.ProcessNodeLeftEvent;
import org.drools.event.process.ProcessNodeTriggeredEvent;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItemHandler;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;

public class SimplePersistenceBPMNProcessTest
extends JbpmBpmn2TestCase {
    public SimplePersistenceBPMNProcessTest() {
        super(true);
    }

    public void testCompensateEndEventProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-CompensateEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("CompensateEndEvent");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "Task", "CompensateEvent", "CompensateEvent2", "Compensate", "EndEvent");
    }

    public void testSignalBoundaryEventOnTask() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-BoundarySignalEventOnTaskbpmn2.bpmn");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new JbpmBpmn2TestCase.TestWorkItemHandler());
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                System.out.println("After node left " + event.getNodeInstance().getNodeName());
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                System.out.println("After node triggered " + event.getNodeInstance().getNodeName());
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                System.out.println("Before node left " + event.getNodeInstance().getNodeName());
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                System.out.println("Before node triggered " + event.getNodeInstance().getNodeName());
            }
        });
        ProcessInstance processInstance = ksession.startProcess("BoundarySignalOnTask");
        ksession.signalEvent("MySignal", (Object)"hello");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "User Task", "Boundary event", "Signal received", "End2");
    }

    public void testIntermediateCatchEventSignal() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventSignal.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        SimplePersistenceBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.signalEvent("MyMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "UserTask", "EndProcess", "event");
    }
}

