/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.concurrency;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import junit.framework.Assert;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.event.process.ProcessCompletedEvent;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.process.ProcessNodeLeftEvent;
import org.drools.event.process.ProcessNodeTriggeredEvent;
import org.drools.event.process.ProcessStartedEvent;
import org.drools.event.process.ProcessVariableChangedEvent;
import org.drools.io.ResourceFactory;
import org.drools.persistence.util.LoggingPrintStream;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.jbpm.bpmn2.objects.Status;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class MultipleProcessesPerThreadTest {
    private static final int LOOPS = 1000;
    private static Logger logger = LoggerFactory.getLogger(MultipleProcessesPerThreadTest.class);

    protected static StatefulKnowledgeSession createStatefulKnowledgeSession(KnowledgeBase kbase) {
        return kbase.newStatefulKnowledgeSession();
    }

    @Test
    public void doMultipleProcessesInMultipleThreads() {
        HelloWorldProcessThread hello = new HelloWorldProcessThread();
        UserTaskProcessThread user = new UserTaskProcessThread();
        hello.start();
        user.start();
        try {
            hello.join();
            user.join();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Assert.assertTrue((String)"Hello World process thread did not complete successfully", (hello.status == Status.SUCCESS ? 1 : 0) != 0);
        Assert.assertTrue((String)"User Task process thread did not complete successfully", (user.status == Status.SUCCESS ? 1 : 0) != 0);
    }

    static {
        System.setOut((PrintStream)new LoggingPrintStream((OutputStream)System.out));
    }

    private static class CompleteProcessListener
    implements ProcessEventListener {
        private volatile CountDownLatch guard;

        public CompleteProcessListener(CountDownLatch guard) {
            this.guard = guard;
        }

        public void beforeProcessStarted(ProcessStartedEvent event) {
        }

        public void afterProcessStarted(ProcessStartedEvent event) {
        }

        public void beforeProcessCompleted(ProcessCompletedEvent event) {
        }

        public void afterProcessCompleted(ProcessCompletedEvent event) {
            this.guard.countDown();
        }

        public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        }

        public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
        }

        public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        }

        public void afterNodeLeft(ProcessNodeLeftEvent event) {
        }

        public void beforeVariableChanged(ProcessVariableChangedEvent event) {
        }

        public void afterVariableChanged(ProcessVariableChangedEvent event) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestWorkItemHandler
    implements WorkItemHandler {
        private List<WorkItem> workItems = new ArrayList<WorkItem>();

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItems.add(workItem);
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }

        public WorkItem getWorkItem() {
            if (this.workItems.size() == 0) {
                return null;
            }
            if (this.workItems.size() == 1) {
                WorkItem result = this.workItems.get(0);
                this.workItems.clear();
                return result;
            }
            throw new IllegalArgumentException("More than one work item active");
        }

        public List<WorkItem> getWorkItems() {
            ArrayList<WorkItem> result = new ArrayList<WorkItem>(this.workItems);
            this.workItems.clear();
            return result;
        }
    }

    private static class UserTaskProcessThread
    implements Runnable {
        private Thread thread;
        volatile Status status;
        private volatile CountDownLatch latch;

        private UserTaskProcessThread() {
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        public void run() {
            this.status = Status.SUCCESS;
            StatefulKnowledgeSession ksession = null;
            try {
                KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
                kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-MultiThreadServiceProcess-Task.bpmn", this.getClass()), ResourceType.BPMN2);
                KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
                kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
                ksession = MultipleProcessesPerThreadTest.createStatefulKnowledgeSession(kbase);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Unable to set up knowlede base or session.", (Throwable)e);
                this.status = Status.FAIL;
            }
            TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
            ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
            for (int i = 1; i <= 1000; ++i) {
                logger.debug("Starting user task process, loop " + i + "/" + 1000);
                this.latch = new CountDownLatch(1);
                CompleteProcessListener listener = new CompleteProcessListener(this.latch);
                ksession.addEventListener((ProcessEventListener)listener);
                try {
                    ksession.startProcess("user-task");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                List<Object> items = new ArrayList();
                items = workItemHandler.getWorkItems();
                for (WorkItem workItem : items) {
                    try {
                        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                try {
                    this.latch.await();
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        public synchronized void join() throws InterruptedException {
            this.thread.join();
        }
    }

    private static class HelloWorldProcessThread
    implements Runnable {
        private Thread thread;
        volatile Status status;
        private volatile CountDownLatch latch;

        private HelloWorldProcessThread() {
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        public void run() {
            this.status = Status.SUCCESS;
            StatefulKnowledgeSession ksession = null;
            try {
                KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
                kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-MultiThreadServiceProcess-Timer.bpmn", this.getClass()), ResourceType.BPMN2);
                KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
                kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
                ksession = MultipleProcessesPerThreadTest.createStatefulKnowledgeSession(kbase);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Unable to set up knowlede base or session.", (Throwable)e);
                this.status = Status.FAIL;
            }
            for (int i = 1; i <= 1000; ++i) {
                logger.debug("Starting hello world process, loop " + i + "/" + 1000);
                this.latch = new CountDownLatch(1);
                CompleteProcessListener listener = new CompleteProcessListener(this.latch);
                ksession.addEventListener((ProcessEventListener)listener);
                try {
                    ksession.startProcess("hello-world");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                try {
                    this.latch.await();
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        public synchronized void join() throws InterruptedException {
            this.thread.join();
        }
    }
}

