/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.persistence;

import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.command.Command;
import org.drools.command.Context;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.event.process.ProcessEventListener;
import org.drools.impl.EnvironmentFactory;
import org.drools.io.ResourceFactory;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.process.audit.JPAProcessInstanceDbLog;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.instance.impl.RuleAwareProcessEventLister;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;

public class SimplePersistedBPMNProcessTest
extends JbpmBpmn2TestCase {
    public SimplePersistedBPMNProcessTest() {
        super(true);
    }

    public void testBusinessRuleTask() throws Exception {
        HashMap<String, ResourceType> resources = new HashMap<String, ResourceType>();
        resources.put("BPMN2-BusinessRuleTask.bpmn2", ResourceType.BPMN2);
        resources.put("BPMN2-BusinessRuleTask.drl", ResourceType.DRL);
        KnowledgeBase kbase = this.createKnowledgeBase(resources);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventLister());
        ProcessInstance processInstance = ksession.startProcess("BPMN2-BusinessRuleTask");
        this.restoreSession(ksession, true);
        ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventLister());
        int fired = ksession.fireAllRules();
        SimplePersistedBPMNProcessTest.assertEquals((int)1, (int)fired);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testScriptTaskWithHistoryLog() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ScriptTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        SimplePersistedBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
        List logs = JPAProcessInstanceDbLog.findNodeInstances((long)processInstance.getId());
        SimplePersistedBPMNProcessTest.assertNotNull((Object)logs);
        SimplePersistedBPMNProcessTest.assertEquals((int)6, (int)logs.size());
        for (NodeInstanceLog log : logs) {
            SimplePersistedBPMNProcessTest.assertNotNull((Object)log.getDate());
        }
        ProcessInstanceLog pilog = JPAProcessInstanceDbLog.findProcessInstance((long)processInstance.getId());
        SimplePersistedBPMNProcessTest.assertNotNull((Object)pilog);
        SimplePersistedBPMNProcessTest.assertNotNull((Object)pilog.getEnd());
        List pilogs = JPAProcessInstanceDbLog.findActiveProcessInstances((String)processInstance.getProcessId());
        SimplePersistedBPMNProcessTest.assertNotNull((Object)pilogs);
        SimplePersistedBPMNProcessTest.assertEquals((int)0, (int)pilogs.size());
    }

    public void testIntermediateCatchEventTimerCycleWithError() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerCycleWithError.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        SimplePersistedBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        final long piId = processInstance.getId();
        ksession.execute((Command)new GenericCommand<Void>(){

            public Void execute(Context context) {
                StatefulKnowledgeSession ksession = ((KnowledgeCommandContext)context).getStatefulKnowledgesession();
                WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(piId);
                processInstance.setVariable("x", (Object)0);
                return null;
            }
        });
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        Integer xValue = (Integer)ksession.execute((Command)new GenericCommand<Integer>(){

            public Integer execute(Context context) {
                StatefulKnowledgeSession ksession = ((KnowledgeCommandContext)context).getStatefulKnowledgesession();
                WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(piId);
                return (Integer)processInstance.getVariable("x");
            }
        });
        SimplePersistedBPMNProcessTest.assertEquals((Object)new Integer(2), (Object)xValue);
        ksession.abortProcessInstance(processInstance.getId());
        this.assertProcessInstanceAborted(processInstance.getId(), ksession);
    }

    public void testCallActivityWithTimer() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-ParentProcess.bpmn2"), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-SubProcessWithTimer.bpmn2"), ResourceType.BPMN2);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        Environment env = EnvironmentFactory.newEnvironment();
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)emf);
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap params = new HashMap();
        ProcessInstance processInstance = ksession.startProcess("ParentProcess", params);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), null);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("sleep", "2s");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        int sessionId = ksession.getId();
        System.out.println("dispose");
        ksession.dispose();
        Thread.sleep(3000L);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KnowledgeBase)kbase, null, (Environment)env);
        Thread.sleep(3000L);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testProcesWithHumanTaskWithTimer() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-SubProcessWithTimer.bpmn2"), ResourceType.BPMN2);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        Environment env = EnvironmentFactory.newEnvironment();
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)emf);
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap params = new HashMap();
        ProcessInstance processInstance = ksession.startProcess("subproc", params);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), null);
        int sessionId = ksession.getId();
        ksession.dispose();
        Thread.sleep(3000L);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KnowledgeBase)kbase, null, (Environment)env);
        Thread.sleep(3000L);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }
}

