/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.persistence;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.Assert;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.base.MapGlobalResolver;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.impl.EnvironmentFactory;
import org.drools.io.ResourceFactory;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;
import org.jbpm.bpmn2.concurrency.MultipleProcessesPerThreadTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnmarshallingOverdueTimersTest {
    private static Logger logger = LoggerFactory.getLogger(MultipleProcessesPerThreadTest.class);
    private static EntityManagerFactory emf;
    private static PoolingDataSource pds;
    private static long seconds;
    private static String timeUnit;
    private static String bpmn2FileName;
    private static boolean debug;

    @Before
    public void setup() {
        pds = new PoolingDataSource();
        pds.setUniqueName("jdbc/testDS1");
        pds.setMaxPoolSize(16);
        pds.setAllowLocalTransactions(true);
        pds.setClassName("bitronix.tm.resource.jdbc.lrc.LrcXADataSource");
        pds.getDriverProperties().put("user", "sa");
        pds.getDriverProperties().put("password", "sasa");
        pds.getDriverProperties().put("url", "jdbc:h2:file:jbpm-test");
        pds.getDriverProperties().put("driverClassName", "org.h2.Driver");
        pds.init();
        emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        Assert.assertNotNull((String)"EntityManagerFactory is null.", (Object)emf);
    }

    @After
    public void tearDown() throws Exception {
        BitronixTransactionManager txm = TransactionManagerServices.getTransactionManager();
        if (txm != null) {
            txm.shutdown();
        }
        try {
            emf.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            pds.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static KnowledgeBase loadKnowledgeBase(String bpmn2FileName) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)bpmn2FileName, UnmarshallingOverdueTimersTest.class), ResourceType.BPMN2);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    private static Environment createEnvironment() {
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)emf);
        env.set("drools.transaction.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        env.set("drools.Globals", (Object)new MapGlobalResolver());
        return env;
    }

    private static StatefulKnowledgeSession createStatefulKnowledgeSession(KnowledgeBase kbase) {
        Environment env = UnmarshallingOverdueTimersTest.createEnvironment();
        return JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
    }

    private static int knowledgeSessionDispose(StatefulKnowledgeSession ksession) {
        int ksessionId = ksession.getId();
        logger.debug("disposing of ksesssion");
        ksession.dispose();
        return ksessionId;
    }

    private static StatefulKnowledgeSession reloadStatefulKnowledgeSession(String bpmn2FileName, int ksessionId) {
        KnowledgeBase kbase = UnmarshallingOverdueTimersTest.loadKnowledgeBase(bpmn2FileName);
        logger.debug(". reloading ksession " + ksessionId);
        Environment env = null;
        env = UnmarshallingOverdueTimersTest.createEnvironment();
        return JPAKnowledgeService.loadStatefulKnowledgeSession((int)ksessionId, (KnowledgeBase)kbase, null, (Environment)env);
    }

    @Test
    public void startDisposeAndReloadTimerProcess() throws Exception {
        ProcessInstance processInstance;
        StatefulKnowledgeSession ksession;
        String shellVar;
        String shellVarVal;
        if (debug && (shellVarVal = System.getenv(shellVar = "TEST")) != null) {
            debug = false;
        }
        String sessionPropName = "KSESSION_ID";
        String sessionPropVal = System.getenv(sessionPropName);
        String processPropName = "PROCESS_ID";
        String processPropVal = System.getenv(sessionPropName);
        if (sessionPropVal == null || debug) {
            KnowledgeBase kbase = UnmarshallingOverdueTimersTest.loadKnowledgeBase(bpmn2FileName);
            ksession = UnmarshallingOverdueTimersTest.createStatefulKnowledgeSession(kbase);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("time", seconds + timeUnit);
            Calendar cal = GregorianCalendar.getInstance();
            processInstance = ksession.startProcess("interruptedTimer", params);
            long processId = processInstance.getId();
            if (debug) {
                processPropVal = Long.toString(processId);
            } else {
                logger.info("export " + processPropName + "=" + processId);
            }
            KnowledgeSessionConfiguration config = ksession.getSessionConfiguration();
            int ksessionId = UnmarshallingOverdueTimersTest.knowledgeSessionDispose(ksession);
            if (debug) {
                sessionPropVal = Integer.toString(ksessionId);
            } else {
                logger.info("export " + sessionPropName + "=" + ksessionId);
            }
            if (!debug) {
                cal.add(13, (int)seconds);
                SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
                logger.info("\nPlease wait at least " + seconds + timeUnit + " [" + sdf.format(cal.getTime()) + "]\n");
            }
        }
        if (debug) {
            long wait = (long)((double)seconds * 1000.0 * 1.1);
            logger.debug("sleeping " + wait + " seconds");
            Thread.sleep(seconds * 1000L);
        }
        if (sessionPropVal != null || debug) {
            int ksessionId = Integer.parseInt(sessionPropVal);
            ksession = UnmarshallingOverdueTimersTest.reloadStatefulKnowledgeSession(bpmn2FileName, ksessionId);
            long processInstanceId = Integer.parseInt(processPropVal);
            logger.debug("! waiting 5 seconds for timer to fire");
            Thread.sleep(5000L);
            processInstance = ksession.getProcessInstance(processInstanceId);
            if (processInstance != null) {
                Assert.assertTrue((String)"Process has not terminated.", (processInstance.getState() == 2 ? 1 : 0) != 0);
            }
        }
    }

    static {
        seconds = 10L;
        timeUnit = "s";
        bpmn2FileName = "BPMN2-TimerInterrupted.bpmn2";
        debug = true;
    }
}

