/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.drools.core.util.DroolsStreamUtils;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.kie.KnowledgeBase;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.definition.KnowledgePackage;
import org.kie.io.ResourceFactory;
import org.kie.io.ResourceType;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.ProcessInstance;
import org.kie.runtime.process.WorkItemHandler;

public class BoundaryEventWithCancelActivityTest
extends JbpmBpmn2TestCase {
    @Override
    protected void setUp() {
        this.persistence = false;
    }

    public void testConditionalBoundaryEventInterrupting() throws Exception {
        KnowledgeBase kbase = this.readKnowledgeBaseFromDisc("BPMN2-ConditionalBoundaryEventInterrupting.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("ConditionalBoundaryEvent");
        BoundaryEventWithCancelActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        Person person = new Person();
        person.setName("john");
        ksession.insert((Object)person);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "Hello", "StartSubProcess", "Task", "BoundaryEvent", "Goodbye", "EndProcess");
    }

    public void testSignalBoundaryEventInterrupting() throws Exception {
        KnowledgeBase kbase = this.readKnowledgeBaseFromDisc("BPMN2-SignalBoundaryEventInterrupting.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("SignalBoundaryEvent");
        BoundaryEventWithCancelActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.signalEvent("MyMessage", null);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    private KnowledgeBase readKnowledgeBaseFromDisc(String process) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)process), ResourceType.BPMN2);
        File packageFile = null;
        Iterator i$ = kbuilder.getKnowledgePackages().iterator();
        if (i$.hasNext()) {
            KnowledgePackage pkg = (KnowledgePackage)i$.next();
            packageFile = new File(System.getProperty("java.io.tmpdir") + File.separator + pkg.getName() + ".pkg");
            this.writePackage(pkg, packageFile);
        }
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newFileResource(packageFile), ResourceType.PKG);
        return kbuilder.newKnowledgeBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePackage(KnowledgePackage kpackage, File p1file) throws IOException, FileNotFoundException {
        FileOutputStream out = new FileOutputStream(p1file);
        try {
            DroolsStreamUtils.streamOut((OutputStream)out, (Object)kpackage);
        }
        finally {
            out.close();
        }
    }
}

