/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.drools.core.util.FileManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.KnowledgeBase;
import org.kie.agent.KnowledgeAgent;
import org.kie.agent.KnowledgeAgentFactory;
import org.kie.definition.KnowledgePackage;
import org.kie.io.ResourceChangeScannerConfiguration;
import org.kie.io.ResourceFactory;

public class ScannerChangeSetTest {
    public static final String TMP_DIR = "target/classes/";
    FileManager fileManager;

    @Before
    public void setUp() throws Exception {
        this.fileManager = new FileManager();
        this.fileManager.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.fileManager.tearDown();
    }

    @Test
    @Ignore(value="Requires the implementation of the new agent infrastructure")
    public void testBPMNByResourceChangeScanner() throws Exception {
        File ruleFile = new File("target/classes/temporary.bpmn");
        ScannerChangeSetTest.copy(this.getClass().getResourceAsStream("/BPMN2-ScannerChangeSet.bpmn"), new FileOutputStream(ruleFile));
        String BPMN_CHANGESET = "<change-set xmlns=\"http://drools.org/drools-5.0/change-set\"\n            xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n            xs:schemaLocation=\"http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd\">\n  <add>\n    <resource source=\"file:" + ruleFile.getAbsolutePath() + "\" type=\"BPMN2\" />\n" + "  </add>\n" + "</change-set>\n";
        File bpmnChangeset = new File("target/classes/bpmnChangeset.xml");
        bpmnChangeset.deleteOnExit();
        ScannerChangeSetTest.writeToFile(bpmnChangeset, BPMN_CHANGESET);
        ResourceChangeScannerConfiguration config = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
        config.setProperty("drools.resource.scanner.interval", "1");
        ResourceFactory.getResourceChangeScannerService().configure(config);
        KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"bpmn agent");
        kagent.applyChangeSet(ResourceFactory.newFileResource((File)bpmnChangeset));
        KnowledgeBase kbase = kagent.getKnowledgeBase();
        ResourceFactory.getResourceChangeNotifierService().start();
        ResourceFactory.getResourceChangeScannerService().start();
        Assert.assertEquals((long)kbase.getKnowledgePackages().size(), (long)1L);
        Assert.assertEquals((long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size(), (long)6L);
        Thread.sleep(1500L);
        ruleFile.delete();
        ruleFile = new File("target/classes/temporary.bpmn");
        ScannerChangeSetTest.copy(this.getClass().getResourceAsStream("/BPMN2-ScannerChangeSet2.bpmn"), new FileOutputStream(ruleFile));
        Thread.sleep(1000L);
        Assert.assertEquals((long)kbase.getKnowledgePackages().size(), (long)1L);
        Assert.assertEquals((long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size(), (long)6L);
        kbase = kagent.getKnowledgeBase();
        Assert.assertEquals((long)kbase.getKnowledgePackages().size(), (long)1L);
        Assert.assertEquals((long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size(), (long)3L);
        ResourceFactory.getResourceChangeNotifierService().stop();
        ResourceFactory.getResourceChangeScannerService().stop();
        ruleFile.delete();
        kagent.dispose();
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(File file, String content) throws Exception {
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            fw.write(content);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    public class Message
    implements Serializable {
        private static final long serialVersionUID = -7176392345381065685L;
        private String message;

        public Message() {
            this.message = "";
        }

        public Message(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String toString() {
            return "org.jboss.qa.drools.domain.Message[message='" + this.message + "']";
        }
    }

    public static class Person {
        private int id;

        public void setId(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

