/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.drools.SessionConfiguration;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.impl.EnvironmentFactory;
import org.drools.xml.SemanticModule;
import org.jbpm.bpmn2.SimpleBPMNProcessTest;
import org.jbpm.bpmn2.handler.ReceiveTaskHandler;
import org.jbpm.bpmn2.handler.SendTaskHandler;
import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.process.ProcessBaseFactoryService;
import org.jbpm.process.instance.event.DefaultSignalManagerFactory;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.KnowledgeBaseFactoryService;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderConfiguration;
import org.kie.builder.KnowledgeBuilderError;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.definition.process.Process;
import org.kie.definition.process.WorkflowProcess;
import org.kie.event.process.DefaultProcessEventListener;
import org.kie.event.process.ProcessEventListener;
import org.kie.event.process.ProcessStartedEvent;
import org.kie.io.ResourceFactory;
import org.kie.io.ResourceType;
import org.kie.runtime.KieSessionConfiguration;
import org.kie.runtime.KnowledgeRuntime;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.ProcessInstance;
import org.kie.runtime.process.WorkItem;
import org.kie.runtime.process.WorkItemHandler;
import org.kie.runtime.process.WorkItemManager;
import org.kie.runtime.process.WorkflowProcessInstance;

public class StandaloneBPMNProcessTest
extends TestCase {
    public void tearDown() {
        KnowledgeBaseFactory.setKnowledgeBaseServiceFactory(null);
    }

    public void testMinimalProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Minimal");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testMinimalProcessWithGraphical() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcessWithGraphical.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Minimal");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testMinimalProcessWithDIGraphical() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcessWithDIGraphical.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Minimal");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testCompositeProcessWithDIGraphical() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-CompositeProcessWithDIGraphical.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Composite");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testScriptTask() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ScriptTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testDataObject() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-DataObject.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = ksession.startProcess("Evaluation", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testEvaluationProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("RegisterRequest", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = ksession.startProcess("Evaluation", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testEvaluationProcess2() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess2.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = ksession.startProcess("com.sample.evaluation", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testUserTask() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-UserTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        WorkItem workItem = workItemHandler.getWorkItem();
        StandaloneBPMNProcessTest.assertNotNull((Object)workItem);
        StandaloneBPMNProcessTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testLane() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-Lane.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        WorkItem workItem = workItemHandler.getWorkItem();
        StandaloneBPMNProcessTest.assertNotNull((Object)workItem);
        StandaloneBPMNProcessTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("ActorId", "mary");
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), results);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        workItem = workItemHandler.getWorkItem();
        StandaloneBPMNProcessTest.assertNotNull((Object)workItem);
        StandaloneBPMNProcessTest.assertEquals((Object)"mary", (Object)workItem.getParameter("ActorId"));
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    private StatefulKnowledgeSession restoreSession(StatefulKnowledgeSession ksession, boolean b) {
        return ksession;
    }

    public void testExclusiveSplit() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "First");
        params.put("y", "Second");
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testExclusiveSplitDefault() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitDefault.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "NotFirst");
        params.put("y", "Second");
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testInclusiveSplit() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testInclusiveSplitDefault() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitDefault.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", -5);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testEventBasedSplit() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testEventBasedSplitBefore() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
    }

    public void testEventBasedSplitAfter() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
    }

    public void testEventBasedSplit2() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit2.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        Thread.sleep(800L);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Thread.sleep(800L);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testEventBasedSplit4() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit4.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("Message-YesMessage", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        processInstance = ksession.startProcess("com.sample.test");
        ksession.signalEvent("Message-NoMessage", (Object)"NoValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testEventBasedSplit5() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit5.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ReceiveTaskHandler receiveTaskHandler = new ReceiveTaskHandler((KnowledgeRuntime)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        receiveTaskHandler.setKnowledgeRuntime((KnowledgeRuntime)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        receiveTaskHandler.messageReceived("YesMessage", (Object)"YesValue");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        receiveTaskHandler.messageReceived("NoMessage", (Object)"NoValue");
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        receiveTaskHandler.setKnowledgeRuntime((KnowledgeRuntime)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        processInstance = ksession.startProcess("com.sample.test");
        receiveTaskHandler.messageReceived("NoMessage", (Object)"NoValue");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        receiveTaskHandler.messageReceived("YesMessage", (Object)"YesValue");
    }

    public void testCallActivity() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivity.bpmn2"), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivitySubProcess.bpmn2"), ResourceType.BPMN2);
        if (!kbuilder.getErrors().isEmpty()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                System.err.println(error);
            }
            throw new IllegalArgumentException("Errors while parsing knowledge base");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        ProcessInstance processInstance = ksession.startProcess("ParentProcess", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
        StandaloneBPMNProcessTest.assertEquals((Object)"new value", (Object)((WorkflowProcessInstance)processInstance).getVariable("y"));
    }

    public void testSubProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-SubProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("SubProcess");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testMultiInstanceLoopCharacteristicsProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MultiInstanceLoopCharacteristicsProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        ProcessInstance processInstance = ksession.startProcess("MultiInstanceLoopCharacteristicsProcess", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testEscalationBoundaryEvent() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EscalationBoundaryEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("EscalationBoundaryEvent");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testEscalationBoundaryEventInterrupting() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EscalationBoundaryEventInterrupting.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("EscalationBoundaryEvent");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void testErrorBoundaryEvent() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ErrorBoundaryEventInterrupting.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("ErrorBoundaryEvent");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testIntermediateCatchEventSignal() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventSignal.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.signalEvent("MyMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testIntermediateCatchEventMessage() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventMessage.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.signalEvent("Message-HelloMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testIntermediateCatchEventTimer() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerDuration.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        ksession = this.restoreSession(ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testErrorEndEventProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ErrorEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("ErrorEndEvent");
        this.assertProcessInstanceAborted(processInstance.getId(), ksession);
    }

    public void testEscalationEndEventProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-EscalationEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("EscalationEndEvent");
        this.assertProcessInstanceAborted(processInstance.getId(), ksession);
    }

    public void testEscalationIntermediateThrowEventProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventEscalation.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("EscalationIntermediateThrowEvent");
        this.assertProcessInstanceAborted(processInstance.getId(), ksession);
    }

    public void testCompensateIntermediateThrowEventProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventCompensate.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("CompensateIntermediateThrowEvent");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testCompensateEndEventProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-CompensateEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("CompensateEndEvent");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testServiceTask() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ServiceProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("ServiceProcess", params);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        StandaloneBPMNProcessTest.assertEquals((Object)"Hello john!", (Object)processInstance.getVariable("s"));
    }

    public void testSendTask() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-SendTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("SendTask", params);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testReceiveTask() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ReceiveTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ReceiveTaskHandler receiveTaskHandler = new ReceiveTaskHandler((KnowledgeRuntime)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("ReceiveTask");
        StandaloneBPMNProcessTest.assertEquals((int)1, (int)processInstance.getState());
        ksession = this.restoreSession(ksession, true);
        receiveTaskHandler.messageReceived("HelloMessage", (Object)"Hello john!");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testSignalStart() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-SignalStart.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        ksession.signalEvent("MySignal", (Object)"NewValue");
        StandaloneBPMNProcessTest.assertEquals((int)1, (int)list.size());
    }

    public void testSignalEnd() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-SignalEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ksession.startProcess("SignalEndEvent", params);
    }

    public void testMessageStart() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MessageStart.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        ksession.signalEvent("Message-HelloMessage", (Object)"NewValue");
        StandaloneBPMNProcessTest.assertEquals((int)1, (int)list.size());
    }

    public void testMessageEnd() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MessageEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = ksession.startProcess("MessageEndEvent", params);
        StandaloneBPMNProcessTest.assertEquals((int)2, (int)processInstance.getState());
    }

    public void testMessageIntermediateThrow() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventMessage.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = ksession.startProcess("MessageIntermediateEvent", params);
        StandaloneBPMNProcessTest.assertEquals((int)2, (int)processInstance.getState());
    }

    public void testSignalIntermediateThrow() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventSignal.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = ksession.startProcess("SignalIntermediateEvent", params);
        StandaloneBPMNProcessTest.assertEquals((int)2, (int)processInstance.getState());
    }

    public void testNoneIntermediateThrow() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventNone.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("NoneIntermediateEvent", null);
        StandaloneBPMNProcessTest.assertEquals((int)2, (int)processInstance.getState());
    }

    private KnowledgeBase createKnowledgeBase(String process) throws Exception {
        KnowledgeBaseFactory.setKnowledgeBaseServiceFactory((KnowledgeBaseFactoryService)new ProcessBaseFactoryService());
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        ((PackageBuilderConfiguration)conf).initSemanticModules();
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNSemanticModule());
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        XmlProcessReader processReader = new XmlProcessReader(((PackageBuilderConfiguration)conf).getSemanticModules(), ((Object)((Object)this)).getClass().getClassLoader());
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        List processes = processReader.read(SimpleBPMNProcessTest.class.getResourceAsStream("/" + process));
        for (Process p : processes) {
            RuleFlowProcess ruleFlowProcess = (RuleFlowProcess)p;
            kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)ruleFlowProcess))), ResourceType.BPMN2);
        }
        if (!kbuilder.getErrors().isEmpty()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                System.err.println(error);
            }
            throw new IllegalArgumentException("Errors while parsing knowledge base");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KnowledgeBase kbase) {
        Properties defaultProps = new Properties();
        defaultProps.setProperty("drools.processSignalManagerFactory", DefaultSignalManagerFactory.class.getName());
        defaultProps.setProperty("drools.processInstanceManagerFactory", DefaultProcessInstanceManagerFactory.class.getName());
        SessionConfiguration sessionConfig = new SessionConfiguration(defaultProps);
        return kbase.newStatefulKnowledgeSession((KieSessionConfiguration)sessionConfig, EnvironmentFactory.newEnvironment());
    }

    public void assertProcessInstanceCompleted(long processInstanceId, StatefulKnowledgeSession ksession) {
        StandaloneBPMNProcessTest.assertNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    public void assertProcessInstanceAborted(long processInstanceId, StatefulKnowledgeSession ksession) {
        StandaloneBPMNProcessTest.assertNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    public void assertProcessInstanceActive(long processInstanceId, StatefulKnowledgeSession ksession) {
        StandaloneBPMNProcessTest.assertNotNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    public static class TestWorkItemHandler
    implements WorkItemHandler {
        private List<WorkItem> workItems = new ArrayList<WorkItem>();

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItems.add(workItem);
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }

        public WorkItem getWorkItem() {
            if (this.workItems.size() == 0) {
                return null;
            }
            if (this.workItems.size() == 1) {
                WorkItem result = this.workItems.get(0);
                this.workItems.clear();
                return result;
            }
            throw new IllegalArgumentException("More than one work item active");
        }

        public List<WorkItem> getWorkItems() {
            ArrayList<WorkItem> result = new ArrayList<WorkItem>(this.workItems);
            this.workItems.clear();
            return result;
        }
    }
}

