/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.persistence;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.WorkingMemory;
import org.drools.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.AgendaGroupPoppedEvent;
import org.drools.event.AgendaGroupPushedEvent;
import org.drools.event.BeforeActivationFiredEvent;
import org.drools.event.RuleFlowGroupActivatedEvent;
import org.drools.event.RuleFlowGroupDeactivatedEvent;
import org.drools.impl.EnvironmentFactory;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.xml.SemanticModule;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.SimpleBPMNProcessTest;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.process.audit.JPAProcessInstanceDbLog;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.instance.impl.RuleAwareProcessEventLister;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.ForEachNodeInstance;
import org.kie.KieBase;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderConfiguration;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.command.Command;
import org.kie.command.Context;
import org.kie.definition.process.WorkflowProcess;
import org.kie.event.process.DefaultProcessEventListener;
import org.kie.event.process.ProcessEventListener;
import org.kie.event.process.ProcessNodeLeftEvent;
import org.kie.event.process.ProcessNodeTriggeredEvent;
import org.kie.event.rule.DebugAgendaEventListener;
import org.kie.io.ResourceFactory;
import org.kie.io.ResourceType;
import org.kie.persistence.jpa.JPAKnowledgeService;
import org.kie.runtime.Environment;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.NodeInstance;
import org.kie.runtime.process.ProcessInstance;
import org.kie.runtime.process.WorkItem;
import org.kie.runtime.process.WorkItemHandler;
import org.kie.runtime.process.WorkflowProcessInstance;

public class SimplePersistenceBPMNProcessTest
extends JbpmBpmn2TestCase {
    public SimplePersistenceBPMNProcessTest() {
        super(true);
    }

    public void testBusinessRuleTask() throws Exception {
        HashMap<String, ResourceType> resources = new HashMap<String, ResourceType>();
        resources.put("BPMN2-BusinessRuleTask.bpmn2", ResourceType.BPMN2);
        resources.put("BPMN2-BusinessRuleTask.drl", ResourceType.DRL);
        KnowledgeBase kbase = this.createKnowledgeBase(resources);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventLister());
        ProcessInstance processInstance = ksession.startProcess("BPMN2-BusinessRuleTask");
        this.restoreSession(ksession, true);
        ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventLister());
        int fired = ksession.fireAllRules();
        SimplePersistenceBPMNProcessTest.assertEquals((int)1, (int)fired);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testScriptTaskWithHistoryLog() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ScriptTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        SimplePersistenceBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
        List logs = JPAProcessInstanceDbLog.findNodeInstances((long)processInstance.getId());
        SimplePersistenceBPMNProcessTest.assertNotNull((Object)logs);
        SimplePersistenceBPMNProcessTest.assertEquals((int)6, (int)logs.size());
        for (NodeInstanceLog log : logs) {
            SimplePersistenceBPMNProcessTest.assertNotNull((Object)log.getDate());
        }
        ProcessInstanceLog pilog = JPAProcessInstanceDbLog.findProcessInstance((long)processInstance.getId());
        SimplePersistenceBPMNProcessTest.assertNotNull((Object)pilog);
        SimplePersistenceBPMNProcessTest.assertNotNull((Object)pilog.getEnd());
        List pilogs = JPAProcessInstanceDbLog.findActiveProcessInstances((String)processInstance.getProcessId());
        SimplePersistenceBPMNProcessTest.assertNotNull((Object)pilogs);
        SimplePersistenceBPMNProcessTest.assertEquals((int)0, (int)pilogs.size());
    }

    public void testIntermediateCatchEventTimerCycleWithError() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerCycleWithError.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        SimplePersistenceBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        final long piId = processInstance.getId();
        ksession.execute((Command)new GenericCommand<Void>(){

            public Void execute(Context context) {
                StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)((KnowledgeCommandContext)context).getKieSession();
                WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(piId);
                processInstance.setVariable("x", (Object)0);
                return null;
            }
        });
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        Integer xValue = (Integer)ksession.execute((Command)new GenericCommand<Integer>(){

            public Integer execute(Context context) {
                StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)((KnowledgeCommandContext)context).getKieSession();
                WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(piId);
                return (Integer)processInstance.getVariable("x");
            }
        });
        SimplePersistenceBPMNProcessTest.assertEquals((Object)new Integer(2), (Object)xValue);
        ksession.abortProcessInstance(processInstance.getId());
        this.assertProcessInstanceAborted(processInstance.getId(), ksession);
    }

    public void testCallActivityWithTimer() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-ParentProcess.bpmn2"), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-SubProcessWithTimer.bpmn2"), ResourceType.BPMN2);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        Environment env = EnvironmentFactory.newEnvironment();
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        env.set("org.kie.persistence.jpa.EntityManagerFactory", (Object)emf);
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap params = new HashMap();
        ProcessInstance processInstance = ksession.startProcess("ParentProcess", params);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), null);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("sleep", "2s");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        int sessionId = ksession.getId();
        System.out.println("dispose");
        ksession.dispose();
        Thread.sleep(3000L);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)env);
        Thread.sleep(3000L);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testProcesWithHumanTaskWithTimer() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-SubProcessWithTimer.bpmn2"), ResourceType.BPMN2);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        Environment env = EnvironmentFactory.newEnvironment();
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        env.set("org.kie.persistence.jpa.EntityManagerFactory", (Object)emf);
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap params = new HashMap();
        ProcessInstance processInstance = ksession.startProcess("subproc", params);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), null);
        int sessionId = ksession.getId();
        ksession.dispose();
        Thread.sleep(3000L);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)env);
        Thread.sleep(3000L);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testBusinessRuleTaskWithDataInputs() throws Exception {
        HashMap<String, ResourceType> resources = new HashMap<String, ResourceType>();
        resources.put("BPMN2-BusinessRuleTaskWithDataInputs.bpmn2", ResourceType.BPMN2);
        resources.put("BPMN2-BusinessRuleTaskWithDataInput.drl", ResourceType.DRL);
        KnowledgeBase kbase = this.createKnowledgeBase(resources);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Person> params = new HashMap<String, Person>();
        params.put("person", new Person());
        ProcessInstance processInstance = ksession.startProcess("BPMN2-BusinessRuleTask", params);
        int fired = ksession.fireAllRules();
        SimplePersistenceBPMNProcessTest.assertEquals((int)1, (int)fired);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testBusinessRuleTaskDynamic() throws Exception {
        HashMap<String, ResourceType> resources = new HashMap<String, ResourceType>();
        resources.put("BPMN2-BusinessRuleTaskDynamic.bpmn2", ResourceType.BPMN2);
        resources.put("BPMN2-BusinessRuleTask.drl", ResourceType.DRL);
        KnowledgeBase kbase = this.createKnowledgeBase(resources);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventLister());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dynamicrule", "MyRuleFlow");
        ProcessInstance processInstance = ksession.startProcess("BPMN2-BusinessRuleTask", params);
        int fired = ksession.fireAllRules();
        SimplePersistenceBPMNProcessTest.assertEquals((int)1, (int)fired);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testCompensateEndEventProcess() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-CompensateEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("CompensateEndEvent");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "Task", "CompensateEvent", "CompensateEvent2", "Compensate", "EndEvent");
    }

    public void testSignalBoundaryEventOnTask() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-BoundarySignalEventOnTaskbpmn2.bpmn");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new JbpmBpmn2TestCase.TestWorkItemHandler());
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                System.out.println("After node left " + event.getNodeInstance().getNodeName());
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                System.out.println("After node triggered " + event.getNodeInstance().getNodeName());
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                System.out.println("Before node left " + event.getNodeInstance().getNodeName());
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                System.out.println("Before node triggered " + event.getNodeInstance().getNodeName());
            }
        });
        ProcessInstance processInstance = ksession.startProcess("BoundarySignalOnTask");
        ksession.signalEvent("MySignal", (Object)"hello");
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "User Task", "Boundary event", "Signal received", "End2");
    }

    public void testIntermediateCatchEventSignal() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventSignal.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        SimplePersistenceBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        ksession.signalEvent("MyMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "UserTask", "EndProcess", "event");
    }

    public void testRuleTaskWithFacts() throws Exception {
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        ((PackageBuilderConfiguration)conf).initSemanticModules();
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNSemanticModule());
        ((PackageBuilderConfiguration)conf).addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        XmlProcessReader processReader = new XmlProcessReader(((PackageBuilderConfiguration)conf).getSemanticModules(), ((Object)((Object)this)).getClass().getClassLoader());
        List processes = processReader.read(SimpleBPMNProcessTest.class.getResourceAsStream("/BPMN2-RuleTaskWithFact.bpmn2"));
        SimplePersistenceBPMNProcessTest.assertNotNull((Object)processes);
        SimplePersistenceBPMNProcessTest.assertEquals((int)1, (int)processes.size());
        RuleFlowProcess p = (RuleFlowProcess)processes.get(0);
        SimplePersistenceBPMNProcessTest.assertNotNull((Object)p);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)p))), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-RuleTask3.drl"), ResourceType.DRL);
        if (!kbuilder.getErrors().isEmpty()) {
            throw new IllegalArgumentException("Errors while parsing knowledge base");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        final StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener agendaEventListener = new AgendaEventListener(){

            public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
                ksession.fireAllRules();
            }

            public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
            }

            public void beforeActivationFired(BeforeActivationFiredEvent event, WorkingMemory workingMemory) {
            }

            public void afterActivationFired(AfterActivationFiredEvent event, WorkingMemory workingMemory) {
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event, WorkingMemory workingMemory) {
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event, WorkingMemory workingMemory) {
            }

            public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
            }

            public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
                workingMemory.fireAllRules();
            }

            public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
            }

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
            }
        };
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession()).session.addEventListener(agendaEventListener);
        ksession.addEventListener((org.kie.event.rule.AgendaEventListener)new DebugAgendaEventListener());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "SomeString");
        ProcessInstance processInstance = ksession.startProcess("RuleTask", params);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
        params = new HashMap();
        try {
            processInstance = ksession.startProcess("RuleTask", params);
            SimplePersistenceBPMNProcessTest.fail((String)"Should fail");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        params = new HashMap();
        params.put("x", "SomeString");
        processInstance = ksession.startProcess("RuleTask", params);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testInclusiveSplitAndJoin() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoin.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        SimplePersistenceBPMNProcessTest.assertEquals((int)2, (int)activeWorkItems.size());
        this.restoreSession(ksession, true);
        for (WorkItem wi : activeWorkItems) {
            ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testInclusiveSplitAndJoinNested() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinNested.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        SimplePersistenceBPMNProcessTest.assertEquals((int)2, (int)activeWorkItems.size());
        this.restoreSession(ksession, true);
        for (WorkItem wi : activeWorkItems) {
            ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        activeWorkItems = workItemHandler.getWorkItems();
        SimplePersistenceBPMNProcessTest.assertEquals((int)2, (int)activeWorkItems.size());
        this.restoreSession(ksession, true);
        for (WorkItem wi : activeWorkItems) {
            ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testInclusiveSplitAndJoinEmbedded() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinEmbedded.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        SimplePersistenceBPMNProcessTest.assertEquals((int)2, (int)activeWorkItems.size());
        this.restoreSession(ksession, true);
        for (WorkItem wi : activeWorkItems) {
            ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testInclusiveSplitAndJoinWithParallel() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinWithParallel.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 25);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        SimplePersistenceBPMNProcessTest.assertEquals((int)4, (int)activeWorkItems.size());
        this.restoreSession(ksession, true);
        for (WorkItem wi : activeWorkItems) {
            ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testInclusiveSplitAndJoinWithEnd() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinWithEnd.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 25);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        SimplePersistenceBPMNProcessTest.assertEquals((int)3, (int)activeWorkItems.size());
        this.restoreSession(ksession, true);
        for (int i = 0; i < 2; ++i) {
            ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(i).getId(), null);
        }
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(2).getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testInclusiveSplitAndJoinWithTimer() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinWithTimer.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        SimplePersistenceBPMNProcessTest.assertEquals((int)1, (int)activeWorkItems.size());
        ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(0).getId(), null);
        ksession.fireAllRules();
        Thread.sleep(3000L);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        activeWorkItems = workItemHandler.getWorkItems();
        SimplePersistenceBPMNProcessTest.assertEquals((int)2, (int)activeWorkItems.size());
        ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(0).getId(), null);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(1).getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testInclusiveSplitAndJoinExtraPath() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinExtraPath.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 25);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        ksession.signalEvent("signal", null);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        SimplePersistenceBPMNProcessTest.assertEquals((int)4, (int)activeWorkItems.size());
        this.restoreSession(ksession, true);
        for (int i = 0; i < 3; ++i) {
            ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(i).getId(), null);
        }
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(3).getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testMultiInstanceLoopCharacteristicsProcessWithORGateway() throws Exception {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-MultiInstanceLoopCharacteristicsProcessWithORgateway.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap params = new HashMap();
        ArrayList<Integer> myList = new ArrayList<Integer>();
        myList.add(12);
        myList.add(15);
        params.put("list", myList);
        ProcessInstance processInstance = ksession.startProcess("MultiInstanceLoopCharacteristicsProcess", params);
        List<WorkItem> workItems = workItemHandler.getWorkItems();
        SimplePersistenceBPMNProcessTest.assertEquals((int)4, (int)workItems.size());
        Collection nodeInstances = ((WorkflowProcessInstanceImpl)processInstance).getNodeInstances();
        SimplePersistenceBPMNProcessTest.assertEquals((int)1, (int)nodeInstances.size());
        NodeInstance nodeInstance = (NodeInstance)nodeInstances.iterator().next();
        SimplePersistenceBPMNProcessTest.assertTrue((boolean)(nodeInstance instanceof ForEachNodeInstance));
        Collection nodeInstancesChild = ((ForEachNodeInstance)nodeInstance).getNodeInstances();
        SimplePersistenceBPMNProcessTest.assertEquals((int)2, (int)nodeInstancesChild.size());
        for (NodeInstance child : nodeInstancesChild) {
            SimplePersistenceBPMNProcessTest.assertTrue((boolean)(child instanceof CompositeContextNodeInstance));
            SimplePersistenceBPMNProcessTest.assertEquals((int)2, (int)((CompositeContextNodeInstance)child).getNodeInstances().size());
        }
        ksession.getWorkItemManager().completeWorkItem(workItems.get(0).getId(), null);
        ksession.getWorkItemManager().completeWorkItem(workItems.get(1).getId(), null);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        nodeInstances = ((WorkflowProcessInstanceImpl)processInstance).getNodeInstances();
        SimplePersistenceBPMNProcessTest.assertEquals((int)1, (int)nodeInstances.size());
        nodeInstance = (NodeInstance)nodeInstances.iterator().next();
        SimplePersistenceBPMNProcessTest.assertTrue((boolean)(nodeInstance instanceof ForEachNodeInstance));
        nodeInstancesChild = ((ForEachNodeInstance)nodeInstance).getNodeInstances();
        SimplePersistenceBPMNProcessTest.assertEquals((int)1, (int)nodeInstancesChild.size());
        Iterator childIterator = nodeInstancesChild.iterator();
        SimplePersistenceBPMNProcessTest.assertTrue((boolean)(childIterator.next() instanceof CompositeContextNodeInstance));
        ksession.getWorkItemManager().completeWorkItem(workItems.get(2).getId(), null);
        ksession.getWorkItemManager().completeWorkItem(workItems.get(3).getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }
}

