/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.persistence;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.persistence.EntityManagerFactory;
import org.drools.WorkingMemory;
import org.drools.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.AgendaGroupPoppedEvent;
import org.drools.event.AgendaGroupPushedEvent;
import org.drools.event.BeforeActivationFiredEvent;
import org.drools.event.RuleFlowGroupActivatedEvent;
import org.drools.event.RuleFlowGroupDeactivatedEvent;
import org.drools.impl.EnvironmentFactory;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.audit.AuditLoggerFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.KieBase;
import org.kie.KnowledgeBase;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.definition.KnowledgePackage;
import org.kie.event.KnowledgeRuntimeEventManager;
import org.kie.event.process.DefaultProcessEventListener;
import org.kie.event.process.ProcessEventListener;
import org.kie.event.process.ProcessStartedEvent;
import org.kie.io.ResourceFactory;
import org.kie.io.ResourceType;
import org.kie.persistence.jpa.JPAKnowledgeService;
import org.kie.runtime.Environment;
import org.kie.runtime.StatefulKnowledgeSession;

public class TimerCycleOnBinaryPackageTest {
    private HashMap<String, Object> context;
    private Environment env;

    @Before
    public void setUp() {
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        this.env = EnvironmentFactory.newEnvironment();
        EntityManagerFactory emf = (EntityManagerFactory)this.context.get("org.kie.persistence.jpa.EntityManagerFactory");
        this.env.set("org.kie.persistence.jpa.EntityManagerFactory", (Object)emf);
    }

    @After
    public void tearDown() {
        this.env = null;
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testStartTimerCycleFromDisc() throws Exception {
        KnowledgeBase kbase = this.readKnowledgeBaseFromDisc();
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KnowledgeRuntimeEventManager)ksession, null);
        int sessionId = ksession.getId();
        final ArrayList list = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        Assert.assertEquals((long)2L, (long)list.size());
        System.out.println("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)this.env);
        AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KnowledgeRuntimeEventManager)ksession, null);
        final ArrayList list2 = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list2.add(event.getProcessInstance().getId());
            }
        });
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        Assert.assertEquals((long)3L, (long)list2.size());
        ksession.dispose();
    }

    @Test
    public void testStartTimerCycleFromClassPath() throws Exception {
        KnowledgeBase kbase = this.readKnowledgeBase();
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KnowledgeRuntimeEventManager)ksession, null);
        int sessionId = ksession.getId();
        final ArrayList list = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        Assert.assertEquals((long)2L, (long)list.size());
        System.out.println("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)this.env);
        AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KnowledgeRuntimeEventManager)ksession, null);
        final ArrayList list2 = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list2.add(event.getProcessInstance().getId());
            }
        });
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        Assert.assertEquals((long)3L, (long)list2.size());
        ksession.dispose();
    }

    @Test
    public void testStartTimerCycleFromDiscDRL() throws Exception {
        KnowledgeBase kbase = this.readKnowledgeBaseFromDiscDRL();
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KnowledgeRuntimeEventManager)ksession, null);
        int sessionId = ksession.getId();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        Assert.assertEquals((long)2L, (long)list.size());
        System.out.println("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)this.env);
        AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KnowledgeRuntimeEventManager)ksession, null);
        ArrayList list2 = new ArrayList();
        ksession.setGlobal("list", list2);
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        Assert.assertEquals((long)3L, (long)list2.size());
        ksession.dispose();
    }

    @Test
    public void testStartTimerCycleFromClasspathDRL() throws Exception {
        KnowledgeBase kbase = this.readKnowledgeBaseDRL();
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KnowledgeRuntimeEventManager)ksession, null);
        int sessionId = ksession.getId();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        Assert.assertEquals((long)2L, (long)list.size());
        System.out.println("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)this.env);
        AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KnowledgeRuntimeEventManager)ksession, null);
        ArrayList list2 = new ArrayList();
        ksession.setGlobal("list", list2);
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        Assert.assertEquals((long)3L, (long)list2.size());
        ksession.dispose();
    }

    private KnowledgeBase readKnowledgeBaseFromDisc() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-StartTimerCycle.bpmn2"), ResourceType.BPMN2);
        File packageFile = null;
        Iterator i$ = kbuilder.getKnowledgePackages().iterator();
        if (i$.hasNext()) {
            KnowledgePackage pkg = (KnowledgePackage)i$.next();
            packageFile = new File(System.getProperty("java.io.tmpdir") + File.separator + pkg.getName() + ".pkg");
            this.writePackage(pkg, packageFile);
        }
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newFileResource(packageFile), ResourceType.PKG);
        return kbuilder.newKnowledgeBase();
    }

    private KnowledgeBase readKnowledgeBase() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-StartTimerCycle.bpmn2"), ResourceType.BPMN2);
        return kbuilder.newKnowledgeBase();
    }

    private KnowledgeBase readKnowledgeBaseFromDiscDRL() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"rules-timer.drl"), ResourceType.DRL);
        File packageFile = null;
        Iterator i$ = kbuilder.getKnowledgePackages().iterator();
        if (i$.hasNext()) {
            KnowledgePackage pkg = (KnowledgePackage)i$.next();
            packageFile = new File(System.getProperty("java.io.tmpdir") + File.separator + pkg.getName() + ".pkg");
            this.writePackage(pkg, packageFile);
        }
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newFileResource(packageFile), ResourceType.PKG);
        return kbuilder.newKnowledgeBase();
    }

    private KnowledgeBase readKnowledgeBaseDRL() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"rules-timer.drl"), ResourceType.DRL);
        return kbuilder.newKnowledgeBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePackage(KnowledgePackage kpackage, File p1file) throws IOException, FileNotFoundException {
        FileOutputStream out = new FileOutputStream(p1file);
        try {
            DroolsStreamUtils.streamOut((OutputStream)out, (Object)kpackage);
        }
        finally {
            out.close();
        }
    }

    private static class TriggerRulesEventListener
    implements AgendaEventListener {
        private StatefulKnowledgeSession ksession;

        public TriggerRulesEventListener(StatefulKnowledgeSession ksession) {
            this.ksession = ksession;
        }

        public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
            this.ksession.fireAllRules();
        }

        public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
        }

        public void beforeActivationFired(BeforeActivationFiredEvent event, WorkingMemory workingMemory) {
        }

        public void afterActivationFired(AfterActivationFiredEvent event, WorkingMemory workingMemory) {
        }

        public void agendaGroupPopped(AgendaGroupPoppedEvent event, WorkingMemory workingMemory) {
        }

        public void agendaGroupPushed(AgendaGroupPushedEvent event, WorkingMemory workingMemory) {
        }

        public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
        }

        public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
            workingMemory.fireAllRules();
        }

        public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
        }

        public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
        }
    }
}

