/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import org.drools.impl.EnvironmentFactory;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.KieBase;
import org.kie.KnowledgeBase;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.event.process.DefaultProcessEventListener;
import org.kie.event.process.ProcessEventListener;
import org.kie.event.process.ProcessNodeLeftEvent;
import org.kie.io.ResourceFactory;
import org.kie.io.ResourceType;
import org.kie.persistence.jpa.JPAKnowledgeService;
import org.kie.runtime.Environment;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.ProcessInstance;
import org.kie.runtime.process.WorkItemHandler;

public class TimerPersistenceTest {
    private HashMap<String, Object> context;
    private Environment env;

    @Before
    public void setUp() {
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        this.env = EnvironmentFactory.newEnvironment();
        EntityManagerFactory emf = (EntityManagerFactory)this.context.get("org.kie.persistence.jpa.EntityManagerFactory");
        this.env.set("org.kie.persistence.jpa.EntityManagerFactory", (Object)emf);
    }

    @After
    public void tearDown() {
        this.env = null;
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testTimerBoundaryEventCycleISO() throws Exception {
        KnowledgeBase kbase = this.readKnowledgeBase("BPMN2-TimerBoundaryEventCycleISO.bpmn2");
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        final ArrayList list = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("TimerEvent")) {
                    list.add(event.getProcessInstance().getId());
                }
            }
        };
        ksession.addEventListener((ProcessEventListener)listener);
        int sessionId = ksession.getId();
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("TimerBoundaryEvent");
        Assert.assertEquals((long)processInstance.getState(), (long)1L);
        Thread.sleep(1000L);
        Assert.assertEquals((long)processInstance.getState(), (long)1L);
        System.out.println("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)this.env);
        ksession.addEventListener((ProcessEventListener)listener);
        Thread.sleep(1000L);
        Assert.assertEquals((long)processInstance.getState(), (long)1L);
        Thread.sleep(2000L);
        Assert.assertEquals((long)processInstance.getState(), (long)1L);
        ksession.abortProcessInstance(processInstance.getId());
        Thread.sleep(1000L);
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    private KnowledgeBase readKnowledgeBase(String process) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)process), ResourceType.BPMN2);
        return kbuilder.newKnowledgeBase();
    }
}

