/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.structureref;

import java.util.HashMap;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.kie.KnowledgeBase;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.ProcessInstance;
import org.kie.runtime.process.WorkItemHandler;

public class StructureRefTest
extends JbpmBpmn2TestCase {
    public StructureRefTest() {
        super(true);
    }

    public void testStringStructureRef() {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-StringStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        StructureRefTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "test value");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testBooleanStructureRef() {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-BooleanStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        StructureRefTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "true");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testIntegerStructureRef() {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-IntegerStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        StructureRefTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "25");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testFloatStructureRef() {
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-FloatStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        StructureRefTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "5.5");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testObjectStructureRef() {
        String personAsXml = "<org.jbpm.bpmn2.objects.Person><id>1</id><name>john</name></org.jbpm.bpmn2.objects.Person>";
        KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-ObjectStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        JbpmBpmn2TestCase.TestWorkItemHandler workItemHandler = new JbpmBpmn2TestCase.TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        StructureRefTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", personAsXml);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    public void testNoStructureRef() {
        try {
            KnowledgeBase kbase = this.createKnowledgeBase("BPMN2-NoStructureRef.bpmn2");
            StructureRefTest.fail((String)"Structure ref must be defined for a process");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

