/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.List;
import java.util.Map;
import org.drools.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.core.Error;
import org.jbpm.bpmn2.core.Escalation;
import org.jbpm.bpmn2.core.Message;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ConstraintTrigger;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.Trigger;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StartEventHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        return new StartNode();
    }

    public Class generateNodeFor() {
        return StartNode.class;
    }

    @Override
    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        StartNode startNode = (StartNode)node;
        startNode.setInterupting(Boolean.parseBoolean(element.getAttribute("isInterrupting")));
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String activityRef;
            EventTypeFilter eventFilter;
            EventTrigger trigger;
            String nodeName = xmlNode.getNodeName();
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, startNode);
            } else {
                String escalationRef;
                String mapping;
                EventTypeFilter eventFilter2;
                EventTrigger trigger2;
                if ("conditionalEventDefinition".equals(nodeName)) {
                    String constraint = null;
                    for (org.w3c.dom.Node subNode = xmlNode.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                        String subnodeName = subNode.getNodeName();
                        if (!"condition".equals(subnodeName)) continue;
                        constraint = xmlNode.getTextContent();
                        break;
                    }
                    ConstraintTrigger trigger3 = new ConstraintTrigger();
                    trigger3.setConstraint(constraint);
                    startNode.addTrigger((Trigger)trigger3);
                    break;
                }
                if ("signalEventDefinition".equals(nodeName)) {
                    String type = ((Element)xmlNode).getAttribute("signalRef");
                    if (type != null && type.trim().length() > 0) {
                        trigger = new EventTrigger();
                        eventFilter = new EventTypeFilter();
                        eventFilter.setType(type);
                        trigger.addEventFilter((EventFilter)eventFilter);
                        String mapping2 = (String)startNode.getMetaData("TriggerMapping");
                        if (mapping2 != null) {
                            trigger.addInMapping(mapping2, "event");
                        }
                        startNode.addTrigger((Trigger)trigger);
                    }
                } else if ("messageEventDefinition".equals(nodeName)) {
                    String messageRef = ((Element)xmlNode).getAttribute("messageRef");
                    Map messages = (Map)((ProcessBuildData)parser.getData()).getMetaData("Messages");
                    if (messages == null) {
                        throw new IllegalArgumentException("No messages found");
                    }
                    Message message = (Message)messages.get(messageRef);
                    if (message == null) {
                        throw new IllegalArgumentException("Could not find message " + messageRef);
                    }
                    startNode.setMetaData("MessageType", (Object)message.getType());
                    trigger2 = new EventTrigger();
                    eventFilter2 = new EventTypeFilter();
                    eventFilter2.setType("Message-" + messageRef);
                    trigger2.addEventFilter((EventFilter)eventFilter2);
                    mapping = (String)startNode.getMetaData("TriggerMapping");
                    if (mapping != null) {
                        trigger2.addInMapping(mapping, "event");
                    }
                    startNode.addTrigger((Trigger)trigger2);
                } else if ("timerEventDefinition".equals(nodeName)) {
                    org.w3c.dom.Node subNode = xmlNode.getFirstChild();
                    while (subNode instanceof Element) {
                        ConstraintTrigger trigger4;
                        String period;
                        String subNodeName = subNode.getNodeName();
                        Timer timer = null;
                        if (parser.getParent() instanceof EventSubProcessNode) {
                            timer = new Timer();
                            trigger2 = new EventTrigger();
                            eventFilter2 = new EventTypeFilter();
                            eventFilter2.setType("Timer-" + ((EventSubProcessNode)parser.getParent()).getId());
                            trigger2.addEventFilter((EventFilter)eventFilter2);
                            mapping = (String)startNode.getMetaData("TriggerMapping");
                            if (mapping != null) {
                                trigger2.addInMapping(mapping, "event");
                            }
                            startNode.addTrigger((Trigger)trigger2);
                        }
                        if ("timeCycle".equals(subNodeName)) {
                            period = "";
                            String repeatLimit = "-1";
                            String delay = subNode.getTextContent();
                            String language = ((Element)subNode).getAttribute("language");
                            if (language == null || language.trim().length() == 0) {
                                language = "int";
                            }
                            if ("int".equalsIgnoreCase(language)) {
                                long[] repeatTimer = DateTimeUtils.parseRepeatableDateTime((String)delay);
                                if (repeatTimer.length == 1) {
                                    startNode.setMetaData("TimerDef", (Object)delay);
                                    delay = Long.toString(repeatTimer[0]);
                                    period = Long.toString(repeatTimer[0]);
                                } else {
                                    startNode.setMetaData("TimerDef", (Object)delay);
                                    repeatLimit = Long.toString(repeatTimer[0] + 1L);
                                    delay = Long.toString(repeatTimer[1]);
                                    period = Long.toString(repeatTimer[2]);
                                }
                            }
                            if (delay != null && delay.trim().length() > 0) {
                                startNode.setMetaData("TimerType", (Object)2);
                                if (timer != null) {
                                    timer.setDelay(delay);
                                    timer.setPeriod(period);
                                    timer.setTimeType(Integer.valueOf(2).intValue());
                                    ((EventSubProcessNode)parser.getParent()).addTimer(timer, (DroolsAction)new DroolsConsequenceAction("java", ""));
                                } else {
                                    ConstraintTrigger trigger5 = new ConstraintTrigger();
                                    trigger5.setConstraint("");
                                    if ("int".equals(language)) {
                                        if (repeatLimit.equals("-1")) {
                                            trigger5.setHeader("timer (int:" + delay + " " + period + ")");
                                        } else {
                                            trigger5.setHeader("timer (int:" + delay + " " + period + " repeat-limit=" + repeatLimit + ")");
                                        }
                                    } else {
                                        trigger5.setHeader("timer (" + language + ":" + delay + ")");
                                    }
                                    startNode.addTrigger((Trigger)trigger5);
                                }
                                break;
                            }
                        } else if ("timeDuration".equals(subNodeName)) {
                            period = Long.toString(DateTimeUtils.parseDuration((String)subNode.getTextContent()));
                            if (period != null && period.trim().length() > 0) {
                                startNode.setMetaData("TimerDef", (Object)period);
                                startNode.setMetaData("TimerType", (Object)1);
                                if (timer != null) {
                                    timer.setDelay(period);
                                    timer.setTimeType(Integer.valueOf(1).intValue());
                                    ((EventSubProcessNode)parser.getParent()).addTimer(timer, (DroolsAction)new DroolsConsequenceAction("java", ""));
                                } else {
                                    trigger4 = new ConstraintTrigger();
                                    trigger4.setConstraint("");
                                    trigger4.setHeader("timer (int:" + period + " 0)");
                                    startNode.addTrigger((Trigger)trigger4);
                                }
                                break;
                            }
                        } else if ("timeDate".equals(subNodeName) && (period = Long.toString(DateTimeUtils.parseDateAsDuration((String)subNode.getTextContent()))) != null && period.trim().length() > 0) {
                            startNode.setMetaData("TimerDef", (Object)period);
                            startNode.setMetaData("TimerType", (Object)3);
                            if (timer != null) {
                                timer.setDate(period);
                                timer.setTimeType(Integer.valueOf(3).intValue());
                                ((EventSubProcessNode)parser.getParent()).addTimer(timer, (DroolsAction)new DroolsConsequenceAction("java", ""));
                            } else {
                                trigger4 = new ConstraintTrigger();
                                trigger4.setConstraint("");
                                trigger4.setHeader("timer (int:" + period + " 0)");
                                startNode.addTrigger((Trigger)trigger4);
                            }
                            break;
                        }
                        subNode = subNode.getNextSibling();
                    }
                } else if ("errorEventDefinition".equals(nodeName)) {
                    String errorRef = ((Element)xmlNode).getAttribute("errorRef");
                    if (errorRef != null && errorRef.trim().length() > 0) {
                        Map errors = (Map)((ProcessBuildData)parser.getData()).getMetaData("Errors");
                        if (errors == null) {
                            throw new IllegalArgumentException("No errors found");
                        }
                        Error error = (Error)errors.get(errorRef);
                        if (error == null) {
                            throw new IllegalArgumentException("Could not find error " + errorRef);
                        }
                        trigger2 = new EventTrigger();
                        eventFilter2 = new EventTypeFilter();
                        eventFilter2.setType("Error-" + error.getErrorCode());
                        trigger2.addEventFilter((EventFilter)eventFilter2);
                        startNode.addTrigger((Trigger)trigger2);
                    }
                } else if ("escalationEventDefinition".equals(nodeName) && (escalationRef = ((Element)xmlNode).getAttribute("escalationRef")) != null && escalationRef.trim().length() > 0) {
                    Map escalations = (Map)((ProcessBuildData)parser.getData()).getMetaData("Escalations");
                    if (escalations == null) {
                        throw new IllegalArgumentException("No escalations found");
                    }
                    Escalation escalation = (Escalation)escalations.get(escalationRef);
                    if (escalation == null) {
                        throw new IllegalArgumentException("Could not find escalation " + escalationRef);
                    }
                    trigger2 = new EventTrigger();
                    eventFilter2 = new EventTypeFilter();
                    eventFilter2.setType("Escalation-" + escalation.getEscalationCode());
                    trigger2.addEventFilter((EventFilter)eventFilter2);
                    startNode.addTrigger((Trigger)trigger2);
                }
            }
            if (!"compensateEventDefinition".equals(nodeName) || (activityRef = ((Element)xmlNode).getAttribute("activityRef")) == null || activityRef.trim().length() <= 0) continue;
            trigger = new EventTrigger();
            eventFilter = new EventTypeFilter();
            eventFilter.setType("Compensate-" + activityRef);
            trigger.addEventFilter((EventFilter)eventFilter);
            startNode.addTrigger((Trigger)trigger);
        }
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, StartNode startNode) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        if ("sourceRef".equals(subNode.getNodeName())) {
            subNode = subNode.getNextSibling();
        }
        String to = subNode.getTextContent();
        startNode.setMetaData("TriggerMapping", (Object)to);
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        List triggers;
        StartNode startNode = (StartNode)node;
        this.writeNode("startEvent", (Node)startNode, xmlDump, metaDataType);
        if (startNode.isInterupting()) {
            xmlDump.append(" isInterrupting=\"true\" ");
        }
        if ((triggers = startNode.getTriggers()) != null) {
            xmlDump.append(">" + EOL);
            if (triggers.size() > 1) {
                throw new IllegalArgumentException("Multiple start triggers not supported");
            }
            Trigger trigger = (Trigger)triggers.get(0);
            if (trigger instanceof ConstraintTrigger) {
                ConstraintTrigger constraintTrigger = (ConstraintTrigger)trigger;
                if (constraintTrigger.getHeader() == null) {
                    xmlDump.append("      <conditionalEventDefinition>" + EOL);
                    xmlDump.append("        <condition xsi:type=\"tFormalExpression\" language=\"http://www.jboss.org/drools/rule\">" + constraintTrigger.getConstraint() + "</condition>" + EOL);
                    xmlDump.append("      </conditionalEventDefinition>" + EOL);
                } else {
                    Integer timerType = (Integer)startNode.getMetaData("TimerType");
                    if (timerType == 1) {
                        xmlDump.append("      <timerEventDefinition>" + EOL);
                        xmlDump.append("        <timeDuration xsi:type=\"tFormalExpression\" >" + startNode.getMetaData("TimerDef") + "</timeDuration>" + EOL);
                        xmlDump.append("      </timerEventDefinition>" + EOL);
                    } else if (timerType == 3) {
                        xmlDump.append("      <timerEventDefinition>" + EOL);
                        xmlDump.append("        <timeDate xsi:type=\"tFormalExpression\" >" + startNode.getMetaData("TimerDef") + "</timeDate>" + EOL);
                        xmlDump.append("      </timerEventDefinition>" + EOL);
                    } else {
                        String header = constraintTrigger.getHeader();
                        header = header.substring(7, header.length() - 1);
                        int index = header.indexOf(":");
                        String language = header.substring(0, index);
                        header = header.substring(index + 1);
                        String cycle = null;
                        if (startNode.getMetaData("TimerDef") != null) {
                            cycle = (String)startNode.getMetaData("TimerDef");
                        } else if ("int".equals(language)) {
                            int lenght = (header.length() - 1) / 2;
                            cycle = header.substring(0, lenght);
                        } else {
                            cycle = header;
                        }
                        xmlDump.append("      <timerEventDefinition>" + EOL);
                        xmlDump.append("        <timeCycle xsi:type=\"tFormalExpression\" language=\"" + language + "\">" + cycle + "</timeCycle>" + EOL);
                        xmlDump.append("      </timerEventDefinition>" + EOL);
                    }
                }
            } else if (trigger instanceof EventTrigger) {
                String type;
                EventTrigger eventTrigger = (EventTrigger)trigger;
                if (!trigger.getInMappings().isEmpty()) {
                    String mapping = (String)eventTrigger.getInMappings().keySet().iterator().next();
                    xmlDump.append("      <dataOutput id=\"_" + startNode.getId() + "_Output\" />" + EOL + "      <dataOutputAssociation>" + EOL + "        <sourceRef>_" + startNode.getId() + "_Output</sourceRef>" + EOL + "        <targetRef>" + mapping + "</targetRef>" + EOL + "      </dataOutputAssociation>" + EOL + "      <outputSet>" + EOL + "        <dataOutputRefs>_" + startNode.getId() + "_Output</dataOutputRefs>" + EOL + "      </outputSet>" + EOL);
                }
                if ((type = ((EventTypeFilter)eventTrigger.getEventFilters().get(0)).getType()).startsWith("Message-")) {
                    type = type.substring(8);
                    xmlDump.append("      <messageEventDefinition messageRef=\"" + type + "\"/>" + EOL);
                } else if (type.startsWith("Error-")) {
                    type = type.substring(6);
                    xmlDump.append("      <errorEventDefinition errorRef=\"" + type + "\"/>" + EOL);
                } else if (type.startsWith("Escalation-")) {
                    type = type.substring(11);
                    xmlDump.append("      <escalationEventDefinition escalationRef=\"" + type + "\"/>" + EOL);
                }
                if (type.startsWith("Compensate-")) {
                    type = type.substring(11);
                    xmlDump.append("      <compensateEventDefinition activityRef=\"" + type + "\"/>" + EOL);
                } else {
                    xmlDump.append("      <signalEventDefinition signalRef=\"" + type + "\" />" + EOL);
                }
            } else {
                throw new IllegalArgumentException("Unsupported trigger type " + trigger);
            }
            this.endNode("startEvent", xmlDump);
        } else {
            this.endNode(xmlDump);
        }
    }
}

