/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.drools.core.WorkingMemory;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.event.ActivationCancelledEvent;
import org.drools.core.event.ActivationCreatedEvent;
import org.drools.core.event.AfterActivationFiredEvent;
import org.drools.core.event.AgendaGroupPushedEvent;
import org.drools.core.event.BeforeActivationFiredEvent;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.jbpm.bpmn2.JbpmTestCase;
import org.jbpm.bpmn2.RequirePersistence;
import org.jbpm.bpmn2.handler.ReceiveTaskHandler;
import org.jbpm.bpmn2.handler.SendTaskHandler;
import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.audit.JPAProcessInstanceDbLog;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.instance.impl.RuleAwareProcessEventLister;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.DynamicUtils;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.DebugAgendaEventListener;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class ActivityTest
extends JbpmTestCase {
    private Logger logger = LoggerFactory.getLogger(ActivityTest.class);
    private StatefulKnowledgeSession ksession;
    private StatefulKnowledgeSession ksession2;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public ActivityTest(boolean persistence) throws Exception {
        super(persistence);
    }

    @BeforeClass
    public static void setup() throws Exception {
        ActivityTest.setUpDataSource();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
        if (this.ksession2 != null) {
            this.ksession2.dispose();
            this.ksession2 = null;
        }
    }

    @Test
    public void testMinimalProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Minimal");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMinimalProcessImplicit() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcessImplicit.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Minimal");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMinimalProcessWithGraphical() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcessWithGraphical.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Minimal");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMinimalProcessWithDIGraphical() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcessWithDIGraphical.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Minimal");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testCompositeProcessWithDIGraphical() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-CompositeProcessWithDIGraphical.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Composite");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testScriptTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ScriptTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("ScriptTask");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    @RequirePersistence
    public void testScriptTaskWithHistoryLog() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ScriptTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("ScriptTask");
        this.assertProcessInstanceCompleted(processInstance);
        List logs = JPAProcessInstanceDbLog.findNodeInstances((long)processInstance.getId());
        ActivityTest.assertNotNull((Object)logs);
        ActivityTest.assertEquals((int)6, (int)logs.size());
        for (NodeInstanceLog log : logs) {
            ActivityTest.assertNotNull((Object)log.getDate());
        }
        ProcessInstanceLog pilog = JPAProcessInstanceDbLog.findProcessInstance((long)processInstance.getId());
        ActivityTest.assertNotNull((Object)pilog);
        ActivityTest.assertNotNull((Object)pilog.getEnd());
        List pilogs = JPAProcessInstanceDbLog.findActiveProcessInstances((String)processInstance.getProcessId());
        ActivityTest.assertNotNull((Object)pilogs);
        ActivityTest.assertEquals((int)0, (int)pilogs.size());
    }

    @Test
    public void testRuleTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-RuleTask.bpmn2", "BPMN2-RuleTask.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        this.ksession.setGlobal("list", list);
        ProcessInstance processInstance = this.ksession.startProcess("RuleTask");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.setGlobal("list", list);
        this.ksession.fireAllRules();
        ActivityTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testRuleTask2() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-RuleTask2.bpmn2", "BPMN2-RuleTask2.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        this.ksession.setGlobal("list", list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "SomeString");
        ProcessInstance processInstance = this.ksession.startProcess("RuleTask", params);
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.fireAllRules();
        ActivityTest.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    @RequirePersistence(value=false)
    public void testRuleTaskWithFacts() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-RuleTaskWithFact.bpmn2", "BPMN2-RuleTask3.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener(new AgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
                ActivityTest.this.ksession.fireAllRules();
            }

            public void matchCancelled(MatchCancelledEvent event) {
            }

            public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            }

            public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
            }

            public void beforeMatchFired(BeforeMatchFiredEvent event) {
            }

            public void agendaGroupPushed(org.kie.api.event.rule.AgendaGroupPushedEvent event) {
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
            }

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            }

            public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
                ActivityTest.this.ksession.fireAllRules();
            }

            public void afterMatchFired(AfterMatchFiredEvent event) {
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "SomeString");
        ProcessInstance processInstance = this.ksession.startProcess("RuleTask", params);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        params = new HashMap();
        try {
            processInstance = this.ksession.startProcess("RuleTask", params);
            ActivityTest.fail((String)"Should fail");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        params = new HashMap();
        params.put("x", "SomeString");
        processInstance = this.ksession.startProcess("RuleTask", params);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    @RequirePersistence
    public void testRuleTaskWithFactsWithPersistence() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-RuleTaskWithFact.bpmn2", "BPMN2-RuleTask3.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        org.drools.core.event.AgendaEventListener agendaEventListener = new org.drools.core.event.AgendaEventListener(){

            public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
                ActivityTest.this.ksession.fireAllRules();
            }

            public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
            }

            public void beforeActivationFired(BeforeActivationFiredEvent event, WorkingMemory workingMemory) {
            }

            public void afterActivationFired(AfterActivationFiredEvent event, WorkingMemory workingMemory) {
            }

            public void agendaGroupPopped(org.drools.core.event.AgendaGroupPoppedEvent event, WorkingMemory workingMemory) {
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event, WorkingMemory workingMemory) {
            }

            public void beforeRuleFlowGroupActivated(org.drools.core.event.RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
            }

            public void afterRuleFlowGroupActivated(org.drools.core.event.RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
                workingMemory.fireAllRules();
            }

            public void beforeRuleFlowGroupDeactivated(org.drools.core.event.RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
            }

            public void afterRuleFlowGroupDeactivated(org.drools.core.event.RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
            }
        };
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)this.ksession).getCommandService().getContext()).getKieSession()).session.addEventListener(agendaEventListener);
        this.ksession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "SomeString");
        ProcessInstance processInstance = this.ksession.startProcess("RuleTask", params);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        params = new HashMap();
        try {
            processInstance = this.ksession.startProcess("RuleTask", params);
            ActivityTest.fail((String)"Should fail");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        params = new HashMap();
        params.put("x", "SomeString");
        processInstance = this.ksession.startProcess("RuleTask", params);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testRuleTaskAcrossSessions() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-RuleTask.bpmn2", "BPMN2-RuleTask.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession2 = this.createKnowledgeSession(kbase);
        ArrayList list1 = new ArrayList();
        this.ksession.setGlobal("list", list1);
        ArrayList list2 = new ArrayList();
        this.ksession2.setGlobal("list", list2);
        ProcessInstance processInstance1 = this.ksession.startProcess("RuleTask");
        ProcessInstance processInstance2 = this.ksession2.startProcess("RuleTask");
        this.ksession.fireAllRules();
        this.assertProcessInstanceFinished(processInstance1, (KieSession)this.ksession);
        this.assertProcessInstanceActive(processInstance2);
        this.ksession2.fireAllRules();
        this.assertProcessInstanceFinished(processInstance2, (KieSession)this.ksession2);
    }

    @Test
    public void testUserTaskWithDataStoreScenario() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithDataStore.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.startProcess("UserProcess");
    }

    @Test
    public void testUserTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession(ksession, true);
        WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        ActivityTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        ksession.dispose();
    }

    @Test
    @RequirePersistence
    public void testProcesWithHumanTaskWithTimer() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SubProcessWithTimer.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap params = new HashMap();
        ProcessInstance processInstance = ksession.startProcess("subproc", params);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), null);
        int sessionId = ksession.getId();
        Environment env = ksession.getEnvironment();
        ksession.dispose();
        Thread.sleep(3000L);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)env);
        Thread.sleep(3000L);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
    }

    @Test
    public void testCallActivity() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-CallActivity.bpmn2", "BPMN2-CallActivitySubProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        ProcessInstance processInstance = this.ksession.startProcess("ParentProcess", params);
        this.assertProcessInstanceCompleted(processInstance);
        ActivityTest.assertEquals((Object)"new value", (Object)((WorkflowProcessInstance)processInstance).getVariable("y"));
    }

    @Test
    public void testCallActivity2() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-CallActivity2.bpmn2", "BPMN2-CallActivitySubProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        ProcessInstance processInstance = this.ksession.startProcess("ParentProcess", params);
        this.assertProcessInstanceActive(processInstance);
        ActivityTest.assertEquals((Object)"new value", (Object)((WorkflowProcessInstance)processInstance).getVariable("y"));
        this.ksession = this.restoreSession(this.ksession, true);
        WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        ActivityTest.assertEquals((Object)"krisv", (Object)workItem.getParameter("ActorId"));
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testCallActivityByName() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-CallActivityByName.bpmn2", "BPMN2-CallActivitySubProcess.bpmn2", "BPMN2-CallActivitySubProcessV2.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        ProcessInstance processInstance = this.ksession.startProcess("ParentProcess", params);
        this.assertProcessInstanceCompleted(processInstance);
        ActivityTest.assertEquals((Object)"new value V2", (Object)((WorkflowProcessInstance)processInstance).getVariable("y"));
    }

    @Test
    @RequirePersistence
    public void testCallActivityWithHistoryLog() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-CallActivity.bpmn2", "BPMN2-CallActivitySubProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        ProcessInstance processInstance = this.ksession.startProcess("ParentProcess", params);
        this.assertProcessInstanceCompleted(processInstance);
        ActivityTest.assertEquals((Object)"new value", (Object)((WorkflowProcessInstance)processInstance).getVariable("y"));
        List subprocesses = JPAProcessInstanceDbLog.findSubProcessInstances((long)processInstance.getId());
        ActivityTest.assertNotNull((Object)subprocesses);
        ActivityTest.assertEquals((int)1, (int)subprocesses.size());
    }

    @Test
    @RequirePersistence
    public void testCallActivityWithTimer() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ParentProcess.bpmn2", "BPMN2-SubProcessWithTimer.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap params = new HashMap();
        ProcessInstance processInstance = this.ksession.startProcess("ParentProcess", params);
        this.ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), null);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("sleep", "2s");
        this.ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        int sessionId = this.ksession.getId();
        Environment env = this.ksession.getEnvironment();
        System.out.println("dispose");
        this.ksession.dispose();
        Thread.sleep(3000L);
        this.ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)env);
        Thread.sleep(3000L);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testSubProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SubProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                ActivityTest.this.logger.debug(event.toString());
            }

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                ActivityTest.this.logger.debug(event.toString());
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                ActivityTest.this.logger.debug(event.toString());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("SubProcess");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testSubProcessWithTerminateEndEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SubProcessWithTerminateEndEvent.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                list.add(event.getNodeInstance().getNodeName());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("SubProcessTerminate");
        this.assertProcessInstanceCompleted(processInstance);
        ActivityTest.assertEquals((int)7, (int)list.size());
    }

    @Test
    public void testSubProcessWithTerminateEndEventProcessScope() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SubProcessWithTerminateEndEventProcessScope.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                list.add(event.getNodeInstance().getNodeName());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("SubProcessTerminate");
        this.assertProcessInstanceCompleted(processInstance);
        ActivityTest.assertEquals((int)5, (int)list.size());
    }

    @Test
    public void testAdHocSubProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-AdHocSubProcess.bpmn2", "BPMN2-AdHocSubProcess.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("AdHocSubProcess");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNull((Object)workItem);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.fireAllRules();
        this.logger.debug("Signaling Hello2");
        this.ksession.signalEvent("Hello2", null, processInstance.getId());
        workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
    }

    @Test
    public void testAdHocSubProcessAutoComplete() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-AdHocSubProcessAutoComplete.bpmn2", "BPMN2-AdHocSubProcess.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("AdHocSubProcess");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNull((Object)workItem);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.fireAllRules();
        workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testAdHocSubProcessAutoCompleteDynamicTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-AdHocSubProcessAutoComplete.bpmn2", "BPMN2-AdHocSubProcess.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        TestWorkItemHandler workItemHandler2 = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("OtherTask", (WorkItemHandler)workItemHandler2);
        ProcessInstance processInstance = this.ksession.startProcess("AdHocSubProcess");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        DynamicNodeInstance dynamicContext = (DynamicNodeInstance)((WorkflowProcessInstance)processInstance).getNodeInstances().iterator().next();
        DynamicUtils.addDynamicWorkItem((DynamicNodeInstance)dynamicContext, (KieRuntime)this.ksession, (String)"OtherTask", new HashMap());
        WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNull((Object)workItem);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.fireAllRules();
        workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceActive(processInstance);
        workItem = workItemHandler2.getWorkItem();
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.ksession.dispose();
    }

    @Test
    public void testAdHocSubProcessAutoCompleteDynamicSubProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-AdHocSubProcessAutoComplete.bpmn2", "BPMN2-AdHocSubProcess.drl", "BPMN2-MinimalProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        TestWorkItemHandler workItemHandler2 = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("OtherTask", (WorkItemHandler)workItemHandler2);
        ProcessInstance processInstance = this.ksession.startProcess("AdHocSubProcess");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession.fireAllRules();
        DynamicNodeInstance dynamicContext = (DynamicNodeInstance)((WorkflowProcessInstance)processInstance).getNodeInstances().iterator().next();
        DynamicUtils.addDynamicSubProcess((DynamicNodeInstance)dynamicContext, (KieRuntime)this.ksession, (String)"Minimal", new HashMap());
        this.ksession = this.restoreSession(this.ksession, true);
        WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testAdHocSubProcessAutoCompleteDynamicSubProcess2() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-AdHocSubProcessAutoComplete.bpmn2", "BPMN2-AdHocSubProcess.drl", "BPMN2-ServiceProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        TestWorkItemHandler workItemHandler2 = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)workItemHandler2);
        ProcessInstance processInstance = this.ksession.startProcess("AdHocSubProcess");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession.fireAllRules();
        DynamicNodeInstance dynamicContext = (DynamicNodeInstance)((WorkflowProcessInstance)processInstance).getNodeInstances().iterator().next();
        DynamicUtils.addDynamicSubProcess((DynamicNodeInstance)dynamicContext, (KieRuntime)this.ksession, (String)"ServiceProcess", new HashMap());
        this.ksession = this.restoreSession(this.ksession, true);
        WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceActive(processInstance);
        workItem = workItemHandler2.getWorkItem();
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testAdHocProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-AdHocProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("AdHocProcess");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.logger.debug("Triggering node");
        this.ksession.signalEvent("Task1", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        this.ksession.signalEvent("User1", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        this.ksession.insert((Object)new Person());
        this.ksession.signalEvent("Task3", null, processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testAdHocProcessDynamicTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-AdHocProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("AdHocProcess");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.logger.debug("Triggering node");
        this.ksession.signalEvent("Task1", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        TestWorkItemHandler workItemHandler2 = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("OtherTask", (WorkItemHandler)workItemHandler2);
        DynamicUtils.addDynamicWorkItem((ProcessInstance)processInstance, (KieRuntime)this.ksession, (String)"OtherTask", new HashMap());
        WorkItem workItem = workItemHandler2.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.ksession.signalEvent("User1", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        this.ksession.insert((Object)new Person());
        this.ksession.signalEvent("Task3", null, processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testAdHocProcessDynamicSubProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-AdHocProcess.bpmn2", "BPMN2-MinimalProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("AdHocProcess");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.logger.debug("Triggering node");
        this.ksession.signalEvent("Task1", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        TestWorkItemHandler workItemHandler2 = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("OtherTask", (WorkItemHandler)workItemHandler2);
        DynamicUtils.addDynamicSubProcess((ProcessInstance)processInstance, (KieRuntime)this.ksession, (String)"Minimal", new HashMap());
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("User1", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        this.ksession.insert((Object)new Person());
        this.ksession.signalEvent("Task3", null, processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testServiceTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ServiceProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.startProcess("ServiceProcess", params);
        this.assertProcessInstanceFinished((ProcessInstance)processInstance, (KieSession)this.ksession);
        ActivityTest.assertEquals((Object)"Hello john!", (Object)processInstance.getVariable("s"));
    }

    @Test
    public void testSendTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SendTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.startProcess("SendTask", params);
        this.assertProcessInstanceFinished((ProcessInstance)processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testReceiveTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ReceiveTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ReceiveTaskHandler receiveTaskHandler = new ReceiveTaskHandler((KieSession)this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.startProcess("ReceiveTask");
        this.assertProcessInstanceActive((ProcessInstance)processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        receiveTaskHandler.setKnowledgeRuntime((KieSession)this.ksession);
        receiveTaskHandler.messageReceived("HelloMessage", (Object)"Hello john!");
        this.assertProcessInstanceFinished((ProcessInstance)processInstance, (KieSession)this.ksession);
    }

    @Test
    @RequirePersistence(value=false)
    public void testBusinessRuleTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BusinessRuleTask.bpmn2", "BPMN2-BusinessRuleTask.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventLister());
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-BusinessRuleTask");
        int fired = this.ksession.fireAllRules();
        ActivityTest.assertEquals((int)1, (int)fired);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    @RequirePersistence(value=true)
    public void testBusinessRuleTaskWithPersistence() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BusinessRuleTask.bpmn2", "BPMN2-BusinessRuleTask.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventLister());
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-BusinessRuleTask");
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventLister());
        int fired = this.ksession.fireAllRules();
        ActivityTest.assertEquals((int)1, (int)fired);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testBusinessRuleTaskDynamic() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BusinessRuleTaskDynamic.bpmn2", "BPMN2-BusinessRuleTask.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventLister());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dynamicrule", "MyRuleFlow");
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-BusinessRuleTask", params);
        int fired = this.ksession.fireAllRules();
        ActivityTest.assertEquals((int)1, (int)fired);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testBusinessRuleTaskWithDataInputsWithPersistence() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BusinessRuleTaskWithDataInputs.bpmn2", "BPMN2-BusinessRuleTaskWithDataInput.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Person> params = new HashMap<String, Person>();
        params.put("person", new Person());
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-BusinessRuleTask", params);
        int fired = this.ksession.fireAllRules();
        ActivityTest.assertEquals((int)1, (int)fired);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testNullVariableInScriptTaskProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-NullVariableInScriptTaskProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("nullVariableInScriptAfterTimer");
        this.assertProcessInstanceActive(processInstance);
        long sleep = 1000L;
        this.logger.debug("Sleeping " + sleep / 1000L + " seconds.");
        Thread.sleep(sleep);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testScriptTaskWithVariableByName() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("myVar", "test");
        KieBase kbase = this.createKnowledgeBase("BPMN2-ProcessWithVariableName.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-ProcessWithVariableName", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testCallActivityWithBoundaryEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-CallActivityWithBoundaryEvent.bpmn2", "BPMN2-CallActivitySubProcessWithBoundaryEvent.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        ProcessInstance processInstance = this.ksession.startProcess("ParentProcess", params);
        Thread.sleep(3000L);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "CallActivity", "Boundary event", "Script Task", "end");
        this.assertNodeTriggered(processInstance.getId() + 1L, "StartProcess2", "User Task");
    }

    @Test
    public void testUserTaskWithBooleanOutput() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithBooleanOutput.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.boolean");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        ActivityTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        HashMap<String, String> output = new HashMap<String, String>();
        output.put("isCheckedCheckbox", "true");
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), output);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testUserTaskWithSimData() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSimulationMetaData.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("UserTask");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession = this.restoreSession(this.ksession, true);
        WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        ActivityTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }
}

