/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jbpm.bpmn2.JbpmTestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.ForEachNodeInstance;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@RunWith(value=Parameterized.class)
public class FlowTest
extends JbpmTestCase {
    private Logger logger = LoggerFactory.getLogger(FlowTest.class);
    private StatefulKnowledgeSession ksession;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public FlowTest(boolean persistence) {
        super(persistence);
    }

    @BeforeClass
    public static void setup() throws Exception {
        FlowTest.setUpDataSource();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testExclusiveSplit() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplit.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "First");
        params.put("y", "Second");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testExclusiveSplitXPathAdvanced() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitXPath-advanced.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, Object> params = new HashMap<String, Object>();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element hi = doc.createElement("hi");
        Element ho = doc.createElement("ho");
        hi.appendChild(ho);
        Attr attr = doc.createAttribute("value");
        ho.setAttributeNode(attr);
        attr.setValue("a");
        params.put("x", hi);
        params.put("y", "Second");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testExclusiveSplitXPathAdvanced2() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitXPath-advanced-vars-not-signaled.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, Object> params = new HashMap<String, Object>();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element hi = doc.createElement("hi");
        Element ho = doc.createElement("ho");
        hi.appendChild(ho);
        Attr attr = doc.createAttribute("value");
        ho.setAttributeNode(attr);
        attr.setValue("a");
        params.put("x", hi);
        params.put("y", "Second");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testExclusiveSplitXPathAdvancedWithVars() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitXPath-advanced-with-vars.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, Object> params = new HashMap<String, Object>();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element hi = doc.createElement("hi");
        Element ho = doc.createElement("ho");
        hi.appendChild(ho);
        Attr attr = doc.createAttribute("value");
        ho.setAttributeNode(attr);
        attr.setValue("a");
        params.put("x", hi);
        params.put("y", "Second");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testExclusiveSplitPriority() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitPriority.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "First");
        params.put("y", "Second");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testExclusiveSplitDefault() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitDefault.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "NotFirst");
        params.put("y", "Second");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testExclusiveXORGateway() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-gatewayTest.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<instanceMetadata><user approved=\"false\" /></instanceMetadata>".getBytes()));
        HashMap<String, Node> params = new HashMap<String, Node>();
        params.put("instanceMetadata", document);
        params.put("startMessage", DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<task subject='foobar2'/>".getBytes())).getFirstChild());
        ProcessInstance processInstance = this.ksession.startProcess("process", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testInclusiveSplit() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplit.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testInclusiveSplitAndJoin() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoin.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        FlowTest.assertEquals((int)2, (int)activeWorkItems.size());
        this.ksession = this.restoreSession(this.ksession, true);
        for (WorkItem wi : activeWorkItems) {
            this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testInclusiveSplitAndJoinLoop() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinLoop.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 21);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        FlowTest.assertEquals((int)3, (int)activeWorkItems.size());
        this.ksession = this.restoreSession(this.ksession, true);
        for (WorkItem wi : activeWorkItems) {
            this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testInclusiveSplitAndJoinLoop2() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinLoop2.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 21);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        FlowTest.assertEquals((int)3, (int)activeWorkItems.size());
        this.ksession = this.restoreSession(this.ksession, true);
        for (WorkItem wi : activeWorkItems) {
            this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testInclusiveSplitAndJoinNested() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinNested.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        FlowTest.assertEquals((int)2, (int)activeWorkItems.size());
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        for (WorkItem wi : activeWorkItems) {
            this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        activeWorkItems = workItemHandler.getWorkItems();
        FlowTest.assertEquals((int)2, (int)activeWorkItems.size());
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        for (WorkItem wi : activeWorkItems) {
            this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testInclusiveSplitAndJoinEmbedded() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinEmbedded.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        FlowTest.assertEquals((int)2, (int)activeWorkItems.size());
        this.ksession = this.restoreSession(this.ksession, true);
        for (WorkItem wi : activeWorkItems) {
            this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testInclusiveSplitAndJoinWithParallel() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinWithParallel.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 25);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        FlowTest.assertEquals((int)4, (int)activeWorkItems.size());
        this.ksession = this.restoreSession(this.ksession, true);
        for (WorkItem wi : activeWorkItems) {
            this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testInclusiveSplitAndJoinWithEnd() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinWithEnd.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 25);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        FlowTest.assertEquals((int)3, (int)activeWorkItems.size());
        this.ksession = this.restoreSession(this.ksession, true);
        for (int i = 0; i < 2; ++i) {
            this.ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(i).getId(), null);
        }
        this.assertProcessInstanceActive(processInstance);
        this.ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(2).getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testInclusiveSplitAndJoinWithTimer() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinWithTimer.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        FlowTest.assertEquals((int)1, (int)activeWorkItems.size());
        this.ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(0).getId(), null);
        Thread.sleep(3000L);
        this.assertProcessInstanceActive(processInstance);
        activeWorkItems = workItemHandler.getWorkItems();
        FlowTest.assertEquals((int)2, (int)activeWorkItems.size());
        this.ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(0).getId(), null);
        this.assertProcessInstanceActive(processInstance);
        this.ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(1).getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testInclusiveSplitAndJoinExtraPath() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinExtraPath.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 25);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        this.ksession.signalEvent("signal", null);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        FlowTest.assertEquals((int)4, (int)activeWorkItems.size());
        this.ksession = this.restoreSession(this.ksession, true);
        for (int i = 0; i < 3; ++i) {
            this.ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(i).getId(), null);
        }
        this.assertProcessInstanceActive(processInstance);
        this.ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(3).getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testInclusiveSplitDefault() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitDefault.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", -5);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcessWithORGateway() throws Exception {
        Iterator childIterator;
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultiInstanceLoopCharacteristicsProcessWithORgateway.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap params = new HashMap();
        ArrayList<Integer> myList = new ArrayList<Integer>();
        myList.add(12);
        myList.add(15);
        params.put("list", myList);
        ProcessInstance processInstance = this.ksession.startProcess("MultiInstanceLoopCharacteristicsProcess", params);
        List<WorkItem> workItems = workItemHandler.getWorkItems();
        FlowTest.assertEquals((int)4, (int)workItems.size());
        Collection nodeInstances = ((WorkflowProcessInstanceImpl)processInstance).getNodeInstances();
        FlowTest.assertEquals((int)1, (int)nodeInstances.size());
        NodeInstance nodeInstance = (NodeInstance)nodeInstances.iterator().next();
        FlowTest.assertTrue((boolean)(nodeInstance instanceof ForEachNodeInstance));
        Collection nodeInstancesChild = ((ForEachNodeInstance)nodeInstance).getNodeInstances();
        FlowTest.assertEquals((int)2, (int)nodeInstancesChild.size());
        for (NodeInstance child : nodeInstancesChild) {
            FlowTest.assertTrue((boolean)(child instanceof CompositeContextNodeInstance));
            FlowTest.assertEquals((int)2, (int)((CompositeContextNodeInstance)child).getNodeInstances().size());
        }
        this.ksession.getWorkItemManager().completeWorkItem(workItems.get(0).getId(), null);
        this.ksession.getWorkItemManager().completeWorkItem(workItems.get(1).getId(), null);
        processInstance = this.ksession.getProcessInstance(processInstance.getId());
        nodeInstances = ((WorkflowProcessInstanceImpl)processInstance).getNodeInstances();
        FlowTest.assertEquals((int)1, (int)nodeInstances.size());
        nodeInstance = (NodeInstance)nodeInstances.iterator().next();
        FlowTest.assertTrue((boolean)(nodeInstance instanceof ForEachNodeInstance));
        if (this.isPersistence()) {
            nodeInstancesChild = ((ForEachNodeInstance)nodeInstance).getNodeInstances();
            FlowTest.assertEquals((int)1, (int)nodeInstancesChild.size());
            childIterator = nodeInstancesChild.iterator();
            FlowTest.assertTrue((boolean)(childIterator.next() instanceof CompositeContextNodeInstance));
            this.ksession.getWorkItemManager().completeWorkItem(workItems.get(2).getId(), null);
            this.ksession.getWorkItemManager().completeWorkItem(workItems.get(3).getId(), null);
            this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        } else {
            nodeInstancesChild = ((ForEachNodeInstance)nodeInstance).getNodeInstances();
            FlowTest.assertEquals((int)2, (int)nodeInstancesChild.size());
            childIterator = nodeInstancesChild.iterator();
            FlowTest.assertTrue((boolean)(childIterator.next() instanceof CompositeContextNodeInstance));
            FlowTest.assertTrue((boolean)(childIterator.next() instanceof ForEachNodeInstance.ForEachJoinNodeInstance));
            this.ksession.getWorkItemManager().completeWorkItem(workItems.get(2).getId(), null);
            this.ksession.getWorkItemManager().completeWorkItem(workItems.get(3).getId(), null);
            this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        }
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultiInstanceLoopCharacteristicsProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        ProcessInstance processInstance = this.ksession.startProcess("MultiInstanceLoopCharacteristicsProcess", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcessWithOutput() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultiInstanceLoopCharacteristicsProcessWithOutput.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        ArrayList myListOut = new ArrayList();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        params.put("listOut", myListOut);
        FlowTest.assertEquals((int)0, (int)myListOut.size());
        ProcessInstance processInstance = this.ksession.startProcess("MultiInstanceLoopCharacteristicsProcessWithOutput", params);
        this.assertProcessInstanceCompleted(processInstance);
        FlowTest.assertEquals((int)2, (int)myListOut.size());
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsTaskWithOutput() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultiInstanceLoopCharacteristicsTaskWithOutput.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        ArrayList myListOut = new ArrayList();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        params.put("listOut", myListOut);
        FlowTest.assertEquals((int)0, (int)myListOut.size());
        ProcessInstance processInstance = this.ksession.startProcess("MultiInstanceLoopCharacteristicsTask", params);
        this.assertProcessInstanceCompleted(processInstance);
        FlowTest.assertEquals((int)2, (int)myListOut.size());
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultiInstanceLoopCharacteristicsTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        ProcessInstance processInstance = this.ksession.startProcess("MultiInstanceLoopCharacteristicsTask", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMultipleInOutgoingSequenceFlows() throws Exception {
        System.setProperty("jbpm.enable.multi.con", "true");
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleInOutgoingSequenceFlows.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        FlowTest.assertEquals((int)0, (int)list.size());
        this.ksession.fireAllRules();
        Thread.sleep(1500L);
        FlowTest.assertEquals((int)1, (int)list.size());
        System.clearProperty("jbpm.enable.multi.con");
    }

    @Test
    @Ignore
    public void testMultipleInOutgoingSequenceFlowsDisable() throws Exception {
        try {
            KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleInOutgoingSequenceFlows.bpmn2");
            FlowTest.fail((String)"Should fail as multiple outgoing and incoming connections are disabled by default");
        }
        catch (Exception e) {
            FlowTest.assertEquals((String)"This type of node cannot have more than one outgoing connection!", (String)e.getMessage());
        }
    }

    @Test
    public void testConditionalFlow() throws Exception {
        System.setProperty("jbpm.enable.multi.con", "true");
        String processId = "designer.conditional-flow";
        KieBase kbase = this.createKnowledgeBase("BPMN2-ConditionalFlowWithoutGateway.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        WorkflowProcessInstance wpi = (WorkflowProcessInstance)this.ksession.startProcess(processId);
        this.assertProcessInstanceFinished((ProcessInstance)wpi, (KieSession)this.ksession);
        this.assertNodeTriggered(wpi.getId(), "start", "script", "end1");
        System.clearProperty("jbpm.enable.multi.con");
    }

    @Test
    public void testLane() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-Lane.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("UserTask");
        FlowTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        WorkItem workItem = workItemHandler.getWorkItem();
        FlowTest.assertNotNull((Object)workItem);
        FlowTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("ActorId", "mary");
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), results);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        workItem = workItemHandler.getWorkItem();
        FlowTest.assertNotNull((Object)workItem);
        FlowTest.assertEquals((Object)"mary", (Object)workItem.getParameter("ActorId"));
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }
}

