/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.Assert;
import org.drools.core.SessionConfiguration;
import org.drools.core.audit.WorkingMemoryInMemoryLogger;
import org.drools.core.audit.event.LogEvent;
import org.drools.core.audit.event.RuleFlowLogEvent;
import org.drools.core.audit.event.RuleFlowNodeLogEvent;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.util.DroolsStreamUtils;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.jbpm.bpmn2.RequirePersistence;
import org.jbpm.process.audit.AuditLoggerFactory;
import org.jbpm.process.audit.JPAProcessInstanceDbLog;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.instance.event.DefaultSignalManagerFactory;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.process.Node;
import org.kie.api.io.Resource;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.event.KnowledgeRuntimeEventManager;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JbpmTestCase
extends Assert {
    public static String[] txStateName = new String[]{"ACTIVE", "MARKED_ROLLBACK", "PREPARED", "COMMITTED", "ROLLEDBACK", "UNKNOWN", "NO_TRANSACTION", "PREPARING", "COMMITTING", "ROLLING_BACK"};
    public static final boolean PERSISTENCE = Boolean.valueOf(System.getProperty("org.jbpm.test.persistence", "true"));
    private static boolean setupDataSource = false;
    private boolean sessionPersistence = false;
    private static H2Server server = new H2Server();
    private WorkingMemoryInMemoryLogger logger;
    private Logger testLogger = null;
    private static EntityManagerFactory emf;
    private static PoolingDataSource ds;
    private RequirePersistence testReqPersistence;
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            System.out.println(" >>> " + description.getMethodName() + " <<< ");
            try {
                String method = description.getMethodName();
                int i = method.indexOf("[");
                if (i > 0) {
                    method = method.substring(0, i);
                }
                JbpmTestCase.this.testReqPersistence = description.getTestClass().getMethod(method, new Class[0]).getAnnotation(RequirePersistence.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (JbpmTestCase.this.testLogger == null) {
                JbpmTestCase.this.testLogger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            }
        }

        protected void finished(Description description) {
            System.out.println("");
        }
    };

    public JbpmTestCase() {
        this(PERSISTENCE);
    }

    public JbpmTestCase(boolean sessionPersistance) {
        System.setProperty("jbpm.user.group.mapping", "classpath:/usergroups.properties");
        System.setProperty("jbpm.usergroup.callback", "org.jbpm.task.identity.DefaultUserGroupCallbackImpl");
        this.sessionPersistence = sessionPersistance;
    }

    public static PoolingDataSource setupPoolingDataSource() {
        PoolingDataSource pds = new PoolingDataSource();
        pds.setUniqueName("jdbc/testDS1");
        pds.setClassName("bitronix.tm.resource.jdbc.lrc.LrcXADataSource");
        pds.setMaxPoolSize(5);
        pds.setAllowLocalTransactions(true);
        pds.getDriverProperties().put("user", "sa");
        pds.getDriverProperties().put("password", "");
        pds.getDriverProperties().put("url", "jdbc:h2:tcp://localhost/~/jbpm-db");
        pds.getDriverProperties().put("driverClassName", "org.h2.Driver");
        pds.init();
        return pds;
    }

    public void setPersistence(boolean sessionPersistence) {
        this.sessionPersistence = sessionPersistence;
    }

    public boolean isPersistence() {
        return this.sessionPersistence;
    }

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        JbpmTestCase.emf = emf;
    }

    public void setPoolingDataSource(PoolingDataSource ds) {
        JbpmTestCase.ds = ds;
    }

    public static void setUpDataSource() throws Exception {
        setupDataSource = true;
        server.start();
        ds = JbpmTestCase.setupPoolingDataSource();
        emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
    }

    @Before
    public void checkTest() {
        if (this.testReqPersistence != null && this.testReqPersistence.value() != this.sessionPersistence) {
            System.out.println("skipped - test is run only " + (this.testReqPersistence.value() ? "with" : "without") + " persistence");
            System.out.println(this.testReqPersistence.comment());
            Assume.assumeTrue((boolean)false);
        }
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (setupDataSource) {
            int testTxState;
            if (ds != null) {
                try {
                    ds.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ds = null;
            }
            server.stop();
            DeleteDbFiles.execute((String)"~", (String)"jbpm-db", (boolean)true);
            BitronixTransaction tx = TransactionManagerServices.getTransactionManager().getCurrentTransaction();
            if (tx != null && (testTxState = tx.getStatus()) != 6 && testTxState != 4 && testTxState != 3) {
                try {
                    tx.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Assert.fail((String)("Transaction had status " + txStateName[testTxState] + " at the end of the test."));
            }
            if (emf != null) {
                try {
                    emf.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                emf = null;
            }
        }
    }

    protected KieBase createKnowledgeBase(String ... process) throws Exception {
        Resource[] resources = new Resource[process.length];
        for (int i = 0; i < process.length; ++i) {
            String p = process[i];
            resources[i] = ResourceFactory.newClassPathResource((String)p);
        }
        return this.createKnowledgeBaseFromResources(resources);
    }

    protected KieBase createKnowledgeBaseFromResources(Resource ... process) throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        if (process.length > 0) {
            KieFileSystem kfs = ks.newKieFileSystem();
            for (Resource p : process) {
                kfs.write(p);
            }
            KieBuilder kb = ks.newKieBuilder(kfs);
            kb.buildAll();
            if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
                throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
            }
        }
        KieContainer kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        return kContainer.getKieBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KieBase createKnowledgeBaseFromDisc(String process) throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        KieFileSystem kfs = ks.newKieFileSystem();
        Resource res = ResourceFactory.newClassPathResource((String)process);
        kfs.write(res);
        KieBuilder kb = ks.newKieBuilder(kfs);
        kb.buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
        }
        KieContainer kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        KieBase kbase = kContainer.getKieBase();
        File packageFile = null;
        Iterator i$ = kbase.getKiePackages().iterator();
        if (i$.hasNext()) {
            KiePackage pkg = (KiePackage)i$.next();
            packageFile = new File(System.getProperty("java.io.tmpdir") + File.separator + pkg.getName() + ".pkg");
            packageFile.deleteOnExit();
            FileOutputStream out = new FileOutputStream(packageFile);
            try {
                DroolsStreamUtils.streamOut((OutputStream)out, (Object)pkg);
            }
            finally {
                out.close();
            }
        }
        kfs.delete(new String[]{res.getSourcePath()});
        kfs.write(ResourceFactory.newFileResource(packageFile));
        kb = ks.newKieBuilder(kfs);
        kb.buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
        }
        kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        kbase = kContainer.getKieBase();
        return kbase;
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KieBase kbase) throws Exception {
        return this.createKnowledgeSession(kbase, null, null);
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KieBase kbase, Environment env) throws Exception {
        return this.createKnowledgeSession(kbase, null, env);
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KieBase kbase, KieSessionConfiguration conf, Environment env) throws Exception {
        StatefulKnowledgeSession result;
        if (conf == null) {
            conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        }
        if (this.sessionPersistence) {
            if (env == null) {
                env = this.createEnvironment(emf);
            }
            result = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, (KieSessionConfiguration)conf, (Environment)env);
            AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)result, null);
            JPAProcessInstanceDbLog.setEnvironment((Environment)result.getEnvironment());
        } else {
            if (env == null) {
                env = EnvironmentFactory.newEnvironment();
                env.set("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)emf);
            }
            Properties defaultProps = new Properties();
            defaultProps.setProperty("drools.processSignalManagerFactory", DefaultSignalManagerFactory.class.getName());
            defaultProps.setProperty("drools.processInstanceManagerFactory", DefaultProcessInstanceManagerFactory.class.getName());
            conf = new SessionConfiguration(defaultProps);
            result = (StatefulKnowledgeSession)kbase.newKieSession(conf, env);
            this.logger = new WorkingMemoryInMemoryLogger((KnowledgeRuntimeEventManager)result);
        }
        return result;
    }

    protected StatefulKnowledgeSession createKnowledgeSession(String ... process) throws Exception {
        KieBase kbase = this.createKnowledgeBase(process);
        return this.createKnowledgeSession(kbase);
    }

    protected StatefulKnowledgeSession restoreSession(StatefulKnowledgeSession ksession, boolean noCache) {
        if (this.sessionPersistence) {
            int id = ksession.getId();
            KnowledgeBase kbase = ksession.getKieBase();
            Environment env = null;
            env = noCache ? this.createEnvironment(emf) : ksession.getEnvironment();
            KieSessionConfiguration config = ksession.getSessionConfiguration();
            StatefulKnowledgeSession result = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KieBase)kbase, (KieSessionConfiguration)config, (Environment)env);
            AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)result, null);
            ksession.dispose();
            return result;
        }
        return ksession;
    }

    protected StatefulKnowledgeSession restoreSession(StatefulKnowledgeSession ksession) {
        return ksession;
    }

    protected Environment createEnvironment(EntityManagerFactory emf) {
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)emf);
        env.set("org.kie.transaction.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        return env;
    }

    public void assertProcessInstanceCompleted(ProcessInstance processInstance) {
        JbpmTestCase.assertTrue((String)"Process instance has not been completed.", (processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public void assertProcessInstanceAborted(ProcessInstance processInstance) {
        JbpmTestCase.assertTrue((String)"Process instance has not been aborted.", (processInstance.getState() == 3 ? 1 : 0) != 0);
    }

    public void assertProcessInstanceActive(ProcessInstance processInstance) {
        JbpmTestCase.assertTrue((String)"Process instance is not active.", (processInstance.getState() == 1 || processInstance.getState() == 0 ? 1 : 0) != 0);
    }

    public void assertProcessInstanceFinished(ProcessInstance processInstance, KieSession ksession) {
        JbpmTestCase.assertNull((String)"Process instance has not been finished.", (Object)ksession.getProcessInstance(processInstance.getId()));
    }

    public void assertNodeActive(long processInstanceId, KieSession ksession, String ... name) {
        ArrayList<String> names = new ArrayList<String>();
        for (String n : name) {
            names.add(n);
        }
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        if (processInstance instanceof WorkflowProcessInstance) {
            this.assertNodeActive((NodeInstanceContainer)((WorkflowProcessInstance)processInstance), names);
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            JbpmTestCase.fail((String)("Node(s) not active: " + s));
        }
    }

    private void assertNodeActive(NodeInstanceContainer container, List<String> names) {
        for (NodeInstance nodeInstance : container.getNodeInstances()) {
            String nodeName = nodeInstance.getNodeName();
            if (names.contains(nodeName)) {
                names.remove(nodeName);
            }
            if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
            this.assertNodeActive((NodeInstanceContainer)nodeInstance, names);
        }
    }

    public void assertNodeTriggered(long processInstanceId, String ... nodeNames) {
        List<String> names = this.getNotTriggeredNodes(processInstanceId, nodeNames);
        if (!names.isEmpty()) {
            String s = names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + names.get(i);
            }
            JbpmTestCase.fail((String)("Node(s) not executed: " + s));
        }
    }

    public void assertNotNodeTriggered(long processInstanceId, String ... nodeNames) {
        List<String> names = this.getNotTriggeredNodes(processInstanceId, nodeNames);
        JbpmTestCase.assertTrue((boolean)Arrays.equals(names.toArray(), nodeNames));
    }

    public int getNumberOfNodeTriggered(long processInstanceId, String node) {
        int counter;
        block3: {
            block2: {
                counter = 0;
                if (!this.sessionPersistence) break block2;
                List logs = JPAProcessInstanceDbLog.findNodeInstances((long)processInstanceId);
                if (logs == null) break block3;
                for (NodeInstanceLog l : logs) {
                    String nodeName = l.getNodeName();
                    if (l.getType() != 0 && l.getType() != 1 || !node.equals(nodeName)) continue;
                    ++counter;
                }
                break block3;
            }
            for (LogEvent event : this.logger.getLogEvents()) {
                String nodeName;
                if (!(event instanceof RuleFlowNodeLogEvent) || !node.equals(nodeName = ((RuleFlowNodeLogEvent)event).getNodeName())) continue;
                ++counter;
            }
        }
        return counter;
    }

    public int getNumberOfProcessInstances(String processId) {
        int counter = 0;
        if (this.sessionPersistence) {
            List logs = JPAProcessInstanceDbLog.findProcessInstances((String)processId);
            if (logs != null) {
                return logs.size();
            }
        } else {
            for (LogEvent event : this.logger.getLogEvents()) {
                if (event.getType() != 8 || !((RuleFlowLogEvent)event).getProcessId().equals(processId)) continue;
                ++counter;
            }
        }
        return counter;
    }

    private List<String> getNotTriggeredNodes(long processInstanceId, String ... nodeNames) {
        ArrayList<String> names;
        block4: {
            block3: {
                names = new ArrayList<String>();
                for (String nodeName : nodeNames) {
                    names.add(nodeName);
                }
                if (!this.sessionPersistence) break block3;
                List logs = JPAProcessInstanceDbLog.findNodeInstances((long)processInstanceId);
                if (logs == null) break block4;
                for (NodeInstanceLog l : logs) {
                    String nodeName;
                    nodeName = l.getNodeName();
                    if (l.getType() != 0 && l.getType() != 1 || !names.contains(nodeName)) continue;
                    names.remove(nodeName);
                }
                break block4;
            }
            for (LogEvent event : this.logger.getLogEvents()) {
                String nodeName;
                if (!(event instanceof RuleFlowNodeLogEvent) || !names.contains(nodeName = ((RuleFlowNodeLogEvent)event).getNodeName())) continue;
                names.remove(nodeName);
            }
        }
        return names;
    }

    protected void clearHistory() {
        if (this.sessionPersistence) {
            try {
                JPAProcessInstanceDbLog.clear();
            }
            catch (Exception exception) {}
        } else if (this.logger != null) {
            this.logger.clear();
        }
    }

    public void assertProcessVarExists(ProcessInstance process, String ... processVarNames) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        ArrayList<String> names = new ArrayList<String>();
        for (String nodeName : processVarNames) {
            names.add(nodeName);
        }
        for (String pvar : instance.getVariables().keySet()) {
            if (!names.contains(pvar)) continue;
            names.remove(pvar);
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            JbpmTestCase.fail((String)("Process Variable(s) do not exist: " + s));
        }
    }

    public void assertNodeExists(ProcessInstance process, String ... nodeNames) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        ArrayList<String> names = new ArrayList<String>();
        for (String string : nodeNames) {
            names.add(string);
        }
        for (String string : instance.getNodeContainer().getNodes()) {
            if (!names.contains(string.getName())) continue;
            names.remove(string.getName());
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            JbpmTestCase.fail((String)("Node(s) do not exist: " + s));
        }
    }

    public void assertNumOfIncommingConnections(ProcessInstance process, String nodeName, int num) {
        this.assertNodeExists(process, nodeName);
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        for (Node node : instance.getNodeContainer().getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            if (node.getIncomingConnections().size() == num) break;
            JbpmTestCase.fail((String)("Expected incomming connections: " + num + " - found " + node.getIncomingConnections().size()));
        }
    }

    public void assertNumOfOutgoingConnections(ProcessInstance process, String nodeName, int num) {
        this.assertNodeExists(process, nodeName);
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        for (Node node : instance.getNodeContainer().getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            if (node.getOutgoingConnections().size() == num) break;
            JbpmTestCase.fail((String)("Expected outgoing connections: " + num + " - found " + node.getOutgoingConnections().size()));
        }
    }

    public void assertVersionEquals(ProcessInstance process, String version) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getVersion().equals(version)) {
            JbpmTestCase.fail((String)("Expected version: " + version + " - found " + instance.getWorkflowProcess().getVersion()));
        }
    }

    public void assertProcessNameEquals(ProcessInstance process, String name) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getName().equals(name)) {
            JbpmTestCase.fail((String)("Expected name: " + name + " - found " + instance.getWorkflowProcess().getName()));
        }
    }

    public void assertPackageNameEquals(ProcessInstance process, String packageName) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getPackageName().equals(packageName)) {
            JbpmTestCase.fail((String)("Expected package name: " + packageName + " - found " + instance.getWorkflowProcess().getPackageName()));
        }
    }

    public Object eval(Reader reader, Map vars) {
        try {
            return this.eval(this.toString(reader), vars);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception Thrown", e);
        }
    }

    private String toString(Reader reader) throws IOException {
        int charValue;
        StringBuilder sb = new StringBuilder(1024);
        while ((charValue = reader.read()) != -1) {
            sb.append((char)charValue);
        }
        return sb.toString();
    }

    public Object eval(String str, Map vars) {
        ParserContext context = new ParserContext();
        context.addPackageImport("org.jbpm.task");
        context.addPackageImport("org.jbpm.task.service");
        context.addPackageImport("org.jbpm.task.query");
        context.addPackageImport("java.util");
        vars.put("now", new Date());
        return MVEL.executeExpression((Object)MVEL.compileExpression((String)str, (ParserContext)context), (Map)vars);
    }

    private static class H2Server {
        private Server server;

        private H2Server() {
        }

        public synchronized void start() {
            if (this.server == null || !this.server.isRunning(false)) {
                try {
                    DeleteDbFiles.execute((String)"~", (String)"jbpm-db", (boolean)true);
                    this.server = Server.createTcpServer((String[])new String[0]);
                    this.server.start();
                }
                catch (SQLException e) {
                    throw new RuntimeException("Cannot start h2 server database", e);
                }
            }
        }

        public synchronized void finalize() throws Throwable {
            this.stop();
            super.finalize();
        }

        public void stop() {
            if (this.server != null) {
                this.server.stop();
                this.server.shutdown();
                DeleteDbFiles.execute((String)"~", (String)"jbpm-db", (boolean)true);
                this.server = null;
            }
        }
    }
}

