/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.structureref;

import java.util.HashMap;
import org.jbpm.bpmn2.NewJbpmBpmn2TestBase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;

public class StructureRefTest
extends NewJbpmBpmn2TestBase {
    @Test
    public void testStringStructureRef() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-StringStructureRef.bpmn2");
        KieSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        StructureRefTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "test value");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    @Test
    public void testBooleanStructureRef() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-BooleanStructureRef.bpmn2");
        KieSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        StructureRefTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "true");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    @Test
    public void testIntegerStructureRef() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-IntegerStructureRef.bpmn2");
        KieSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        StructureRefTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "25");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    @Test
    public void testFloatStructureRef() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-FloatStructureRef.bpmn2");
        KieSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        StructureRefTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "5.5");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    @Test
    public void testObjectStructureRef() throws Exception {
        String personAsXml = "<org.jbpm.bpmn2.objects.Person><id>1</id><name>john</name></org.jbpm.bpmn2.objects.Person>";
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-ObjectStructureRef.bpmn2");
        KieSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        StructureRefTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", personAsXml);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), ksession);
    }

    @Test
    public void testNoStructureRef() {
        try {
            KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-NoStructureRef.bpmn2");
            StructureRefTest.fail((String)"Structure ref must be defined for a process");
        }
        catch (Exception e) {
            StructureRefTest.assertEquals((String)"Exception about parsing errors missing.", (String)"Errors while parsing knowledge base", (String)e.getMessage());
        }
    }
}

