/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import org.drools.core.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.bpmn2.JbpmTestCase;
import org.jbpm.bpmn2.core.Association;
import org.jbpm.bpmn2.core.DataStore;
import org.jbpm.bpmn2.core.Definitions;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@RunWith(value=Parameterized.class)
public class DataTest
extends JbpmTestCase {
    private Logger logger = LoggerFactory.getLogger(DataTest.class);
    private StatefulKnowledgeSession ksession;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public DataTest(boolean persistence) {
        super(persistence);
    }

    @BeforeClass
    public static void setup() throws Exception {
        DataTest.setUpDataSource();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testImport() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-Import.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Import");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testDataObject() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataObject.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testDataStore() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataStore.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation");
        Definitions def = (Definitions)processInstance.getProcess().getMetaData().get("Definitions");
        DataTest.assertNotNull((Object)def.getDataStores());
        DataTest.assertTrue((def.getDataStores().size() == 1 ? 1 : 0) != 0);
        DataStore dataStore = (DataStore)def.getDataStores().get(0);
        DataTest.assertEquals((String)"employee", (String)dataStore.getId());
        DataTest.assertEquals((String)"employeeStore", (String)dataStore.getName());
        DataTest.assertEquals((String)String.class.getCanonicalName(), (String)((ObjectDataType)dataStore.getType()).getClassName());
    }

    @Test
    public void testAssociation() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-Association.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation");
        Definitions def = (Definitions)processInstance.getProcess().getMetaData().get("Definitions");
        DataTest.assertNotNull((Object)def.getAssociations());
        DataTest.assertTrue((def.getAssociations().size() == 1 ? 1 : 0) != 0);
        Association assoc = (Association)def.getAssociations().get(0);
        DataTest.assertEquals((String)"_1234", (String)assoc.getId());
        DataTest.assertEquals((String)"_1", (String)assoc.getSourceRef());
        DataTest.assertEquals((String)"_2", (String)assoc.getTargetRef());
    }

    @Test
    public void testEvaluationProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("RegisterRequest", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testEvaluationProcess2() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess2.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.evaluation", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testEvaluationProcess3() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess3.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("RegisterRequest", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "john2");
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testXpathExpression() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-XpathExpression.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<instanceMetadata><user approved=\"false\" /></instanceMetadata>".getBytes()));
        HashMap<String, Document> params = new HashMap<String, Document>();
        params.put("instanceMetadata", document);
        ProcessInstance processInstance = this.ksession.startProcess("XPathProcess", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testDataInputAssociations() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataInputAssociations.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((Object)"hello world", (Object)workItem.getParameter("coId"));
            }
        });
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
        HashMap<String, Node> params = new HashMap<String, Node>();
        params.put("instanceMetadata", document.getFirstChild());
        ProcessInstance processInstance = this.ksession.startProcess("process", params);
    }

    @Test
    public void testDataInputAssociationsWithStringObject() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataInputAssociations-string-object.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((Object)"hello", (Object)workItem.getParameter("coId"));
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instanceMetadata", "hello");
        ProcessInstance processInstance = this.ksession.startProcess("process", params);
    }

    @Test
    @Ignore
    public void testDataInputAssociationsWithLazyLoading() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataInputAssociations-lazy-creating.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((String)"mydoc", (String)((Element)workItem.getParameter("coId")).getNodeName());
                Assert.assertEquals((String)"mynode", (String)((Element)workItem.getParameter("coId")).getFirstChild().getNodeName());
                Assert.assertEquals((String)"user", (String)((Element)workItem.getParameter("coId")).getFirstChild().getFirstChild().getNodeName());
                Assert.assertEquals((String)"hello world", (String)((Element)workItem.getParameter("coId")).getFirstChild().getFirstChild().getAttributes().getNamedItem("hello").getNodeValue());
            }
        });
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
        HashMap<String, Node> params = new HashMap<String, Node>();
        params.put("instanceMetadata", document.getFirstChild());
        ProcessInstance processInstance = this.ksession.startProcess("process", params);
    }

    @Test
    public void testDataInputAssociationsWithString() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataInputAssociations-string.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((Object)"hello", (Object)workItem.getParameter("coId"));
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("process", null);
    }

    @Test
    public void testDataInputAssociationsWithStringWithoutQuotes() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataInputAssociations-string-no-quotes.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((Object)"hello", (Object)workItem.getParameter("coId"));
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("process", null);
    }

    @Test
    public void testDataInputAssociationsWithXMLLiteral() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataInputAssociations-xml-literal.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((String)"id", (String)((Node)workItem.getParameter("coId")).getNodeName());
                Assert.assertEquals((String)"some text", (String)((Node)workItem.getParameter("coId")).getFirstChild().getTextContent());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("process", null);
    }

    @Test
    @Ignore
    public void testDataInputAssociationsWithTwoAssigns() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataInputAssociations-two-assigns.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assert.assertEquals((String)"foo", (String)((Element)workItem.getParameter("Comment")).getNodeName());
            }
        });
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
        HashMap<String, Node> params = new HashMap<String, Node>();
        params.put("instanceMetadata", document.getFirstChild());
        ProcessInstance processInstance = this.ksession.startProcess("process", params);
    }

    @Test
    public void testDataOutputAssociationsforHumanTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataOutputAssociations-HumanTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                DocumentBuilder builder;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    builder = factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    throw new RuntimeException(e);
                }
                HashMap<String, Element> results = new HashMap<String, Element>();
                Document processMetadaDoc = builder.newDocument();
                Element processMetadata = processMetadaDoc.createElement("previoustasksowner");
                processMetadaDoc.appendChild(processMetadata);
                processMetadata.setAttribute("primaryname", "my_result");
                results.put("output", processMetadata);
                mgr.completeWorkItem(workItem.getId(), results);
            }
        });
        HashMap params = new HashMap();
        ProcessInstance processInstance = this.ksession.startProcess("process", params);
    }

    @Test
    public void testDataOutputAssociations() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataOutputAssociations.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                try {
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
                    HashMap<String, Node> params = new HashMap<String, Node>();
                    params.put("output", document.getFirstChild());
                    mgr.completeWorkItem(workItem.getId(), params);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("process", null);
    }

    @Test
    public void testDataOutputAssociationsXmlNode() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataOutputAssociations-xml-node.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                try {
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
                    HashMap<String, Node> params = new HashMap<String, Node>();
                    params.put("output", document.getFirstChild());
                    mgr.completeWorkItem(workItem.getId(), params);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("process", null);
    }
}

