/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.jbpm.bpmn2.JbpmTestCase;
import org.jbpm.bpmn2.RequirePersistence;
import org.jbpm.bpmn2.handler.ReceiveTaskHandler;
import org.jbpm.bpmn2.handler.SendTaskHandler;
import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.jbpm.bpmn2.handler.SignallingTaskHandlerWrapper;
import org.jbpm.bpmn2.objects.ExceptionService;
import org.jbpm.bpmn2.objects.MyError;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.Context;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class IntermediateEventTest
extends JbpmTestCase {
    private Logger logger = LoggerFactory.getLogger(IntermediateEventTest.class);
    private StatefulKnowledgeSession ksession;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public IntermediateEventTest(boolean persistence) {
        super(persistence);
    }

    @BeforeClass
    public static void setup() throws Exception {
        IntermediateEventTest.setUpDataSource();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testSignalBoundaryEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundarySignalEventOnTaskbpmn2.bpmn", "BPMN2-IntermediateThrowEventSignal.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = ksession.startProcess("BoundarySignalOnTask");
        ProcessInstance processInstance2 = ksession.startProcess("SignalIntermediateEvent");
        this.assertProcessInstanceFinished(processInstance2, (KieSession)ksession);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
    }

    @Test
    public void testSignalBoundaryEventOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundarySignalEventOnTaskbpmn2.bpmn");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new TestWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                System.out.println("After node left " + event.getNodeInstance().getNodeName());
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                System.out.println("After node triggered " + event.getNodeInstance().getNodeName());
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                System.out.println("Before node left " + event.getNodeInstance().getNodeName());
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                System.out.println("Before node triggered " + event.getNodeInstance().getNodeName());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("BoundarySignalOnTask");
        this.ksession.signalEvent("MySignal", (Object)"value");
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testSignalBoundaryEventOnTaskComplete() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundarySignalEventOnTaskbpmn2.bpmn");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                System.out.println("After node left " + event.getNodeInstance().getNodeName());
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                System.out.println("After node triggered " + event.getNodeInstance().getNodeName());
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                System.out.println("Before node left " + event.getNodeInstance().getNodeName());
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                System.out.println("Before node triggered " + event.getNodeInstance().getNodeName());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("BoundarySignalOnTask");
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.ksession.signalEvent("MySignal", (Object)"value");
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testSignalBoundaryEventInterrupting() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SignalBoundaryEventInterrupting.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("SignalBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("MyMessage", null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testSignalIntermediateThrow() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventSignal.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = this.ksession.startProcess("SignalIntermediateEvent", params);
        IntermediateEventTest.assertEquals((int)2, (int)processInstance.getState());
    }

    @Test
    public void testSignalBetweenProcesses() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchSignalSingle.bpmn2", "BPMN2-IntermediateThrowEventSignal.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = ksession.startProcess("BPMN2-IntermediateCatchSignalSingle");
        ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        ProcessInstance processInstance2 = ksession.startProcess("SignalIntermediateEvent");
        this.assertProcessInstanceFinished(processInstance2, (KieSession)ksession);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
    }

    @Test
    public void testEventBasedSplit() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testEventBasedSplitBefore() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
    }

    @Test
    public void testEventBasedSplitAfter() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
    }

    @Test
    public void testEventBasedSplit2() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit2.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        Thread.sleep(800L);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.fireAllRules();
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(800L);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.fireAllRules();
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testEventBasedSplit3() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit3.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        Person jack = new Person();
        jack.setName("Jack");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.insert((Object)jack);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testEventBasedSplit4() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit4.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.signalEvent("Message-YesMessage", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        processInstance = this.ksession.startProcess("com.sample.test");
        this.ksession.signalEvent("Message-NoMessage", (Object)"NoValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testEventBasedSplit5() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit5.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ReceiveTaskHandler receiveTaskHandler = new ReceiveTaskHandler((KieSession)this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        receiveTaskHandler.setKnowledgeRuntime((KieSession)this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        receiveTaskHandler.messageReceived("YesMessage", (Object)"YesValue");
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        receiveTaskHandler.messageReceived("NoMessage", (Object)"NoValue");
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        receiveTaskHandler.setKnowledgeRuntime((KieSession)this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        processInstance = this.ksession.startProcess("com.sample.test");
        receiveTaskHandler.messageReceived("NoMessage", (Object)"NoValue");
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        receiveTaskHandler.messageReceived("YesMessage", (Object)"YesValue");
    }

    @Test
    public void testEventSubprocessSignal() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessSignal.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessSignal");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)listener);
        this.ksession.signalEvent("MySignal", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        this.ksession.signalEvent("MySignal", null);
        this.assertProcessInstanceActive(processInstance);
        this.ksession.signalEvent("MySignal", null);
        this.assertProcessInstanceActive(processInstance);
        this.ksession.signalEvent("MySignal", null);
        this.assertProcessInstanceActive(processInstance);
        WorkItem workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        IntermediateEventTest.assertEquals((int)4, (int)executednodes.size());
    }

    @Test
    public void testEventSubprocessSignalWithStateNode() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessSignalWithStateNode.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("User Task 2")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessSignal");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)listener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        WorkItem workItemTopProcess = workItemHandler.getWorkItem();
        this.ksession.signalEvent("MySignal", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        WorkItem workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.ksession.signalEvent("MySignal", null);
        this.assertProcessInstanceActive(processInstance);
        workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.ksession.signalEvent("MySignal", null);
        this.assertProcessInstanceActive(processInstance);
        workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.ksession.signalEvent("MySignal", null);
        this.assertProcessInstanceActive(processInstance);
        workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        IntermediateEventTest.assertNotNull((Object)workItemTopProcess);
        this.ksession.getWorkItemManager().completeWorkItem(workItemTopProcess.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "User Task 2", "end-sub");
        IntermediateEventTest.assertEquals((int)4, (int)executednodes.size());
    }

    @Test
    public void testEventSubprocessSignalInterrupting() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessSignalInterrupting.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessSignal");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)listener);
        this.ksession.signalEvent("MySignal", null, processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        IntermediateEventTest.assertEquals((int)1, (int)executednodes.size());
    }

    @Test
    public void testEventSubprocessMessage() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessMessage.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessMessage");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)listener);
        this.ksession.signalEvent("Message-HelloMessage", null, processInstance.getId());
        this.ksession.signalEvent("Message-HelloMessage", null);
        this.ksession.signalEvent("Message-HelloMessage", null);
        this.ksession.signalEvent("Message-HelloMessage", null);
        this.ksession.getProcessInstance(processInstance.getId());
        this.ksession.getProcessInstance(processInstance.getId());
        this.ksession.getProcessInstance(processInstance.getId());
        this.ksession.getProcessInstance(processInstance.getId());
        WorkItem workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        IntermediateEventTest.assertEquals((int)4, (int)executednodes.size());
    }

    @Test
    public void testEventSubprocessEscalation() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessEscalation.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessEscalation");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)listener);
        WorkItem workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        IntermediateEventTest.assertEquals((int)1, (int)executednodes.size());
    }

    @Test
    public void testEventSubprocessError() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessError.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessError");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)listener);
        WorkItem workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        IntermediateEventTest.assertEquals((int)1, (int)executednodes.size());
    }

    @Test
    public void testEventSubprocessErrorThrowOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessError.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new TestWorkItemHandler(){

            @Override
            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                throw new MyError();
            }

            @Override
            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
                manager.abortWorkItem(workItem.getId());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessError");
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertProcessInstanceAborted(processInstance);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        IntermediateEventTest.assertEquals((int)1, (int)executednodes.size());
    }

    @Test
    public void testEventSubprocessCompensation() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessCompensation.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessCompensation");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)listener);
        WorkItem workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        IntermediateEventTest.assertEquals((int)1, (int)executednodes.size());
    }

    @Test
    public void testEventSubprocessTimer() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessTimer.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessTimer");
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        WorkItem workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        IntermediateEventTest.assertEquals((int)1, (int)executednodes.size());
    }

    @Test
    @RequirePersistence
    public void testEventSubprocessTimerCycle() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessTimerCycle.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessTimer");
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(2000L);
        WorkItem workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "end", "start-sub", "Script Task 1", "end-sub");
        IntermediateEventTest.assertEquals((int)4, (int)executednodes.size());
    }

    @Test
    public void testEventSubprocessConditional() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessConditional.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessConditional");
        this.assertProcessInstanceActive(processInstance);
        Person person = new Person();
        person.setName("john");
        this.ksession.insert((Object)person);
        WorkItem workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        IntermediateEventTest.assertEquals((int)1, (int)executednodes.size());
    }

    @Test
    public void testMessageIntermediateThrow() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventMessage.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = this.ksession.startProcess("MessageIntermediateEvent", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMessageBoundaryEventOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryMessageEventOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new TestWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("BoundaryMessageOnTask");
        this.ksession.signalEvent("Message-HelloMessage", (Object)"message data");
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "User Task", "Boundary event", "Condition met", "End2");
    }

    @Test
    public void testMessageBoundaryEventOnTaskComplete() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryMessageEventOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("BoundaryMessageOnTask");
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.ksession.signalEvent("Message-HelloMessage", (Object)"message data");
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "User Task", "User Task2", "End1");
    }

    @Test
    public void testEscalationBoundaryEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EscalationBoundaryEvent.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("EscalationBoundaryEvent");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testEscalationBoundaryEventInterrupting() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EscalationBoundaryEventInterrupting.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("EscalationBoundaryEvent");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testEscalationBoundaryEventOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EscalationBoundaryEventOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                System.out.println("After node left " + event.getNodeInstance().getNodeName());
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                System.out.println("After node triggered " + event.getNodeInstance().getNodeName());
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                System.out.println("Before node left " + event.getNodeInstance().getNodeName());
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                System.out.println("Before node triggered " + event.getNodeInstance().getNodeName());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EscalationBoundaryEventOnTask");
        List<WorkItem> workItems = handler.getWorkItems();
        IntermediateEventTest.assertEquals((int)2, (int)workItems.size());
        WorkItem workItem = workItems.get(0);
        if (!"john".equalsIgnoreCase((String)workItem.getParameter("ActorId"))) {
            workItem = workItems.get(1);
        }
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testEscalationIntermediateThrowEventProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventEscalation.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("EscalationIntermediateThrowEvent");
        this.assertProcessInstanceAborted(processInstance);
    }

    @Test
    public void testErrorBoundaryEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ErrorBoundaryEventInterrupting.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("ErrorBoundaryEvent");
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testErrorBoundaryEventOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ErrorBoundaryEventOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-ErrorBoundaryEventOnTask");
        List<WorkItem> workItems = handler.getWorkItems();
        IntermediateEventTest.assertEquals((int)2, (int)workItems.size());
        WorkItem workItem = workItems.get(0);
        if (!"john".equalsIgnoreCase((String)workItem.getParameter("ActorId"))) {
            workItem = workItems.get(1);
        }
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertProcessInstanceAborted(processInstance);
        this.assertNodeTriggered(processInstance.getId(), "start", "split", "User Task", "User task error attached", "error end event");
        this.assertNotNodeTriggered(processInstance.getId(), "Script Task", "error1", "error2");
    }

    @Test
    public void testCatchErrorBoundaryEventOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ErrorBoundaryEventOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new TestWorkItemHandler(){

            @Override
            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                if (workItem.getParameter("ActorId").equals("mary")) {
                    throw new MyError();
                }
            }

            @Override
            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
                manager.abortWorkItem(workItem.getId());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-ErrorBoundaryEventOnTask");
        this.assertProcessInstanceActive(processInstance);
        this.assertNodeTriggered(processInstance.getId(), "start", "split", "User Task", "User task error attached", "Script Task", "error1", "error2");
    }

    @Test
    public void testTimerBoundaryEventDuration() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventDuration.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        this.ksession = this.restoreSession(this.ksession, true);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testTimerBoundaryEventDurationISO() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventDurationISO.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1500L);
        this.ksession = this.restoreSession(this.ksession, true);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testTimerBoundaryEventDateISO() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventDateISO.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        DateTime now = new DateTime(System.currentTimeMillis());
        now.plus(2000L);
        params.put("date", now.toString());
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent", params);
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(2000L);
        this.ksession = this.restoreSession(this.ksession, true);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testTimerBoundaryEventCycle1() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventCycle1.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        this.ksession = this.restoreSession(this.ksession, true);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testTimerBoundaryEventCycle2() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventCycle2.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance);
        this.ksession.abortProcessInstance(processInstance.getId());
        Thread.sleep(1000L);
    }

    @Test
    @RequirePersistence(value=false)
    public void testTimerBoundaryEventCycleISO() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventCycleISO.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance);
        this.ksession.abortProcessInstance(processInstance.getId());
        Thread.sleep(1000L);
    }

    @Test
    @RequirePersistence
    public void testTimerBoundaryEventCycleISOWithPersistence() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventCycleISO.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("TimerEvent")) {
                    list.add(event.getProcessInstance().getId());
                }
            }
        };
        ksession.addEventListener((ProcessEventListener)listener);
        int sessionId = ksession.getId();
        Environment env = ksession.getEnvironment();
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance);
        System.out.println("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)env);
        ksession.addEventListener((ProcessEventListener)listener);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(2000L);
        this.assertProcessInstanceActive(processInstance);
        ksession.abortProcessInstance(processInstance.getId());
        Thread.sleep(1000L);
        IntermediateEventTest.assertEquals((int)2, (int)list.size());
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
    }

    @Test
    public void testTimerBoundaryEventInterrupting() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventInterrupting.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        this.ksession = this.restoreSession(this.ksession, true);
        this.logger.debug("Firing timer");
        this.ksession.fireAllRules();
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testTimerBoundaryEventInterruptingOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventInterruptingOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new TestWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        this.ksession = this.restoreSession(this.ksession, true);
        this.logger.debug("Firing timer");
        this.ksession.fireAllRules();
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testIntermediateCatchEventSignal() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventSignal.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("MyMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "UserTask", "EndProcess", "event");
    }

    @Test
    public void testIntermediateCatchEventMessage() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventMessage.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("Message-HelloMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testIntermediateCatchEventTimerDuration() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerDuration.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.fireAllRules();
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testIntermediateCatchEventTimerDateISO() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerDateISO.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        DateTime now = new DateTime(System.currentTimeMillis());
        now.plus(2000L);
        params.put("date", now.toString());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent", params);
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(2000L);
        this.ksession.fireAllRules();
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testIntermediateCatchEventTimerDurationISO() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerDurationISO.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1500L);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.fireAllRules();
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testIntermediateCatchEventTimerCycle1() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerCycle1.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.fireAllRules();
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testIntermediateCatchEventTimerCycleISO() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerCycleISO.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("timer")) {
                    list.add(event.getProcessInstance().getId());
                }
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(500L);
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(1000L);
        }
        IntermediateEventTest.assertEquals((int)5, (int)list.size());
    }

    @Test
    public void testIntermediateCatchEventTimerCycle2() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerCycle2.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance);
        this.ksession.abortProcessInstance(processInstance.getId());
        Thread.sleep(1000L);
    }

    @Test
    public void testIntermediateCatchEventCondition() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventCondition.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        Person person = new Person();
        person.setName("Jack");
        this.ksession.insert((Object)person);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testIntermediateCatchEventConditionFilterByProcessInstance() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventConditionFilterByProcessInstance.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Long> params1 = new HashMap<String, Long>();
        params1.put("personId", 1L);
        Person person1 = new Person();
        person1.setId(1L);
        WorkflowProcessInstance pi1 = (WorkflowProcessInstance)this.ksession.createProcessInstance("IntermediateCatchEventConditionFilterByProcessInstance", params1);
        long pi1id = pi1.getId();
        this.ksession.insert((Object)pi1);
        FactHandle personHandle1 = this.ksession.insert((Object)person1);
        this.ksession.startProcessInstance(pi1.getId());
        HashMap<String, Long> params2 = new HashMap<String, Long>();
        params2.put("personId", 2L);
        Person person2 = new Person();
        person2.setId(2L);
        WorkflowProcessInstance pi2 = (WorkflowProcessInstance)this.ksession.createProcessInstance("IntermediateCatchEventConditionFilterByProcessInstance", params2);
        long pi2id = pi2.getId();
        this.ksession.insert((Object)pi2);
        FactHandle personHandle2 = this.ksession.insert((Object)person2);
        this.ksession.startProcessInstance(pi2.getId());
        person1.setName("John");
        this.ksession.update(personHandle1, (Object)person1);
        IntermediateEventTest.assertNull((String)"First process should be completed", (Object)this.ksession.getProcessInstance(pi1id));
        IntermediateEventTest.assertNotNull((String)"Second process should NOT be completed", (Object)this.ksession.getProcessInstance(pi2id));
    }

    @Test
    @RequirePersistence(value=false)
    public void testIntermediateCatchEventTimerCycleWithError() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerCycleWithError.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 0);
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent", params);
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance);
        processInstance = this.ksession.getProcessInstance(processInstance.getId());
        Integer xValue = (Integer)((WorkflowProcessInstance)processInstance).getVariable("x");
        IntermediateEventTest.assertEquals((Object)new Integer(3), (Object)xValue);
        this.ksession.abortProcessInstance(processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    @RequirePersistence
    public void testIntermediateCatchEventTimerCycleWithErrorWithPersistence() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerCycleWithError.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance);
        final long piId = processInstance.getId();
        this.ksession.execute((Command)new GenericCommand<Void>(){

            public Void execute(Context context) {
                StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)((KnowledgeCommandContext)context).getKieSession();
                WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(piId);
                processInstance.setVariable("x", (Object)0);
                return null;
            }
        });
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance);
        Thread.sleep(1000L);
        this.assertProcessInstanceActive(processInstance);
        Integer xValue = (Integer)this.ksession.execute((Command)new GenericCommand<Integer>(){

            public Integer execute(Context context) {
                StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)((KnowledgeCommandContext)context).getKieSession();
                WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(piId);
                return (Integer)processInstance.getVariable("x");
            }
        });
        IntermediateEventTest.assertEquals((Object)new Integer(2), (Object)xValue);
        this.ksession.abortProcessInstance(processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testCompensateIntermediateThrowEventProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventCompensate.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("CompensateIntermediateThrowEvent");
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
    }

    @Test
    public void testNoneIntermediateThrow() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventNone.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("NoneIntermediateEvent", null);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testLinkIntermediateEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateLinkEvent.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("linkEventProcessExample");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testLinkEventCompositeProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-LinkEventCompositeProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Composite");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testConditionalBoundaryEventOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryConditionalEventOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new TestWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("BoundarySignalOnTask");
        Person person = new Person();
        person.setName("john");
        this.ksession.insert((Object)person);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "User Task", "Boundary event", "Condition met", "End2");
    }

    @Test
    public void testConditionalBoundaryEventOnTaskComplete() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryConditionalEventOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("BoundarySignalOnTask");
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        Person person = new Person();
        person.setName("john");
        this.ksession.insert((Object)person);
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "User Task", "User Task2", "End1");
    }

    @Test
    public void testConditionalBoundaryEventOnTaskActiveOnStartup() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryConditionalEventOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new TestWorkItemHandler());
        Person person = new Person();
        person.setName("john");
        this.ksession.insert((Object)person);
        ProcessInstance processInstance = this.ksession.startProcess("BoundarySignalOnTask");
        this.assertProcessInstanceCompleted(processInstance);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "User Task", "Boundary event", "Condition met", "End2");
    }

    @Test
    public void testConditionalBoundaryEventInterrupting() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ConditionalBoundaryEventInterrupting.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("ConditionalBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        Person person = new Person();
        person.setName("john");
        this.ksession.insert((Object)person);
        this.assertProcessInstanceFinished(processInstance, (KieSession)this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "Hello", "StartSubProcess", "Task", "BoundaryEvent", "Goodbye", "EndProcess");
    }

    @Test
    public void testErrorSignallingExceptionServiceTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExceptionServiceProcess-ErrorSignalling.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        String eventType = "Error-code";
        SignallingTaskHandlerWrapper signallingTaskWrapper = new SignallingTaskHandlerWrapper(ServiceTaskHandler.class, eventType, (KieSession)this.ksession);
        signallingTaskWrapper.setWorkItemExceptionParameterName(ExceptionService.exceptionParameterName);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)signallingTaskWrapper);
        Object[] caughtEventObjectHolder = new Object[]{null};
        ExceptionService.setCaughtEventObjectHolder(caughtEventObjectHolder);
        HashMap<String, String> params = new HashMap<String, String>();
        String input = "this is my service input";
        params.put("serviceInputItem", input);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.startProcess("ServiceProcess", params);
        IntermediateEventTest.assertTrue((String)"Event was not passed to Event Subprocess", (caughtEventObjectHolder[0] != null && caughtEventObjectHolder[0] instanceof WorkItem ? 1 : 0) != 0);
        WorkItem workItem = (WorkItem)caughtEventObjectHolder[0];
        Object throwObj = workItem.getParameter(ExceptionService.exceptionParameterName);
        IntermediateEventTest.assertTrue((String)"WorkItem doesn't contain Throwable", (boolean)(throwObj instanceof Throwable));
        IntermediateEventTest.assertTrue((String)"Exception message does not match service input.", (boolean)((Throwable)throwObj).getMessage().endsWith(input));
        this.assertProcessInstanceAborted((ProcessInstance)processInstance);
    }

    @Test
    public void testSignallingExceptionServiceTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExceptionServiceProcess-Signalling.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        String eventType = "exception-signal";
        SignallingTaskHandlerWrapper signallingTaskWrapper = new SignallingTaskHandlerWrapper(ServiceTaskHandler.class, eventType, (KieSession)this.ksession);
        signallingTaskWrapper.setWorkItemExceptionParameterName(ExceptionService.exceptionParameterName);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)signallingTaskWrapper);
        Object[] caughtEventObjectHolder = new Object[]{null};
        ExceptionService.setCaughtEventObjectHolder(caughtEventObjectHolder);
        HashMap<String, String> params = new HashMap<String, String>();
        String input = "this is my service input";
        params.put("serviceInputItem", input);
        ProcessInstance processInstance = this.ksession.startProcess("ServiceProcess", params);
        IntermediateEventTest.assertTrue((String)"Event was not passed to Event Subprocess", (caughtEventObjectHolder[0] != null && caughtEventObjectHolder[0] instanceof WorkItem ? 1 : 0) != 0);
        WorkItem workItem = (WorkItem)caughtEventObjectHolder[0];
        Object throwObj = workItem.getParameter(ExceptionService.exceptionParameterName);
        IntermediateEventTest.assertTrue((String)"WorkItem doesn't contain Throwable", (boolean)(throwObj instanceof Throwable));
        IntermediateEventTest.assertTrue((String)"Exception message does not match service input.", (boolean)((Throwable)throwObj).getMessage().endsWith(input));
        IntermediateEventTest.assertEquals((String)"Process instance is not active.", (int)1, (int)processInstance.getState());
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        processInstance = this.ksession.getProcessInstance(processInstance.getId());
        if (processInstance != null) {
            IntermediateEventTest.assertEquals((String)"Process instance is not completed.", (int)2, (int)processInstance.getState());
        }
    }
}

