/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.handler;

import java.util.ArrayList;
import java.util.HashMap;
import org.jbpm.bpmn2.JbpmTestCase;
import org.jbpm.bpmn2.handler.LoggingTaskHandlerWrapper;
import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.junit.After;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class LoggingTaskHandlerWrapperTest
extends JbpmTestCase {
    private StatefulKnowledgeSession ksession;

    public LoggingTaskHandlerWrapperTest() {
        super(false);
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testLimitExceptionInfoList() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExceptionThrowingServiceProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        LoggingTaskHandlerWrapper loggingTaskHandlerWrapper = new LoggingTaskHandlerWrapper(ServiceTaskHandler.class, 2);
        loggingTaskHandlerWrapper.setPrintStackTrace(false);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)loggingTaskHandlerWrapper);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("serviceInputItem", "exception message");
        this.ksession.startProcess("ServiceProcess", params);
        this.ksession.startProcess("ServiceProcess", params);
        this.ksession.startProcess("ServiceProcess", params);
        int size = loggingTaskHandlerWrapper.getWorkItemExceptionInfoList().size();
        LoggingTaskHandlerWrapperTest.assertTrue((String)("WorkItemExceptionInfoList is too large: " + size), (size == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testFormatLoggingError() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExceptionThrowingServiceProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        LoggingTaskHandlerWrapper loggingTaskHandlerWrapper = new LoggingTaskHandlerWrapper(ServiceTaskHandler.class, 2);
        loggingTaskHandlerWrapper.setLoggedMessageFormat("{0} - {1} - {2} - {3}");
        ArrayList<LoggingTaskHandlerWrapper.InputParameter> inputParameters = new ArrayList<LoggingTaskHandlerWrapper.InputParameter>();
        inputParameters.add(LoggingTaskHandlerWrapper.InputParameter.EXCEPTION_CLASS);
        inputParameters.add(LoggingTaskHandlerWrapper.InputParameter.WORK_ITEM_ID);
        inputParameters.add(LoggingTaskHandlerWrapper.InputParameter.WORK_ITEM_NAME);
        inputParameters.add(LoggingTaskHandlerWrapper.InputParameter.PROCESS_INSTANCE_ID);
        loggingTaskHandlerWrapper.setLoggedMessageInput(inputParameters);
        loggingTaskHandlerWrapper.setPrintStackTrace(false);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)loggingTaskHandlerWrapper);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("serviceInputItem", "exception message");
        this.ksession.startProcess("ServiceProcess", params);
        this.ksession.startProcess("ServiceProcess", params);
        this.ksession.startProcess("ServiceProcess", params);
    }
}

