/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.persistence;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import junit.framework.Assert;
import org.jbpm.bpmn2.concurrency.MultipleProcessesPerThreadTest;
import org.jbpm.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnmarshallingOverdueTimersTest {
    private static Logger logger = LoggerFactory.getLogger(MultipleProcessesPerThreadTest.class);
    private HashMap<String, Object> context;
    private static long seconds = 10L;
    private static String timeUnit = "s";
    private static String bpmn2FileName = "BPMN2-TimerInterrupted.bpmn2";
    private static boolean debug = true;

    @Before
    public void setup() {
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.cleanUp(this.context);
    }

    private static KnowledgeBase loadKnowledgeBase(String bpmn2FileName) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)bpmn2FileName, UnmarshallingOverdueTimersTest.class), ResourceType.BPMN2);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    private StatefulKnowledgeSession createStatefulKnowledgeSession(KnowledgeBase kbase) {
        Environment env = PersistenceUtil.createEnvironment(this.context);
        return JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
    }

    private static int knowledgeSessionDispose(StatefulKnowledgeSession ksession) {
        int ksessionId = ksession.getId();
        logger.debug("disposing of ksesssion");
        ksession.dispose();
        return ksessionId;
    }

    private StatefulKnowledgeSession reloadStatefulKnowledgeSession(String bpmn2FileName, int ksessionId) {
        KnowledgeBase kbase = UnmarshallingOverdueTimersTest.loadKnowledgeBase(bpmn2FileName);
        logger.debug(". reloading ksession " + ksessionId);
        Environment env = null;
        env = PersistenceUtil.createEnvironment(this.context);
        return JPAKnowledgeService.loadStatefulKnowledgeSession((int)ksessionId, (KieBase)kbase, null, (Environment)env);
    }

    @Test
    public void startDisposeAndReloadTimerProcess() throws Exception {
        ProcessInstance processInstance;
        StatefulKnowledgeSession ksession;
        String shellVar;
        String shellVarVal;
        if (debug && (shellVarVal = System.getenv(shellVar = "TEST")) != null) {
            debug = false;
        }
        String sessionPropName = "KSESSION_ID";
        String sessionPropVal = System.getenv(sessionPropName);
        String processPropName = "PROCESS_ID";
        String processPropVal = System.getenv(sessionPropName);
        if (sessionPropVal == null || debug) {
            KnowledgeBase kbase = UnmarshallingOverdueTimersTest.loadKnowledgeBase(bpmn2FileName);
            ksession = this.createStatefulKnowledgeSession(kbase);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("time", seconds + timeUnit);
            Calendar cal = GregorianCalendar.getInstance();
            processInstance = ksession.startProcess("interruptedTimer", params);
            long processId = processInstance.getId();
            if (debug) {
                processPropVal = Long.toString(processId);
            } else {
                logger.info("export " + processPropName + "=" + processId);
            }
            KieSessionConfiguration config = ksession.getSessionConfiguration();
            int ksessionId = UnmarshallingOverdueTimersTest.knowledgeSessionDispose(ksession);
            if (debug) {
                sessionPropVal = Integer.toString(ksessionId);
            } else {
                logger.info("export " + sessionPropName + "=" + ksessionId);
            }
            if (!debug) {
                cal.add(13, (int)seconds);
                SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
                logger.info("\nPlease wait at least " + seconds + timeUnit + " [" + sdf.format(cal.getTime()) + "]\n");
            }
        }
        if (debug) {
            long wait = (long)((double)seconds * 1000.0 * 1.1);
            logger.debug("sleeping " + wait + " seconds");
            Thread.sleep(seconds * 1000L);
        }
        if (sessionPropVal != null || debug) {
            int ksessionId = Integer.parseInt(sessionPropVal);
            ksession = this.reloadStatefulKnowledgeSession(bpmn2FileName, ksessionId);
            long processInstanceId = Integer.parseInt(processPropVal);
            logger.debug("! waiting 5 seconds for timer to fire");
            Thread.sleep(5000L);
            processInstance = ksession.getProcessInstance(processInstanceId);
            if (processInstance != null) {
                Assert.assertTrue((String)"Process has not terminated.", (processInstance.getState() == 2 ? 1 : 0) != 0);
            }
        }
    }
}

