/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.StringHolder;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.StatefulKnowledgeSession;

@RunWith(value=Parameterized.class)
public class CompensationTest
extends JbpmBpmn2TestCase {
    private KieSession ksession;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public CompensationTest(boolean persistence) {
        super(persistence);
    }

    @BeforeClass
    public static void setup() throws Exception {
        CompensationTest.setUpDataSource();
    }

    @Before
    public void prepare() {
        this.clearHistory();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void compensationViaIntermediateThrowEventProcess() throws Exception {
        StatefulKnowledgeSession ksession = this.createKnowledgeSession("compensation/BPMN2-Compensation-IntermediateThrowEvent.bpmn2");
        HashMap<String, StringHolder> params = new HashMap<String, StringHolder>();
        StringHolder x = new StringHolder();
        params.put("x", x);
        ProcessInstance processInstance = ksession.startProcess("CompensateIntermediateThrowEvent", params);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
        CompensationTest.assertTrue((String)("Value was not modified in compensation script and is: " + x.getVal()), (boolean)"true".equals(x.getVal()));
    }

    @Test
    public void compensationViaEventSubProcess() throws Exception {
        StatefulKnowledgeSession ksession = this.createKnowledgeSession("compensation/BPMN2-Compensation-EventSubProcess.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, StringHolder> params = new HashMap<String, StringHolder>();
        StringHolder x = new StringHolder();
        params.put("x", x);
        ProcessInstance processInstance = ksession.startProcess("CompensateEventSubprocess", params);
        this.assertProcessInstanceActive(processInstance.getId(), (KieSession)ksession);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), null);
        this.assertProcessVarValue(processInstance, "x", "true");
    }
}

