/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;

public class IncrementalCompilationTest {
    @Test
    @Ignore(value="See https://issues.jboss.org/browse/DROOLS-179")
    public void testIncrementalProcessCompilation() throws Exception {
        String invalidProcessDefinition = this.getResource("/BPMN2-Incremental-Build-Invalid.bpmn2");
        String validProcessDefinition = this.getResource("/BPMN2-Incremental-Build-Valid.bpmn2");
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/p1.bpmn2", invalidProcessDefinition);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Results results = kieBuilder.getResults();
        Assert.assertEquals((int)4, (int)results.getMessages(new Message.Level[]{Message.Level.ERROR}).size());
        kfs.write("src/main/resources/p1.bpmn2", validProcessDefinition);
        IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/p1.bpmn2"}).build();
        Assert.assertEquals((int)0, (int)addResults.getAddedMessages().size());
        Assert.assertEquals((int)4, (int)addResults.getRemovedMessages().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResource(String name) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(name);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
        finally {
            br.close();
        }
    }
}

