/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.persistence;

import java.util.ArrayList;
import org.drools.core.WorkingMemory;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.event.ActivationCancelledEvent;
import org.drools.core.event.ActivationCreatedEvent;
import org.drools.core.event.AfterActivationFiredEvent;
import org.drools.core.event.AgendaEventListener;
import org.drools.core.event.AgendaGroupPoppedEvent;
import org.drools.core.event.AgendaGroupPushedEvent;
import org.drools.core.event.BeforeActivationFiredEvent;
import org.drools.core.event.RuleFlowGroupActivatedEvent;
import org.drools.core.event.RuleFlowGroupDeactivatedEvent;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.process.audit.AuditLoggerFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class TimerCycleOnBinaryPackageTest
extends JbpmBpmn2TestCase {
    private StatefulKnowledgeSession ksession;

    public TimerCycleOnBinaryPackageTest() {
        super(true);
    }

    @BeforeClass
    public static void setup() throws Exception {
        TimerCycleOnBinaryPackageTest.setUpDataSource();
    }

    @Before
    public void prepare() {
        this.clearHistory();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    @Test
    public void testStartTimerCycleFromDisc() throws Exception {
        KieBase kbase = this.createKnowledgeBaseFromDisc("BPMN2-StartTimerCycle.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TimerCycleOnBinaryPackageTest.assertEquals((int)0, (int)this.getNumberOfProcessInstances("defaultPackage.TimerProcess"));
        int sessionId = ksession.getId();
        Environment env = ksession.getEnvironment();
        final ArrayList list = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        Thread.sleep(5000L);
        TimerCycleOnBinaryPackageTest.assertEquals((int)2, (int)this.getNumberOfProcessInstances("defaultPackage.TimerProcess"));
        System.out.println("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)env);
        AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)ksession, null);
        final ArrayList list2 = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list2.add(event.getProcessInstance().getId());
            }
        });
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        Thread.sleep(5000L);
        ksession.dispose();
        TimerCycleOnBinaryPackageTest.assertEquals((int)4, (int)this.getNumberOfProcessInstances("defaultPackage.TimerProcess"));
    }

    @Test
    public void testStartTimerCycleFromClassPath() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-StartTimerCycle.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TimerCycleOnBinaryPackageTest.assertEquals((int)0, (int)this.getNumberOfProcessInstances("defaultPackage.TimerProcess"));
        int sessionId = ksession.getId();
        Environment env = ksession.getEnvironment();
        final ArrayList list = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        Thread.sleep(5000L);
        TimerCycleOnBinaryPackageTest.assertEquals((int)2, (int)this.getNumberOfProcessInstances("defaultPackage.TimerProcess"));
        System.out.println("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)env);
        AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)ksession, null);
        final ArrayList list2 = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list2.add(event.getProcessInstance().getId());
            }
        });
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        Thread.sleep(5000L);
        ksession.dispose();
        TimerCycleOnBinaryPackageTest.assertEquals((int)4, (int)this.getNumberOfProcessInstances("defaultPackage.TimerProcess"));
    }

    @Test
    @Ignore(value="beta4 phreak")
    public void testStartTimerCycleFromDiscDRL() throws Exception {
        KieBase kbase = this.createKnowledgeBaseFromDisc("rules-timer.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        int sessionId = ksession.getId();
        Environment env = ksession.getEnvironment();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        TimerCycleOnBinaryPackageTest.assertEquals((int)2, (int)list.size());
        System.out.println("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)env);
        AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)ksession, null);
        ArrayList list2 = new ArrayList();
        ksession.setGlobal("list", list2);
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(6000L);
        TimerCycleOnBinaryPackageTest.assertEquals((int)3, (int)list2.size());
    }

    @Test
    @Ignore(value="beta4 phreak")
    public void testStartTimerCycleFromClasspathDRL() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("rules-timer.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        int sessionId = ksession.getId();
        Environment env = ksession.getEnvironment();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        TimerCycleOnBinaryPackageTest.assertEquals((int)2, (int)list.size());
        System.out.println("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)env);
        AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)ksession, null);
        ArrayList list2 = new ArrayList();
        ksession.setGlobal("list", list2);
        ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession()).session.addEventListener((AgendaEventListener)new TriggerRulesEventListener(ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        TimerCycleOnBinaryPackageTest.assertEquals((int)3, (int)list2.size());
    }

    private static class TriggerRulesEventListener
    implements AgendaEventListener {
        private StatefulKnowledgeSession ksession;

        public TriggerRulesEventListener(StatefulKnowledgeSession ksession) {
            this.ksession = ksession;
        }

        public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
            this.ksession.fireAllRules();
        }

        public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
        }

        public void beforeActivationFired(BeforeActivationFiredEvent event, WorkingMemory workingMemory) {
        }

        public void afterActivationFired(AfterActivationFiredEvent event, WorkingMemory workingMemory) {
        }

        public void agendaGroupPopped(AgendaGroupPoppedEvent event, WorkingMemory workingMemory) {
        }

        public void agendaGroupPushed(AgendaGroupPushedEvent event, WorkingMemory workingMemory) {
        }

        public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
        }

        public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
            workingMemory.fireAllRules();
        }

        public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
        }

        public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
        }
    }
}

