/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.structureref;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.StartEventTest;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class StructureRefTest
extends JbpmBpmn2TestCase {
    private Logger logger = LoggerFactory.getLogger(StartEventTest.class);

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}};
        return Arrays.asList(data);
    }

    public StructureRefTest(boolean persistence) {
        super(persistence);
    }

    @Test
    public void testStringStructureRef() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-StringStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        StructureRefTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "test value");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testBooleanStructureRef() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-BooleanStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        StructureRefTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "true");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testIntegerStructureRef() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-IntegerStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        StructureRefTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "25");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testFloatStructureRef() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-FloatStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        StructureRefTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "5.5");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testObjectStructureRef() throws Exception {
        String personAsXml = "<org.jbpm.bpmn2.objects.Person><id>1</id><name>john</name></org.jbpm.bpmn2.objects.Person>";
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-ObjectStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        StructureRefTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", personAsXml);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testDefaultObjectStructureRef() throws Exception {
        String value = "simple text for testing";
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DefaultObjectStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        StructureRefTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", value);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testNoStructureRef() throws Exception {
        Person person = new Person();
        person.setId(1L);
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-NoStructureRef.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("StructureRef");
        StructureRefTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        HashMap<String, Person> res = new HashMap<String, Person>();
        res.put("testHT", person);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }
}

