/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceListener;
import org.jbpm.bpmn2.BPMN2XMLTest;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.process.WorkflowProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class XMLBPMNProcessDumperTest
extends JbpmBpmn2TestCase {
    private static final Logger logger = LoggerFactory.getLogger(XMLBPMNProcessDumperTest.class);

    public XMLBPMNProcessDumperTest() {
        super(false);
    }

    @Test
    public void testConditionExpression() throws Exception {
        String filename = "BPMN2-GatewaySplit-SequenceConditions.bpmn2";
        String original = BPMN2XMLTest.slurp(XMLBPMNProcessDumperTest.class.getResourceAsStream("/" + filename));
        KieBase kbase = this.createKnowledgeBase(filename);
        WorkflowProcess process = (WorkflowProcess)kbase.getProcess("GatewayTest");
        String result = XmlBPMNProcessDumper.INSTANCE.dump(process, 2);
        Diff diff = new Diff(original, result);
        diff.overrideDifferenceListener(new DifferenceListener(){

            public int differenceFound(Difference diff) {
                String nodeName = diff.getTestNodeDetail().getNode().getNodeName();
                if (nodeName.equals("conditionExpression") || nodeName.equals("language")) {
                    logger.info(diff.toString());
                    return 0;
                }
                return 1;
            }

            public void skippedComparison(Node one, Node two) {
                logger.info("{} : {}", (Object)one.getLocalName(), (Object)two.getLocalName());
            }
        });
        XMLBPMNProcessDumperTest.assertTrue((String)"Original and generated output is not the same.", (boolean)diff.identical());
    }
}

