/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.StandaloneBPMNProcessTest;
import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.jbpm.bpmn2.objects.MyError;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class ErrorEventTest
extends JbpmBpmn2TestCase {
    private Logger logger = LoggerFactory.getLogger(ErrorEventTest.class);
    private KieSession ksession;
    private ProcessEventListener LOGGING_EVENT_LISTENER = new DefaultProcessEventListener(){

        public void afterNodeLeft(ProcessNodeLeftEvent event) {
            ErrorEventTest.this.logger.info("After node left {}", (Object)event.getNodeInstance().getNodeName());
        }

        public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
            ErrorEventTest.this.logger.info("After node triggered {}", (Object)event.getNodeInstance().getNodeName());
        }

        public void beforeNodeLeft(ProcessNodeLeftEvent event) {
            ErrorEventTest.this.logger.info("Before node left {}", (Object)event.getNodeInstance().getNodeName());
        }

        public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
            ErrorEventTest.this.logger.info("Before node triggered {}", (Object)event.getNodeInstance().getNodeName());
        }
    };

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public ErrorEventTest(boolean persistence) {
        super(persistence);
    }

    @BeforeClass
    public static void setup() throws Exception {
        ErrorEventTest.setUpDataSource();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testEventSubprocessError() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessError.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessError");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)listener);
        WorkItem workItem = workItemHandler.getWorkItem();
        ErrorEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        ErrorEventTest.assertEquals((long)1L, (long)executednodes.size());
    }

    @Test
    public void testEventSubprocessErrorThrowOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessError.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new TestWorkItemHandler(){

            @Override
            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                throw new MyError();
            }

            @Override
            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
                manager.abortWorkItem(workItem.getId());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessError");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertProcessInstanceAborted(processInstance);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        ErrorEventTest.assertEquals((long)1L, (long)executednodes.size());
    }

    @Test
    public void testErrorBoundaryEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ErrorBoundaryEventInterrupting.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("ErrorBoundaryEvent");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testErrorBoundaryEventOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ErrorBoundaryEventOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-ErrorBoundaryEventOnTask");
        List<WorkItem> workItems = handler.getWorkItems();
        ErrorEventTest.assertEquals((long)2L, (long)workItems.size());
        WorkItem workItem = workItems.get(0);
        if (!"john".equalsIgnoreCase((String)workItem.getParameter("ActorId"))) {
            workItem = workItems.get(1);
        }
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertProcessInstanceAborted(processInstance);
        this.assertNodeTriggered(processInstance.getId(), "start", "split", "User Task", "User task error attached", "error end event");
        this.assertNotNodeTriggered(processInstance.getId(), "Script Task", "error1", "error2");
    }

    @Test
    public void testErrorBoundaryEventOnServiceTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ErrorBoundaryEventOnServiceTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "test");
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-ErrorBoundaryEventOnServiceTask", params);
        List<WorkItem> workItems = handler.getWorkItems();
        ErrorEventTest.assertEquals((long)1L, (long)workItems.size());
        this.ksession.getWorkItemManager().completeWorkItem(workItems.get(0).getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "split", "User Task", "Service task error attached", "end0", "Script Task", "error2");
    }

    @Test
    public void testCatchErrorBoundaryEventOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ErrorBoundaryEventOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new TestWorkItemHandler(){

            @Override
            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                if (workItem.getParameter("ActorId").equals("mary")) {
                    throw new MyError();
                }
            }

            @Override
            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
                manager.abortWorkItem(workItem.getId());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-ErrorBoundaryEventOnTask");
        this.assertProcessInstanceActive(processInstance);
        this.assertNodeTriggered(processInstance.getId(), "start", "split", "User Task", "User task error attached", "Script Task", "error1", "error2");
    }

    @Test
    public void testErrorSignallingExceptionServiceTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExceptionServiceProcess-ErrorSignalling.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        StandaloneBPMNProcessTest.runTestErrorSignallingExceptionServiceTask(this.ksession);
    }

    @Test
    public void testSignallingExceptionServiceTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExceptionServiceProcess-Signalling.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        StandaloneBPMNProcessTest.runTestSignallingExceptionServiceTask(this.ksession);
    }
}

