/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.handler.LoggingTaskHandlerDecorator;
import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.StatefulKnowledgeSession;

@RunWith(value=Parameterized.class)
public class LoggingTaskHandlerWrapperTest
extends JbpmBpmn2TestCase {
    private StatefulKnowledgeSession ksession;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public LoggingTaskHandlerWrapperTest(boolean persistence) {
        super(persistence);
    }

    @BeforeClass
    public static void setup() throws Exception {
        LoggingTaskHandlerWrapperTest.setUpDataSource();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testLimitExceptionInfoList() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExceptionThrowingServiceProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        LoggingTaskHandlerDecorator loggingTaskHandlerWrapper = new LoggingTaskHandlerDecorator(ServiceTaskHandler.class, 2);
        loggingTaskHandlerWrapper.setPrintStackTrace(false);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)loggingTaskHandlerWrapper);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("serviceInputItem", "exception message");
        this.ksession.startProcess("ServiceProcess", params);
        this.ksession.startProcess("ServiceProcess", params);
        this.ksession.startProcess("ServiceProcess", params);
        int size = loggingTaskHandlerWrapper.getWorkItemExceptionInfoList().size();
        LoggingTaskHandlerWrapperTest.assertTrue((String)("WorkItemExceptionInfoList is too large: " + size), (size == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testFormatLoggingError() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExceptionThrowingServiceProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        LoggingTaskHandlerDecorator loggingTaskHandlerWrapper = new LoggingTaskHandlerDecorator(ServiceTaskHandler.class, 2);
        loggingTaskHandlerWrapper.setLoggedMessageFormat("{0} - {1} - {2} - {3}");
        ArrayList<LoggingTaskHandlerDecorator.InputParameter> inputParameters = new ArrayList<LoggingTaskHandlerDecorator.InputParameter>();
        inputParameters.add(LoggingTaskHandlerDecorator.InputParameter.EXCEPTION_CLASS);
        inputParameters.add(LoggingTaskHandlerDecorator.InputParameter.WORK_ITEM_ID);
        inputParameters.add(LoggingTaskHandlerDecorator.InputParameter.WORK_ITEM_NAME);
        inputParameters.add(LoggingTaskHandlerDecorator.InputParameter.PROCESS_INSTANCE_ID);
        loggingTaskHandlerWrapper.setLoggedMessageInput(inputParameters);
        loggingTaskHandlerWrapper.setPrintStackTrace(false);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)loggingTaskHandlerWrapper);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("serviceInputItem", "exception message");
        this.ksession.startProcess("ServiceProcess", params);
        this.ksession.startProcess("ServiceProcess", params);
        this.ksession.startProcess("ServiceProcess", params);
    }
}

