/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class EscalationEventTest
extends JbpmBpmn2TestCase {
    private Logger logger = LoggerFactory.getLogger(EscalationEventTest.class);
    private KieSession ksession;
    private ProcessEventListener LOGGING_EVENT_LISTENER = new DefaultProcessEventListener(){

        public void afterNodeLeft(ProcessNodeLeftEvent event) {
            EscalationEventTest.this.logger.info("After node left {}", (Object)event.getNodeInstance().getNodeName());
        }

        public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
            EscalationEventTest.this.logger.info("After node triggered {}", (Object)event.getNodeInstance().getNodeName());
        }

        public void beforeNodeLeft(ProcessNodeLeftEvent event) {
            EscalationEventTest.this.logger.info("Before node left {}", (Object)event.getNodeInstance().getNodeName());
        }

        public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
            EscalationEventTest.this.logger.info("Before node triggered {}", (Object)event.getNodeInstance().getNodeName());
        }
    };

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public EscalationEventTest(boolean persistence) {
        super(persistence);
    }

    @BeforeClass
    public static void setup() throws Exception {
        EscalationEventTest.setUpDataSource();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testEventSubprocessEscalation() throws Exception {
        KieBase kbase = this.createKnowledgeBase("escalation/BPMN2-EventSubprocessEscalation.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessEscalation");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)listener);
        WorkItem workItem = workItemHandler.getWorkItem();
        EscalationEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        EscalationEventTest.assertEquals((long)1L, (long)executednodes.size());
    }

    @Test
    public void testEscalationBoundaryEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("escalation/BPMN2-EscalationBoundaryEvent.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("EscalationBoundaryEvent");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testEscalationBoundaryEventInterrupting() throws Exception {
        KieBase kbase = this.createKnowledgeBase("escalation/BPMN2-EscalationBoundaryEventInterrupting.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("EscalationBoundaryEvent");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    @Ignore(value="Escalation does not cancel work items yet.")
    public void testEscalationBoundaryEventInterruptsTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("escalation/BPMN2-EscalationBoundaryEventInterrupting.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("EscalationBoundaryEvent");
        this.assertProcessInstanceCompleted(processInstance);
        EscalationEventTest.assertEquals((String)"WorkItem was not cancelled!", (long)3L, (long)handler.getWorkItem().getState());
    }

    @Test
    public void testEscalationIntermediateThrowEventProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("escalation/BPMN2-IntermediateThrowEventEscalation.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("EscalationIntermediateThrowEvent");
        this.assertProcessInstanceAborted(processInstance);
    }

    @Test
    @Ignore(value="General escalation is not yet supported.")
    public void testGeneralEscalationBoundaryEventWithTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("escalation/BPMN2-EscalationBoundaryEventWithTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "0");
        ProcessInstance processInstance = this.ksession.startProcess("non-interrupting-escalation", params);
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.assertProcessInstanceCompleted(processInstance);
        this.assertProcessVarValue(processInstance, "x", "1");
    }

    @Test
    public void testInterruptingEscalationBoundaryEventOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("escalation/BPMN2-EscalationBoundaryEventOnTaskInterrupting.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        this.ksession.addEventListener(this.LOGGING_EVENT_LISTENER);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EscalationBoundaryEventOnTask");
        List<WorkItem> workItems = handler.getWorkItems();
        EscalationEventTest.assertEquals((long)2L, (long)workItems.size());
        WorkItem workItem = workItems.get(0);
        if (!"john".equalsIgnoreCase((String)workItem.getParameter("ActorId"))) {
            workItem = workItems.get(1);
        }
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    @Ignore(value="Non interrupting escalation has not yet been implemented.")
    public void testNonInterruptingEscalationBoundaryEventOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("escalation/BPMN2-EscalationBoundaryEventOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        this.ksession.addEventListener(this.LOGGING_EVENT_LISTENER);
        ProcessInstance processInstance = this.ksession.startProcess("non-interrupting-escalation");
        List<WorkItem> workItems = handler.getWorkItems();
        EscalationEventTest.assertEquals((long)2L, (long)workItems.size());
        WorkItem johnsWork = workItems.get(0);
        WorkItem marysWork = workItems.get(1);
        if (!"john".equalsIgnoreCase((String)johnsWork.getParameter("ActorId"))) {
            marysWork = johnsWork;
            johnsWork = workItems.get(1);
        }
        this.ksession.getWorkItemManager().completeWorkItem(johnsWork.getId(), null);
        this.ksession.getWorkItemManager().completeWorkItem(marysWork.getId(), null);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testEscalationEndEventProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("escalation/BPMN2-EscalationEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("EscalationEndEvent");
        this.assertProcessInstanceAborted(processInstance.getId(), (KieSession)ksession);
    }
}

