/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.process.instance.WorkItem;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.handler.ReceiveTaskHandler;
import org.jbpm.bpmn2.handler.SendTaskHandler;
import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.bpmn2.test.RequirePersistence;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.impl.DataTransformerRegistry;
import org.jbpm.process.core.impl.ProcessImpl;
import org.jbpm.process.instance.event.listeners.RuleAwareProcessEventLister;
import org.jbpm.process.instance.event.listeners.TriggerRulesEventListener;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.DynamicUtils;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.DebugAgendaEventListener;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.DataTransformer;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.command.Context;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class ActivityTest
extends JbpmBpmn2TestCase {
    private static final Logger logger = LoggerFactory.getLogger(ActivityTest.class);
    private KieSession ksession;
    private KieSession ksession2;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public ActivityTest(boolean persistence) throws Exception {
        super(persistence);
    }

    @BeforeClass
    public static void setup() throws Exception {
        ActivityTest.setUpDataSource();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
        if (this.ksession2 != null) {
            this.ksession2.dispose();
            this.ksession2 = null;
        }
    }

    @Test
    public void testMinimalProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Minimal");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMinimalProcessImplicit() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcessImplicit.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Minimal");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMinimalProcessWithGraphical() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcessWithGraphical.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Minimal");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMinimalProcessWithDIGraphical() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcessWithDIGraphical.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Minimal");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMinimalProcessMetaData() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcessMetaData.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list1 = new ArrayList();
        final ArrayList list2 = new ArrayList();
        final ArrayList list3 = new ArrayList();
        final ArrayList list4 = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                String customTag2;
                System.out.println("before node");
                Map metaData = event.getNodeInstance().getNode().getMetaData();
                for (Map.Entry entry : metaData.entrySet()) {
                    System.out.println((String)entry.getKey() + " " + entry.getValue());
                }
                String customTag = (String)metaData.get("customTag");
                if (customTag != null) {
                    list1.add(customTag);
                }
                if ((customTag2 = (String)metaData.get("customTag2")) != null) {
                    list2.add(customTag2);
                }
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                System.out.println("after variable");
                VariableScope variableScope = (VariableScope)((ProcessImpl)event.getProcessInstance().getProcess()).resolveContext("VariableScope", (Object)event.getVariableId());
                if (variableScope == null) {
                    return;
                }
                Map metaData = variableScope.findVariable(event.getVariableId()).getMetaData();
                for (Map.Entry entry : metaData.entrySet()) {
                    System.out.println((String)entry.getKey() + " " + entry.getValue());
                }
                String customTag = (String)metaData.get("customTagVar");
                if (customTag != null) {
                    list3.add(customTag);
                }
            }

            public void afterProcessStarted(ProcessStartedEvent event) {
                System.out.println("after process");
                Map metaData = event.getProcessInstance().getProcess().getMetaData();
                for (Map.Entry entry : metaData.entrySet()) {
                    System.out.println((String)entry.getKey() + " " + entry.getValue());
                }
                String customTag = (String)metaData.get("customTagProcess");
                if (customTag != null) {
                    list4.add(customTag);
                }
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "krisv");
        ProcessInstance processInstance = this.ksession.startProcess("Minimal", params);
        this.assertProcessInstanceCompleted(processInstance);
        ActivityTest.assertEquals((long)3L, (long)list1.size());
        ActivityTest.assertEquals((long)2L, (long)list2.size());
        ActivityTest.assertEquals((long)1L, (long)list3.size());
        ActivityTest.assertEquals((long)1L, (long)list4.size());
    }

    @Test
    public void testCompositeProcessWithDIGraphical() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-CompositeProcessWithDIGraphical.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Composite");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testScriptTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ScriptTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("ScriptTask");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    @RequirePersistence
    public void testScriptTaskWithHistoryLog() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ScriptTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("ScriptTask");
        this.assertProcessInstanceCompleted(processInstance);
        JPAAuditLogService logService = new JPAAuditLogService(this.ksession.getEnvironment());
        List logs = logService.findNodeInstances(processInstance.getId());
        ActivityTest.assertNotNull((Object)logs);
        ActivityTest.assertEquals((long)6L, (long)logs.size());
        for (NodeInstanceLog log : logs) {
            ActivityTest.assertNotNull((Object)log.getDate());
        }
        ProcessInstanceLog pilog = logService.findProcessInstance(processInstance.getId());
        ActivityTest.assertNotNull((Object)pilog);
        ActivityTest.assertNotNull((Object)pilog.getEnd());
        List pilogs = logService.findActiveProcessInstances(processInstance.getProcessId());
        ActivityTest.assertNotNull((Object)pilogs);
        ActivityTest.assertEquals((long)0L, (long)pilogs.size());
        logService.dispose();
    }

    @Test
    public void testRuleTask() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-RuleTask.bpmn2", "BPMN2-RuleTask.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        this.ksession.setGlobal("list", list);
        ProcessInstance processInstance = this.ksession.startProcess("RuleTask");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.setGlobal("list", list);
        this.ksession.fireAllRules();
        ActivityTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testRuleTask2() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-RuleTask2.bpmn2", "BPMN2-RuleTask2.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        this.ksession.setGlobal("list", list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "SomeString");
        ProcessInstance processInstance = this.ksession.startProcess("RuleTask", params);
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.fireAllRules();
        ActivityTest.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    @RequirePersistence(value=true)
    public void testRuleTaskSetVariable() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-RuleTask2.bpmn2", "BPMN2-RuleTaskSetVariable.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        this.ksession.setGlobal("list", list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "SomeString");
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        ProcessInstance processInstance = this.ksession.startProcess("RuleTask", params);
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession.fireAllRules();
        ut.commit();
        ActivityTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        this.assertProcessVarValue(processInstance, "x", "AnotherString");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testRuleTaskSetVariableWithReconnect() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-RuleTask2.bpmn2", "BPMN2-RuleTaskSetVariableReconnect.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        this.ksession.setGlobal("list", list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "SomeString");
        ProcessInstance processInstance = this.ksession.startProcess("RuleTask", params);
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession.fireAllRules();
        ActivityTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        this.assertProcessVarValue(processInstance, "x", "AnotherString");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    @RequirePersistence(value=false)
    public void testRuleTaskWithFacts() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-RuleTaskWithFact.bpmn2", "BPMN2-RuleTask3.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener(new AgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
                ActivityTest.this.ksession.fireAllRules();
            }

            public void matchCancelled(MatchCancelledEvent event) {
            }

            public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            }

            public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
            }

            public void beforeMatchFired(BeforeMatchFiredEvent event) {
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event) {
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
            }

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            }

            public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
                ActivityTest.this.ksession.fireAllRules();
            }

            public void afterMatchFired(AfterMatchFiredEvent event) {
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "SomeString");
        ProcessInstance processInstance = this.ksession.startProcess("RuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        params = new HashMap();
        try {
            processInstance = this.ksession.startProcess("RuleTask", params);
            ActivityTest.fail((String)"Should fail");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        params = new HashMap();
        params.put("x", "SomeString");
        processInstance = this.ksession.startProcess("RuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    @RequirePersistence
    public void testRuleTaskWithFactsWithPersistence() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-RuleTaskWithFact.bpmn2", "BPMN2-RuleTask3.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        ((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)this.ksession).getCommandService().getContext()).getKieSession().addEventListener((AgendaEventListener)new TriggerRulesEventListener(this.ksession));
        this.ksession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "SomeString");
        ProcessInstance processInstance = this.ksession.startProcess("RuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        params = new HashMap();
        try {
            processInstance = this.ksession.startProcess("RuleTask", params);
            ActivityTest.fail((String)"Should fail");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        params = new HashMap();
        params.put("x", "SomeString");
        processInstance = this.ksession.startProcess("RuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testRuleTaskAcrossSessions() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-RuleTask.bpmn2", "BPMN2-RuleTask.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession2 = this.createKnowledgeSession(kbase);
        ArrayList list1 = new ArrayList();
        this.ksession.setGlobal("list", list1);
        ArrayList list2 = new ArrayList();
        this.ksession2.setGlobal("list", list2);
        ProcessInstance processInstance1 = this.ksession.startProcess("RuleTask");
        ProcessInstance processInstance2 = this.ksession2.startProcess("RuleTask");
        this.ksession.fireAllRules();
        this.assertProcessInstanceFinished(processInstance1, this.ksession);
        this.assertProcessInstanceActive(processInstance2);
        this.ksession2.fireAllRules();
        this.assertProcessInstanceFinished(processInstance2, this.ksession2);
    }

    @Test
    public void testUserTaskWithDataStoreScenario() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithDataStore.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.startProcess("UserProcess");
    }

    @Test
    public void testUserTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession((KieSession)ksession, true);
        org.kie.api.runtime.process.WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        ActivityTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        ksession.dispose();
    }

    @Test
    public void testUserTaskVerifyParameters() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getEnvironment().set("deploymentId", (Object)"test-deployment-id");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession((KieSession)ksession, true);
        final org.kie.api.runtime.process.WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        ActivityTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        final long pId = processInstance.getId();
        ksession.execute((Command)new GenericCommand<Void>(){

            public Void execute(Context context) {
                KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
                ProcessInstance processInstance = ksession.getProcessInstance(pId);
                Assert.assertNotNull((Object)processInstance);
                NodeInstance nodeInstance = ((WorkflowProcessInstance)processInstance).getNodeInstance(((WorkItem)workItem).getNodeInstanceId());
                Assert.assertNotNull((Object)nodeInstance);
                Assert.assertTrue((boolean)(nodeInstance instanceof WorkItemNodeInstance));
                String deploymentId = ((WorkItemNodeInstance)nodeInstance).getWorkItem().getDeploymentId();
                long nodeInstanceId = ((WorkItemNodeInstance)nodeInstance).getWorkItem().getNodeInstanceId();
                long nodeId = ((WorkItemNodeInstance)nodeInstance).getWorkItem().getNodeId();
                Assert.assertEquals((Object)((WorkItem)workItem).getDeploymentId(), (Object)deploymentId);
                Assert.assertEquals((long)((WorkItem)workItem).getNodeId(), (long)nodeId);
                Assert.assertEquals((long)((WorkItem)workItem).getNodeInstanceId(), (long)nodeInstanceId);
                return null;
            }
        });
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        ksession.dispose();
    }

    @Test
    @RequirePersistence
    public void testProcesWithHumanTaskWithTimer() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SubProcessWithTimer.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap params = new HashMap();
        ProcessInstance processInstance = ksession.startProcess("subproc", params);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), null);
        int sessionId = ksession.getId();
        Environment env = ksession.getEnvironment();
        ksession.dispose();
        Thread.sleep(3000L);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)env);
        Thread.sleep(3000L);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
    }

    @Test
    public void testCallActivityWithContantsAssignment() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("subprocess/SingleTaskWithVarDef.bpmn2", "subprocess/InputMappingUsingValue.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("CustomTask", (WorkItemHandler)handler);
        HashMap params = new HashMap();
        ProcessInstance processInstance = this.ksession.startProcess("defaultPackage.InputMappingUsingValue", params);
        org.kie.api.runtime.process.WorkItem workItem = handler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        Object value = workItem.getParameter("TaskName");
        ActivityTest.assertNotNull((Object)value);
        ActivityTest.assertEquals((Object)"test string", (Object)value);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testSubProcessWithEntryExitScripts() throws Exception {
        KieBase kbase = this.createKnowledgeBase("subprocess/BPMN2-SubProcessWithEntryExitScripts.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.bpmn.hello");
        this.assertNodeTriggered(processInstance.getId(), "Task1");
        String var1 = this.getProcessVarValue(processInstance, "var1");
        ActivityTest.assertNotNull((Object)var1);
        ActivityTest.assertEquals((Object)"10", (Object)var1.toString());
        this.assertNodeTriggered(processInstance.getId(), "Task2");
        String var2 = this.getProcessVarValue(processInstance, "var2");
        ActivityTest.assertNotNull((Object)var2);
        ActivityTest.assertEquals((Object)"20", (Object)var2.toString());
        this.assertNodeTriggered(processInstance.getId(), "Task3");
        String var3 = this.getProcessVarValue(processInstance, "var3");
        ActivityTest.assertNotNull((Object)var3);
        ActivityTest.assertEquals((Object)"30", (Object)var3.toString());
        this.assertNodeTriggered(processInstance.getId(), "SubProcess");
        String var4 = this.getProcessVarValue(processInstance, "var4");
        ActivityTest.assertNotNull((Object)var4);
        ActivityTest.assertEquals((Object)"40", (Object)var4.toString());
        String var5 = this.getProcessVarValue(processInstance, "var5");
        ActivityTest.assertNotNull((Object)var5);
        ActivityTest.assertEquals((Object)"50", (Object)var5.toString());
        org.kie.api.runtime.process.WorkItem workItem = handler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testCallActivity() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-CallActivity.bpmn2", "BPMN2-CallActivitySubProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        ProcessInstance processInstance = this.ksession.startProcess("ParentProcess", params);
        this.assertProcessInstanceCompleted(processInstance);
        ActivityTest.assertEquals((Object)"new value", (Object)((WorkflowProcessInstance)processInstance).getVariable("y"));
    }

    @Test
    public void testCallActivity2() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-CallActivity2.bpmn2", "BPMN2-CallActivitySubProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        ProcessInstance processInstance = this.ksession.startProcess("ParentProcess", params);
        this.assertProcessInstanceActive(processInstance);
        ActivityTest.assertEquals((Object)"new value", (Object)((WorkflowProcessInstance)processInstance).getVariable("y"));
        this.ksession = this.restoreSession(this.ksession, true);
        org.kie.api.runtime.process.WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        ActivityTest.assertEquals((Object)"krisv", (Object)workItem.getParameter("ActorId"));
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testCallActivityByName() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-CallActivityByName.bpmn2", "BPMN2-CallActivitySubProcess.bpmn2", "BPMN2-CallActivitySubProcessV2.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        ProcessInstance processInstance = this.ksession.startProcess("ParentProcess", params);
        this.assertProcessInstanceCompleted(processInstance);
        ActivityTest.assertEquals((Object)"new value V2", (Object)((WorkflowProcessInstance)processInstance).getVariable("y"));
    }

    @Test
    @RequirePersistence
    public void testCallActivityWithHistoryLog() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-CallActivity.bpmn2", "BPMN2-CallActivitySubProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        ProcessInstance processInstance = this.ksession.startProcess("ParentProcess", params);
        this.assertProcessInstanceCompleted(processInstance);
        ActivityTest.assertEquals((Object)"new value", (Object)((WorkflowProcessInstance)processInstance).getVariable("y"));
        JPAAuditLogService logService = new JPAAuditLogService(this.ksession.getEnvironment());
        List subprocesses = logService.findSubProcessInstances(processInstance.getId());
        ActivityTest.assertNotNull((Object)subprocesses);
        ActivityTest.assertEquals((long)1L, (long)subprocesses.size());
        logService.dispose();
    }

    @Test
    @RequirePersistence
    public void testCallActivityWithTimer() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ParentProcess.bpmn2", "BPMN2-SubProcessWithTimer.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap params = new HashMap();
        ProcessInstance processInstance = this.ksession.startProcess("ParentProcess", params);
        this.ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), null);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("sleep", "2s");
        this.ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), res);
        int sessionId = this.ksession.getId();
        Environment env = this.ksession.getEnvironment();
        logger.info("dispose");
        this.ksession.dispose();
        Thread.sleep(3000L);
        this.ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)env);
        Thread.sleep(3000L);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testSubProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SubProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                logger.debug(event.toString());
            }

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                logger.debug(event.toString());
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                logger.debug(event.toString());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("SubProcess");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testSubProcessWithTerminateEndEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SubProcessWithTerminateEndEvent.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                list.add(event.getNodeInstance().getNodeName());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("SubProcessTerminate");
        this.assertProcessInstanceCompleted(processInstance);
        ActivityTest.assertEquals((long)7L, (long)list.size());
    }

    @Test
    public void testSubProcessWithTerminateEndEventProcessScope() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SubProcessWithTerminateEndEventProcessScope.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                list.add(event.getNodeInstance().getNodeName());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("SubProcessTerminate");
        this.assertProcessInstanceCompleted(processInstance);
        ActivityTest.assertEquals((long)5L, (long)list.size());
    }

    @Test
    public void testAdHocSubProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-AdHocSubProcess.bpmn2", "BPMN2-AdHocSubProcess.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("AdHocSubProcess");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        org.kie.api.runtime.process.WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNull((Object)workItem);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.fireAllRules();
        logger.debug("Signaling Hello2");
        this.ksession.signalEvent("Hello2", null, processInstance.getId());
        workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
    }

    @Test
    public void testAdHocSubProcessAutoComplete() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-AdHocSubProcessAutoComplete.bpmn2", "BPMN2-AdHocSubProcess.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("AdHocSubProcess");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        org.kie.api.runtime.process.WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNull((Object)workItem);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.fireAllRules();
        workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testAdHocSubProcessAutoCompleteDynamicTask() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-AdHocSubProcessAutoComplete.bpmn2", "BPMN2-AdHocSubProcess.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        TestWorkItemHandler workItemHandler2 = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("OtherTask", (WorkItemHandler)workItemHandler2);
        ProcessInstance processInstance = this.ksession.startProcess("AdHocSubProcess");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        DynamicNodeInstance dynamicContext = (DynamicNodeInstance)((WorkflowProcessInstance)processInstance).getNodeInstances().iterator().next();
        DynamicUtils.addDynamicWorkItem((DynamicNodeInstance)dynamicContext, (KieRuntime)this.ksession, (String)"OtherTask", new HashMap());
        org.kie.api.runtime.process.WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNull((Object)workItem);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.fireAllRules();
        workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceActive(processInstance);
        workItem = workItemHandler2.getWorkItem();
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.ksession.dispose();
    }

    @Test
    public void testAdHocSubProcessAutoCompleteDynamicSubProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-AdHocSubProcessAutoComplete.bpmn2", "BPMN2-AdHocSubProcess.drl", "BPMN2-MinimalProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        TestWorkItemHandler workItemHandler2 = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("OtherTask", (WorkItemHandler)workItemHandler2);
        ProcessInstance processInstance = this.ksession.startProcess("AdHocSubProcess");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession.fireAllRules();
        DynamicNodeInstance dynamicContext = (DynamicNodeInstance)((WorkflowProcessInstance)processInstance).getNodeInstances().iterator().next();
        DynamicUtils.addDynamicSubProcess((DynamicNodeInstance)dynamicContext, (KieRuntime)this.ksession, (String)"Minimal", new HashMap());
        this.ksession = this.restoreSession(this.ksession, true);
        org.kie.api.runtime.process.WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testAdHocSubProcessAutoCompleteDynamicSubProcess2() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-AdHocSubProcessAutoComplete.bpmn2", "BPMN2-AdHocSubProcess.drl", "BPMN2-ServiceProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        TestWorkItemHandler workItemHandler2 = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)workItemHandler2);
        ProcessInstance processInstance = this.ksession.startProcess("AdHocSubProcess");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession.fireAllRules();
        DynamicNodeInstance dynamicContext = (DynamicNodeInstance)((WorkflowProcessInstance)processInstance).getNodeInstances().iterator().next();
        DynamicUtils.addDynamicSubProcess((DynamicNodeInstance)dynamicContext, (KieRuntime)this.ksession, (String)"ServiceProcess", new HashMap());
        this.ksession = this.restoreSession(this.ksession, true);
        org.kie.api.runtime.process.WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceActive(processInstance);
        workItem = workItemHandler2.getWorkItem();
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testAdHocProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-AdHocProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("AdHocProcess");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        logger.debug("Triggering node");
        this.ksession.signalEvent("Task1", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        this.ksession.signalEvent("User1", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        this.ksession.insert((Object)new Person());
        this.ksession.signalEvent("Task3", null, processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testAdHocProcessDynamicTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-AdHocProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("AdHocProcess");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        logger.debug("Triggering node");
        this.ksession.signalEvent("Task1", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        TestWorkItemHandler workItemHandler2 = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("OtherTask", (WorkItemHandler)workItemHandler2);
        DynamicUtils.addDynamicWorkItem((ProcessInstance)processInstance, (KieRuntime)this.ksession, (String)"OtherTask", new HashMap());
        org.kie.api.runtime.process.WorkItem workItem = workItemHandler2.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.ksession.signalEvent("User1", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        this.ksession.insert((Object)new Person());
        this.ksession.signalEvent("Task3", null, processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testAdHocProcessDynamicSubProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-AdHocProcess.bpmn2", "BPMN2-MinimalProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("AdHocProcess");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        logger.debug("Triggering node");
        this.ksession.signalEvent("Task1", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        TestWorkItemHandler workItemHandler2 = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("OtherTask", (WorkItemHandler)workItemHandler2);
        DynamicUtils.addDynamicSubProcess((ProcessInstance)processInstance, (KieRuntime)this.ksession, (String)"Minimal", new HashMap());
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("User1", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        this.ksession.insert((Object)new Person());
        this.ksession.signalEvent("Task3", null, processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testServiceTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ServiceProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.startProcess("ServiceProcess", params);
        this.assertProcessInstanceFinished((ProcessInstance)processInstance, this.ksession);
        ActivityTest.assertEquals((Object)"Hello john!", (Object)processInstance.getVariable("s"));
    }

    @Test
    public void testServiceTaskWithTransformation() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-ServiceProcessWithTransformation.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "JoHn");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.startProcess("ServiceProcess", params);
        this.assertProcessInstanceFinished((ProcessInstance)processInstance, this.ksession);
        ActivityTest.assertEquals((Object)"hello john!", (Object)processInstance.getVariable("s"));
    }

    @Test
    public void testServiceTaskWithMvelTransformation() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-ServiceProcessWithMvelTransformation.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "JoHn");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.startProcess("ServiceProcess", params);
        this.assertProcessInstanceFinished((ProcessInstance)processInstance, this.ksession);
        ActivityTest.assertEquals((Object)"hello john!", (Object)processInstance.getVariable("s"));
    }

    @Test
    public void testServiceTaskWithCustomTransformation() throws Exception {
        DataTransformerRegistry.get().register("http://custom/transformer", new DataTransformer(){

            public Object transform(Object expression, Map<String, Object> parameters) {
                String value = parameters.values().iterator().next().toString();
                String result = null;
                if ("caplitalizeFirst".equals(expression)) {
                    String first = value.substring(0, 1);
                    String main = value.substring(1, value.length());
                    result = first.toUpperCase() + main;
                } else if ("caplitalizeLast".equals(expression)) {
                    String last = value.substring(value.length() - 1);
                    String main = value.substring(0, value.length() - 1);
                    result = main + last.toUpperCase();
                } else {
                    throw new IllegalArgumentException("Unknown expression " + expression);
                }
                return result;
            }

            public Object compile(String expression) {
                return expression;
            }
        });
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-ServiceProcessWithCustomTransformation.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john doe");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.startProcess("ServiceProcess", params);
        this.assertProcessInstanceFinished((ProcessInstance)processInstance, this.ksession);
        ActivityTest.assertEquals((Object)"John doE", (Object)processInstance.getVariable("s"));
    }

    @Test
    public void testServiceTaskNoInterfaceName() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ServiceTask-web-service.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new SystemOutWorkItemHandler(){

            public void executeWorkItem(org.kie.api.runtime.process.WorkItem workItem, WorkItemManager manager) {
                Assert.assertEquals((Object)"SimpleService", (Object)workItem.getParameter("Interface"));
                Assert.assertEquals((Object)"hello", (Object)workItem.getParameter("Operation"));
                Assert.assertEquals((Object)"java.lang.String", (Object)workItem.getParameter("ParameterType"));
                Assert.assertEquals((Object)"##WebService", (Object)workItem.getParameter("implementation"));
                Assert.assertEquals((Object)"hello", (Object)workItem.getParameter("operationImplementationRef"));
                Assert.assertEquals((Object)"SimpleService", (Object)workItem.getParameter("interfaceImplementationRef"));
                super.executeWorkItem(workItem, manager);
            }
        });
        HashMap params = new HashMap();
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.startProcess("org.jboss.qa.jbpm.CallWS", params);
        this.assertProcessInstanceFinished((ProcessInstance)processInstance, this.ksession);
    }

    @Test
    public void testSendTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SendTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.startProcess("SendTask", params);
        this.assertProcessInstanceFinished((ProcessInstance)processInstance, this.ksession);
    }

    @Test
    public void testReceiveTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ReceiveTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ReceiveTaskHandler receiveTaskHandler = new ReceiveTaskHandler(this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.startProcess("ReceiveTask");
        this.assertProcessInstanceActive((ProcessInstance)processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        receiveTaskHandler.setKnowledgeRuntime(this.ksession);
        receiveTaskHandler.messageReceived("HelloMessage", (Object)"Hello john!");
        this.assertProcessInstanceFinished((ProcessInstance)processInstance, this.ksession);
    }

    @Test
    @RequirePersistence(value=false)
    public void testBusinessRuleTask() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-BusinessRuleTask.bpmn2", "BPMN2-BusinessRuleTask.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventLister());
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-BusinessRuleTask");
        int fired = this.ksession.fireAllRules();
        ActivityTest.assertEquals((long)1L, (long)fired);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    @RequirePersistence(value=true)
    public void testBusinessRuleTaskWithPersistence() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-BusinessRuleTask.bpmn2", "BPMN2-BusinessRuleTask.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventLister());
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-BusinessRuleTask");
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventLister());
        int fired = this.ksession.fireAllRules();
        ActivityTest.assertEquals((long)1L, (long)fired);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testBusinessRuleTaskDynamic() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-BusinessRuleTaskDynamic.bpmn2", "BPMN2-BusinessRuleTask.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventLister());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dynamicrule", "MyRuleFlow");
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-BusinessRuleTask", params);
        int fired = this.ksession.fireAllRules();
        ActivityTest.assertEquals((long)1L, (long)fired);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testBusinessRuleTaskWithDataInputsWithPersistence() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-BusinessRuleTaskWithDataInputs.bpmn2", "BPMN2-BusinessRuleTaskWithDataInput.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Person> params = new HashMap<String, Person>();
        params.put("person", new Person());
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-BusinessRuleTask", params);
        int fired = this.ksession.fireAllRules();
        ActivityTest.assertEquals((long)1L, (long)fired);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testBusinessRuleTaskWithDataInputs2WithPersistence() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-BusinessRuleTaskWithDataInput.bpmn2", "BPMN2-BusinessRuleTaskWithDataInput.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Person> params = new HashMap<String, Person>();
        params.put("person", new Person());
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-BusinessRuleTask", params);
        int fired = this.ksession.fireAllRules();
        ActivityTest.assertEquals((long)1L, (long)fired);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testBusinessRuleTaskWithContionalEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-ConditionalEventRuleTask.bpmn2", "BPMN2-ConditionalEventRuleTask.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        this.ksession.setGlobal("list", list);
        ProcessInstance processInstance = this.ksession.startProcess("TestFlow");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Person person = new Person();
        person.setName("john");
        this.ksession.insert((Object)person);
        this.ksession.fireAllRules();
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
        ActivityTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testNullVariableInScriptTaskProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-NullVariableInScriptTaskProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("nullVariableInScriptAfterTimer");
        this.assertProcessInstanceActive(processInstance);
        long sleep = 1000L;
        logger.debug("Sleeping {} seconds", (Object)(sleep / 1000L));
        Thread.sleep(sleep);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testScriptTaskWithVariableByName() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("myVar", "test");
        KieBase kbase = this.createKnowledgeBase("BPMN2-ProcessWithVariableName.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-ProcessWithVariableName", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testCallActivityWithBoundaryEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-CallActivityWithBoundaryEvent.bpmn2", "BPMN2-CallActivitySubProcessWithBoundaryEvent.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        ProcessInstance processInstance = this.ksession.startProcess("ParentProcess", params);
        Thread.sleep(3000L);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "CallActivity", "Boundary event", "Script Task", "end");
        this.assertNodeTriggered(processInstance.getId() + 1L, "StartProcess2", "User Task");
    }

    @Test
    public void testUserTaskWithBooleanOutput() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithBooleanOutput.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.boolean");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        org.kie.api.runtime.process.WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        ActivityTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        HashMap<String, String> output = new HashMap<String, String>();
        output.put("isCheckedCheckbox", "true");
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), output);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testUserTaskWithSimData() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTaskWithSimulationMetaData.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("UserTask");
        ActivityTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession = this.restoreSession(this.ksession, true);
        org.kie.api.runtime.process.WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        ActivityTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testCallActivityWithBoundaryErrorEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-CallActivityProcessBoundaryError.bpmn2", "BPMN2-CallActivitySubProcessBoundaryError.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("task1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("ParentProcess");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "Call Activity 1", "Boundary event", "Task Parent", "End2");
        this.assertNodeTriggered(processInstance.getId() + 1L, "StartProcess", "Task 1", "End");
    }

    @Test
    public void testCallActivityWithBoundaryErrorEventWithWaitState() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-CallActivityProcessBoundaryError.bpmn2", "BPMN2-CallActivitySubProcessBoundaryError.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("task1", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("ParentProcess");
        org.kie.api.runtime.process.WorkItem workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = workItemHandler.getWorkItem();
        ActivityTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "Call Activity 1", "Boundary event", "Task Parent", "End2");
        this.assertNodeTriggered(processInstance.getId() + 1L, "StartProcess", "Task 1", "End");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidServiceTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InvalidServiceProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
    }

    @Test
    public void testServiceTaskInterface() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ServiceTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap params = new HashMap();
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.startProcess("EAID_DP000000_23D3_4e7e_80FE_6D8C0AF83CAA", params);
        this.assertProcessInstanceFinished((ProcessInstance)processInstance, this.ksession);
    }
}

