/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.persistence;

import java.util.ArrayList;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.process.audit.AuditLoggerFactory;
import org.jbpm.process.instance.event.listeners.TriggerRulesEventListener;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerCycleOnBinaryPackageTest
extends JbpmBpmn2TestCase {
    private static final Logger logger = LoggerFactory.getLogger(TimerCycleOnBinaryPackageTest.class);
    private StatefulKnowledgeSession ksession;

    public TimerCycleOnBinaryPackageTest() {
        super(true);
    }

    @BeforeClass
    public static void setup() throws Exception {
        TimerCycleOnBinaryPackageTest.setUpDataSource();
    }

    @Before
    public void prepare() {
        this.clearHistory();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    @Test
    public void testStartTimerCycleFromDisc() throws Exception {
        KieBase kbase = this.createKnowledgeBaseFromDisc("BPMN2-StartTimerCycle.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TimerCycleOnBinaryPackageTest.assertEquals((long)0L, (long)this.getNumberOfProcessInstances("defaultPackage.TimerProcess"));
        int sessionId = ksession.getId();
        Environment env = ksession.getEnvironment();
        final ArrayList list = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        ((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession().addEventListener((AgendaEventListener)new TriggerRulesEventListener((KieSession)ksession));
        Thread.sleep(5000L);
        TimerCycleOnBinaryPackageTest.assertEquals((long)2L, (long)this.getNumberOfProcessInstances("defaultPackage.TimerProcess"));
        logger.info("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)env);
        AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)ksession, null);
        final ArrayList list2 = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list2.add(event.getProcessInstance().getId());
            }
        });
        ((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession().addEventListener((AgendaEventListener)new TriggerRulesEventListener((KieSession)ksession));
        Thread.sleep(5000L);
        ksession.dispose();
        TimerCycleOnBinaryPackageTest.assertEquals((long)4L, (long)this.getNumberOfProcessInstances("defaultPackage.TimerProcess"));
    }

    @Test
    public void testStartTimerCycleFromClassPath() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-StartTimerCycle.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TimerCycleOnBinaryPackageTest.assertEquals((long)0L, (long)this.getNumberOfProcessInstances("defaultPackage.TimerProcess"));
        int sessionId = ksession.getId();
        Environment env = ksession.getEnvironment();
        final ArrayList list = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        ((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession().addEventListener((AgendaEventListener)new TriggerRulesEventListener((KieSession)ksession));
        Thread.sleep(5000L);
        TimerCycleOnBinaryPackageTest.assertEquals((long)2L, (long)this.getNumberOfProcessInstances("defaultPackage.TimerProcess"));
        logger.info("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)env);
        AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)ksession, null);
        final ArrayList list2 = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list2.add(event.getProcessInstance().getId());
            }
        });
        ((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession().addEventListener((AgendaEventListener)new TriggerRulesEventListener((KieSession)ksession));
        Thread.sleep(5000L);
        ksession.dispose();
        TimerCycleOnBinaryPackageTest.assertEquals((long)4L, (long)this.getNumberOfProcessInstances("defaultPackage.TimerProcess"));
    }

    @Test
    @Ignore(value="beta4 phreak")
    public void testStartTimerCycleFromDiscDRL() throws Exception {
        KieBase kbase = this.createKnowledgeBaseFromDisc("rules-timer.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        int sessionId = ksession.getId();
        Environment env = ksession.getEnvironment();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession().addEventListener((AgendaEventListener)new TriggerRulesEventListener((KieSession)ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        TimerCycleOnBinaryPackageTest.assertEquals((long)2L, (long)list.size());
        logger.info("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)env);
        AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)ksession, null);
        ArrayList list2 = new ArrayList();
        ksession.setGlobal("list", list2);
        ((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession().addEventListener((AgendaEventListener)new TriggerRulesEventListener((KieSession)ksession));
        ksession.fireAllRules();
        Thread.sleep(6000L);
        TimerCycleOnBinaryPackageTest.assertEquals((long)3L, (long)list2.size());
    }

    @Test
    @Ignore(value="beta4 phreak")
    public void testStartTimerCycleFromClasspathDRL() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("rules-timer.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        int sessionId = ksession.getId();
        Environment env = ksession.getEnvironment();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession().addEventListener((AgendaEventListener)new TriggerRulesEventListener((KieSession)ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        TimerCycleOnBinaryPackageTest.assertEquals((long)2L, (long)list.size());
        logger.info("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)env);
        AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)ksession, null);
        ArrayList list2 = new ArrayList();
        ksession.setGlobal("list", list2);
        ((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession().addEventListener((AgendaEventListener)new TriggerRulesEventListener((KieSession)ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        TimerCycleOnBinaryPackageTest.assertEquals((long)3L, (long)list2.size());
    }
}

