/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.persistence;

import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.compiler.xml.XmlRuleFlowProcessDumper;
import org.jbpm.persistence.session.objects.TestWorkItemHandler;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.command.Context;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicProcessTest
extends JbpmBpmn2TestCase {
    private static final Logger logger = LoggerFactory.getLogger(DynamicProcessTest.class);

    @BeforeClass
    public static void setup() throws Exception {
        if (PERSISTENCE) {
            DynamicProcessTest.setUpDataSource();
        }
    }

    @Test
    public void testDynamicProcess() throws Exception {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.HelloWorld");
        factory.name("HelloWorldProcess").version("1.0").packageName("org.jbpm").startNode(1L).name("Start").done().humanTaskNode(2L).name("Task1").actorId("krisv").taskName("MyTask").done().endNode(3L).name("End").done().connection(1L, 2L).connection(2L, 3L);
        final RuleFlowProcess process = factory.validate().getProcess();
        Resource resource = ResourceFactory.newByteArrayResource((byte[])XmlRuleFlowProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        resource.setSourcePath("/tmp/dynamicProcess.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(resource);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)testHandler);
        ksession.addEventListener(new ProcessEventListener(){

            public void beforeVariableChanged(ProcessVariableChangedEvent arg0) {
            }

            public void beforeProcessStarted(ProcessStartedEvent arg0) {
                logger.info("{}", (Object)arg0);
            }

            public void beforeProcessCompleted(ProcessCompletedEvent arg0) {
                logger.info("{}", (Object)arg0);
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent arg0) {
                logger.info("{}", (Object)arg0);
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent arg0) {
                logger.info("{}", (Object)arg0);
            }

            public void afterVariableChanged(ProcessVariableChangedEvent arg0) {
            }

            public void afterProcessStarted(ProcessStartedEvent arg0) {
            }

            public void afterProcessCompleted(ProcessCompletedEvent arg0) {
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent arg0) {
            }

            public void afterNodeLeft(ProcessNodeLeftEvent arg0) {
            }
        });
        final ProcessInstanceImpl processInstance = (ProcessInstanceImpl)ksession.startProcess("org.jbpm.HelloWorld");
        HumanTaskNode node = new HumanTaskNode();
        node.setName("Task2");
        node.setId(4L);
        DynamicProcessTest.insertNodeInBetween(process, 2L, 3L, (NodeImpl)node);
        ((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().execute((Command)new GenericCommand<Void>(){

            public Void execute(Context context) {
                StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)((KnowledgeCommandContext)context).getKieSession();
                ((ProcessInstanceImpl)ksession.getProcessInstance(processInstance.getId())).updateProcess((Process)process);
                return null;
            }
        });
        this.assertProcessInstanceActive((ProcessInstance)processInstance);
        ksession.getWorkItemManager().completeWorkItem(testHandler.getWorkItem().getId(), null);
        this.assertProcessInstanceActive((ProcessInstance)processInstance);
        ksession.getWorkItemManager().completeWorkItem(testHandler.getWorkItem().getId(), null);
        this.assertProcessInstanceFinished((ProcessInstance)processInstance, (KieSession)ksession);
        ksession.dispose();
    }

    private static void insertNodeInBetween(RuleFlowProcess process, long startNodeId, long endNodeId, NodeImpl node) {
        if (process == null) {
            throw new IllegalArgumentException("Process may not be null");
        }
        NodeImpl selectedNode = (NodeImpl)process.getNode(startNodeId);
        if (selectedNode == null) {
            throw new IllegalArgumentException("Node " + startNodeId + " not found in process " + process.getId());
        }
        for (Connection connection : selectedNode.getDefaultOutgoingConnections()) {
            if (connection.getTo().getId() != endNodeId) continue;
            process.addNode((Node)node);
            NodeImpl endNode = (NodeImpl)connection.getTo();
            ((ConnectionImpl)connection).terminate();
            new ConnectionImpl((Node)selectedNode, "DROOLS_DEFAULT", (Node)node, "DROOLS_DEFAULT");
            new ConnectionImpl((Node)node, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
            return;
        }
        throw new IllegalArgumentException("Connection to node " + endNodeId + " not found in process " + process.getId());
    }
}

