/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.handler.SendTaskHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class EndEventTest
extends JbpmBpmn2TestCase {
    private Logger logger = LoggerFactory.getLogger(EndEventTest.class);
    private StatefulKnowledgeSession ksession;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public EndEventTest(boolean persistence) {
        super(persistence);
    }

    @BeforeClass
    public static void setup() throws Exception {
        EndEventTest.setUpDataSource();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testImplicitEndParallel() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ParallelSplit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testErrorEndEventProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ErrorEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("ErrorEndEvent");
        this.assertProcessInstanceAborted(processInstance);
        EndEventTest.assertEquals((Object)"error", (Object)((org.jbpm.process.instance.ProcessInstance)processInstance).getOutcome());
    }

    @Test
    public void testEscalationEndEventProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("escalation/BPMN2-EscalationEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("EscalationEndEvent");
        this.assertProcessInstanceAborted(processInstance);
    }

    @Test
    public void testSignalEnd() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SignalEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ksession.startProcess("SignalEndEvent", params);
    }

    @Test
    public void testMessageEnd() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MessageEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = ksession.startProcess("MessageEndEvent", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testOnEntryExitScript() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-OnEntryExitScriptProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new SystemOutWorkItemHandler());
        ArrayList myList = new ArrayList();
        ksession.setGlobal("list", myList);
        ProcessInstance processInstance = ksession.startProcess("OnEntryExitScriptProcess");
        this.assertProcessInstanceCompleted(processInstance);
        EndEventTest.assertEquals((long)4L, (long)myList.size());
    }

    @Test
    public void testOnEntryExitNamespacedScript() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-OnEntryExitNamespacedScriptProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new SystemOutWorkItemHandler());
        ArrayList myList = new ArrayList();
        ksession.setGlobal("list", myList);
        ProcessInstance processInstance = ksession.startProcess("OnEntryExitScriptProcess");
        this.assertProcessInstanceCompleted(processInstance);
        EndEventTest.assertEquals((long)4L, (long)myList.size());
    }

    @Test
    public void testOnEntryExitMixedNamespacedScript() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-OnEntryExitMixedNamespacedScriptProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new SystemOutWorkItemHandler());
        ArrayList myList = new ArrayList();
        ksession.setGlobal("list", myList);
        ProcessInstance processInstance = ksession.startProcess("OnEntryExitScriptProcess");
        this.assertProcessInstanceCompleted(processInstance);
        EndEventTest.assertEquals((long)4L, (long)myList.size());
    }

    @Test
    public void testOnEntryExitScriptDesigner() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-OnEntryExitDesignerScriptProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new SystemOutWorkItemHandler());
        ArrayList myList = new ArrayList();
        ksession.setGlobal("list", myList);
        ProcessInstance processInstance = ksession.startProcess("OnEntryExitScriptProcess");
        this.assertProcessInstanceCompleted(processInstance);
        EndEventTest.assertEquals((long)4L, (long)myList.size());
    }

    @Test
    public void testTerminateWithinSubprocessEnd() throws Exception {
        KieBase kbase = this.createKnowledgeBase("subprocess/BPMN2-SubprocessWithParallelSpitTerminate.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("BPMN2-SubprocessWithParallelSpitTerminate");
        ksession.signalEvent("signal1", null, processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testTerminateEnd() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ParallelSpitTerminate.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("BPMN2-ParallelSpitTerminate");
        ksession.signalEvent("Signal 1", null, processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance);
    }
}

