/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.drools.core.util.IoUtils;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.NotAvailableGoodsReport;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieRepository;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class StartEventTest
extends JbpmBpmn2TestCase {
    private static final Integer EXTRA_SLEEP_TIME = 250;
    private static final Logger logger = LoggerFactory.getLogger(StartEventTest.class);
    private KieSession ksession;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public StartEventTest(boolean persistence) {
        super(persistence);
    }

    @BeforeClass
    public static void setup() throws Exception {
        StartEventTest.setUpDataSource();
    }

    @Before
    public void prepare() {
        this.clearHistory();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testConditionalStart() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-ConditionalStart.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        Person person = new Person();
        person.setName("jack");
        this.ksession.insert((Object)person);
        person = new Person();
        person.setName("john");
        this.ksession.insert((Object)person);
    }

    @Test
    public void testTimerStartCycleLegacy() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerStartCycleLegacy.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        System.out.println("About to start ###### " + new Date());
        Thread.sleep(1800L);
        StartEventTest.assertEquals((long)0L, (long)list.size());
        Thread.sleep(2500L);
        this.ksession.dispose();
        StartEventTest.assertEquals((long)5L, (long)this.getNumberOfProcessInstances("Minimal"));
    }

    @Test
    public void testTimerStart() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerStart.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        StartEventTest.assertEquals((long)0L, (long)list.size());
        Thread.sleep(2500 + EXTRA_SLEEP_TIME);
        StartEventTest.assertEquals((long)5L, (long)this.getNumberOfProcessInstances("Minimal"));
    }

    @Test
    public void testTimerStartDateISO() throws Exception {
        byte[] content = IoUtils.readBytesFromInputStream((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/BPMN2-TimerStartDate.bpmn2"));
        String processContent = new String(content, "UTF-8");
        DateTime now = new DateTime(System.currentTimeMillis());
        now = now.plus(2000L);
        processContent = processContent.replaceFirst("#\\{date\\}", now.toString());
        Resource resource = ResourceFactory.newReaderResource((Reader)new StringReader(processContent));
        resource.setSourcePath("/BPMN2-TimerStartDate.bpmn2");
        resource.setTargetPath("/BPMN2-TimerStartDate.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(resource);
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        StartEventTest.assertEquals((long)0L, (long)list.size());
        Thread.sleep(3000L);
        StartEventTest.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testTimerStartCycleISO() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerStartISO.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        StartEventTest.assertEquals((long)0L, (long)list.size());
        Thread.sleep(6000 + EXTRA_SLEEP_TIME);
        StartEventTest.assertEquals((long)6L, (long)this.getNumberOfProcessInstances("Minimal"));
    }

    @Test
    public void testTimerStartDuration() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerStartDuration.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        Thread.sleep(250L);
        StartEventTest.assertEquals((long)0L, (long)list.size());
        Thread.sleep(3000L);
        StartEventTest.assertEquals((long)1L, (long)this.getNumberOfProcessInstances("Minimal"));
    }

    @Test
    public void testTimerStartCron() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerStartCron.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        Thread.sleep(5000L);
        StartEventTest.assertEquals((long)5L, (long)this.getNumberOfProcessInstances("Minimal"));
    }

    @Test
    public void testSignalToStartProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SignalStart.bpmn2", "BPMN2-IntermediateThrowEventSignal.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        final ArrayList startedProcesses = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                startedProcesses.add(event.getProcessInstance().getProcessId());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("SignalIntermediateEvent");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        StartEventTest.assertEquals((long)1L, (long)this.getNumberOfProcessInstances("Minimal"));
        StartEventTest.assertEquals((long)1L, (long)this.getNumberOfProcessInstances("SignalIntermediateEvent"));
    }

    @Test
    public void testSignalStart() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SignalStart.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        this.ksession.signalEvent("MySignal", (Object)"NewValue");
        Thread.sleep(500L);
        StartEventTest.assertEquals((long)1L, (long)this.getNumberOfProcessInstances("Minimal"));
    }

    @Test
    public void testSignalStartDynamic() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SignalStart.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        KieContainer kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        kContainer.getKieBase();
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                logger.info("{}", (Object)event.getProcessInstance().getId());
                list.add(event.getProcessInstance().getId());
            }
        });
        this.ksession.signalEvent("MySignal", (Object)"NewValue");
        Thread.sleep(500L);
        StartEventTest.assertEquals((long)1L, (long)this.getNumberOfProcessInstances("Minimal"));
        kbase.removeProcess("Minimal");
        this.ksession.signalEvent("MySignal", (Object)"NewValue");
        Thread.sleep(500L);
        StartEventTest.assertEquals((long)1L, (long)this.getNumberOfProcessInstances("Minimal"));
    }

    @Test
    public void testMessageStart() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MessageStart.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.signalEvent("Message-HelloMessage", (Object)"NewValue");
        StartEventTest.assertEquals((long)1L, (long)this.getNumberOfProcessInstances("Minimal"));
    }

    @Test
    public void testMultipleStartEventsRegularStart() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleStartEventProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("MultipleStartEvents");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        WorkItem workItem = workItemHandler.getWorkItem();
        StartEventTest.assertNotNull((Object)workItem);
        StartEventTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testMultipleStartEventsStartOnTimer() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleStartEventProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        StartEventTest.assertEquals((long)0L, (long)list.size());
        Thread.sleep(2500 + EXTRA_SLEEP_TIME);
        StartEventTest.assertEquals((long)5L, (long)this.getNumberOfProcessInstances("MultipleStartEvents"));
    }

    @Test
    public void testMultipleEventBasedStartEventsSignalStart() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleEventBasedStartEventProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        this.ksession.signalEvent("startSignal", null);
        StartEventTest.assertEquals((long)1L, (long)list.size());
        WorkItem workItem = workItemHandler.getWorkItem();
        long processInstanceId = ((WorkItemImpl)workItem).getProcessInstanceId();
        ProcessInstance processInstance = this.ksession.getProcessInstance(processInstanceId);
        this.ksession = this.restoreSession(this.ksession, true);
        StartEventTest.assertNotNull((Object)workItem);
        StartEventTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testMultipleEventBasedStartEventsDifferentPaths() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleStartEventProcessDifferentPaths.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        this.ksession.startProcess("muliplestartevents", null);
        StartEventTest.assertEquals((long)1L, (long)list.size());
        WorkItem workItem = workItemHandler.getWorkItem();
        long processInstanceId = ((WorkItemImpl)workItem).getProcessInstanceId();
        ProcessInstance processInstance = this.ksession.getProcessInstance(processInstanceId);
        this.ksession = this.restoreSession(this.ksession, true);
        StartEventTest.assertNotNull((Object)workItem);
        StartEventTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstanceId, "Start", "Script 1", "User task", "End");
    }

    @Test
    public void testMultipleEventBasedStartEventsTimerDifferentPaths() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleStartEventProcessDifferentPaths.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        StartEventTest.assertEquals((long)0L, (long)list.size());
        Thread.sleep(2000 + EXTRA_SLEEP_TIME);
        StartEventTest.assertEquals((long)2L, (long)list.size());
        List<WorkItem> workItems = workItemHandler.getWorkItems();
        for (WorkItem workItem : workItems) {
            long processInstanceId = ((WorkItemImpl)workItem).getProcessInstanceId();
            ProcessInstance processInstance = this.ksession.getProcessInstance(processInstanceId);
            this.ksession = this.restoreSession(this.ksession, true);
            StartEventTest.assertNotNull((Object)workItem);
            StartEventTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
            this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
            this.assertProcessInstanceFinished(processInstance, this.ksession);
            this.assertNodeTriggered(processInstanceId, "StartTimer", "Script 2", "User task", "End");
        }
    }

    @Test
    public void testMultipleEventBasedStartEventsSignalDifferentPaths() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleStartEventProcessDifferentPaths.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        this.ksession.signalEvent("startSignal", null);
        StartEventTest.assertEquals((long)1L, (long)list.size());
        WorkItem workItem = workItemHandler.getWorkItem();
        long processInstanceId = ((WorkItemImpl)workItem).getProcessInstanceId();
        ProcessInstance processInstance = this.ksession.getProcessInstance(processInstanceId);
        this.ksession = this.restoreSession(this.ksession, true);
        StartEventTest.assertNotNull((Object)workItem);
        StartEventTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstanceId, "StartSignal", "Script 3", "User task", "End");
    }

    @Test
    public void testMultipleEventBasedStartEventsStartOnTimer() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleEventBasedStartEventProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        StartEventTest.assertEquals((long)0L, (long)list.size());
        Thread.sleep(2500 + EXTRA_SLEEP_TIME);
        StartEventTest.assertEquals((long)5L, (long)this.getNumberOfProcessInstances("MultipleStartEvents"));
    }

    @Test
    public void testTimerCycle() throws Exception {
        KieBase kbase = this.createKnowledgeBase("timer/BPMN2-StartTimerCycle.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        StartCountingListener listener = new StartCountingListener();
        this.ksession.addEventListener((ProcessEventListener)listener);
        for (int i = 1; i < 10; ++i) {
            Thread.sleep(1100L);
            StartEventTest.assertEquals((long)i, (long)listener.getCount("start.cycle"));
        }
    }

    @Test
    public void testSignalStartWithTransformation() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-SignalStartWithTransformation.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance());
            }
        });
        this.ksession.signalEvent("MySignal", (Object)"NewValue");
        Thread.sleep(500L);
        StartEventTest.assertEquals((long)1L, (long)this.getNumberOfProcessInstances("Minimal"));
        StartEventTest.assertNotNull(list);
        StartEventTest.assertEquals((long)1L, (long)list.size());
        String var = this.getProcessVarValue((ProcessInstance)list.get(0), "x");
        StartEventTest.assertEquals((Object)"NEWVALUE", (Object)var);
    }

    @Test
    public void testTimerDelay() throws Exception {
        KieBase kbase = this.createKnowledgeBase("timer/BPMN2-StartTimerDuration.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        StartCountingListener listener = new StartCountingListener();
        this.ksession.addEventListener((ProcessEventListener)listener);
        Thread.sleep(1100L);
        StartEventTest.assertEquals((long)1L, (long)listener.getCount("start.delaying"));
    }

    @Test
    public void testSignalStartWithCustomEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SingalStartWithCustomEvent.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance());
            }
        });
        NotAvailableGoodsReport report = new NotAvailableGoodsReport("test");
        this.ksession.signalEvent("SignalNotAvailableGoods", (Object)report);
        Thread.sleep(500L);
        StartEventTest.assertEquals((long)1L, (long)this.getNumberOfProcessInstances("org.jbpm.example.SignalObjectProcess"));
        StartEventTest.assertEquals((long)1L, (long)list.size());
        this.assertProcessVarValue((ProcessInstance)list.get(0), "report", "NotAvailableGoodsReport{type:test}");
    }

    private static class StartCountingListener
    extends DefaultProcessEventListener {
        private Map<String, Integer> map = new HashMap<String, Integer>();

        private StartCountingListener() {
        }

        public void beforeProcessStarted(ProcessStartedEvent event) {
            String processId = event.getProcessInstance().getProcessId();
            Integer count = this.map.get(processId);
            if (count == null) {
                this.map.put(processId, 1);
            } else {
                this.map.put(processId, count + 1);
            }
        }

        public int getCount(String processId) {
            Integer count = this.map.get(processId);
            return count == null ? 0 : count;
        }
    }
}

