/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.StatefulKnowledgeSession;

@RunWith(value=Parameterized.class)
public class CompensationTest
extends JbpmBpmn2TestCase {
    private KieSession ksession;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public CompensationTest(boolean persistence) {
        super(persistence);
    }

    @BeforeClass
    public static void setup() throws Exception {
        CompensationTest.setUpDataSource();
    }

    @Before
    public void prepare() {
        this.clearHistory();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void compensationViaIntermediateThrowEventProcess() throws Exception {
        StatefulKnowledgeSession ksession = this.createKnowledgeSession("compensation/BPMN2-Compensation-IntermediateThrowEvent.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "0");
        ProcessInstance processInstance = ksession.startProcess("CompensateIntermediateThrowEvent", params);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
        this.assertProcessVarValue(processInstance, "x", "1");
    }

    @Test
    public void compensationTwiceViaSignal() throws Exception {
        StatefulKnowledgeSession ksession = this.createKnowledgeSession("compensation/BPMN2-Compensation-IntermediateThrowEvent.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "0");
        String processId = "CompensateIntermediateThrowEvent";
        ProcessInstance processInstance = ksession.startProcess(processId, params);
        ksession.signalEvent("Compensation", (Object)("implicit:" + processId), processInstance.getId());
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
        this.assertProcessVarValue(processInstance, "x", "2");
    }

    @Test
    public void compensationViaEventSubProcess() throws Exception {
        StatefulKnowledgeSession ksession = this.createKnowledgeSession("compensation/BPMN2-Compensation-EventSubProcess.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "0");
        ProcessInstance processInstance = ksession.startProcess("CompensationEventSubProcess", params);
        this.assertProcessInstanceActive(processInstance.getId(), (KieSession)ksession);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), null);
        this.assertProcessVarValue(processInstance, "x", "1");
    }

    @Test
    public void compensationOnlyAfterAssociatedActivityHasCompleted() throws Exception {
        StatefulKnowledgeSession ksession = this.createKnowledgeSession("compensation/BPMN2-Compensation-UserTaskBeforeAssociatedActivity.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "0");
        ProcessInstance processInstance = ksession.startProcess("CompensateIntermediateThrowEvent", params);
        ksession.signalEvent("Compensation", (Object)"_3", processInstance.getId());
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
        this.assertProcessVarValue(processInstance, "x", "1");
    }

    @Test
    public void orderedCompensation() throws Exception {
        StatefulKnowledgeSession ksession = this.createKnowledgeSession("compensation/BPMN2-Compensation-ParallelOrderedCompensation-IntermediateThrowEvent.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "");
        ProcessInstance processInstance = ksession.startProcess("CompensateParallelOrdered", params);
        List<WorkItem> workItems = workItemHandler.getWorkItems();
        ArrayList<Long> workItemIds = new ArrayList<Long>();
        for (WorkItem workItem : workItems) {
            if (!"Thr".equals(workItem.getParameter("NodeName"))) continue;
            workItemIds.add(workItem.getId());
        }
        for (WorkItem workItem : workItems) {
            if (!"Two".equals(workItem.getParameter("NodeName"))) continue;
            workItemIds.add(workItem.getId());
        }
        for (WorkItem workItem : workItems) {
            if (!"One".equals(workItem.getParameter("NodeName"))) continue;
            workItemIds.add(workItem.getId());
        }
        for (Long id : workItemIds) {
            ksession.getWorkItemManager().completeWorkItem(id.longValue(), null);
        }
        String xVal = this.getProcessVarValue(processInstance, "x");
        CompensationTest.assertEquals((String)"Compensation did not fire in the same order as the associated activities completed.", (Object)"_171:_131:_141:_151:", (Object)xVal);
    }

    @Test
    public void compensationInSubSubProcesses() throws Exception {
        StatefulKnowledgeSession ksession = this.createKnowledgeSession("compensation/BPMN2-Compensation-InSubSubProcess.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "0");
        ProcessInstance processInstance = ksession.startProcess("CompensateSubSubSub", params);
        ksession.signalEvent("Compensation", (Object)"_C-2", processInstance.getId());
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), null);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), null);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
        this.assertProcessVarValue(processInstance, "x", "2");
    }

    @Test
    public void specificCompensationOfASubProcess() throws Exception {
        StatefulKnowledgeSession ksession = this.createKnowledgeSession("compensation/BPMN2-Compensation-ThrowSpecificForSubProcess.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 1);
        ProcessInstance processInstance = ksession.startProcess("CompensationSpecificSubProcess", params);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
        if (!this.isPersistence()) {
            this.assertProcessVarValue(processInstance, "x", null);
        } else {
            this.assertProcessVarValue(processInstance, "x", "");
        }
    }

    @Test
    @Ignore
    public void compensationViaCancellation() throws Exception {
        StatefulKnowledgeSession ksession = this.createKnowledgeSession("compensation/BPMN2-Compensation-IntermediateThrowEvent.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "0");
        ProcessInstance processInstance = ksession.startProcess("CompensateIntermediateThrowEvent", params);
        ksession.signalEvent("Cancel", null, processInstance.getId());
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
        this.assertProcessVarValue(processInstance, "x", "1");
    }

    @Test
    public void compensationInvokingSubProcess() throws Exception {
        StatefulKnowledgeSession ksession = this.createKnowledgeSession("compensation/BPMN2-UserTaskCompensation.bpmn2");
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("compensation", "True");
        ProcessInstance processInstance = ksession.startProcess("UserTaskCompensation", params);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
        this.assertProcessVarValue(processInstance, "compensation", "compensation");
    }
}

