/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;

public class IncrementalCompilationTest
extends AbstractBaseTest {
    @Test
    public void testIncrementalProcessCompilation() throws Exception {
        String invalidProcessDefinition = this.getResource("/BPMN2-Incremental-Build-Invalid.bpmn2");
        String validProcessDefinition = this.getResource("/BPMN2-Incremental-Build-Valid.bpmn2");
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/p1.bpmn2", invalidProcessDefinition);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Results results = kieBuilder.getResults();
        IncrementalCompilationTest.assertEquals((long)3L, (long)results.getMessages(new Message.Level[]{Message.Level.ERROR}).size());
        kfs.write("src/main/resources/p1.bpmn2", validProcessDefinition);
        IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/p1.bpmn2"}).build();
        IncrementalCompilationTest.assertEquals((long)0L, (long)addResults.getAddedMessages().size());
        IncrementalCompilationTest.assertEquals((long)3L, (long)addResults.getRemovedMessages().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResource(String name) throws IOException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
    }
}

