/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.command;

import java.util.List;
import org.drools.core.impl.EnvironmentFactory;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.command.ClearHistoryLogsCommand;
import org.jbpm.process.audit.command.FindActiveProcessInstancesCommand;
import org.jbpm.process.audit.command.FindNodeInstancesCommand;
import org.jbpm.process.audit.command.FindProcessInstanceCommand;
import org.jbpm.process.audit.command.FindProcessInstancesCommand;
import org.jbpm.process.audit.command.FindVariableInstancesCommand;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class AuditCommandsTest
extends JbpmBpmn2TestCase {
    private static AuditLogService logService;

    public AuditCommandsTest() {
        super(true);
    }

    @BeforeClass
    public static void setup() throws Exception {
        AuditCommandsTest.setUpDataSource();
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)emf);
        logService = new JPAAuditLogService(env);
        logService.clear();
    }

    @Test
    public void testFindProcessInstanceCommands() throws Exception {
        String processId = "IntermediateCatchEvent";
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventSignal.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess(processId);
        AuditCommandsTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        FindProcessInstancesCommand cmd = new FindProcessInstancesCommand();
        Object result = ksession.execute((Command)cmd);
        AuditCommandsTest.assertNotNull((String)"Command result is empty!", (Object)result);
        AuditCommandsTest.assertTrue((boolean)(result instanceof List));
        List logList = (List)result;
        AuditCommandsTest.assertEquals((String)"Log list size is incorrect.", (long)1L, (long)logList.size());
        ProcessInstanceLog log = (ProcessInstanceLog)logList.get(0);
        AuditCommandsTest.assertEquals((long)log.getProcessInstanceId(), (long)processInstance.getId());
        AuditCommandsTest.assertEquals((Object)log.getProcessId(), (Object)processInstance.getProcessId());
        cmd = new FindActiveProcessInstancesCommand(processId);
        result = ksession.execute((Command)cmd);
        AuditCommandsTest.assertNotNull((String)"Command result is empty!", (Object)result);
        AuditCommandsTest.assertTrue((boolean)(result instanceof List));
        logList = (List)result;
        AuditCommandsTest.assertEquals((String)"Log list size is incorrect.", (long)1L, (long)logList.size());
        log = (ProcessInstanceLog)logList.get(0);
        AuditCommandsTest.assertEquals((String)"Process instance id", (long)log.getProcessInstanceId(), (long)processInstance.getId());
        AuditCommandsTest.assertEquals((String)"Process id", (Object)log.getProcessId(), (Object)processInstance.getProcessId());
        AuditCommandsTest.assertEquals((String)"Status", (long)log.getStatus().intValue(), (long)1L);
        cmd = new FindProcessInstanceCommand(processInstance.getId());
        result = ksession.execute((Command)cmd);
        AuditCommandsTest.assertNotNull((String)"Command result is empty!", (Object)result);
        AuditCommandsTest.assertTrue((boolean)(result instanceof ProcessInstanceLog));
        log = (ProcessInstanceLog)result;
        AuditCommandsTest.assertEquals((long)log.getProcessInstanceId(), (long)processInstance.getId());
        AuditCommandsTest.assertEquals((Object)log.getProcessId(), (Object)processInstance.getProcessId());
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.signalEvent("MyMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
        cmd = new ClearHistoryLogsCommand();
        result = ksession.execute((Command)cmd);
        AuditCommandsTest.assertEquals((String)"There should be no more logs", (long)0L, (long)logService.findProcessInstances().size());
    }

    @Test
    public void testVarAndNodeInstanceCommands() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SubProcessUserTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("SubProcess");
        this.assertProcessInstanceActive(processInstance);
        FindNodeInstancesCommand cmd = new FindNodeInstancesCommand(processInstance.getId());
        Object result = ksession.execute((Command)cmd);
        AuditCommandsTest.assertNotNull((String)"Command result is empty!", (Object)result);
        AuditCommandsTest.assertTrue((boolean)(result instanceof List));
        List nodeLogList = (List)result;
        AuditCommandsTest.assertEquals((String)"Log list size is incorrect.", (long)8L, (long)nodeLogList.size());
        cmd = new FindNodeInstancesCommand(processInstance.getId(), "UserTask_1");
        result = ksession.execute((Command)cmd);
        AuditCommandsTest.assertNotNull((String)"Command result is empty!", (Object)result);
        AuditCommandsTest.assertTrue((boolean)(result instanceof List));
        nodeLogList = (List)result;
        AuditCommandsTest.assertEquals((String)"Log list size is incorrect.", (long)1L, (long)nodeLogList.size());
        cmd = new FindVariableInstancesCommand(processInstance.getId(), "2:x");
        result = ksession.execute((Command)cmd);
        AuditCommandsTest.assertNotNull((String)"Command result is empty!", (Object)result);
        AuditCommandsTest.assertTrue((boolean)(result instanceof List));
        List varLogList = (List)result;
        AuditCommandsTest.assertEquals((String)"Log list size is incorrect.", (long)1L, (long)varLogList.size());
        WorkItem workItem = workItemHandler.getWorkItem();
        AuditCommandsTest.assertNotNull((Object)workItem);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
    }
}

