/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.ElementNameAndAttributeQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLTestCase;
import org.custommonkey.xmlunit.XMLUnit;
import org.drools.core.xml.SemanticModule;
import org.drools.core.xml.SemanticModules;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.kie.api.definition.process.WorkflowProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class BPMN2XMLTest
extends XMLTestCase {
    private static final Logger logger = LoggerFactory.getLogger(BPMN2XMLTest.class);
    private static final String[] processes = new String[]{"BPMN2-SimpleXMLProcess.bpmn2"};

    public void setUp() throws Exception {
        super.setUp();
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
    }

    public void testXML() throws IOException, SAXException {
        SemanticModules modules = new SemanticModules();
        modules.addSemanticModule((SemanticModule)new BPMNSemanticModule());
        modules.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        XmlProcessReader processReader = new XmlProcessReader(modules, ((Object)((Object)this)).getClass().getClassLoader());
        for (String processName : processes) {
            String original = BPMN2XMLTest.slurp(BPMN2XMLTest.class.getResourceAsStream("/" + processName));
            List processes = processReader.read(BPMN2XMLTest.class.getResourceAsStream("/" + processName));
            BPMN2XMLTest.assertNotNull((Object)processes);
            BPMN2XMLTest.assertEquals((int)1, (int)processes.size());
            RuleFlowProcess p = (RuleFlowProcess)processes.get(0);
            String result = XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)p, 2);
            Diff diff = new Diff(original, result);
            final HashSet<String> sequenceDoesNotMatter = new HashSet<String>();
            sequenceDoesNotMatter.add("startEvent");
            sequenceDoesNotMatter.add("scriptTask");
            sequenceDoesNotMatter.add("endEvent");
            sequenceDoesNotMatter.add("bpmndi:BPMNShape");
            diff.overrideDifferenceListener(new DifferenceListener(){

                public int differenceFound(Difference diff) {
                    String nodeName = diff.getTestNodeDetail().getNode().getNodeName();
                    if (sequenceDoesNotMatter.contains(nodeName) && diff.getId() == 20) {
                        return 1;
                    }
                    logger.info("! {}", (Object)diff.getTestNodeDetail().getNode().getNodeName());
                    return 0;
                }

                public void skippedComparison(Node one, Node two) {
                    logger.info("{} : {}", (Object)one.getLocalName(), (Object)two.getLocalName());
                }
            });
            diff.overrideElementQualifier((ElementQualifier)new ElementNameAndAttributeQualifier());
            BPMN2XMLTest.assertTrue((String)"Original and generated output is not the same.", (boolean)diff.identical());
        }
    }

    public static String slurp(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }
}

