/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.core.command.SingleSessionCommandService;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.impl.RegistryContext;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.process.instance.WorkItemHandler;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.StandaloneBPMNProcessTest;
import org.jbpm.bpmn2.handler.ReceiveTaskHandler;
import org.jbpm.bpmn2.handler.SendTaskHandler;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.bpmn2.test.RequirePersistence;
import org.jbpm.persistence.api.ProcessPersistenceContext;
import org.jbpm.persistence.api.ProcessPersistenceContextManager;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.command.UpdateTimerCommand;
import org.jbpm.process.instance.event.listeners.RuleAwareProcessEventLister;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.test.util.CountDownProcessEventListener;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class IntermediateEventTest
extends JbpmBpmn2TestCase {
    private Logger logger = LoggerFactory.getLogger(IntermediateEventTest.class);
    private KieSession ksession;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false, false}, {true, false}, {true, true}};
        return Arrays.asList(data);
    }

    public IntermediateEventTest(boolean persistence, boolean locking) {
        super(persistence, locking);
    }

    @BeforeClass
    public static void setup() throws Exception {
        IntermediateEventTest.setUpDataSource();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    private TimerManager getTimerManager(KieSession ksession) {
        KieSession internal = ksession;
        if (ksession instanceof CommandBasedStatefulKnowledgeSession) {
            internal = ((SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getRunner()).getKieSession();
        }
        return ((InternalProcessRuntime)((StatefulKnowledgeSessionImpl)internal).getProcessRuntime()).getTimerManager();
    }

    @Test
    public void testSignalBoundaryEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundarySignalEventOnTaskbpmn2.bpmn", "BPMN2-IntermediateThrowEventSignal.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        ProcessInstance processInstance = ksession.startProcess("BoundarySignalOnTask");
        ProcessInstance processInstance2 = ksession.startProcess("SignalIntermediateEvent");
        this.assertProcessInstanceFinished(processInstance2, (KieSession)ksession);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
    }

    @Test
    public void testSignalBoundaryEventOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundarySignalEventOnTaskbpmn2.bpmn");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new TestWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                IntermediateEventTest.this.logger.info("After node left {}", (Object)event.getNodeInstance().getNodeName());
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                IntermediateEventTest.this.logger.info("After node triggered {}", (Object)event.getNodeInstance().getNodeName());
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                IntermediateEventTest.this.logger.info("Before node left {}", (Object)event.getNodeInstance().getNodeName());
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                IntermediateEventTest.this.logger.info("Before node triggered {}", (Object)event.getNodeInstance().getNodeName());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("BoundarySignalOnTask");
        this.ksession.signalEvent("MySignal", (Object)"value");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testSignalBoundaryEventOnTaskWithSignalName() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundarySignalWithNameEventOnTaskbpmn2.bpmn");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new TestWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                IntermediateEventTest.this.logger.info("After node left {}", (Object)event.getNodeInstance().getNodeName());
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                IntermediateEventTest.this.logger.info("After node triggered {}", (Object)event.getNodeInstance().getNodeName());
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                IntermediateEventTest.this.logger.info("Before node left {}", (Object)event.getNodeInstance().getNodeName());
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                IntermediateEventTest.this.logger.info("Before node triggered {}", (Object)event.getNodeInstance().getNodeName());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("BoundarySignalOnTask");
        this.ksession.signalEvent("MySignal", (Object)"value");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testSignalBoundaryEventOnTaskComplete() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundarySignalEventOnTaskbpmn2.bpmn");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                IntermediateEventTest.this.logger.info("After node left {}", (Object)event.getNodeInstance().getNodeName());
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                IntermediateEventTest.this.logger.info("After node triggered {}", (Object)event.getNodeInstance().getNodeName());
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                IntermediateEventTest.this.logger.info("Before node left {}", (Object)event.getNodeInstance().getNodeName());
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                IntermediateEventTest.this.logger.info("Before node triggered {}", (Object)event.getNodeInstance().getNodeName());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("BoundarySignalOnTask");
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.ksession.signalEvent("MySignal", (Object)"value");
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testSignalBoundaryEventInterrupting() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SignalBoundaryEventInterrupting.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("SignalBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("MyMessage", null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testSignalIntermediateThrow() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventSignal.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = this.ksession.startProcess("SignalIntermediateEvent", params);
        IntermediateEventTest.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testSignalBetweenProcesses() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchSignalSingle.bpmn2", "BPMN2-IntermediateThrowEventSignal.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        ProcessInstance processInstance = ksession.startProcess("BPMN2-IntermediateCatchSignalSingle");
        ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        ProcessInstance processInstance2 = ksession.startProcess("SignalIntermediateEvent");
        this.assertProcessInstanceFinished(processInstance2, (KieSession)ksession);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
    }

    @Test
    public void testEventBasedSplit() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testEventBasedSplitBefore() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
    }

    @Test
    public void testEventBasedSplitAfter() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
    }

    @Test(timeout=10000L)
    public void testEventBasedSplit2() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("timer", 2);
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit2.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testEventBasedSplit3() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit3.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        Person jack = new Person();
        jack.setName("Jack");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.insert((Object)jack);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testEventBasedSplit4() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit4.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.signalEvent("Message-YesMessage", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        processInstance = this.ksession.startProcess("com.sample.test");
        this.ksession.signalEvent("Message-NoMessage", (Object)"NoValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testEventBasedSplit5() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit5.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        ReceiveTaskHandler receiveTaskHandler = new ReceiveTaskHandler(this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (org.kie.api.runtime.process.WorkItemHandler)receiveTaskHandler);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        receiveTaskHandler.setKnowledgeRuntime(this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (org.kie.api.runtime.process.WorkItemHandler)receiveTaskHandler);
        receiveTaskHandler.messageReceived("YesMessage", (Object)"YesValue");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        receiveTaskHandler.messageReceived("NoMessage", (Object)"NoValue");
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email1", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email2", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        receiveTaskHandler.setKnowledgeRuntime(this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (org.kie.api.runtime.process.WorkItemHandler)receiveTaskHandler);
        processInstance = this.ksession.startProcess("com.sample.test");
        receiveTaskHandler.messageReceived("NoMessage", (Object)"NoValue");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        receiveTaskHandler.messageReceived("YesMessage", (Object)"YesValue");
    }

    @Test
    public void testEventBasedSplitWithSubprocess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveEventBasedGatewayInSubprocess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.bpmn.testEBGInSubprocess");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("StopSignal", (Object)"", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        processInstance = this.ksession.startProcess("com.sample.bpmn.testEBGInSubprocess");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("ContinueSignal", (Object)"", processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("StopSignal", (Object)"", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testEventSubprocessSignal() throws Exception {
        String[] nodes = new String[]{"start", "User Task 1", "end", "Sub Process 1", "start-sub", "sub-script", "end-sub"};
        this.runTestEventSubprocessSignal("BPMN2-EventSubprocessSignal.bpmn2", nodes);
    }

    @Test
    public void testEventSubprocessSignalNested() throws Exception {
        String[] nodes = new String[]{"Start", "Sub Process", "Sub Start", "Sub Sub Process", "Sub Sub Start", "Sub Sub User Task", "Sub Sub Sub Process", "start-sub", "sub-script", "end-sub", "Sub Sub End", "Sub End", "End"};
        this.runTestEventSubprocessSignal("BPMN2-EventSubprocessSignal-Nested.bpmn2", nodes);
    }

    public void runTestEventSubprocessSignal(String processFile, String[] completedNodes) throws Exception {
        KieBase kbase = this.createKnowledgeBase(processFile);
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("sub-script")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessSignal");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)listener);
        this.ksession.signalEvent("MySignal", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        this.ksession.signalEvent("MySignal", null);
        this.assertProcessInstanceActive(processInstance);
        this.ksession.signalEvent("MySignal", null);
        this.assertProcessInstanceActive(processInstance);
        this.ksession.signalEvent("MySignal", null);
        this.assertProcessInstanceActive(processInstance);
        org.kie.api.runtime.process.WorkItem workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), completedNodes);
        IntermediateEventTest.assertEquals((long)4L, (long)executednodes.size());
    }

    @Test
    public void testEventSubprocessSignalWithStateNode() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessSignalWithStateNode.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("User Task 2")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessSignal");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)listener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)workItemHandler);
        org.kie.api.runtime.process.WorkItem workItemTopProcess = workItemHandler.getWorkItem();
        this.ksession.signalEvent("MySignal", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        org.kie.api.runtime.process.WorkItem workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.ksession.signalEvent("MySignal", null);
        this.assertProcessInstanceActive(processInstance);
        workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.ksession.signalEvent("MySignal", null);
        this.assertProcessInstanceActive(processInstance);
        workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.ksession.signalEvent("MySignal", null);
        this.assertProcessInstanceActive(processInstance);
        workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        IntermediateEventTest.assertNotNull((Object)workItemTopProcess);
        this.ksession.getWorkItemManager().completeWorkItem(workItemTopProcess.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "User Task 2", "end-sub");
        IntermediateEventTest.assertEquals((long)4L, (long)executednodes.size());
    }

    @Test
    public void testEventSubprocessSignalInterrupting() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessSignalInterrupting.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessSignal");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)listener);
        this.ksession.signalEvent("MySignal", null, processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        IntermediateEventTest.assertEquals((long)1L, (long)executednodes.size());
    }

    @Test
    public void testEventSubprocessMessage() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessMessage.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessMessage");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)listener);
        this.ksession.signalEvent("Message-HelloMessage", null, processInstance.getId());
        this.ksession.signalEvent("Message-HelloMessage", null);
        this.ksession.signalEvent("Message-HelloMessage", null);
        this.ksession.signalEvent("Message-HelloMessage", null);
        this.ksession.getProcessInstance(processInstance.getId());
        this.ksession.getProcessInstance(processInstance.getId());
        this.ksession.getProcessInstance(processInstance.getId());
        this.ksession.getProcessInstance(processInstance.getId());
        org.kie.api.runtime.process.WorkItem workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        IntermediateEventTest.assertEquals((long)4L, (long)executednodes.size());
    }

    @Test(timeout=10000L)
    public void testEventSubprocessTimer() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Script Task 1", 1);
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessTimer.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessTimer");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        org.kie.api.runtime.process.WorkItem workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
    }

    @Test(timeout=10000L)
    @RequirePersistence
    public void testEventSubprocessTimerCycle() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Script Task 1", 4);
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessTimerCycle.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessTimer");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        org.kie.api.runtime.process.WorkItem workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "end", "start-sub", "Script Task 1", "end-sub");
    }

    @Test
    public void testEventSubprocessConditional() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessConditional.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessConditional");
        this.assertProcessInstanceActive(processInstance);
        Person person = new Person();
        person.setName("john");
        this.ksession.insert((Object)person);
        org.kie.api.runtime.process.WorkItem workItem = workItemHandler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        IntermediateEventTest.assertEquals((long)1L, (long)executednodes.size());
    }

    @Test(timeout=10000L)
    public void testEventSubprocessMessageWithLocalVars() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("timer", 1);
        KieBase kbase = this.createKnowledgeBase("subprocess/BPMN2-EventSubProcessWithLocalVariables.bpmn2");
        final HashSet variablevalues = new HashSet();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                Map variable = (Map)event.getNodeInstance().getVariable("richiesta");
                if (variable != null) {
                    variablevalues.addAll(variable.keySet());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance processInstance = this.ksession.startProcess("EventSPWithVars");
        this.assertProcessInstanceActive(processInstance);
        HashMap data = new HashMap();
        this.ksession.signalEvent("Message-MAIL", data, processInstance.getId());
        countDownListener.waitTillCompleted();
        processInstance = this.ksession.getProcessInstance(processInstance.getId());
        IntermediateEventTest.assertNull((Object)processInstance);
        IntermediateEventTest.assertEquals((long)2L, (long)variablevalues.size());
        IntermediateEventTest.assertTrue((boolean)variablevalues.contains("SCRIPT1"));
        IntermediateEventTest.assertTrue((boolean)variablevalues.contains("SCRIPT2"));
    }

    @Test
    public void testMessageIntermediateThrow() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventMessage.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (org.kie.api.runtime.process.WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = this.ksession.startProcess("MessageIntermediateEvent", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMessageIntermediateThrowVerifyWorkItemData() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventMessage.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = this.ksession.startProcess("MessageIntermediateEvent", params);
        this.assertProcessInstanceCompleted(processInstance);
        org.kie.api.runtime.process.WorkItem workItem = handler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        IntermediateEventTest.assertTrue((boolean)(workItem instanceof WorkItem));
        long nodeInstanceId = ((WorkItem)workItem).getNodeInstanceId();
        long nodeId = ((WorkItem)workItem).getNodeId();
        IntermediateEventTest.assertNotNull((Object)nodeId);
        IntermediateEventTest.assertTrue((nodeId > 0L ? 1 : 0) != 0);
        IntermediateEventTest.assertNotNull((Object)nodeInstanceId);
        IntermediateEventTest.assertTrue((nodeInstanceId > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testMessageIntermediateThrowVerifyWorkItemDataDeploymentId() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventMessage.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = this.ksession.startProcess("MessageIntermediateEvent", params);
        this.assertProcessInstanceCompleted(processInstance);
        org.kie.api.runtime.process.WorkItem workItem = handler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        IntermediateEventTest.assertTrue((boolean)(workItem instanceof WorkItem));
        long nodeInstanceId = ((WorkItem)workItem).getNodeInstanceId();
        long nodeId = ((WorkItem)workItem).getNodeId();
        String deploymentId = ((WorkItem)workItem).getDeploymentId();
        IntermediateEventTest.assertNotNull((Object)nodeId);
        IntermediateEventTest.assertTrue((nodeId > 0L ? 1 : 0) != 0);
        IntermediateEventTest.assertNotNull((Object)nodeInstanceId);
        IntermediateEventTest.assertTrue((nodeInstanceId > 0L ? 1 : 0) != 0);
        IntermediateEventTest.assertNull((Object)deploymentId);
        this.ksession.getEnvironment().set("deploymentId", (Object)"testDeploymentId");
        this.ksession.startProcess("MessageIntermediateEvent", params);
        this.assertProcessInstanceCompleted(processInstance);
        workItem = handler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)workItem);
        IntermediateEventTest.assertTrue((boolean)(workItem instanceof WorkItem));
        nodeInstanceId = ((WorkItem)workItem).getNodeInstanceId();
        nodeId = ((WorkItem)workItem).getNodeId();
        deploymentId = ((WorkItem)workItem).getDeploymentId();
        IntermediateEventTest.assertNotNull((Object)nodeId);
        IntermediateEventTest.assertTrue((nodeId > 0L ? 1 : 0) != 0);
        IntermediateEventTest.assertNotNull((Object)nodeInstanceId);
        IntermediateEventTest.assertTrue((nodeInstanceId > 0L ? 1 : 0) != 0);
        IntermediateEventTest.assertNotNull((Object)deploymentId);
        IntermediateEventTest.assertEquals((Object)"testDeploymentId", (Object)deploymentId);
    }

    @Test
    public void testMessageBoundaryEventOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryMessageEventOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new TestWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("BoundaryMessageOnTask");
        this.ksession.signalEvent("Message-HelloMessage", (Object)"message data");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "User Task", "Boundary event", "Condition met", "End2");
    }

    @Test
    public void testMessageBoundaryEventOnTaskComplete() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryMessageEventOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("BoundaryMessageOnTask");
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.ksession.signalEvent("Message-HelloMessage", (Object)"message data");
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "User Task", "User Task2", "End1");
    }

    @Test(timeout=10000L)
    public void testTimerBoundaryEventDuration() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("TimerEvent", 1);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventDuration.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.ksession = this.restoreSession(this.ksession, true);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test(timeout=10000L)
    public void testTimerBoundaryEventDurationISO() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("TimerEvent", 1);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventDurationISO.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.ksession = this.restoreSession(this.ksession, true);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test(timeout=10000L)
    public void testTimerBoundaryEventDateISO() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("TimerEvent", 1);
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-TimerBoundaryEventDateISO.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        DateTime now = new DateTime(System.currentTimeMillis());
        now.plus(2000L);
        params.put("date", now.toString());
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent", params);
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.ksession = this.restoreSession(this.ksession, true);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test(timeout=10000L)
    public void testTimerBoundaryEventCycle1() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("TimerEvent", 1);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventCycle1.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.ksession = this.restoreSession(this.ksession, true);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test(timeout=10000L)
    public void testTimerBoundaryEventCycle2() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("TimerEvent", 3);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventCycle2.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        this.ksession.abortProcessInstance(processInstance.getId());
    }

    @Test(timeout=10000L)
    @RequirePersistence(value=false)
    public void testTimerBoundaryEventCycleISO() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("TimerEvent", 2);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventCycleISO.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        this.ksession.abortProcessInstance(processInstance.getId());
    }

    @Test(timeout=10000L)
    @RequirePersistence
    public void testTimerBoundaryEventCycleISOWithPersistence() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("TimerEvent", 2);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventCycleISO.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        long sessionId = ksession.getIdentifier();
        Environment env = ksession.getEnvironment();
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        this.logger.info("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)sessionId, (KieBase)kbase, null, (Environment)env);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        this.assertProcessInstanceActive(processInstance);
        ksession.abortProcessInstance(processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
    }

    @Test(timeout=10000L)
    public void testTimerBoundaryEventInterrupting() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("TimerEvent", 1);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventInterrupting.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.ksession = this.restoreSession(this.ksession, true);
        this.logger.debug("Firing timer");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test(timeout=10000L)
    public void testTimerBoundaryEventInterruptingOnTask() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("TimerEvent", 1);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventInterruptingOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new TestWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.ksession = this.restoreSession(this.ksession, true);
        this.logger.debug("Firing timer");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testTimerBoundaryEventInterruptingOnTaskCancelTimer() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventInterruptingOnTaskCancelTimer.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        Collection timers = this.getTimerManager(this.ksession).getTimers();
        IntermediateEventTest.assertEquals((long)1L, (long)timers.size());
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        timers = this.getTimerManager(this.ksession).getTimers();
        IntermediateEventTest.assertEquals((long)1L, (long)timers.size());
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        timers = this.getTimerManager(this.ksession).getTimers();
        IntermediateEventTest.assertEquals((long)0L, (long)timers.size());
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testIntermediateCatchEventSignal() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventSignal.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("MyMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "UserTask", "EndProcess", "event");
    }

    @Test
    public void testIntermediateCatchEventMessage() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventMessage.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("Message-HelloMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test(timeout=10000L)
    public void testIntermediateCatchEventTimerDuration() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("timer", 1);
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerDuration.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test(timeout=10000L)
    public void testIntermediateCatchEventTimerDateISO() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("timer", 1);
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-IntermediateCatchEventTimerDateISO.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        HashMap<String, String> params = new HashMap<String, String>();
        DateTime now = new DateTime(System.currentTimeMillis());
        now.plus(2000L);
        params.put("date", now.toString());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent", params);
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test(timeout=10000L)
    public void testIntermediateCatchEventTimerDurationISO() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("timer", 1);
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerDurationISO.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test(timeout=10000L)
    public void testIntermediateCatchEventTimerCycle1() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("timer", 1);
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerCycle1.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test(timeout=10000L)
    public void testIntermediateCatchEventTimerCycleISO() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("timer", 5);
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerCycleISO.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        this.ksession.abortProcessInstance(processInstance.getId());
    }

    @Test(timeout=10000L)
    public void testIntermediateCatchEventTimerCycle2() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("timer", 3);
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerCycle2.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        this.ksession.abortProcessInstance(processInstance.getId());
    }

    @Test
    public void testIntermediateCatchEventCondition() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventCondition.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        Person person = new Person();
        person.setName("Jack");
        this.ksession.insert((Object)person);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testIntermediateCatchEventConditionFilterByProcessInstance() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventConditionFilterByProcessInstance.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Long> params1 = new HashMap<String, Long>();
        params1.put("personId", 1L);
        Person person1 = new Person();
        person1.setId(1L);
        WorkflowProcessInstance pi1 = (WorkflowProcessInstance)this.ksession.createProcessInstance("IntermediateCatchEventConditionFilterByProcessInstance", params1);
        long pi1id = pi1.getId();
        this.ksession.insert((Object)pi1);
        FactHandle personHandle1 = this.ksession.insert((Object)person1);
        this.ksession.startProcessInstance(pi1.getId());
        HashMap<String, Long> params2 = new HashMap<String, Long>();
        params2.put("personId", 2L);
        Person person2 = new Person();
        person2.setId(2L);
        WorkflowProcessInstance pi2 = (WorkflowProcessInstance)this.ksession.createProcessInstance("IntermediateCatchEventConditionFilterByProcessInstance", params2);
        long pi2id = pi2.getId();
        this.ksession.insert((Object)pi2);
        FactHandle personHandle2 = this.ksession.insert((Object)person2);
        this.ksession.startProcessInstance(pi2.getId());
        person1.setName("John");
        this.ksession.update(personHandle1, (Object)person1);
        IntermediateEventTest.assertNull((String)"First process should be completed", (Object)this.ksession.getProcessInstance(pi1id));
        IntermediateEventTest.assertNotNull((String)"Second process should NOT be completed", (Object)this.ksession.getProcessInstance(pi2id));
    }

    @Test(timeout=10000L)
    @RequirePersistence(value=false)
    public void testIntermediateCatchEventTimerCycleWithError() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("timer", 3);
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerCycleWithError.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 0);
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent", params);
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        processInstance = this.ksession.getProcessInstance(processInstance.getId());
        Integer xValue = (Integer)((WorkflowProcessInstance)processInstance).getVariable("x");
        IntermediateEventTest.assertEquals((Object)new Integer(3), (Object)xValue);
        this.ksession.abortProcessInstance(processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test(timeout=10000L)
    @RequirePersistence
    public void testIntermediateCatchEventTimerCycleWithErrorWithPersistence() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("timer", 2);
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerCycleWithError.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        final long piId = processInstance.getId();
        this.ksession.execute((Command)new ExecutableCommand<Void>(){

            public Void execute(Context context) {
                StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)((RegistryContext)context).lookup(KieSession.class);
                WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(piId);
                processInstance.setVariable("x", (Object)0);
                return null;
            }
        });
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        Integer xValue = (Integer)this.ksession.execute((Command)new ExecutableCommand<Integer>(){

            public Integer execute(Context context) {
                StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)((RegistryContext)context).lookup(KieSession.class);
                WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(piId);
                return (Integer)processInstance.getVariable("x");
            }
        });
        IntermediateEventTest.assertEquals((Object)new Integer(2), (Object)xValue);
        this.ksession.abortProcessInstance(processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testNoneIntermediateThrow() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventNone.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("NoneIntermediateEvent", null);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testLinkIntermediateEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateLinkEvent.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("linkEventProcessExample");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testLinkEventCompositeProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-LinkEventCompositeProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Composite");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testConditionalBoundaryEventOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryConditionalEventOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new TestWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("BoundarySignalOnTask");
        Person person = new Person();
        person.setName("john");
        this.ksession.insert((Object)person);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "User Task", "Boundary event", "Condition met", "End2");
    }

    @Test
    public void testConditionalBoundaryEventOnTaskComplete() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryConditionalEventOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("BoundarySignalOnTask");
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        Person person = new Person();
        person.setName("john");
        this.ksession.insert((Object)person);
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "User Task", "User Task2", "End1");
    }

    @Test
    public void testConditionalBoundaryEventOnTaskActiveOnStartup() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryConditionalEventOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new TestWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("BoundarySignalOnTask");
        Person person = new Person();
        person.setName("john");
        this.ksession.insert((Object)person);
        this.assertProcessInstanceCompleted(processInstance);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "User Task", "Boundary event", "Condition met", "End2");
    }

    @Test
    public void testConditionalBoundaryEventInterrupting() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ConditionalBoundaryEventInterrupting.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("ConditionalBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        Person person = new Person();
        person.setName("john");
        this.ksession.insert((Object)person);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "Hello", "StartSubProcess", "Task", "BoundaryEvent", "Goodbye", "EndProcess");
    }

    @Test
    public void testSignallingExceptionServiceTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExceptionServiceProcess-Signalling.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        StandaloneBPMNProcessTest.runTestSignallingExceptionServiceTask(this.ksession);
    }

    @Test
    public void testSignalBoundaryEventOnSubprocessTakingDifferentPaths() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SignalBoundaryOnSubProcess.bpmn");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("jbpm.testing.signal");
        this.assertProcessInstanceActive(processInstance);
        ksession.signalEvent("continue", null, processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        ksession.dispose();
        ksession = this.createKnowledgeSession(kbase);
        processInstance = ksession.startProcess("jbpm.testing.signal");
        this.assertProcessInstanceActive(processInstance);
        ksession.signalEvent("forward", null);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        ksession.dispose();
    }

    @Test
    public void testIntermediateCatchEventSameSignalOnTwoKsessions() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventSignal.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        KieBase kbase2 = this.createKnowledgeBase("BPMN2-IntermediateCatchEventSignal2.bpmn2");
        StatefulKnowledgeSession ksession2 = this.createKnowledgeSession(kbase2);
        ksession2.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance2 = ksession2.startProcess("IntermediateCatchEvent2");
        this.assertProcessInstanceActive(processInstance);
        this.assertProcessInstanceActive(processInstance2);
        this.ksession = this.restoreSession(this.ksession, true);
        ksession2 = this.restoreSession((KieSession)ksession2, true);
        this.ksession.signalEvent("MyMessage", (Object)"SomeValue");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertProcessInstanceActive(processInstance2);
        ksession2.signalEvent("MyMessage", (Object)"SomeValue");
        this.assertProcessInstanceFinished(processInstance2, (KieSession)ksession2);
        ksession2.dispose();
    }

    @Test
    @RequirePersistence
    public void testEventTypesLifeCycle() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchSignalBetweenUserTasks.bpmn2");
        EntityManagerFactory separateEmf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        Environment env = this.createEnvironment(separateEmf);
        this.ksession = this.createKnowledgeSession(kbase, null, env);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.startProcess("BPMN2-IntermediateCatchSignalBetweenUserTasks");
        int signalListSize = (Integer)this.ksession.execute((Command)new ExecutableCommand<Integer>(){

            public Integer execute(Context context) {
                SingleSessionCommandService commandService = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)IntermediateEventTest.this.ksession).getRunner();
                InternalKnowledgeRuntime kruntime = (InternalKnowledgeRuntime)commandService.getKieSession();
                ProcessPersistenceContextManager contextManager = (ProcessPersistenceContextManager)kruntime.getEnvironment().get("org.kie.api.persistence.PersistenceContextManager");
                ProcessPersistenceContext pcontext = contextManager.getProcessPersistenceContext();
                List processInstancesToSignalList = pcontext.getProcessInstancesWaitingForEvent("MySignal");
                return processInstancesToSignalList.size();
            }
        });
        IntermediateEventTest.assertEquals((long)0L, (long)signalListSize);
        this.ksession.getWorkItemManager().completeWorkItem(1L, null);
        signalListSize = (Integer)this.ksession.execute((Command)new ExecutableCommand<Integer>(){

            public Integer execute(Context context) {
                SingleSessionCommandService commandService = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)IntermediateEventTest.this.ksession).getRunner();
                InternalKnowledgeRuntime kruntime = (InternalKnowledgeRuntime)commandService.getKieSession();
                ProcessPersistenceContextManager contextManager = (ProcessPersistenceContextManager)kruntime.getEnvironment().get("org.kie.api.persistence.PersistenceContextManager");
                ProcessPersistenceContext pcontext = contextManager.getProcessPersistenceContext();
                List processInstancesToSignalList = pcontext.getProcessInstancesWaitingForEvent("MySignal");
                return processInstancesToSignalList.size();
            }
        });
        IntermediateEventTest.assertEquals((long)1L, (long)signalListSize);
        this.ksession.signalEvent("MySignal", null);
        signalListSize = (Integer)this.ksession.execute((Command)new ExecutableCommand<Integer>(){

            public Integer execute(Context context) {
                SingleSessionCommandService commandService = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)IntermediateEventTest.this.ksession).getRunner();
                InternalKnowledgeRuntime kruntime = (InternalKnowledgeRuntime)commandService.getKieSession();
                ProcessPersistenceContextManager contextManager = (ProcessPersistenceContextManager)kruntime.getEnvironment().get("org.kie.api.persistence.PersistenceContextManager");
                ProcessPersistenceContext pcontext = contextManager.getProcessPersistenceContext();
                List processInstancesToSignalList = pcontext.getProcessInstancesWaitingForEvent("MySignal");
                return processInstancesToSignalList.size();
            }
        });
        IntermediateEventTest.assertEquals((long)0L, (long)signalListSize);
        this.ksession.getWorkItemManager().completeWorkItem(2L, null);
        this.ksession.dispose();
        this.ksession = null;
        separateEmf.close();
    }

    @Test
    public void testIntermediateCatchEventNoIncommingConnection() throws Exception {
        try {
            KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventNoIncommingConnection.bpmn2");
            this.ksession = this.createKnowledgeSession(kbase);
        }
        catch (RuntimeException e) {
            IntermediateEventTest.assertNotNull((Object)e.getMessage());
            IntermediateEventTest.assertTrue((boolean)e.getMessage().contains("has no incoming connection"));
        }
    }

    @Test
    public void testSignalBoundaryEventOnMultiInstanceSubprocess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("subprocess/BPMN2-MultiInstanceSubprocessWithBoundarySignal.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        HashMap params = new HashMap();
        ArrayList<String> approvers = new ArrayList<String>();
        approvers.add("john");
        approvers.add("john");
        params.put("approvers", approvers);
        ProcessInstance processInstance = ksession.startProcess("boundary-catch-error-event", params);
        this.assertProcessInstanceActive(processInstance);
        List<org.kie.api.runtime.process.WorkItem> workItems = handler.getWorkItems();
        IntermediateEventTest.assertNotNull(workItems);
        IntermediateEventTest.assertEquals((long)2L, (long)workItems.size());
        ksession.signalEvent("Outside", null, processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        ksession.dispose();
    }

    @Test
    public void testSignalBoundaryEventNoInteruptOnMultiInstanceSubprocess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("subprocess/BPMN2-MultiInstanceSubprocessWithBoundarySignalNoInterupting.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        HashMap params = new HashMap();
        ArrayList<String> approvers = new ArrayList<String>();
        approvers.add("john");
        approvers.add("john");
        params.put("approvers", approvers);
        ProcessInstance processInstance = ksession.startProcess("boundary-catch-error-event", params);
        this.assertProcessInstanceActive(processInstance);
        List<org.kie.api.runtime.process.WorkItem> workItems = handler.getWorkItems();
        IntermediateEventTest.assertNotNull(workItems);
        IntermediateEventTest.assertEquals((long)2L, (long)workItems.size());
        ksession.signalEvent("Outside", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance.getId(), (KieSession)ksession);
        for (org.kie.api.runtime.process.WorkItem wi : workItems) {
            ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        ksession.dispose();
    }

    @Test
    public void testErrorBoundaryEventOnMultiInstanceSubprocess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("subprocess/BPMN2-MultiInstanceSubprocessWithBoundaryError.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        HashMap params = new HashMap();
        ArrayList<String> approvers = new ArrayList<String>();
        approvers.add("john");
        approvers.add("john");
        params.put("approvers", approvers);
        ProcessInstance processInstance = ksession.startProcess("boundary-catch-error-event", params);
        this.assertProcessInstanceActive(processInstance);
        List<org.kie.api.runtime.process.WorkItem> workItems = handler.getWorkItems();
        IntermediateEventTest.assertNotNull(workItems);
        IntermediateEventTest.assertEquals((long)2L, (long)workItems.size());
        ksession.signalEvent("Inside", null, processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        ksession.dispose();
    }

    @Test
    public void testIntermediateCatchEventSignalAndBoundarySignalEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryEventWithSignals.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("boundaryeventtest");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        this.ksession.signalEvent("moveon", (Object)"", processInstance.getId());
        this.assertProcessInstanceActive(processInstance);
        org.kie.api.runtime.process.WorkItem wi = handler.getWorkItem();
        IntermediateEventTest.assertNotNull((Object)wi);
        this.ksession.signalEvent("moveon", (Object)"", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testSignalIntermediateThrowEventWithTransformation() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-BoundarySignalEventOnTaskbpmn2.bpmn", "BPMN2-IntermediateThrowEventSignalWithTransformation.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "john");
        ProcessInstance processInstance = ksession.startProcess("BoundarySignalOnTask");
        ProcessInstance processInstance2 = ksession.startProcess("SignalIntermediateEvent", params);
        this.assertProcessInstanceFinished(processInstance2, (KieSession)ksession);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        String var = this.getProcessVarValue(processInstance, "x");
        IntermediateEventTest.assertEquals((Object)"JOHN", (Object)var);
    }

    @Test
    public void testSignalBoundaryEventWithTransformation() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-BoundarySignalEventOnTaskWithTransformation.bpmn", "BPMN2-IntermediateThrowEventSignal.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "john");
        ProcessInstance processInstance = ksession.startProcess("BoundarySignalOnTask");
        ProcessInstance processInstance2 = ksession.startProcess("SignalIntermediateEvent", params);
        this.assertProcessInstanceFinished(processInstance2, (KieSession)ksession);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        String var = this.getProcessVarValue(processInstance, "x");
        IntermediateEventTest.assertEquals((Object)"JOHN", (Object)var);
    }

    @Test
    public void testMessageIntermediateThrowWithTransformation() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-IntermediateThrowEventMessageWithTransformation.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final StringBuffer messageContent = new StringBuffer();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (org.kie.api.runtime.process.WorkItemHandler)new SendTaskHandler(){

            public void executeWorkItem(org.kie.api.runtime.process.WorkItem workItem, WorkItemManager manager) {
                messageContent.append(workItem.getParameter("Message"));
                super.executeWorkItem(workItem, manager);
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = this.ksession.startProcess("MessageIntermediateEvent", params);
        this.assertProcessInstanceCompleted(processInstance);
        IntermediateEventTest.assertEquals((Object)"MYVALUE", (Object)messageContent.toString());
    }

    @Test
    public void testIntermediateCatchEventSignalWithTransformation() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-IntermediateCatchEventSignalWithTransformation.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("MyMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "UserTask", "EndProcess", "event");
        String var = this.getProcessVarValue(processInstance, "x");
        IntermediateEventTest.assertNotNull((Object)var);
        IntermediateEventTest.assertEquals((Object)"SOMEVALUE", (Object)var);
    }

    @Test
    public void testIntermediateCatchEventMessageWithTransformation() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-IntermediateCatchEventMessageWithTransformation.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("Message-HelloMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        String var = this.getProcessVarValue(processInstance, "x");
        IntermediateEventTest.assertNotNull((Object)var);
        IntermediateEventTest.assertEquals((Object)"SOMEVALUE", (Object)var);
    }

    @Test
    public void testEventSubprocessSignalWithTransformation() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-EventSubprocessSignalWithTransformation.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessSignal");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("MySignal", (Object)"john", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "Sub Process 1", "start-sub", "end-sub");
        String var = this.getProcessVarValue(processInstance, "x");
        IntermediateEventTest.assertNotNull((Object)var);
        IntermediateEventTest.assertEquals((Object)"JOHN", (Object)var);
    }

    @Test
    public void testMultipleMessageSignalSubprocess() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-MultipleMessageSignalSubprocess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.bpmn.Multiple_MessageSignal_Subprocess");
        this.logger.debug("Parent Process ID: " + processInstance.getId());
        this.ksession.signalEvent("Message-Message_1", (Object)"Test", processInstance.getId());
        this.assertProcessInstanceActive(processInstance.getId(), this.ksession);
        this.ksession.signalEvent("Message-Message_1", (Object)"Test", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test
    public void testIntermediateCatchEventSignalWithRef() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-IntermediateCatchEventSignalWithRef.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("Signal1", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "UserTask", "EndProcess", "event");
    }

    @Test(timeout=10000L)
    public void testTimerMultipleInstances() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("timer", 3);
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultiInstanceLoopBoundaryTimer.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("boundaryTimerMultipleInstances");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        List<org.kie.api.runtime.process.WorkItem> workItems = handler.getWorkItems();
        IntermediateEventTest.assertNotNull(workItems);
        IntermediateEventTest.assertEquals((long)3L, (long)workItems.size());
        for (org.kie.api.runtime.process.WorkItem wi : workItems) {
            this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test(timeout=10000L)
    public void testIntermediateCatchEventTimerCycleCron() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("timer", 3);
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerCycleCron.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        this.ksession.abortProcessInstance(processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test(timeout=10000L)
    public void testIntermediateCatchEventTimerDurationValueFromGlobal() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("timer", 1);
        KieBase kbase = this.createKnowledgeBase("BPMN2-GlobalTimerInterrupted.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        this.ksession.setGlobal("time", (Object)"2s");
        ProcessInstance processInstance = this.ksession.startProcess("interruptedTimer");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test(timeout=10000L)
    public void testTimerBoundaryEventCronCycle() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Send Update Timer", 3);
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryTimerCycleCron.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("boundaryTimerCycleCron");
        this.assertProcessInstanceActive(processInstance);
        List<org.kie.api.runtime.process.WorkItem> workItems = handler.getWorkItems();
        IntermediateEventTest.assertNotNull(workItems);
        IntermediateEventTest.assertEquals((long)1L, (long)workItems.size());
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        workItems = handler.getWorkItems();
        IntermediateEventTest.assertNotNull(workItems);
        IntermediateEventTest.assertEquals((long)3L, (long)workItems.size());
        this.ksession.abortProcessInstance(processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test(timeout=10000L)
    public void testIntermediateTimerParallelGateway() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Timer1", 1);
        CountDownProcessEventListener countDownListener2 = new CountDownProcessEventListener("Timer2", 1);
        CountDownProcessEventListener countDownListener3 = new CountDownProcessEventListener("Timer3", 1);
        KieBase kbase = this.createKnowledgeBase("timer/BPMN2-IntermediateTimerParallelGateway.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        this.ksession.addEventListener((ProcessEventListener)countDownListener2);
        this.ksession.addEventListener((ProcessEventListener)countDownListener3);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation.timer-parallel");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        countDownListener2.waitTillCompleted();
        countDownListener3.waitTillCompleted();
        this.assertProcessInstanceCompleted(processInstance.getId(), this.ksession);
    }

    @Test(timeout=10000L)
    public void testIntermediateTimerEventMI() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("After timer", 3);
        KieBase kbase = this.createKnowledgeBase("timer/BPMN2-IntermediateTimerEventMI.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("defaultprocessid");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance.getId(), this.ksession);
        this.ksession.abortProcessInstance(processInstance.getId());
        this.assertProcessInstanceAborted(processInstance.getId(), this.ksession);
    }

    @Test
    public void testThrowIntermediateSignalWithScope() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2IntermediateThrowEventScope.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        HashMap params = new HashMap();
        ProcessInstance processInstance = this.ksession.startProcess("intermediate-event-scope", params);
        ProcessInstance processInstance2 = this.ksession.startProcess("intermediate-event-scope", params);
        this.assertProcessInstanceActive(processInstance);
        this.assertProcessInstanceActive(processInstance2);
        this.assertNodeActive(processInstance.getId(), this.ksession, "Complete work", "Wait");
        this.assertNodeActive(processInstance2.getId(), this.ksession, "Complete work", "Wait");
        List<org.kie.api.runtime.process.WorkItem> items = handler.getWorkItems();
        org.kie.api.runtime.process.WorkItem wi = items.get(0);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("_output", "sending event");
        this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), result);
        this.assertProcessInstanceCompleted(processInstance);
        this.assertProcessInstanceActive(processInstance2);
        this.assertNodeActive(processInstance2.getId(), this.ksession, "Complete work", "Wait");
        wi = items.get(1);
        this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), result);
        this.assertProcessInstanceCompleted(processInstance2);
    }

    @Test
    public void testThrowEndSignalWithScope() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2EndThrowEventScope.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        HashMap params = new HashMap();
        ProcessInstance processInstance = this.ksession.startProcess("end-event-scope", params);
        ProcessInstance processInstance2 = this.ksession.startProcess("end-event-scope", params);
        this.assertProcessInstanceActive(processInstance);
        this.assertProcessInstanceActive(processInstance2);
        this.assertNodeActive(processInstance.getId(), this.ksession, "Complete work", "Wait");
        this.assertNodeActive(processInstance2.getId(), this.ksession, "Complete work", "Wait");
        List<org.kie.api.runtime.process.WorkItem> items = handler.getWorkItems();
        org.kie.api.runtime.process.WorkItem wi = items.get(0);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("_output", "sending event");
        this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), result);
        this.assertProcessInstanceCompleted(processInstance);
        this.assertProcessInstanceActive(processInstance2);
        this.assertNodeActive(processInstance2.getId(), this.ksession, "Complete work", "Wait");
        wi = items.get(1);
        this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), result);
        this.assertProcessInstanceCompleted(processInstance2);
    }

    @Test
    public void testThrowIntermediateSignalWithExternalScope() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventExternalScope.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        WorkItemHandler externalHandler = new WorkItemHandler(){

            public void executeWorkItem(org.kie.api.runtime.process.WorkItem workItem, WorkItemManager manager) {
                String signal = (String)workItem.getParameter("Signal");
                IntermediateEventTest.this.ksession.signalEvent(signal, null);
                manager.completeWorkItem(workItem.getId(), null);
            }

            public void abortWorkItem(org.kie.api.runtime.process.WorkItem workItem, WorkItemManager manager) {
            }
        };
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        this.ksession.getWorkItemManager().registerWorkItemHandler("External Send Task", (org.kie.api.runtime.process.WorkItemHandler)externalHandler);
        HashMap params = new HashMap();
        ProcessInstance processInstance = this.ksession.startProcess("intermediate-event-scope", params);
        this.assertProcessInstanceActive(processInstance);
        this.assertNodeActive(processInstance.getId(), this.ksession, "Complete work", "Wait");
        List<org.kie.api.runtime.process.WorkItem> items = handler.getWorkItems();
        IntermediateEventTest.assertEquals((long)1L, (long)items.size());
        org.kie.api.runtime.process.WorkItem wi = items.get(0);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("_output", "sending event");
        this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), result);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testIntermediateCatchEventSignalWithVariable() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventSignalWithVariable.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        String signalVar = "myVarSignal";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("signalName", signalVar);
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent", parameters);
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent(signalVar, (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "StartProcess", "UserTask", "EndProcess", "event");
    }

    @Test
    public void testSignalIntermediateThrowWithVariable() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventSignalWithVariable.bpmn2", "BPMN2-IntermediateCatchEventSignalWithVariable.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new SystemOutWorkItemHandler());
        String signalVar = "myVarSignal";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("signalName", signalVar);
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent", parameters);
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        params.put("signalName", signalVar);
        ProcessInstance processInstanceThrow = this.ksession.startProcess("SignalIntermediateEvent", params);
        IntermediateEventTest.assertEquals((long)2L, (long)processInstanceThrow.getState());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testInvalidDateTimerBoundary() throws Exception {
        try {
            this.createKnowledgeBase("timer/BPMN2-TimerBoundaryEventDateInvalid.bpmn2");
            IntermediateEventTest.fail((String)"Should fail as timer expression is not valid");
        }
        catch (RuntimeException e) {
            IntermediateEventTest.assertTrue((boolean)e.getMessage().contains("Could not parse date 'abcdef'"));
        }
    }

    @Test
    public void testInvalidDurationTimerBoundary() throws Exception {
        try {
            this.createKnowledgeBase("timer/BPMN2-TimerBoundaryEventDurationInvalid.bpmn2");
            IntermediateEventTest.fail((String)"Should fail as timer expression is not valid");
        }
        catch (Exception e) {
            IntermediateEventTest.assertTrue((boolean)e.getMessage().contains("Could not parse delay 'abcdef'"));
        }
    }

    @Test
    public void testInvalidCycleTimerBoundary() throws Exception {
        try {
            this.createKnowledgeBase("timer/BPMN2-TimerBoundaryEventCycleInvalid.bpmn2");
            IntermediateEventTest.fail((String)"Should fail as timer expression is not valid");
        }
        catch (Exception e) {
            IntermediateEventTest.assertTrue((boolean)e.getMessage().contains("Could not parse delay 'abcdef'"));
        }
    }

    @Test
    public void testIntermediateCatchEventConditionSetVariableAfter() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventConditionSetVariableAfter.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventLister());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventLister());
        Collection processInstances = this.ksession.getObjects(new ObjectFilter(){

            public boolean accept(Object object) {
                return object instanceof ProcessInstance;
            }
        });
        IntermediateEventTest.assertNotNull((Object)processInstances);
        IntermediateEventTest.assertEquals((long)1L, (long)processInstances.size());
        Person person = new Person();
        person.setName("Jack");
        this.ksession.insert((Object)person);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        processInstances = this.ksession.getObjects(new ObjectFilter(){

            public boolean accept(Object object) {
                return object instanceof ProcessInstance;
            }
        });
        IntermediateEventTest.assertNotNull((Object)processInstances);
        IntermediateEventTest.assertEquals((long)0L, (long)processInstances.size());
    }

    @Test
    public void testIntermediateCatchEventConditionRemovePIAfter() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventCondition.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventLister());
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventLister());
        Collection processInstances = this.ksession.getObjects(new ObjectFilter(){

            public boolean accept(Object object) {
                return object instanceof ProcessInstance;
            }
        });
        IntermediateEventTest.assertNotNull((Object)processInstances);
        IntermediateEventTest.assertEquals((long)1L, (long)processInstances.size());
        Person person = new Person();
        person.setName("Jack");
        this.ksession.insert((Object)person);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        processInstances = this.ksession.getObjects(new ObjectFilter(){

            public boolean accept(Object object) {
                return object instanceof ProcessInstance;
            }
        });
        IntermediateEventTest.assertNotNull((Object)processInstances);
        IntermediateEventTest.assertEquals((long)0L, (long)processInstances.size());
    }

    @Test(timeout=10000L)
    @RequirePersistence
    public void testIntermediateCatchEventTimerDurationWithError() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("timer", 1);
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerDurationWithError.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)new DoNothingWorkItemHandler());
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 0);
        ProcessInstance processInstance = this.ksession.startProcess("IntermediateCatchEvent", params);
        long waitTime = 2L;
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted(waitTime * 1000L);
        this.assertProcessInstanceActive(processInstance);
        processInstance = this.ksession.getProcessInstance(processInstance.getId());
        this.ksession.setGlobal("TestOK", (Object)Boolean.TRUE);
        this.ksession.execute((Command)new UpdateTimerCommand(processInstance.getId(), "timer", waitTime + 1L));
        countDownListener.reset(1);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test(timeout=10000L)
    public void testTimerBoundaryEventCronCycleVariable() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Send Update Timer", 3);
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryTimerCycleCronVariable.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("cronStr", "0/1 * * * * ?");
        ProcessInstance processInstance = this.ksession.startProcess("boundaryTimerCycleCron", parameters);
        this.assertProcessInstanceActive(processInstance);
        List<org.kie.api.runtime.process.WorkItem> workItems = handler.getWorkItems();
        IntermediateEventTest.assertNotNull(workItems);
        IntermediateEventTest.assertEquals((long)1L, (long)workItems.size());
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        workItems = handler.getWorkItems();
        IntermediateEventTest.assertNotNull(workItems);
        IntermediateEventTest.assertEquals((long)3L, (long)workItems.size());
        this.ksession.abortProcessInstance(processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test(timeout=10000L)
    public void testMultipleTimerBoundaryEventCronCycleVariable() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Send Update Timer", 2);
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleBoundaryTimerCycleCronVariable.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("cronStr", "0/1 * * * * ?");
        ProcessInstance processInstance = this.ksession.startProcess("boundaryTimerCycleCron", parameters);
        this.assertProcessInstanceActive(processInstance);
        List<org.kie.api.runtime.process.WorkItem> workItems = handler.getWorkItems();
        IntermediateEventTest.assertNotNull(workItems);
        IntermediateEventTest.assertEquals((long)1L, (long)workItems.size());
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        workItems = handler.getWorkItems();
        IntermediateEventTest.assertNotNull(workItems);
        IntermediateEventTest.assertEquals((long)2L, (long)workItems.size());
        this.ksession.abortProcessInstance(processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testEventBasedSplitWithCronTimerAndSignal() throws Exception {
        System.setProperty("jbpm.enable.multi.con", "true");
        try {
            CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Request photos of order in use", 1);
            CountDownProcessEventListener countDownListener2 = new CountDownProcessEventListener("Request an online review", 1);
            CountDownProcessEventListener countDownListener3 = new CountDownProcessEventListener("Send a thank you card", 1);
            CountDownProcessEventListener countDownListener4 = new CountDownProcessEventListener("Request an online review", 1);
            KieBase kbase = this.createKnowledgeBase("timer/BPMN2-CronTimerWithEventBasedGateway.bpmn2");
            this.ksession = this.createKnowledgeSession(kbase);
            TestWorkItemHandler handler = new TestWorkItemHandler();
            this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (org.kie.api.runtime.process.WorkItemHandler)handler);
            this.ksession.addEventListener((ProcessEventListener)countDownListener);
            this.ksession.addEventListener((ProcessEventListener)countDownListener2);
            this.ksession.addEventListener((ProcessEventListener)countDownListener3);
            this.ksession.addEventListener((ProcessEventListener)countDownListener4);
            ProcessInstance processInstance = this.ksession.startProcess("timerWithEventBasedGateway");
            this.assertProcessInstanceActive(processInstance.getId(), this.ksession);
            countDownListener.waitTillCompleted();
            this.logger.debug("First timer triggered");
            countDownListener2.waitTillCompleted();
            this.logger.debug("Second timer triggered");
            countDownListener3.waitTillCompleted();
            this.logger.debug("Third timer triggered");
            countDownListener4.waitTillCompleted();
            this.logger.debug("Fourth timer triggered");
            List<org.kie.api.runtime.process.WorkItem> wi = handler.getWorkItems();
            IntermediateEventTest.assertNotNull(wi);
            IntermediateEventTest.assertEquals((long)3L, (long)wi.size());
            this.ksession.abortProcessInstance(processInstance.getId());
        }
        finally {
            System.clearProperty("jbpm.enable.multi.con");
        }
    }

    @Test
    public void testEventSubprocessWithEmbeddedSignals() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessErrorSignalEmbedded.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("project2.myerrorprocess");
        this.assertProcessInstanceActive(processInstance.getId(), this.ksession);
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("signal1", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance.getId(), this.ksession);
        for (NodeInstance nodeInstance : ((WorkflowProcessInstance)processInstance).getNodeInstances()) {
            System.out.println("Active node instance " + nodeInstance);
        }
        this.ksession.signalEvent("signal2", null, processInstance.getId());
        this.assertProcessInstanceActive(processInstance.getId(), this.ksession);
        this.ksession.signalEvent("signal3", null, processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testEventSubprocessWithExpression() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessSignalExpression.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "signalling");
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessSignalExpression", params);
        this.assertProcessInstanceActive(processInstance.getId(), this.ksession);
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.signalEvent("signalling", null, processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testConditionalProcessFactInsertedBefore() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventConditionPI.bpmn2", "BPMN2-IntermediateCatchEventSignal.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        Person person0 = new Person("john");
        this.ksession.insert((Object)person0);
        HashMap<String, String> params0 = new HashMap<String, String>();
        params0.put("name", "john");
        ProcessInstance pi0 = this.ksession.startProcess("IntermediateCatchEvent", params0);
        this.ksession.insert((Object)pi0);
        Person person = new Person("Jack");
        this.ksession.insert((Object)person);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "Poul");
        ProcessInstance pi = this.ksession.startProcess("IntermediateCatchEventPI", params);
        this.ksession.insert((Object)pi);
        pi = this.ksession.getProcessInstance(pi.getId());
        IntermediateEventTest.assertNotNull((Object)pi);
        Person person2 = new Person("Poul");
        this.ksession.insert((Object)person2);
        pi = this.ksession.getProcessInstance(pi.getId());
        IntermediateEventTest.assertNull((Object)pi);
    }
}

