/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.core.SessionConfiguration;
import org.drools.core.audit.WorkingMemoryInMemoryLogger;
import org.drools.core.audit.event.LogEvent;
import org.drools.core.audit.event.RuleFlowLogEvent;
import org.drools.core.audit.event.RuleFlowNodeLogEvent;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.core.util.MVELSafeHelper;
import org.drools.core.xml.SemanticModule;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.jbpm.bpmn2.test.RequireLocking;
import org.jbpm.bpmn2.test.RequirePersistence;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNExtensionsSemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.marshalling.impl.ProcessInstanceResolverStrategy;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.AuditLoggerFactory;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.instance.event.DefaultSignalManagerFactory;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.rules.Timeout;
import org.junit.runner.Description;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.api.io.Resource;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.event.KnowledgeRuntimeEventManager;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class JbpmBpmn2TestCase
extends AbstractBaseTest {
    private static final Logger log = LoggerFactory.getLogger(JbpmBpmn2TestCase.class);
    public static String[] txStateName = new String[]{"ACTIVE", "MARKED_ROLLBACK", "PREPARED", "COMMITTED", "ROLLEDBACK", "UNKNOWN", "NO_TRANSACTION", "PREPARING", "COMMITTING", "ROLLING_BACK"};
    public static final boolean PERSISTENCE = Boolean.valueOf(System.getProperty("org.jbpm.test.persistence", "true"));
    public static final boolean LOCKING = Boolean.valueOf(System.getProperty("org.jbpm.test.locking", "false"));
    private static boolean setupDataSource = false;
    private boolean sessionPersistence = false;
    private boolean pessimisticLocking = false;
    private static H2Server server = new H2Server();
    private WorkingMemoryInMemoryLogger logger;
    protected AuditLogService logService;
    protected static EntityManagerFactory emf;
    private static PoolingDataSource ds;
    private RequireLocking testReqLocking;
    private RequirePersistence testReqPersistence;
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)30L);
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            log.info(" >>> {} <<<", (Object)description.getMethodName());
            try {
                String methodName = description.getMethodName();
                int i = methodName.indexOf("[");
                if (i > 0) {
                    methodName = methodName.substring(0, i);
                }
                Method method = description.getTestClass().getMethod(methodName, new Class[0]);
                JbpmBpmn2TestCase.this.testReqPersistence = method.getAnnotation(RequirePersistence.class);
                JbpmBpmn2TestCase.this.testReqLocking = method.getAnnotation(RequireLocking.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void finished(Description description) {
            log.info("Finished {}", (Object)description);
        }
    };

    public JbpmBpmn2TestCase() {
        this(PERSISTENCE, LOCKING);
    }

    public JbpmBpmn2TestCase(boolean sessionPersistence) {
        this(sessionPersistence, LOCKING);
    }

    public JbpmBpmn2TestCase(boolean sessionPersistance, boolean locking) {
        System.setProperty("jbpm.user.group.mapping", "classpath:/usergroups.properties");
        System.setProperty("jbpm.usergroup.callback", "org.jbpm.task.identity.DefaultUserGroupCallbackImpl");
        this.sessionPersistence = sessionPersistance;
        this.pessimisticLocking = locking;
    }

    public static PoolingDataSource setupPoolingDataSource() {
        Properties dsProps = PersistenceUtil.getDatasourceProperties();
        String jdbcUrl = dsProps.getProperty("url");
        String driverClass = dsProps.getProperty("driverClassName");
        PoolingDataSource ds1 = PersistenceUtil.setupPoolingDataSource((Properties)dsProps, (String)"jdbc/testDS1", (boolean)false);
        if (driverClass.startsWith("org.h2")) {
            ds1.getDriverProperties().setProperty("url", jdbcUrl);
        }
        ds1.init();
        return ds1;
    }

    public void setPersistence(boolean sessionPersistence) {
        this.sessionPersistence = sessionPersistence;
    }

    public boolean isPersistence() {
        return this.sessionPersistence;
    }

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        JbpmBpmn2TestCase.emf = emf;
    }

    public void setPoolingDataSource(PoolingDataSource ds) {
        JbpmBpmn2TestCase.ds = ds;
    }

    public static void setUpDataSource() throws Exception {
        setupDataSource = true;
        server.start();
        ds = JbpmBpmn2TestCase.setupPoolingDataSource();
        emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
    }

    @Before
    public void checkTest() {
        String comment;
        if (this.testReqPersistence != null && this.testReqPersistence.value() != this.sessionPersistence) {
            log.info("Skipped - test is run only {} persistence", (Object)(this.testReqPersistence.value() ? "with" : "without"));
            comment = this.testReqPersistence.comment();
            if (comment.length() > 0) {
                log.info(comment);
            }
            Assume.assumeTrue((boolean)false);
        }
        if (this.testReqLocking != null && this.testReqLocking.value() != this.pessimisticLocking) {
            log.info("Skipped - test is run only {} pessimistic locking", (Object)(this.testReqLocking.value() ? "with" : "without"));
            comment = this.testReqPersistence.comment();
            if (comment.length() > 0) {
                log.info(comment);
            }
            Assume.assumeTrue((boolean)false);
        }
    }

    @After
    public void clear() {
        this.clearHistory();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (setupDataSource) {
            int testTxState;
            String runningTransactionStatus = null;
            BitronixTransaction tx = TransactionManagerServices.getTransactionManager().getCurrentTransaction();
            if (tx != null && (testTxState = tx.getStatus()) != 6 && testTxState != 4 && testTxState != 3) {
                try {
                    tx.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                runningTransactionStatus = txStateName[testTxState];
            }
            if (emf != null) {
                try {
                    emf.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                emf = null;
            }
            if (ds != null) {
                try {
                    ds.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ds = null;
            }
            server.stop();
            DeleteDbFiles.execute((String)"~", (String)"jbpm-db", (boolean)true);
            if (runningTransactionStatus != null) {
                Assert.fail((String)("Transaction had status " + runningTransactionStatus + " at the end of the test."));
            }
        }
    }

    protected KieBase createKnowledgeBase(String ... process) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (int i = 0; i < process.length; ++i) {
            resources.addAll(this.buildAndDumpBPMN2Process(process[i]));
        }
        return this.createKnowledgeBaseFromResources(resources.toArray(new Resource[resources.size()]));
    }

    protected KieBase createKnowledgeBaseWithoutDumper(String ... process) throws Exception {
        Resource[] resources = new Resource[process.length];
        for (int i = 0; i < process.length; ++i) {
            String p = process[i];
            resources[i] = ResourceFactory.newClassPathResource((String)p);
        }
        return this.createKnowledgeBaseFromResources(resources);
    }

    protected List<Resource> buildAndDumpBPMN2Process(String process) throws SAXException, IOException {
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        ((KnowledgeBuilderConfigurationImpl)conf).initSemanticModules();
        ((KnowledgeBuilderConfigurationImpl)conf).addSemanticModule((SemanticModule)new BPMNSemanticModule());
        ((KnowledgeBuilderConfigurationImpl)conf).addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        ((KnowledgeBuilderConfigurationImpl)conf).addSemanticModule((SemanticModule)new BPMNExtensionsSemanticModule());
        Resource classpathResource = ResourceFactory.newClassPathResource((String)process);
        XmlProcessReader processReader = new XmlProcessReader(((KnowledgeBuilderConfigurationImpl)conf).getSemanticModules(), ((Object)((Object)this)).getClass().getClassLoader());
        List processes = processReader.read(((Object)((Object)this)).getClass().getResourceAsStream("/" + process));
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Process p : processes) {
            RuleFlowProcess ruleFlowProcess = (RuleFlowProcess)p;
            String dumpedString = XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)ruleFlowProcess);
            Resource resource = ResourceFactory.newReaderResource((Reader)new StringReader(dumpedString));
            resource.setSourcePath(classpathResource.getSourcePath());
            resource.setTargetPath(classpathResource.getTargetPath());
            resources.add(resource);
        }
        return resources;
    }

    protected KieBase createKnowledgeBaseFromResources(Resource ... process) throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        if (process.length > 0) {
            KieFileSystem kfs = ks.newKieFileSystem();
            for (Resource p : process) {
                kfs.write(p);
            }
            KieBuilder kb = ks.newKieBuilder(kfs);
            kb.buildAll();
            if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
                throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
            }
        }
        KieContainer kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        return kContainer.getKieBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KieBase createKnowledgeBaseFromDisc(String process) throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        KieFileSystem kfs = ks.newKieFileSystem();
        Resource res = ResourceFactory.newClassPathResource((String)process);
        kfs.write(res);
        KieBuilder kb = ks.newKieBuilder(kfs);
        kb.buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
        }
        KieContainer kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        KieBase kbase = kContainer.getKieBase();
        File packageFile = null;
        Iterator iterator = kbase.getKiePackages().iterator();
        if (iterator.hasNext()) {
            KiePackage pkg = (KiePackage)iterator.next();
            packageFile = new File(System.getProperty("java.io.tmpdir") + File.separator + pkg.getName() + ".pkg");
            packageFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(packageFile);){
                DroolsStreamUtils.streamOut((OutputStream)out, (Object)pkg);
            }
        }
        kfs.delete(new String[]{res.getSourcePath()});
        kfs.write(ResourceFactory.newFileResource(packageFile));
        kb = ks.newKieBuilder(kfs);
        kb.buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
        }
        kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        kbase = kContainer.getKieBase();
        return kbase;
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KieBase kbase) throws Exception {
        return this.createKnowledgeSession(kbase, null, null);
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KieBase kbase, Environment env) throws Exception {
        return this.createKnowledgeSession(kbase, null, env);
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KieBase kbase, KieSessionConfiguration conf, Environment env) throws Exception {
        StatefulKnowledgeSession result;
        if (conf == null) {
            conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        }
        if (this.sessionPersistence) {
            if (env == null) {
                env = this.createEnvironment(emf);
            }
            if (this.pessimisticLocking) {
                env.set("org.kie.api.persistence.pessimistic", (Object)true);
            }
            conf.setOption((KieSessionOption)ForceEagerActivationOption.YES);
            result = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, (KieSessionConfiguration)conf, (Environment)env);
            AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)result, null);
            this.logService = new JPAAuditLogService(env);
        } else {
            if (env == null) {
                env = EnvironmentFactory.newEnvironment();
            }
            Properties defaultProps = new Properties();
            defaultProps.setProperty("drools.processSignalManagerFactory", DefaultSignalManagerFactory.class.getName());
            defaultProps.setProperty("drools.processInstanceManagerFactory", DefaultProcessInstanceManagerFactory.class.getName());
            conf = SessionConfiguration.newInstance((Properties)defaultProps);
            conf.setOption((KieSessionOption)ForceEagerActivationOption.YES);
            result = (StatefulKnowledgeSession)kbase.newKieSession(conf, env);
            this.logger = new WorkingMemoryInMemoryLogger((KnowledgeRuntimeEventManager)result);
        }
        return result;
    }

    protected StatefulKnowledgeSession createKnowledgeSession(String ... process) throws Exception {
        KieBase kbase = this.createKnowledgeBase(process);
        return this.createKnowledgeSession(kbase);
    }

    protected KieSession restoreSession(KieSession ksession, boolean noCache) {
        if (this.sessionPersistence) {
            long id = ksession.getIdentifier();
            KieBase kbase = ksession.getKieBase();
            Environment env = null;
            env = noCache ? this.createEnvironment(emf) : ksession.getEnvironment();
            if (this.pessimisticLocking) {
                env.set("org.kie.api.persistence.pessimistic", (Object)true);
            }
            KieSessionConfiguration config = ksession.getSessionConfiguration();
            config.setOption((KieSessionOption)ForceEagerActivationOption.YES);
            StatefulKnowledgeSession result = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, (KieSessionConfiguration)config, (Environment)env);
            AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)result, null);
            ksession.dispose();
            return result;
        }
        return ksession;
    }

    protected KieSession restoreSession(KieSession ksession) {
        return ksession;
    }

    protected StatefulKnowledgeSession restoreSession(StatefulKnowledgeSession ksession) {
        return ksession;
    }

    protected Environment createEnvironment(EntityManagerFactory emf) {
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)emf);
        env.set("org.kie.transaction.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        if (this.sessionPersistence) {
            ObjectMarshallingStrategy[] strategies = (ObjectMarshallingStrategy[])env.get("org.kie.api.marshalling.ObjectMarshallingStrategies");
            ArrayList<ObjectMarshallingStrategy> listStrategies = new ArrayList<ObjectMarshallingStrategy>(Arrays.asList(strategies));
            listStrategies.add(0, (ObjectMarshallingStrategy)new ProcessInstanceResolverStrategy());
            strategies = new ObjectMarshallingStrategy[listStrategies.size()];
            env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)listStrategies.toArray(strategies));
        }
        return env;
    }

    public void assertProcessInstanceCompleted(ProcessInstance processInstance) {
        JbpmBpmn2TestCase.assertTrue((String)"Process instance has not been completed.", (boolean)this.assertProcessInstanceState(2, processInstance));
    }

    public void assertProcessInstanceAborted(ProcessInstance processInstance) {
        JbpmBpmn2TestCase.assertTrue((String)"Process instance has not been aborted.", (boolean)this.assertProcessInstanceState(3, processInstance));
    }

    public void assertProcessInstanceActive(ProcessInstance processInstance) {
        JbpmBpmn2TestCase.assertTrue((String)"Process instance is not active.", (this.assertProcessInstanceState(1, processInstance) || this.assertProcessInstanceState(0, processInstance) ? 1 : 0) != 0);
    }

    public void assertProcessInstanceFinished(ProcessInstance processInstance, KieSession ksession) {
        JbpmBpmn2TestCase.assertNull((String)"Process instance has not been finished.", (Object)ksession.getProcessInstance(processInstance.getId()));
    }

    public void assertNodeActive(long processInstanceId, KieSession ksession, String ... name) {
        ArrayList<String> names = new ArrayList<String>();
        for (String n : name) {
            names.add(n);
        }
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        if (processInstance instanceof WorkflowProcessInstance) {
            if (this.sessionPersistence) {
                List logs = this.logService.findNodeInstances(processInstanceId);
                if (logs != null) {
                    ArrayList<String> activeNodes = new ArrayList<String>();
                    for (NodeInstanceLog l : logs) {
                        String nodeName = l.getNodeName();
                        if (l.getType() == 0 && names.contains(nodeName)) {
                            activeNodes.add(nodeName);
                        }
                        if (l.getType() != 1 || !names.contains(nodeName)) continue;
                        activeNodes.remove(nodeName);
                    }
                    names.removeAll(activeNodes);
                }
            } else {
                this.assertNodeActive((NodeInstanceContainer)((WorkflowProcessInstance)processInstance), names);
            }
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            JbpmBpmn2TestCase.fail((String)("Node(s) not active: " + s));
        }
    }

    private void assertNodeActive(NodeInstanceContainer container, List<String> names) {
        for (NodeInstance nodeInstance : container.getNodeInstances()) {
            String nodeName = nodeInstance.getNodeName();
            if (names.contains(nodeName)) {
                names.remove(nodeName);
            }
            if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
            this.assertNodeActive((NodeInstanceContainer)nodeInstance, names);
        }
    }

    public void assertNodeTriggered(long processInstanceId, String ... nodeNames) {
        List<String> names = this.getNotTriggeredNodes(processInstanceId, nodeNames);
        if (!names.isEmpty()) {
            String s = names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + names.get(i);
            }
            JbpmBpmn2TestCase.fail((String)("Node(s) not executed: " + s));
        }
    }

    public void assertNotNodeTriggered(long processInstanceId, String ... nodeNames) {
        List<String> names = this.getNotTriggeredNodes(processInstanceId, nodeNames);
        JbpmBpmn2TestCase.assertTrue((boolean)Arrays.equals(names.toArray(), nodeNames));
    }

    public int getNumberOfNodeTriggered(long processInstanceId, String node) {
        int counter;
        block3: {
            block2: {
                counter = 0;
                if (!this.sessionPersistence) break block2;
                List logs = this.logService.findNodeInstances(processInstanceId);
                if (logs == null) break block3;
                for (NodeInstanceLog l : logs) {
                    String nodeName = l.getNodeName();
                    if (l.getType() != 0 && l.getType() != 1 || !node.equals(nodeName)) continue;
                    ++counter;
                }
                break block3;
            }
            for (LogEvent event : this.logger.getLogEvents()) {
                String nodeName;
                if (!(event instanceof RuleFlowNodeLogEvent) || !node.equals(nodeName = ((RuleFlowNodeLogEvent)event).getNodeName())) continue;
                ++counter;
            }
        }
        return counter;
    }

    public int getNumberOfProcessInstances(String processId) {
        int counter = 0;
        if (this.sessionPersistence) {
            List logs = this.logService.findProcessInstances(processId);
            if (logs != null) {
                return logs.size();
            }
        } else {
            LogEvent[] events;
            for (LogEvent event : events = this.logger.getLogEvents().toArray(new LogEvent[0])) {
                if (event.getType() != 8 || !((RuleFlowLogEvent)event).getProcessId().equals(processId)) continue;
                ++counter;
            }
        }
        return counter;
    }

    protected boolean assertProcessInstanceState(int state, ProcessInstance processInstance) {
        if (this.sessionPersistence) {
            ProcessInstanceLog log = this.logService.findProcessInstance(processInstance.getId());
            if (log != null) {
                return log.getStatus() == state;
            }
        } else {
            return processInstance.getState() == state;
        }
        return false;
    }

    private List<String> getNotTriggeredNodes(long processInstanceId, String ... nodeNames) {
        ArrayList<String> names;
        block4: {
            block3: {
                names = new ArrayList<String>();
                for (String nodeName : nodeNames) {
                    names.add(nodeName);
                }
                if (!this.sessionPersistence) break block3;
                List logs = this.logService.findNodeInstances(processInstanceId);
                if (logs == null) break block4;
                for (NodeInstanceLog l : logs) {
                    String nodeName;
                    nodeName = l.getNodeName();
                    if (l.getType() != 0 && l.getType() != 1 || !names.contains(nodeName)) continue;
                    names.remove(nodeName);
                }
                break block4;
            }
            for (LogEvent event : this.logger.getLogEvents()) {
                String nodeName;
                if (!(event instanceof RuleFlowNodeLogEvent) || !names.contains(nodeName = ((RuleFlowNodeLogEvent)event).getNodeName())) continue;
                names.remove(nodeName);
            }
        }
        return names;
    }

    protected List<String> getCompletedNodes(long processInstanceId) {
        ArrayList<String> names;
        block3: {
            block2: {
                names = new ArrayList<String>();
                if (!this.sessionPersistence) break block2;
                JPAAuditLogService auditLogService = new JPAAuditLogService(emf);
                List logs = auditLogService.findNodeInstances(processInstanceId);
                if (logs == null) break block3;
                for (NodeInstanceLog l : logs) {
                    names.add(l.getNodeId());
                }
                break block3;
            }
            for (LogEvent event : this.logger.getLogEvents()) {
                if (!(event instanceof RuleFlowNodeLogEvent) || event.getType() != 27) continue;
                names.add(((RuleFlowNodeLogEvent)event).getNodeId());
            }
        }
        return names;
    }

    protected void clearHistory() {
        if (this.sessionPersistence) {
            try {
                this.logService.clear();
            }
            catch (Exception exception) {}
        } else if (this.logger != null) {
            this.logger.clear();
        }
    }

    protected void abortProcessInstances(KieSession ksession) {
        if (this.sessionPersistence) {
            try {
                this.logService.findActiveProcessInstances().forEach(pi -> ksession.abortProcessInstance(pi.getId()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void assertProcessVarExists(ProcessInstance process, String ... processVarNames) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        ArrayList<String> names = new ArrayList<String>();
        for (String nodeName : processVarNames) {
            names.add(nodeName);
        }
        for (String pvar : instance.getVariables().keySet()) {
            if (!names.contains(pvar)) continue;
            names.remove(pvar);
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            JbpmBpmn2TestCase.fail((String)("Process Variable(s) do not exist: " + s));
        }
    }

    public String getProcessVarValue(ProcessInstance processInstance, String varName) {
        String actualValue = null;
        if (this.sessionPersistence) {
            List log = this.logService.findVariableInstances(processInstance.getId(), varName);
            if (log != null && !log.isEmpty()) {
                actualValue = ((VariableInstanceLog)log.get(log.size() - 1)).getValue();
            }
        } else {
            Object value = ((WorkflowProcessInstanceImpl)processInstance).getVariable(varName);
            if (value != null) {
                actualValue = value.toString();
            }
        }
        return actualValue;
    }

    public void assertProcessVarValue(ProcessInstance processInstance, String varName, Object varValue) {
        String actualValue = this.getProcessVarValue(processInstance, varName);
        JbpmBpmn2TestCase.assertEquals((String)("Variable " + varName + " value misatch!"), (Object)varValue, (Object)actualValue);
    }

    public void assertNodeExists(ProcessInstance process, String ... nodeNames) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        ArrayList<String> names = new ArrayList<String>();
        for (String string : nodeNames) {
            names.add(string);
        }
        for (String string : instance.getNodeContainer().getNodes()) {
            if (!names.contains(string.getName())) continue;
            names.remove(string.getName());
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            JbpmBpmn2TestCase.fail((String)("Node(s) do not exist: " + s));
        }
    }

    public void assertNumOfIncommingConnections(ProcessInstance process, String nodeName, int num) {
        this.assertNodeExists(process, nodeName);
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        for (Node node : instance.getNodeContainer().getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            if (node.getIncomingConnections().size() == num) break;
            JbpmBpmn2TestCase.fail((String)("Expected incomming connections: " + num + " - found " + node.getIncomingConnections().size()));
        }
    }

    public void assertNumOfOutgoingConnections(ProcessInstance process, String nodeName, int num) {
        this.assertNodeExists(process, nodeName);
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        for (Node node : instance.getNodeContainer().getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            if (node.getOutgoingConnections().size() == num) break;
            JbpmBpmn2TestCase.fail((String)("Expected outgoing connections: " + num + " - found " + node.getOutgoingConnections().size()));
        }
    }

    public void assertVersionEquals(ProcessInstance process, String version) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getVersion().equals(version)) {
            JbpmBpmn2TestCase.fail((String)("Expected version: " + version + " - found " + instance.getWorkflowProcess().getVersion()));
        }
    }

    public void assertProcessNameEquals(ProcessInstance process, String name) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getName().equals(name)) {
            JbpmBpmn2TestCase.fail((String)("Expected name: " + name + " - found " + instance.getWorkflowProcess().getName()));
        }
    }

    public void assertPackageNameEquals(ProcessInstance process, String packageName) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getPackageName().equals(packageName)) {
            JbpmBpmn2TestCase.fail((String)("Expected package name: " + packageName + " - found " + instance.getWorkflowProcess().getPackageName()));
        }
    }

    public Object eval(Reader reader, Map vars) {
        try {
            return this.eval(this.toString(reader), vars);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception Thrown", e);
        }
    }

    private String toString(Reader reader) throws IOException {
        int charValue;
        StringBuilder sb = new StringBuilder(1024);
        while ((charValue = reader.read()) != -1) {
            sb.append((char)charValue);
        }
        return sb.toString();
    }

    public Object eval(String str, Map vars) {
        ParserContext context = new ParserContext();
        context.addPackageImport("org.jbpm.task");
        context.addPackageImport("org.jbpm.task.service");
        context.addPackageImport("org.jbpm.task.query");
        context.addPackageImport("java.util");
        vars.put("now", new Date());
        return MVELSafeHelper.getEvaluator().executeExpression((Object)MVEL.compileExpression((String)str, (ParserContext)context), vars);
    }

    protected void assertProcessInstanceCompleted(long processInstanceId, KieSession ksession) {
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        JbpmBpmn2TestCase.assertNull((String)"Process instance has not completed.", (Object)processInstance);
    }

    protected void assertProcessInstanceAborted(long processInstanceId, KieSession ksession) {
        JbpmBpmn2TestCase.assertNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    protected void assertProcessInstanceActive(long processInstanceId, KieSession ksession) {
        JbpmBpmn2TestCase.assertNotNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    private static class H2Server {
        private Server server;

        private H2Server() {
        }

        public synchronized void start() {
            if (this.server == null || !this.server.isRunning(false)) {
                try {
                    DeleteDbFiles.execute((String)"~", (String)"jbpm-db", (boolean)true);
                    this.server = Server.createTcpServer((String[])new String[0]);
                    this.server.start();
                }
                catch (SQLException e) {
                    throw new RuntimeException("Cannot start h2 server database", e);
                }
            }
        }

        public synchronized void finalize() throws Throwable {
            this.stop();
            super.finalize();
        }

        public void stop() {
            if (this.server != null) {
                this.server.stop();
                this.server.shutdown();
                DeleteDbFiles.execute((String)"~", (String)"jbpm-db", (boolean)true);
                this.server = null;
            }
        }
    }
}

