/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.core.context.variable.VariableViolationException;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.StatefulKnowledgeSession;

@RunWith(value=Parameterized.class)
public class VariableTagsTest
extends JbpmBpmn2TestCase {
    private KieSession ksession;
    private TestWorkItemHandler workItemHandler;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public VariableTagsTest(boolean persistence) throws Exception {
        super(persistence);
    }

    @BeforeClass
    public static void setup() throws Exception {
        VariableTagsTest.setUpDataSource();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.abortProcessInstances(this.ksession);
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testProcessWithMissingRequiredVariable() throws Exception {
        this.ksession = this.createSessionAndRegisterWorkItemHandler("variable-tags/approval-with-required-variable-tags.bpmn2");
        Assertions.assertThatExceptionOfType(VariableViolationException.class).isThrownBy(() -> this.ksession.startProcess("approvals"));
    }

    @Test
    public void testProcessWithNullRequiredVariable() throws Exception {
        this.ksession = this.createSessionAndRegisterWorkItemHandler("variable-tags/approval-with-required-variable-tags.bpmn2");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("approver", null);
        Assertions.assertThatExceptionOfType(VariableViolationException.class).isThrownBy(() -> this.ksession.startProcess("approvals", parameters));
    }

    @Test
    public void testProcessWithRequiredVariable() throws Exception {
        this.ksession = this.createSessionAndRegisterWorkItemHandler("variable-tags/approval-with-required-variable-tags.bpmn2");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("approver", "john");
        ProcessInstance processInstance = this.ksession.startProcess("approvals", parameters);
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)this.workItemHandler);
        WorkItem workItem = this.workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = this.workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testProcessWithReadonlyVariable() throws Exception {
        this.ksession = this.createSessionAndRegisterWorkItemHandler("variable-tags/approval-with-readonly-variable-tags.bpmn2");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("approver", "john");
        ProcessInstance processInstance = this.ksession.startProcess("approvals", parameters);
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = this.workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assertions.assertThatExceptionOfType(VariableViolationException.class).isThrownBy(() -> this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), Collections.singletonMap("ActorId", "john")));
        this.ksession.abortProcessInstance(processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testProcessWithNullReadonlyVariable() throws Exception {
        this.ksession = this.createSessionAndRegisterWorkItemHandler("variable-tags/approval-with-readonly-variable-tags.bpmn2");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("approver", null);
        ProcessInstance processInstance = this.ksession.startProcess("approvals", parameters);
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = this.workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), Collections.singletonMap("ActorId", "john"));
        workItem = this.workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), Collections.singletonMap("ActorId", "john"));
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    private KieSession createSessionAndRegisterWorkItemHandler(String process) throws Exception {
        KieBase kbase = this.createKnowledgeBase(process);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        this.workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)this.workItemHandler);
        return ksession;
    }
}

