/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.util.IoUtils;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.handler.ReceiveTaskHandler;
import org.jbpm.bpmn2.handler.SendTaskHandler;
import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.jbpm.bpmn2.handler.SignallingTaskHandlerDecorator;
import org.jbpm.bpmn2.objects.ExceptionService;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.listener.NodeLeftCountDownProcessEventListener;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@RunWith(value=Parameterized.class)
public class StandaloneBPMNProcessTest
extends JbpmBpmn2TestCase {
    private static final Logger logger = LoggerFactory.getLogger(StandaloneBPMNProcessTest.class);

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false, false}, {true, false}, {true, true}};
        return Arrays.asList(data);
    }

    public StandaloneBPMNProcessTest(boolean persistence, boolean locking) {
        super(persistence, locking);
    }

    @BeforeClass
    public static void setup() throws Exception {
        StandaloneBPMNProcessTest.setUpDataSource();
    }

    @Test
    public void testMinimalProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Minimal");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testMinimalProcessWithGraphical() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcessWithGraphical.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Minimal");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testMinimalProcessWithDIGraphical() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MinimalProcessWithDIGraphical.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Minimal");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testCompositeProcessWithDIGraphical() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-CompositeProcessWithDIGraphical.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("Composite");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testScriptTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ScriptTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("ScriptTask");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testDataObject() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataObject.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = ksession.startProcess("Evaluation", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testEvaluationProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("RegisterRequest", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = ksession.startProcess("Evaluation", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testEvaluationProcess2() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess2.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = ksession.startProcess("com.sample.evaluation", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testEvaluationProcess3() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess3.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("RegisterRequest", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "john2");
        ProcessInstance processInstance = ksession.startProcess("Evaluation", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testUserTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-UserTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        String varId = "s";
        String varValue = "initialValue";
        params.put(varId, varValue);
        ProcessInstance processInstance = ksession.startProcess("UserTask", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        if (this.isPersistence()) {
            List varLogs = this.logService.findVariableInstancesByName(varId, true);
            StandaloneBPMNProcessTest.assertTrue((!varLogs.isEmpty() ? 1 : 0) != 0);
            for (VariableInstanceLog varLog : varLogs) {
                StandaloneBPMNProcessTest.assertEquals((Object)varId, (Object)varLog.getVariableId());
            }
            varLogs = this.logService.findVariableInstancesByNameAndValue(varId, varValue, true);
            StandaloneBPMNProcessTest.assertTrue((!varLogs.isEmpty() ? 1 : 0) != 0);
            for (VariableInstanceLog varLog : varLogs) {
                StandaloneBPMNProcessTest.assertEquals((Object)varId, (Object)varLog.getVariableId());
                StandaloneBPMNProcessTest.assertEquals((Object)varValue, (Object)varLog.getValue());
            }
        }
        ksession = this.restoreSession((KieSession)ksession, true);
        WorkItem workItem = workItemHandler.getWorkItem();
        StandaloneBPMNProcessTest.assertNotNull((Object)workItem);
        StandaloneBPMNProcessTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testLane() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-Lane.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        WorkItem workItem = workItemHandler.getWorkItem();
        StandaloneBPMNProcessTest.assertNotNull((Object)workItem);
        StandaloneBPMNProcessTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("ActorId", "mary");
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), results);
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        workItem = workItemHandler.getWorkItem();
        StandaloneBPMNProcessTest.assertNotNull((Object)workItem);
        StandaloneBPMNProcessTest.assertEquals((Object)"mary", (Object)workItem.getParameter("SwimlaneActorId"));
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testExclusiveSplit() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "First");
        params.put("y", "Second");
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testExclusiveSplitDefault() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitDefault.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "NotFirst");
        params.put("y", "Second");
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testInclusiveSplit() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testInclusiveSplitDefault() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitDefault.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", -5);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    @Test
    @Ignore
    public void testExclusiveSplitXPath() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitXPath.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<myDocument><chapter1>BlaBla</chapter1><chapter2>MoreBlaBla</chapter2></myDocument>".getBytes()));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("x", document);
        params.put("y", "SomeString");
        ProcessInstance processInstance = ksession.startProcess("com.sample.test", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testEventBasedSplit() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
        processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testEventBasedSplitBefore() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testEventBasedSplitAfter() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new DoNothingWorkItemHandler());
        ksession.signalEvent("No", (Object)"NoValue", processInstance.getId());
    }

    @Test(timeout=10000L)
    public void testEventBasedSplit2() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 2);
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit2.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        countDownListener.waitTillCompleted();
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    @Ignore(value="process does not complete")
    public void testEventBasedSplit3() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit3.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        Person jack = new Person();
        jack.setName("Jack");
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession((KieSession)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("Yes", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
        processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession((KieSession)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.insert((Object)jack);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testEventBasedSplit4() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit4.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.signalEvent("Message-YesMessage", (Object)"YesValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        processInstance = ksession.startProcess("com.sample.test");
        ksession.signalEvent("Message-NoMessage", (Object)"NoValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testEventBasedSplit5() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventBasedSplit5.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        ReceiveTaskHandler receiveTaskHandler = new ReceiveTaskHandler((KieSession)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        receiveTaskHandler.setKnowledgeRuntime((KieSession)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        receiveTaskHandler.messageReceived("YesMessage", (Object)"YesValue");
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
        receiveTaskHandler.messageReceived("NoMessage", (Object)"NoValue");
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Email1", (WorkItemHandler)new SystemOutWorkItemHandler());
        ksession.getWorkItemManager().registerWorkItemHandler("Email2", (WorkItemHandler)new SystemOutWorkItemHandler());
        receiveTaskHandler.setKnowledgeRuntime((KieSession)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        processInstance = ksession.startProcess("com.sample.test");
        receiveTaskHandler.messageReceived("NoMessage", (Object)"NoValue");
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
        receiveTaskHandler.messageReceived("YesMessage", (Object)"YesValue");
    }

    @Test
    public void testCallActivity() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivity.bpmn2"), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-CallActivitySubProcess.bpmn2"), ResourceType.BPMN2);
        if (!kbuilder.getErrors().isEmpty()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                logger.error("{}", (Object)error);
            }
            throw new IllegalArgumentException("Errors while parsing knowledge base");
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession((KieBase)kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        ProcessInstance processInstance = ksession.startProcess("ParentProcess", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
        StandaloneBPMNProcessTest.assertEquals((Object)"new value", (Object)((WorkflowProcessInstance)processInstance).getVariable("y"));
    }

    @Test
    public void testSubProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SubProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("SubProcess");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultiInstanceLoopCharacteristicsProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        ProcessInstance processInstance = ksession.startProcess("MultiInstanceLoopCharacteristicsProcess", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testErrorBoundaryEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ErrorBoundaryEventInterrupting.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("ErrorBoundaryEvent");
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test(timeout=10000L)
    public void testTimerBoundaryEvent() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("TimerEvent", 1);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventDuration.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("TimerBoundaryEvent");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test(timeout=10000L)
    public void testTimerBoundaryEventInterrupting() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("TimerEvent", 1);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerBoundaryEventInterrupting.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("TimerBoundaryEvent");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    @Ignore(value="Process does not complete.")
    public void testAdHocSubProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-AdHocSubProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("AdHocSubProcess");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        StandaloneBPMNProcessTest.assertNull((Object)workItem);
        ksession = this.restoreSession((KieSession)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.fireAllRules();
        ksession.signalEvent("Hello2", null, processInstance.getId());
        workItem = workItemHandler.getWorkItem();
        StandaloneBPMNProcessTest.assertNotNull((Object)workItem);
        ksession = this.restoreSession((KieSession)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    @Ignore(value="Process does not complete.")
    public void testAdHocSubProcessAutoComplete() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-AdHocSubProcessAutoComplete.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = ksession.startProcess("AdHocSubProcess");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        StandaloneBPMNProcessTest.assertNull((Object)workItem);
        ksession = this.restoreSession((KieSession)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.fireAllRules();
        workItem = workItemHandler.getWorkItem();
        StandaloneBPMNProcessTest.assertNotNull((String)"WorkItem should not be null.", (Object)workItem);
        ksession = this.restoreSession((KieSession)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testIntermediateCatchEventSignal() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventSignal.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.signalEvent("MyMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testIntermediateCatchEventMessage() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventMessage.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.signalEvent("Message-HelloMessage", (Object)"SomeValue", processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test(timeout=10000L)
    public void testIntermediateCatchEventTimer() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 1);
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventTimerDuration.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        countDownListener.waitTillCompleted();
        ksession = this.restoreSession((KieSession)ksession, true);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new DoNothingWorkItemHandler());
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    @Ignore(value="process does not complete")
    public void testIntermediateCatchEventCondition() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateCatchEventCondition.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession((KieSession)ksession);
        Person person = new Person();
        person.setName("Jack");
        ksession.insert((Object)person);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testErrorEndEventProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ErrorEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("ErrorEndEvent");
        this.assertProcessInstanceAborted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testServiceTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ServiceProcess.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("ServiceProcess", params);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
        StandaloneBPMNProcessTest.assertEquals((Object)"Hello john!", (Object)processInstance.getVariable("s"));
    }

    @Test
    public void testSendTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SendTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("SendTask", params);
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    public void testReceiveTask() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-ReceiveTask.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ReceiveTaskHandler receiveTaskHandler = new ReceiveTaskHandler((KieSession)ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("Receive Task", (WorkItemHandler)receiveTaskHandler);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("ReceiveTask");
        StandaloneBPMNProcessTest.assertEquals((long)1L, (long)processInstance.getState());
        ksession = this.restoreSession((KieSession)ksession);
        receiveTaskHandler.messageReceived("HelloMessage", (Object)"Hello john!");
        this.assertProcessInstanceCompleted(processInstance.getId(), (KieSession)ksession);
    }

    @Test
    @Ignore(value="bpmn does not compile")
    public void testConditionalStart() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ConditionalStart.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Person person = new Person();
        person.setName("jack");
        ksession.insert((Object)person);
        ksession.fireAllRules();
        person = new Person();
        person.setName("john");
        ksession.insert((Object)person);
        ksession.fireAllRules();
    }

    @Test(timeout=10000L)
    public void testTimerStart() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartProcess", 5);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerStart.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        StandaloneBPMNProcessTest.assertEquals((long)0L, (long)list.size());
        countDownListener.waitTillCompleted();
        StandaloneBPMNProcessTest.assertEquals((long)5L, (long)list.size());
    }

    @Test
    public void testSignalStart() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SignalStart.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        ksession.signalEvent("MySignal", (Object)"NewValue");
        StandaloneBPMNProcessTest.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testSignalEnd() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SignalEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ksession.startProcess("SignalEndEvent", params);
    }

    @Test
    public void testMessageStart() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MessageStart.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        ksession.signalEvent("Message-HelloMessage", (Object)"NewValue");
        StandaloneBPMNProcessTest.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testMessageEnd() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MessageEndEvent.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = ksession.startProcess("MessageEndEvent", params);
        StandaloneBPMNProcessTest.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testMessageIntermediateThrow() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventMessage.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Send Task", (WorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = ksession.startProcess("MessageIntermediateEvent", params);
        StandaloneBPMNProcessTest.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testSignalIntermediateThrow() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventSignal.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        ProcessInstance processInstance = ksession.startProcess("SignalIntermediateEvent", params);
        StandaloneBPMNProcessTest.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testNoneIntermediateThrow() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-IntermediateThrowEventNone.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("NoneIntermediateEvent", null);
        StandaloneBPMNProcessTest.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testErrorSignallingExceptionServiceTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExceptionServiceProcess-ErrorSignalling.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        StandaloneBPMNProcessTest.runTestErrorSignallingExceptionServiceTask((KieSession)ksession);
    }

    public static void runTestErrorSignallingExceptionServiceTask(KieSession ksession) throws Exception {
        String eventType = "Error-code";
        SignallingTaskHandlerDecorator signallingTaskWrapper = new SignallingTaskHandlerDecorator(ServiceTaskHandler.class, eventType);
        signallingTaskWrapper.setWorkItemExceptionParameterName(ExceptionService.exceptionParameterName);
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)signallingTaskWrapper);
        Object[] caughtEventObjectHolder = new Object[]{null};
        ExceptionService.setCaughtEventObjectHolder(caughtEventObjectHolder);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        String input = "this is my service input";
        params.put("serviceInputItem", input);
        ProcessInstance processInstance = ksession.startProcess("ServiceProcess", params);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        StandaloneBPMNProcessTest.assertNotNull((Object)workItem);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        StandaloneBPMNProcessTest.assertTrue((String)"Event was not passed to Event Subprocess", (caughtEventObjectHolder[0] != null && caughtEventObjectHolder[0] instanceof WorkItem ? 1 : 0) != 0);
        workItem = (WorkItem)caughtEventObjectHolder[0];
        Object throwObj = workItem.getParameter(ExceptionService.exceptionParameterName);
        StandaloneBPMNProcessTest.assertTrue((String)"WorkItem doesn't contain Throwable", (boolean)(throwObj instanceof Throwable));
        StandaloneBPMNProcessTest.assertTrue((String)"Exception message does not match service input.", (boolean)((Throwable)throwObj).getMessage().endsWith(input));
        processInstance = ksession.getProcessInstance(processInstance.getId());
        StandaloneBPMNProcessTest.assertTrue((String)"Process instance has not been aborted.", (processInstance == null || processInstance.getState() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testSignallingExceptionServiceTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExceptionServiceProcess-Signalling.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        StandaloneBPMNProcessTest.runTestSignallingExceptionServiceTask((KieSession)ksession);
    }

    @Test
    public void testXXEProcessVulnerability() throws Exception {
        Resource processResource = ResourceFactory.newClassPathResource((String)"xxe-protection/BPMN2-XXE-Process.bpmn2");
        File dtdFile = new File("src/test/resources/xxe-protection/external.dtd");
        StandaloneBPMNProcessTest.assertTrue((boolean)dtdFile.exists());
        String dtdContent = IoUtils.readFileAsString((File)dtdFile);
        dtdContent = dtdContent.replaceAll("@@PATH@@", dtdFile.getParentFile().getAbsolutePath());
        IoUtils.write((File)dtdFile, (byte[])dtdContent.getBytes("UTF-8"));
        byte[] data = IoUtils.readBytesFromInputStream((InputStream)processResource.getInputStream());
        String processAsString = new String(data, "UTF-8");
        File testFiles = new File("src/test/resources/xxe-protection");
        StandaloneBPMNProcessTest.assertTrue((boolean)testFiles.exists());
        String path = testFiles.getAbsolutePath();
        processAsString = processAsString.replaceAll("@@PATH@@", path);
        Resource resource = ResourceFactory.newReaderResource((Reader)new StringReader(processAsString));
        resource.setSourcePath(processResource.getSourcePath());
        resource.setTargetPath(processResource.getTargetPath());
        KieBase kbase = this.createKnowledgeBaseFromResources(resource);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("async-examples.bp1");
        String var1 = this.getProcessVarValue(processInstance, "testScript1");
        String var2 = this.getProcessVarValue(processInstance, "testScript2");
        StandaloneBPMNProcessTest.assertNull((Object)var1);
        StandaloneBPMNProcessTest.assertNull((Object)var2);
        StandaloneBPMNProcessTest.assertTrue((processInstance.getState() == 2 ? 1 : 0) != 0);
    }

    public static void runTestSignallingExceptionServiceTask(KieSession ksession) throws Exception {
        String eventType = "exception-signal";
        SignallingTaskHandlerDecorator signallingTaskWrapper = new SignallingTaskHandlerDecorator(ServiceTaskHandler.class, eventType);
        signallingTaskWrapper.setWorkItemExceptionParameterName(ExceptionService.exceptionParameterName);
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)signallingTaskWrapper);
        Object[] caughtEventObjectHolder = new Object[]{null};
        ExceptionService.setCaughtEventObjectHolder(caughtEventObjectHolder);
        HashMap<String, String> params = new HashMap<String, String>();
        String input = "this is my service input";
        params.put("serviceInputItem", input);
        ProcessInstance processInstance = ksession.startProcess("ServiceProcess", params);
        StandaloneBPMNProcessTest.assertTrue((String)"Event was not passed to Event Subprocess", (caughtEventObjectHolder[0] != null && caughtEventObjectHolder[0] instanceof WorkItem ? 1 : 0) != 0);
        WorkItem workItem = (WorkItem)caughtEventObjectHolder[0];
        Object throwObj = workItem.getParameter(ExceptionService.exceptionParameterName);
        StandaloneBPMNProcessTest.assertTrue((String)"WorkItem doesn't contain Throwable", (boolean)(throwObj instanceof Throwable));
        StandaloneBPMNProcessTest.assertTrue((String)"Exception message does not match service input.", (boolean)((Throwable)throwObj).getMessage().endsWith(input));
        StandaloneBPMNProcessTest.assertEquals((String)"Process instance is not active.", (long)1L, (long)processInstance.getState());
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        if (processInstance != null) {
            StandaloneBPMNProcessTest.assertEquals((String)"Process instance is not completed.", (long)2L, (long)processInstance.getState());
        }
    }
}

