/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.persistence;

import java.util.ArrayList;
import org.drools.core.command.SingleSessionCommandService;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.process.audit.AuditLoggerFactory;
import org.jbpm.process.instance.event.listeners.TriggerRulesEventListener;
import org.jbpm.test.listener.NodeLeftCountDownProcessEventListener;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerCycleOnBinaryPackageTest
extends JbpmBpmn2TestCase {
    private static final Logger logger = LoggerFactory.getLogger(TimerCycleOnBinaryPackageTest.class);
    private StatefulKnowledgeSession ksession;

    public TimerCycleOnBinaryPackageTest() {
        super(true);
    }

    @BeforeClass
    public static void setup() throws Exception {
        TimerCycleOnBinaryPackageTest.setUpDataSource();
    }

    @Before
    public void prepare() {
        this.clearHistory();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testStartTimerCycleFromDisc() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("start", 2);
        KieBase kbase = this.createKnowledgeBaseFromDisc("BPMN2-StartTimerCycle.bpmn2");
        try {
            StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
            ksession.addEventListener((ProcessEventListener)countDownListener);
            TimerCycleOnBinaryPackageTest.assertEquals((long)0L, (long)this.getNumberOfProcessInstances("defaultPackage.TimerProcess"));
            long sessionId = ksession.getIdentifier();
            Environment env = ksession.getEnvironment();
            final ArrayList list = new ArrayList();
            ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

                public void beforeProcessStarted(ProcessStartedEvent event) {
                    list.add(event.getProcessInstance().getId());
                }
            });
            ((SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getRunner()).getKieSession().addEventListener((AgendaEventListener)new TriggerRulesEventListener((KieSession)ksession));
            countDownListener.waitTillCompleted();
            TimerCycleOnBinaryPackageTest.assertEquals((long)2L, (long)this.getNumberOfProcessInstances("defaultPackage.TimerProcess"));
            logger.info("dispose");
            ksession.dispose();
            countDownListener = new NodeLeftCountDownProcessEventListener("start", 2);
            ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)sessionId, (KieBase)kbase, null, (Environment)env);
            ksession.addEventListener((ProcessEventListener)countDownListener);
            AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)ksession, null);
            final ArrayList list2 = new ArrayList();
            ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

                public void beforeProcessStarted(ProcessStartedEvent event) {
                    list2.add(event.getProcessInstance().getId());
                }
            });
            ((SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getRunner()).getKieSession().addEventListener((AgendaEventListener)new TriggerRulesEventListener((KieSession)ksession));
            countDownListener.waitTillCompleted();
            TimerCycleOnBinaryPackageTest.assertEquals((long)4L, (long)this.getNumberOfProcessInstances("defaultPackage.TimerProcess"));
            this.abortProcessInstances((KieSession)ksession);
            ksession.dispose();
        }
        finally {
            this.ksession = this.createKnowledgeSession(kbase);
            this.abortProcessInstances((KieSession)this.ksession);
            this.ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testStartTimerCycleFromClassPath() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("start", 2);
        KieBase kbase = this.createKnowledgeBase("BPMN2-StartTimerCycle.bpmn2");
        try {
            StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
            ksession.addEventListener((ProcessEventListener)countDownListener);
            TimerCycleOnBinaryPackageTest.assertEquals((long)0L, (long)this.getNumberOfProcessInstances("defaultPackage.TimerProcess"));
            long sessionId = ksession.getIdentifier();
            Environment env = ksession.getEnvironment();
            final ArrayList list = new ArrayList();
            ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

                public void beforeProcessStarted(ProcessStartedEvent event) {
                    list.add(event.getProcessInstance().getId());
                }
            });
            ((SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getRunner()).getKieSession().addEventListener((AgendaEventListener)new TriggerRulesEventListener((KieSession)ksession));
            countDownListener.waitTillCompleted();
            TimerCycleOnBinaryPackageTest.assertEquals((long)2L, (long)this.getNumberOfProcessInstances("defaultPackage.TimerProcess"));
            logger.info("dispose");
            ksession.dispose();
            countDownListener = new NodeLeftCountDownProcessEventListener("start", 2);
            ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)sessionId, (KieBase)kbase, null, (Environment)env);
            ksession.addEventListener((ProcessEventListener)countDownListener);
            AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)ksession, null);
            final ArrayList list2 = new ArrayList();
            ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

                public void beforeProcessStarted(ProcessStartedEvent event) {
                    list2.add(event.getProcessInstance().getId());
                }
            });
            ((SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getRunner()).getKieSession().addEventListener((AgendaEventListener)new TriggerRulesEventListener((KieSession)ksession));
            countDownListener.waitTillCompleted();
            ksession.dispose();
            TimerCycleOnBinaryPackageTest.assertEquals((long)4L, (long)this.getNumberOfProcessInstances("defaultPackage.TimerProcess"));
        }
        finally {
            this.ksession = this.createKnowledgeSession(kbase);
            this.abortProcessInstances((KieSession)this.ksession);
            this.ksession.dispose();
        }
    }

    @Test
    @Ignore(value="beta4 phreak")
    public void testStartTimerCycleFromDiscDRL() throws Exception {
        KieBase kbase = this.createKnowledgeBaseFromDisc("rules-timer.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        long sessionId = ksession.getIdentifier();
        Environment env = ksession.getEnvironment();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ((SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getRunner()).getKieSession().addEventListener((AgendaEventListener)new TriggerRulesEventListener((KieSession)ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        TimerCycleOnBinaryPackageTest.assertEquals((long)2L, (long)list.size());
        logger.info("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)sessionId, (KieBase)kbase, null, (Environment)env);
        AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)ksession, null);
        ArrayList list2 = new ArrayList();
        ksession.setGlobal("list", list2);
        ((SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getRunner()).getKieSession().addEventListener((AgendaEventListener)new TriggerRulesEventListener((KieSession)ksession));
        ksession.fireAllRules();
        Thread.sleep(6000L);
        TimerCycleOnBinaryPackageTest.assertEquals((long)3L, (long)list2.size());
    }

    @Test
    @Ignore(value="beta4 phreak")
    public void testStartTimerCycleFromClasspathDRL() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("rules-timer.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        long sessionId = ksession.getIdentifier();
        Environment env = ksession.getEnvironment();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ((SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getRunner()).getKieSession().addEventListener((AgendaEventListener)new TriggerRulesEventListener((KieSession)ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        TimerCycleOnBinaryPackageTest.assertEquals((long)2L, (long)list.size());
        logger.info("dispose");
        ksession.dispose();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)sessionId, (KieBase)kbase, null, (Environment)env);
        AuditLoggerFactory.newInstance((AuditLoggerFactory.Type)AuditLoggerFactory.Type.JPA, (KieSession)ksession, null);
        ArrayList list2 = new ArrayList();
        ksession.setGlobal("list", list2);
        ((SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getRunner()).getKieSession().addEventListener((AgendaEventListener)new TriggerRulesEventListener((KieSession)ksession));
        ksession.fireAllRules();
        Thread.sleep(5000L);
        TimerCycleOnBinaryPackageTest.assertEquals((long)3L, (long)list2.size());
    }
}

