/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.ElementNameAndAttributeQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLTestCase;
import org.custommonkey.xmlunit.XMLUnit;
import org.drools.core.xml.SemanticModule;
import org.drools.core.xml.SemanticModules;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.kie.api.definition.process.WorkflowProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BPMN2XMLTest
extends XMLTestCase {
    private static final Logger logger = LoggerFactory.getLogger(BPMN2XMLTest.class);
    private static final String[] processes = new String[]{"BPMN2-SimpleXMLProcess.bpmn2"};
    private String errorMessage;

    public void setUp() throws Exception {
        super.setUp();
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
        this.setErrorMessage(null);
    }

    public void testXML() throws IOException, SAXException {
        SemanticModules modules = new SemanticModules();
        modules.addSemanticModule((SemanticModule)new BPMNSemanticModule());
        modules.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        XmlProcessReader processReader = new XmlProcessReader(modules, ((Object)((Object)this)).getClass().getClassLoader());
        for (String processName : processes) {
            String original = BPMN2XMLTest.slurp(BPMN2XMLTest.class.getResourceAsStream("/" + processName));
            List processes = processReader.read(BPMN2XMLTest.class.getResourceAsStream("/" + processName));
            BPMN2XMLTest.assertNotNull((Object)processes);
            BPMN2XMLTest.assertEquals((int)1, (int)processes.size());
            RuleFlowProcess p = (RuleFlowProcess)processes.get(0);
            String result = XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)p, 2);
            Diff diff = new Diff(original, result);
            final HashSet<String> sequenceDoesNotMatter = new HashSet<String>();
            sequenceDoesNotMatter.add("startEvent");
            sequenceDoesNotMatter.add("scriptTask");
            sequenceDoesNotMatter.add("endEvent");
            sequenceDoesNotMatter.add("bpmndi:BPMNShape");
            diff.overrideDifferenceListener(new DifferenceListener(){

                public int differenceFound(Difference diff) {
                    String nodeName = diff.getTestNodeDetail().getNode().getNodeName();
                    if (sequenceDoesNotMatter.contains(nodeName) && diff.getId() == 20) {
                        return 1;
                    }
                    logger.info("! {}", (Object)diff.getTestNodeDetail().getNode().getNodeName());
                    return 0;
                }

                public void skippedComparison(Node one, Node two) {
                    logger.info("{} : {}", (Object)one.getLocalName(), (Object)two.getLocalName());
                }
            });
            diff.overrideElementQualifier((ElementQualifier)new ElementNameAndAttributeQualifier());
            BPMN2XMLTest.assertTrue((String)"Original and generated output is not the same.", (boolean)diff.identical());
        }
    }

    public void testInvalidXML() throws Exception, SAXException {
        SemanticModules modules = new SemanticModules();
        modules.addSemanticModule((SemanticModule)new BPMNSemanticModule());
        modules.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        XmlProcessReader processReader = new XmlProcessReader(modules, ((Object)((Object)this)).getClass().getClassLoader()){

            protected String processParserMessage(LinkedList<Object> parents, Attributes attr, String errorMessage) {
                BPMN2XMLTest.this.setErrorMessage(super.processParserMessage(parents, attr, errorMessage));
                return errorMessage;
            }
        };
        processReader.read(BPMN2XMLTest.class.getResourceAsStream("/BPMN2-XMLProcessWithError.bpmn2"));
        BPMN2XMLTest.assertNotNull((Object)this.getErrorMessage());
        BPMN2XMLTest.assertEquals((String)"Process Info: id:error.process, pkg:org.jbpm, name:errorprocess, version:1.0 \nNode Info: id:_F8A89567-7416-4CCA-9CCD-BC1DDE870F1E name: \nParser message: (null: 45, 181): cvc-complex-type.2.4.a: Invalid content was found starting with element 'bpmn2:endEvent'. One of '{\"http://www.omg.org/spec/BPMN/20100524/MODEL\":artifact, \"http://www.omg.org/spec/BPMN/20100524/MODEL\":resourceRole, \"http://www.omg.org/spec/BPMN/20100524/MODEL\":correlationSubscription, \"http://www.omg.org/spec/BPMN/20100524/MODEL\":supports}' is expected.", (String)this.getErrorMessage());
    }

    public void testInvalidXMLInCompositeNode() throws Exception, SAXException {
        SemanticModules modules = new SemanticModules();
        modules.addSemanticModule((SemanticModule)new BPMNSemanticModule());
        modules.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        XmlProcessReader processReader = new XmlProcessReader(modules, ((Object)((Object)this)).getClass().getClassLoader()){

            protected String processParserMessage(LinkedList<Object> parents, Attributes attr, String errorMessage) {
                BPMN2XMLTest.this.setErrorMessage(super.processParserMessage(parents, attr, errorMessage));
                return errorMessage;
            }
        };
        processReader.read(BPMN2XMLTest.class.getResourceAsStream("/BPMN2-XMLProcessWithErrorInCompositeNode.bpmn2"));
        BPMN2XMLTest.assertNotNull((Object)this.getErrorMessage());
        BPMN2XMLTest.assertEquals((String)"Process Info: id:abc.abc, pkg:org.drools.bpmn2, name:abc, version:1.0 \nNode Info: id:_47489F3D-FEBD-4452-B62E-B04EF191C6C3 name: \nParser message: (null: 24, 185): cvc-complex-type.2.4.a: Invalid content was found starting with element 'bpmn2:subProcess'. One of '{\"http://www.omg.org/spec/BPMN/20100524/MODEL\":artifact}' is expected.", (String)this.getErrorMessage());
    }

    private void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    private String getErrorMessage() {
        return this.errorMessage;
    }

    public static String slurp(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }
}

