/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.drools.core.util.IoUtils;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.NotAvailableGoodsReport;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.test.listener.NodeLeftCountDownProcessEventListener;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieRepository;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class StartEventTest
extends JbpmBpmn2TestCase {
    private static final Logger logger = LoggerFactory.getLogger(StartEventTest.class);
    private KieSession ksession;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public StartEventTest(boolean persistence) {
        super(persistence);
    }

    @BeforeClass
    public static void setup() throws Exception {
        StartEventTest.setUpDataSource();
    }

    @Before
    public void prepare() {
        this.clearHistory();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testConditionalStart() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-ConditionalStart.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        Person person = new Person();
        person.setName("jack");
        this.ksession.insert((Object)person);
        person = new Person();
        person.setName("john");
        this.ksession.insert((Object)person);
    }

    @Test(timeout=10000L)
    public void testTimerStartCycleLegacy() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartProcess", 5);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerStartCycleLegacy.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        logger.debug("About to start ###### " + new Date());
        StartEventTest.assertEquals((long)0L, (long)list.size());
        countDownListener.waitTillCompleted();
        this.ksession.dispose();
        StartEventTest.assertEquals((long)5L, (long)this.getNumberOfProcessInstances("Minimal"));
    }

    @Test(timeout=10000L)
    public void testTimerStart() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartProcess", 5);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerStart.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        StartEventTest.assertEquals((long)0L, (long)list.size());
        countDownListener.waitTillCompleted();
        StartEventTest.assertEquals((long)5L, (long)this.getNumberOfProcessInstances("Minimal"));
    }

    @Test(timeout=10000L)
    public void testTimerStartDateISO() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartProcess", 1);
        byte[] content = IoUtils.readBytesFromInputStream((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/BPMN2-TimerStartDate.bpmn2"));
        String processContent = new String(content, "UTF-8");
        OffsetDateTime plusTwoSeconds = OffsetDateTime.now().plusSeconds(2L);
        processContent = processContent.replaceFirst("#\\{date\\}", plusTwoSeconds.toString());
        Resource resource = ResourceFactory.newReaderResource((Reader)new StringReader(processContent));
        resource.setSourcePath("/BPMN2-TimerStartDate.bpmn2");
        resource.setTargetPath("/BPMN2-TimerStartDate.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(resource);
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        StartEventTest.assertEquals((long)0L, (long)list.size());
        countDownListener.waitTillCompleted();
        StartEventTest.assertEquals((long)1L, (long)list.size());
    }

    @Test(timeout=10000L)
    public void testTimerStartCycleISO() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartProcess", 6);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerStartISO.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        StartEventTest.assertEquals((long)0L, (long)list.size());
        countDownListener.waitTillCompleted();
        StartEventTest.assertEquals((long)6L, (long)this.getNumberOfProcessInstances("Minimal"));
    }

    @Test(timeout=10000L)
    public void testTimerStartDuration() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartProcess", 1);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerStartDuration.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        StartEventTest.assertEquals((long)0L, (long)list.size());
        countDownListener.waitTillCompleted();
        StartEventTest.assertEquals((long)1L, (long)this.getNumberOfProcessInstances("Minimal"));
    }

    @Test(timeout=10000L)
    public void testTimerStartCron() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartProcess", 5);
        KieBase kbase = this.createKnowledgeBase("BPMN2-TimerStartCron.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        countDownListener.waitTillCompleted();
        StartEventTest.assertEquals((long)5L, (long)this.getNumberOfProcessInstances("Minimal"));
    }

    @Test
    public void testSignalToStartProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SignalStart.bpmn2", "BPMN2-IntermediateThrowEventSignal.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        final ArrayList startedProcesses = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                startedProcesses.add(event.getProcessInstance().getProcessId());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("SignalIntermediateEvent");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        StartEventTest.assertEquals((long)1L, (long)this.getNumberOfProcessInstances("Minimal"));
        StartEventTest.assertEquals((long)1L, (long)this.getNumberOfProcessInstances("SignalIntermediateEvent"));
    }

    @Test
    public void testSignalStart() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SignalStart.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        this.ksession.signalEvent("MySignal", (Object)"NewValue");
        StartEventTest.assertEquals((long)1L, (long)this.getNumberOfProcessInstances("Minimal"));
    }

    @Test
    public void testSignalStartDynamic() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SignalStart.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        KieContainer kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        kContainer.getKieBase();
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                logger.info("{}", (Object)event.getProcessInstance().getId());
                list.add(event.getProcessInstance().getId());
            }
        });
        this.ksession.signalEvent("MySignal", (Object)"NewValue");
        StartEventTest.assertEquals((long)1L, (long)this.getNumberOfProcessInstances("Minimal"));
        kbase.removeProcess("Minimal");
        try {
            this.ksession.signalEvent("MySignal", (Object)"NewValue");
        }
        catch (IllegalArgumentException e) {
            StartEventTest.assertEquals((Object)"Unknown process ID: Minimal", (Object)e.getMessage());
        }
        StartEventTest.assertEquals((long)1L, (long)this.getNumberOfProcessInstances("Minimal"));
    }

    @Test
    public void testMessageStart() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MessageStart.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.signalEvent("Message-HelloMessage", (Object)"NewValue");
        StartEventTest.assertEquals((long)1L, (long)this.getNumberOfProcessInstances("Minimal"));
    }

    @Test
    public void testMultipleStartEventsRegularStart() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleStartEventProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("MultipleStartEvents");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        WorkItem workItem = workItemHandler.getWorkItem();
        StartEventTest.assertNotNull((Object)workItem);
        StartEventTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testMultipleStartEventsStartOnTimer() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartTimer", 5);
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleStartEventProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        try {
            this.ksession.addEventListener((ProcessEventListener)countDownListener);
            TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
            this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
            final ArrayList list = new ArrayList();
            this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

                public void beforeProcessStarted(ProcessStartedEvent event) {
                    list.add(event.getProcessInstance().getId());
                }
            });
            StartEventTest.assertEquals((long)0L, (long)list.size());
            countDownListener.waitTillCompleted();
            StartEventTest.assertEquals((long)5L, (long)this.getNumberOfProcessInstances("MultipleStartEvents"));
        }
        finally {
            this.abortProcessInstances(this.ksession);
        }
    }

    @Test
    public void testMultipleEventBasedStartEventsSignalStart() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleEventBasedStartEventProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        this.ksession.signalEvent("startSignal", null);
        StartEventTest.assertEquals((long)1L, (long)list.size());
        WorkItem workItem = workItemHandler.getWorkItem();
        long processInstanceId = ((WorkItemImpl)workItem).getProcessInstanceId();
        ProcessInstance processInstance = this.ksession.getProcessInstance(processInstanceId);
        this.ksession = this.restoreSession(this.ksession, true);
        StartEventTest.assertNotNull((Object)workItem);
        StartEventTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testMultipleEventBasedStartEventsDifferentPaths() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleStartEventProcessDifferentPaths.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        this.ksession.startProcess("muliplestartevents", null);
        StartEventTest.assertEquals((long)1L, (long)list.size());
        WorkItem workItem = workItemHandler.getWorkItem();
        long processInstanceId = ((WorkItemImpl)workItem).getProcessInstanceId();
        ProcessInstance processInstance = this.ksession.getProcessInstance(processInstanceId);
        this.ksession = this.restoreSession(this.ksession, true);
        StartEventTest.assertNotNull((Object)workItem);
        StartEventTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstanceId, "Start", "Script 1", "User task", "End");
    }

    @Test(timeout=10000L)
    public void testMultipleEventBasedStartEventsTimerDifferentPaths() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartTimer", 2);
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleStartEventProcessDifferentPaths.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        StartEventTest.assertEquals((long)0L, (long)list.size());
        countDownListener.waitTillCompleted();
        StartEventTest.assertEquals((long)2L, (long)list.size());
        List<WorkItem> workItems = workItemHandler.getWorkItems();
        for (WorkItem workItem : workItems) {
            long processInstanceId = ((WorkItemImpl)workItem).getProcessInstanceId();
            ProcessInstance processInstance = this.ksession.getProcessInstance(processInstanceId);
            this.ksession = this.restoreSession(this.ksession, true);
            StartEventTest.assertNotNull((Object)workItem);
            StartEventTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
            this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
            this.assertProcessInstanceFinished(processInstance, this.ksession);
            this.assertNodeTriggered(processInstanceId, "StartTimer", "Script 2", "User task", "End");
        }
    }

    @Test
    public void testMultipleEventBasedStartEventsSignalDifferentPaths() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleStartEventProcessDifferentPaths.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        this.ksession.signalEvent("startSignal", null);
        StartEventTest.assertEquals((long)1L, (long)list.size());
        WorkItem workItem = workItemHandler.getWorkItem();
        long processInstanceId = ((WorkItemImpl)workItem).getProcessInstanceId();
        ProcessInstance processInstance = this.ksession.getProcessInstance(processInstanceId);
        this.ksession = this.restoreSession(this.ksession, true);
        StartEventTest.assertNotNull((Object)workItem);
        StartEventTest.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstanceId, "StartSignal", "Script 3", "User task", "End");
    }

    @Test(timeout=10000L)
    public void testMultipleEventBasedStartEventsStartOnTimer() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartTimer", 5);
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleEventBasedStartEventProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        StartEventTest.assertEquals((long)0L, (long)list.size());
        countDownListener.waitTillCompleted();
        StartEventTest.assertEquals((long)5L, (long)this.getNumberOfProcessInstances("MultipleStartEvents"));
    }

    @Test(timeout=10000L)
    public void testTimerCycle() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("start", 5);
        KieBase kbase = this.createKnowledgeBase("timer/BPMN2-StartTimerCycle.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        StartCountingListener listener = new StartCountingListener();
        this.ksession.addEventListener((ProcessEventListener)listener);
        countDownListener.waitTillCompleted();
        StartEventTest.assertEquals((long)5L, (long)listener.getCount("start.cycle"));
    }

    @Test(timeout=10000L)
    public void testSignalStartWithTransformation() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartProcess", 1);
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-SignalStartWithTransformation.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance());
            }
        });
        this.ksession.signalEvent("MySignal", (Object)"NewValue");
        countDownListener.waitTillCompleted();
        StartEventTest.assertEquals((long)1L, (long)this.getNumberOfProcessInstances("Minimal"));
        StartEventTest.assertNotNull(list);
        StartEventTest.assertEquals((long)1L, (long)list.size());
        String var = this.getProcessVarValue((ProcessInstance)list.get(0), "x");
        StartEventTest.assertEquals((Object)"NEWVALUE", (Object)var);
    }

    @Test(timeout=10000L)
    public void testTimerDelay() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("start", 1);
        KieBase kbase = this.createKnowledgeBase("timer/BPMN2-StartTimerDuration.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        StartCountingListener listener = new StartCountingListener();
        this.ksession.addEventListener((ProcessEventListener)listener);
        countDownListener.waitTillCompleted();
        StartEventTest.assertEquals((long)1L, (long)listener.getCount("start.delaying"));
    }

    @Test
    public void testSignalStartWithCustomEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-SingalStartWithCustomEvent.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance());
            }
        });
        NotAvailableGoodsReport report = new NotAvailableGoodsReport("test");
        this.ksession.signalEvent("SignalNotAvailableGoods", (Object)report);
        StartEventTest.assertEquals((long)1L, (long)this.getNumberOfProcessInstances("org.jbpm.example.SignalObjectProcess"));
        StartEventTest.assertEquals((long)1L, (long)list.size());
        this.assertProcessVarValue((ProcessInstance)list.get(0), "report", "NotAvailableGoodsReport{type:test}");
    }

    @Test
    public void testInvalidDateTimerStart() throws Exception {
        try {
            this.createKnowledgeBase("timer/BPMN2-StartTimerDateInvalid.bpmn2");
            StartEventTest.fail((String)"Should fail as timer expression is not valid");
        }
        catch (RuntimeException e) {
            StartEventTest.assertTrue((boolean)e.getMessage().contains("Could not parse date 'abcdef'"));
        }
    }

    @Test
    public void testInvalidDurationTimerStart() throws Exception {
        try {
            this.createKnowledgeBase("timer/BPMN2-StartTimerDurationInvalid.bpmn2");
            StartEventTest.fail((String)"Should fail as timer expression is not valid");
        }
        catch (Exception e) {
            StartEventTest.assertTrue((boolean)e.getMessage().contains("Could not parse delay 'abcdef'"));
        }
    }

    @Test
    public void testInvalidCycleTimerStart() throws Exception {
        try {
            this.createKnowledgeBase("timer/BPMN2-StartTimerCycleInvalid.bpmn2");
            StartEventTest.fail((String)"Should fail as timer expression is not valid");
        }
        catch (Exception e) {
            StartEventTest.assertTrue((boolean)e.getMessage().contains("Could not parse delay 'abcdef'"));
        }
    }

    private static class StartCountingListener
    extends DefaultProcessEventListener {
        private Map<String, Integer> map = new HashMap<String, Integer>();

        private StartCountingListener() {
        }

        public void beforeProcessStarted(ProcessStartedEvent event) {
            String processId = event.getProcessInstance().getProcessId();
            Integer count = this.map.get(processId);
            if (count == null) {
                this.map.put(processId, 1);
            } else {
                this.map.put(processId, count + 1);
            }
        }

        public int getCount(String processId) {
            Integer count = this.map.get(processId);
            return count == null ? 0 : count;
        }
    }
}

