/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.concurrency;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.jbpm.bpmn2.objects.Status;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class MultipleProcessesPerThreadTest
extends AbstractBaseTest {
    private static final int LOOPS = 1000;
    private static final Logger logger = LoggerFactory.getLogger(MultipleProcessesPerThreadTest.class);

    protected static KieSession createStatefulKnowledgeSession(KieBase kbase) {
        return kbase.newKieSession();
    }

    @Test
    public void doMultipleProcessesInMultipleThreads() {
        HelloWorldProcessThread hello = new HelloWorldProcessThread();
        UserTaskProcessThread user = new UserTaskProcessThread();
        hello.start();
        user.start();
        try {
            hello.join();
            user.join();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Assert.assertTrue((String)"Hello World process thread did not complete successfully", (hello.status == Status.SUCCESS ? 1 : 0) != 0);
        Assert.assertTrue((String)"User Task process thread did not complete successfully", (user.status == Status.SUCCESS ? 1 : 0) != 0);
    }

    private static class CompleteProcessListener
    implements ProcessEventListener {
        private volatile CountDownLatch guard;

        public CompleteProcessListener(CountDownLatch guard) {
            this.guard = guard;
        }

        public void beforeProcessStarted(ProcessStartedEvent event) {
        }

        public void afterProcessStarted(ProcessStartedEvent event) {
        }

        public void beforeProcessCompleted(ProcessCompletedEvent event) {
        }

        public void afterProcessCompleted(ProcessCompletedEvent event) {
            this.guard.countDown();
        }

        public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        }

        public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
        }

        public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        }

        public void afterNodeLeft(ProcessNodeLeftEvent event) {
        }

        public void beforeVariableChanged(ProcessVariableChangedEvent event) {
        }

        public void afterVariableChanged(ProcessVariableChangedEvent event) {
        }
    }

    private static class UserTaskProcessThread
    implements Runnable {
        private Thread thread;
        volatile Status status;
        private volatile CountDownLatch latch;

        private UserTaskProcessThread() {
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        @Override
        public void run() {
            this.status = Status.SUCCESS;
            KieSession ksession = null;
            try {
                KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
                kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-MultiThreadServiceProcess-Task.bpmn", this.getClass()), ResourceType.BPMN2);
                InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
                kbase.addPackages(kbuilder.getKnowledgePackages());
                ksession = MultipleProcessesPerThreadTest.createStatefulKnowledgeSession((KieBase)kbase);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Unable to set up knowlede base or session.", (Throwable)e);
                this.status = Status.FAIL;
            }
            TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
            ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
            for (int i = 1; i <= 1000; ++i) {
                logger.debug("Starting user task process, loop {}/{}", (Object)i, (Object)1000);
                this.latch = new CountDownLatch(1);
                CompleteProcessListener listener = new CompleteProcessListener(this.latch);
                ksession.addEventListener((ProcessEventListener)listener);
                try {
                    ksession.startProcess("user-task");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                List<Object> items = new ArrayList();
                items = workItemHandler.getWorkItems();
                for (WorkItem workItem : items) {
                    try {
                        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                try {
                    this.latch.await();
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        public synchronized void join() throws InterruptedException {
            this.thread.join();
        }
    }

    private static class HelloWorldProcessThread
    implements Runnable {
        private Thread thread;
        volatile Status status;
        private volatile CountDownLatch latch;

        private HelloWorldProcessThread() {
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        @Override
        public void run() {
            this.status = Status.SUCCESS;
            KieSession ksession = null;
            try {
                KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
                kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-MultiThreadServiceProcess-Timer.bpmn", this.getClass()), ResourceType.BPMN2);
                InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
                kbase.addPackages(kbuilder.getKnowledgePackages());
                ksession = MultipleProcessesPerThreadTest.createStatefulKnowledgeSession((KieBase)kbase);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Unable to set up knowlede base or session.", (Throwable)e);
                this.status = Status.FAIL;
            }
            for (int i = 1; i <= 1000; ++i) {
                logger.debug("Starting hello world process, loop {}/{}", (Object)i, (Object)1000);
                this.latch = new CountDownLatch(1);
                CompleteProcessListener listener = new CompleteProcessListener(this.latch);
                ksession.addEventListener((ProcessEventListener)listener);
                try {
                    ksession.startProcess("hello-world");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                try {
                    this.latch.await();
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        public synchronized void join() throws InterruptedException {
            this.thread.join();
        }
    }
}

