/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.persistence.session.objects.TestWorkItemHandler;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.jbpm.test.listener.NodeLeftCountDownProcessEventListener;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.io.Resource;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ProcessFactoryTest
extends JbpmBpmn2TestCase {
    public ProcessFactoryTest() {
        super(false);
    }

    @Test
    public void testProcessFactory() throws Exception {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.name("My process").packageName("org.jbpm").startNode(1L).name("Start").done().actionNode(2L).name("Action").action("java", "System.out.println(\"Action\");").done().endNode(3L).name("End").done().connection(1L, 2L).connection(2L, 3L);
        RuleFlowProcess process = factory.validate().getProcess();
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(res);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.startProcess("org.jbpm.process");
        ksession.dispose();
    }

    @Test
    public void testCompositeNode() throws Exception {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.name("My process").packageName("org.jbpm").startNode(1L).name("Start").done().compositeNode(2L).name("SubProcess").startNode(1L).name("SubProcess Start").done().actionNode(2L).name("SubProcess Action").action("java", "System.out.println(\"SubProcess Action\");").done().endNode(3L).name("SubProcess End").terminate(true).done().connection(1L, 2L).connection(2L, 3L).done().endNode(3L).name("End").done().connection(1L, 2L).connection(2L, 3L);
        RuleFlowProcess process = factory.validate().getProcess();
        Assert.assertEquals((Object)"SubProcess", (Object)process.getNode(2L).getName());
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(res);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance pi = ksession.startProcess("org.jbpm.process");
        Assert.assertEquals((long)2L, (long)pi.getState());
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testBoundaryTimerTimeCycle() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("BoundaryTimerEvent", 1);
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.name("My process").packageName("org.jbpm").startNode(1L).name("Start").done().humanTaskNode(2L).name("Task").actorId("john").taskName("MyTask").done().endNode(3L).name("End1").terminate(false).done().boundaryEventNode(4L).name("BoundaryTimerEvent").attachedTo(2L).timeCycle("1s###5s").cancelActivity(false).done().endNode(5L).name("End2").terminate(false).done().connection(1L, 2L).connection(2L, 3L).connection(4L, 5L);
        RuleFlowProcess process = factory.validate().getProcess();
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(res);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)testHandler);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance pi = ksession.startProcess("org.jbpm.process");
        this.assertProcessInstanceActive(pi);
        countDownListener.waitTillCompleted();
        this.assertNodeTriggered(pi.getId(), "End2");
        this.assertProcessInstanceActive(pi);
        ksession.getWorkItemManager().completeWorkItem(testHandler.getWorkItem().getId(), null);
        this.assertProcessInstanceCompleted(pi);
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testBoundaryTimerTimeDuration() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("BoundaryTimerEvent", 1);
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.name("My process").packageName("org.jbpm").startNode(1L).name("Start").done().humanTaskNode(2L).name("Task").actorId("john").taskName("MyTask").done().endNode(3L).name("End1").terminate(false).done().boundaryEventNode(4L).name("BoundaryTimerEvent").attachedTo(2L).timeDuration("1s").cancelActivity(false).done().endNode(5L).name("End2").terminate(false).done().connection(1L, 2L).connection(2L, 3L).connection(4L, 5L);
        RuleFlowProcess process = factory.validate().getProcess();
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(res);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)testHandler);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance pi = ksession.startProcess("org.jbpm.process");
        this.assertProcessInstanceActive(pi);
        countDownListener.waitTillCompleted();
        this.assertNodeTriggered(pi.getId(), "End2");
        this.assertProcessInstanceActive(pi);
        ksession.getWorkItemManager().completeWorkItem(testHandler.getWorkItem().getId(), null);
        this.assertProcessInstanceCompleted(pi);
        ksession.dispose();
    }
}

