/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.listener.process.NodeLeftCountDownProcessEventListener;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.ForEachNodeInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@RunWith(value=Parameterized.class)
public class FlowTest
extends JbpmBpmn2TestCase {
    private static final Logger logger = LoggerFactory.getLogger(FlowTest.class);
    private KieSession ksession;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public FlowTest(boolean persistence) {
        super(persistence);
    }

    @BeforeClass
    public static void setup() throws Exception {
        FlowTest.setUpDataSource();
        VariableScope.setVariableStrictOption((boolean)true);
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @After
    public void clearProperties() {
        System.clearProperty("jbpm.enable.multi.con");
    }

    @Test
    public void testExclusiveSplitWithNoConditions() throws Exception {
        try {
            this.createKnowledgeBaseWithoutDumper("BPMN2-ExclusiveGatewayWithNoConditionsDefined.bpmn2");
            Assert.fail((String)"Should fail as XOR gateway does not have conditions defined");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((e.getMessage().indexOf("does not have a constraint for Connection") != -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testExclusiveSplit() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplit.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "First");
        params.put("y", "Second");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testExclusiveSplitXPathAdvanced() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitXPath-advanced.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, Object> params = new HashMap<String, Object>();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element hi = doc.createElement("hi");
        Element ho = doc.createElement("ho");
        hi.appendChild(ho);
        Attr attr = doc.createAttribute("value");
        ho.setAttributeNode(attr);
        attr.setValue("a");
        params.put("x", hi);
        params.put("y", "Second");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testExclusiveSplitXPathAdvanced2() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitXPath-advanced-vars-not-signaled.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, Object> params = new HashMap<String, Object>();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element hi = doc.createElement("hi");
        Element ho = doc.createElement("ho");
        hi.appendChild(ho);
        Attr attr = doc.createAttribute("value");
        ho.setAttributeNode(attr);
        attr.setValue("a");
        params.put("x", hi);
        params.put("y", "Second");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testExclusiveSplitXPathAdvancedWithVars() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitXPath-advanced-with-vars.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, Object> params = new HashMap<String, Object>();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element hi = doc.createElement("hi");
        Element ho = doc.createElement("ho");
        hi.appendChild(ho);
        Attr attr = doc.createAttribute("value");
        ho.setAttributeNode(attr);
        attr.setValue("a");
        params.put("x", hi);
        params.put("y", "Second");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testExclusiveSplitPriority() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitPriority.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "First");
        params.put("y", "Second");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testExclusiveSplitDefault() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExclusiveSplitDefault.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "NotFirst");
        params.put("y", "Second");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testExclusiveXORGateway() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-gatewayTest.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<instanceMetadata><user approved=\"false\" /></instanceMetadata>".getBytes()));
        HashMap<String, Node> params = new HashMap<String, Node>();
        params.put("instanceMetadata", document);
        params.put("startMessage", DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<task subject='foobar2'/>".getBytes())).getFirstChild());
        ProcessInstance processInstance = this.ksession.startProcess("process", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testInclusiveSplit() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplit.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testInclusiveSplitDefaultConnection() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-InclusiveGatewayWithDefault.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test", "c");
        ProcessInstance processInstance = this.ksession.startProcess("InclusiveGatewayWithDefault", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testInclusiveSplitAndJoin() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoin.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        Assert.assertEquals((long)2L, (long)activeWorkItems.size());
        this.ksession = this.restoreSession(this.ksession, true);
        for (WorkItem wi : activeWorkItems) {
            this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testInclusiveSplitAndJoinLoop() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinLoop.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 21);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        Assert.assertEquals((long)3L, (long)activeWorkItems.size());
        this.ksession = this.restoreSession(this.ksession, true);
        for (WorkItem wi : activeWorkItems) {
            this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testInclusiveSplitAndJoinLoop2() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinLoop2.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 21);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        Assert.assertEquals((long)3L, (long)activeWorkItems.size());
        this.ksession = this.restoreSession(this.ksession, true);
        for (WorkItem wi : activeWorkItems) {
            this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testInclusiveSplitAndJoinNested() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinNested.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        Assert.assertEquals((long)2L, (long)activeWorkItems.size());
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        for (WorkItem wi : activeWorkItems) {
            this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        activeWorkItems = workItemHandler.getWorkItems();
        Assert.assertEquals((long)2L, (long)activeWorkItems.size());
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        for (WorkItem wi : activeWorkItems) {
            this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testInclusiveSplitAndJoinEmbedded() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinEmbedded.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        Assert.assertEquals((long)2L, (long)activeWorkItems.size());
        this.ksession = this.restoreSession(this.ksession, true);
        for (WorkItem wi : activeWorkItems) {
            this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testInclusiveSplitAndJoinWithParallel() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinWithParallel.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 25);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        Assert.assertEquals((long)4L, (long)activeWorkItems.size());
        this.ksession = this.restoreSession(this.ksession, true);
        for (WorkItem wi : activeWorkItems) {
            this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testInclusiveSplitAndJoinWithEnd() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinWithEnd.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 25);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        Assert.assertEquals((long)3L, (long)activeWorkItems.size());
        this.ksession = this.restoreSession(this.ksession, true);
        for (int i = 0; i < 2; ++i) {
            this.ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(i).getId(), null);
        }
        this.assertProcessInstanceActive(processInstance);
        this.ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(2).getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test(timeout=10000L)
    public void testInclusiveSplitAndJoinWithTimer() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 2);
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinWithTimer.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        Assert.assertEquals((long)1L, (long)activeWorkItems.size());
        this.ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(0).getId(), null);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        activeWorkItems = workItemHandler.getWorkItems();
        Assert.assertEquals((long)2L, (long)activeWorkItems.size());
        this.ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(0).getId(), null);
        this.assertProcessInstanceActive(processInstance);
        this.ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(1).getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testInclusiveSplitAndJoinExtraPath() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitAndJoinExtraPath.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 25);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        this.ksession.signalEvent("signal", null);
        List<WorkItem> activeWorkItems = workItemHandler.getWorkItems();
        Assert.assertEquals((long)4L, (long)activeWorkItems.size());
        this.ksession = this.restoreSession(this.ksession, true);
        for (int i = 0; i < 3; ++i) {
            this.ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(i).getId(), null);
        }
        this.assertProcessInstanceActive(processInstance);
        this.ksession.getWorkItemManager().completeWorkItem(activeWorkItems.get(3).getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testInclusiveSplitDefault() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveSplitDefault.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", -5);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testInclusiveParallelExclusiveSplitNoLoop() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveNestedInParallelNestedInExclusive.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("testWI", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("testWI2", (WorkItemHandler)new SystemOutWorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                Integer x;
                Integer n = x = (Integer)workItem.getParameter("input1");
                Integer n2 = x = Integer.valueOf(x + 1);
                HashMap<String, Integer> results = new HashMap<String, Integer>();
                results.put("output1", x);
                manager.completeWorkItem(workItem.getId(), results);
            }
        });
        final HashMap nodeInstanceExecutionCounter = new HashMap();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                logger.info(event.getNodeInstance().getNodeName());
                Integer value = (Integer)nodeInstanceExecutionCounter.get(event.getNodeInstance().getNodeName());
                if (value == null) {
                    value = new Integer(0);
                }
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
                nodeInstanceExecutionCounter.put(event.getNodeInstance().getNodeName(), value);
            }
        });
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 0);
        ProcessInstance processInstance = this.ksession.startProcess("Process_1", params);
        this.assertProcessInstanceCompleted(processInstance);
        Assert.assertEquals((long)12L, (long)nodeInstanceExecutionCounter.size());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("Start")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("XORGateway-converging")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("ANDGateway-diverging")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("ORGateway-diverging")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("testWI3")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("testWI2")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("ORGateway-converging")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("Script")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("XORGateway-diverging")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("ANDGateway-converging")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("testWI6")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("End")).intValue());
    }

    @Test
    public void testInclusiveParallelExclusiveSplitLoop() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveNestedInParallelNestedInExclusive.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("testWI", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("testWI2", (WorkItemHandler)new SystemOutWorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                Integer x;
                Integer n = x = (Integer)workItem.getParameter("input1");
                Integer n2 = x = Integer.valueOf(x + 1);
                HashMap<String, Integer> results = new HashMap<String, Integer>();
                results.put("output1", x);
                manager.completeWorkItem(workItem.getId(), results);
            }
        });
        final HashMap nodeInstanceExecutionCounter = new HashMap();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                Integer value = (Integer)nodeInstanceExecutionCounter.get(event.getNodeInstance().getNodeName());
                if (value == null) {
                    value = new Integer(0);
                }
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
                nodeInstanceExecutionCounter.put(event.getNodeInstance().getNodeName(), value);
            }
        });
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", -1);
        ProcessInstance processInstance = this.ksession.startProcess("Process_1", params);
        this.assertProcessInstanceCompleted(processInstance);
        Assert.assertEquals((long)12L, (long)nodeInstanceExecutionCounter.size());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("Start")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("XORGateway-converging")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("ANDGateway-diverging")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("ORGateway-diverging")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("testWI3")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("testWI2")).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)nodeInstanceExecutionCounter.get("ORGateway-converging")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("Script")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("XORGateway-diverging")).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)nodeInstanceExecutionCounter.get("ANDGateway-converging")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("testWI6")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("End")).intValue());
    }

    @Test
    public void testInclusiveParallelExclusiveSplitNoLoopAsync() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveNestedInParallelNestedInExclusive.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("testWI", (WorkItemHandler)handler);
        this.ksession.getWorkItemManager().registerWorkItemHandler("testWI2", (WorkItemHandler)new SystemOutWorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                Integer x;
                Integer n = x = (Integer)workItem.getParameter("input1");
                Integer n2 = x = Integer.valueOf(x + 1);
                HashMap<String, Integer> results = new HashMap<String, Integer>();
                results.put("output1", x);
                manager.completeWorkItem(workItem.getId(), results);
            }
        });
        final HashMap nodeInstanceExecutionCounter = new HashMap();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                Integer value = (Integer)nodeInstanceExecutionCounter.get(event.getNodeInstance().getNodeName());
                if (value == null) {
                    value = new Integer(0);
                }
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
                nodeInstanceExecutionCounter.put(event.getNodeInstance().getNodeName(), value);
            }
        });
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 0);
        ProcessInstance processInstance = this.ksession.startProcess("Process_1", params);
        this.assertProcessInstanceActive(processInstance);
        List<WorkItem> workItems = handler.getWorkItems();
        Assert.assertNotNull(workItems);
        Assert.assertEquals((long)2L, (long)workItems.size());
        for (WorkItem workItem : workItems) {
            this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        }
        this.assertProcessInstanceActive(processInstance);
        workItems = handler.getWorkItems();
        Assert.assertNotNull(workItems);
        Assert.assertEquals((long)1L, (long)workItems.size());
        for (WorkItem workItem : workItems) {
            this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        }
        this.assertProcessInstanceCompleted(processInstance);
        Assert.assertEquals((long)12L, (long)nodeInstanceExecutionCounter.size());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("Start")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("XORGateway-converging")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("ANDGateway-diverging")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("ORGateway-diverging")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("testWI3")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("testWI2")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("ORGateway-converging")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("Script")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("XORGateway-diverging")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("ANDGateway-converging")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("testWI6")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("End")).intValue());
    }

    @Test
    public void testInclusiveParallelExclusiveSplitLoopAsync() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveNestedInParallelNestedInExclusive.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("testWI", (WorkItemHandler)handler);
        this.ksession.getWorkItemManager().registerWorkItemHandler("testWI2", (WorkItemHandler)new SystemOutWorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                Integer x;
                Integer n = x = (Integer)workItem.getParameter("input1");
                Integer n2 = x = Integer.valueOf(x + 1);
                HashMap<String, Integer> results = new HashMap<String, Integer>();
                results.put("output1", x);
                manager.completeWorkItem(workItem.getId(), results);
            }
        });
        final HashMap nodeInstanceExecutionCounter = new HashMap();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                Integer value = (Integer)nodeInstanceExecutionCounter.get(event.getNodeInstance().getNodeName());
                if (value == null) {
                    value = new Integer(0);
                }
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
                nodeInstanceExecutionCounter.put(event.getNodeInstance().getNodeName(), value);
            }
        });
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", -1);
        ProcessInstance processInstance = this.ksession.startProcess("Process_1", params);
        this.assertProcessInstanceActive(processInstance);
        List<WorkItem> workItems = handler.getWorkItems();
        Assert.assertNotNull(workItems);
        Assert.assertEquals((long)2L, (long)workItems.size());
        for (WorkItem workItem : workItems) {
            this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        }
        this.assertProcessInstanceActive(processInstance);
        workItems = handler.getWorkItems();
        Assert.assertNotNull(workItems);
        Assert.assertEquals((long)2L, (long)workItems.size());
        for (WorkItem workItem : workItems) {
            this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        }
        this.assertProcessInstanceActive(processInstance);
        workItems = handler.getWorkItems();
        Assert.assertNotNull(workItems);
        Assert.assertEquals((long)1L, (long)workItems.size());
        for (WorkItem workItem : workItems) {
            this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        }
        this.assertProcessInstanceCompleted(processInstance);
        Assert.assertEquals((long)12L, (long)nodeInstanceExecutionCounter.size());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("Start")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("XORGateway-converging")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("ANDGateway-diverging")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("ORGateway-diverging")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("testWI3")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("testWI2")).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)nodeInstanceExecutionCounter.get("ORGateway-converging")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("Script")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("XORGateway-diverging")).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)nodeInstanceExecutionCounter.get("ANDGateway-converging")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("testWI6")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("End")).intValue());
    }

    @Test
    public void testInclusiveSplitNested() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveGatewayNested.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        TestWorkItemHandler handler2 = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("testWI", (WorkItemHandler)handler);
        this.ksession.getWorkItemManager().registerWorkItemHandler("testWI2", (WorkItemHandler)handler2);
        HashMap params = new HashMap();
        ProcessInstance processInstance = this.ksession.startProcess("Process_1", params);
        this.assertProcessInstanceActive(processInstance);
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.ksession.getWorkItemManager().completeWorkItem(handler2.getWorkItem().getId(), null);
        this.assertProcessInstanceActive(processInstance);
        List<WorkItem> workItems = handler.getWorkItems();
        Assert.assertNotNull(workItems);
        Assert.assertEquals((long)2L, (long)workItems.size());
        for (WorkItem wi : workItems) {
            this.assertProcessInstanceActive(processInstance);
            this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceActive(processInstance);
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testInclusiveSplitWithLoopInside() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveGatewayWithLoopInside.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final HashMap nodeInstanceExecutionCounter = new HashMap();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                logger.info("{} {}", (Object)event.getNodeInstance().getNodeName(), (Object)((NodeInstanceImpl)event.getNodeInstance()).getLevel());
                Integer value = (Integer)nodeInstanceExecutionCounter.get(event.getNodeInstance().getNodeName());
                if (value == null) {
                    value = new Integer(0);
                }
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
                nodeInstanceExecutionCounter.put(event.getNodeInstance().getNodeName(), value);
            }
        });
        TestWorkItemHandler handler = new TestWorkItemHandler();
        TestWorkItemHandler handler2 = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("testWI", (WorkItemHandler)handler);
        this.ksession.getWorkItemManager().registerWorkItemHandler("testWI2", (WorkItemHandler)handler2);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", -1);
        ProcessInstance processInstance = this.ksession.startProcess("Process_1", params);
        this.assertProcessInstanceActive(processInstance);
        List<WorkItem> workItems = handler.getWorkItems();
        Assert.assertNotNull(workItems);
        Assert.assertEquals((long)2L, (long)workItems.size());
        for (WorkItem wi : workItems) {
            this.assertProcessInstanceActive(processInstance);
            this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceActive(processInstance);
        this.ksession.getWorkItemManager().completeWorkItem(handler2.getWorkItem().getId(), null);
        this.assertProcessInstanceActive(processInstance);
        this.ksession.getWorkItemManager().completeWorkItem(handler2.getWorkItem().getId(), null);
        this.assertProcessInstanceActive(processInstance);
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.assertProcessInstanceCompleted(processInstance);
        Assert.assertEquals((long)10L, (long)nodeInstanceExecutionCounter.size());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("Start")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("OR diverging")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("tareaWorkflow3")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("tareaWorkflow2")).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)nodeInstanceExecutionCounter.get("OR converging")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("tareaWorkflow6")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("Script")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("XOR diverging")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("XOR converging")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("End")).intValue());
    }

    @Test
    public void testInclusiveSplitWithLoopInsideSubprocess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveGatewayWithLoopInsideSubprocess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final HashMap nodeInstanceExecutionCounter = new HashMap();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                logger.info("{} {}", (Object)event.getNodeInstance().getNodeName(), (Object)((NodeInstanceImpl)event.getNodeInstance()).getLevel());
                Integer value = (Integer)nodeInstanceExecutionCounter.get(event.getNodeInstance().getNodeName());
                if (value == null) {
                    value = new Integer(0);
                }
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
                nodeInstanceExecutionCounter.put(event.getNodeInstance().getNodeName(), value);
            }
        });
        TestWorkItemHandler handler = new TestWorkItemHandler();
        TestWorkItemHandler handler2 = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("testWI", (WorkItemHandler)handler);
        this.ksession.getWorkItemManager().registerWorkItemHandler("testWI2", (WorkItemHandler)handler2);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", -1);
        ProcessInstance processInstance = this.ksession.startProcess("Process_1", params);
        this.assertProcessInstanceActive(processInstance);
        List<WorkItem> workItems = handler.getWorkItems();
        Assert.assertNotNull(workItems);
        Assert.assertEquals((long)2L, (long)workItems.size());
        for (WorkItem wi : workItems) {
            this.assertProcessInstanceActive(processInstance);
            this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        }
        this.assertProcessInstanceActive(processInstance);
        this.ksession.getWorkItemManager().completeWorkItem(handler2.getWorkItem().getId(), null);
        this.assertProcessInstanceActive(processInstance);
        this.ksession.getWorkItemManager().completeWorkItem(handler2.getWorkItem().getId(), null);
        this.assertProcessInstanceActive(processInstance);
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.assertProcessInstanceCompleted(processInstance);
        Assert.assertEquals((long)13L, (long)nodeInstanceExecutionCounter.size());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("Start")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("Sub Process 1")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("sb-start")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("sb-end")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("OR diverging")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("tareaWorkflow3")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("tareaWorkflow2")).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)nodeInstanceExecutionCounter.get("OR converging")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("tareaWorkflow6")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("Script")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("XOR diverging")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)nodeInstanceExecutionCounter.get("XOR converging")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("End")).intValue());
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcessWithORGateway() throws Exception {
        Iterator childIterator;
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-MultiInstanceLoopCharacteristicsProcessWithORgateway.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap params = new HashMap();
        ArrayList<Integer> myList = new ArrayList<Integer>();
        myList.add(12);
        myList.add(15);
        params.put("list", myList);
        ProcessInstance processInstance = this.ksession.startProcess("MultiInstanceLoopCharacteristicsProcess", params);
        List<WorkItem> workItems = workItemHandler.getWorkItems();
        Assert.assertEquals((long)4L, (long)workItems.size());
        Collection nodeInstances = ((WorkflowProcessInstanceImpl)processInstance).getNodeInstances();
        Assert.assertEquals((long)1L, (long)nodeInstances.size());
        NodeInstance nodeInstance = (NodeInstance)nodeInstances.iterator().next();
        Assert.assertTrue((boolean)(nodeInstance instanceof ForEachNodeInstance));
        Collection nodeInstancesChild = ((ForEachNodeInstance)nodeInstance).getNodeInstances();
        Assert.assertEquals((long)2L, (long)nodeInstancesChild.size());
        for (NodeInstance child : nodeInstancesChild) {
            Assert.assertTrue((boolean)(child instanceof CompositeContextNodeInstance));
            Assert.assertEquals((long)2L, (long)((CompositeContextNodeInstance)child).getNodeInstances().size());
        }
        this.ksession.getWorkItemManager().completeWorkItem(workItems.get(0).getId(), null);
        this.ksession.getWorkItemManager().completeWorkItem(workItems.get(1).getId(), null);
        processInstance = this.ksession.getProcessInstance(processInstance.getId());
        nodeInstances = ((WorkflowProcessInstanceImpl)processInstance).getNodeInstances();
        Assert.assertEquals((long)1L, (long)nodeInstances.size());
        nodeInstance = (NodeInstance)nodeInstances.iterator().next();
        Assert.assertTrue((boolean)(nodeInstance instanceof ForEachNodeInstance));
        if (this.isPersistence()) {
            nodeInstancesChild = ((ForEachNodeInstance)nodeInstance).getNodeInstances();
            Assert.assertEquals((long)1L, (long)nodeInstancesChild.size());
            childIterator = nodeInstancesChild.iterator();
            Assert.assertTrue((boolean)(childIterator.next() instanceof CompositeContextNodeInstance));
            this.ksession.getWorkItemManager().completeWorkItem(workItems.get(2).getId(), null);
            this.ksession.getWorkItemManager().completeWorkItem(workItems.get(3).getId(), null);
            this.assertProcessInstanceFinished(processInstance, this.ksession);
        } else {
            nodeInstancesChild = ((ForEachNodeInstance)nodeInstance).getNodeInstances();
            Assert.assertEquals((long)2L, (long)nodeInstancesChild.size());
            childIterator = nodeInstancesChild.iterator();
            Assert.assertTrue((boolean)(childIterator.next() instanceof CompositeContextNodeInstance));
            Assert.assertTrue((boolean)(childIterator.next() instanceof ForEachNodeInstance.ForEachJoinNodeInstance));
            this.ksession.getWorkItemManager().completeWorkItem(workItems.get(2).getId(), null);
            this.ksession.getWorkItemManager().completeWorkItem(workItems.get(3).getId(), null);
            this.assertProcessInstanceFinished(processInstance, this.ksession);
        }
    }

    @Test
    public void testInclusiveJoinWithLoopAndHumanTasks() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-InclusiveGatewayWithHumanTasksProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final HashMap nodeInstanceExecutionCounter = new HashMap();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                logger.info("{} {}", (Object)event.getNodeInstance().getNodeName(), (Object)((NodeInstanceImpl)event.getNodeInstance()).getLevel());
                Integer value = (Integer)nodeInstanceExecutionCounter.get(event.getNodeInstance().getNodeName());
                if (value == null) {
                    value = new Integer(0);
                }
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
                nodeInstanceExecutionCounter.put(event.getNodeInstance().getNodeName(), value);
            }
        });
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("firstXor", true);
        params.put("secondXor", true);
        params.put("thirdXor", true);
        ProcessInstance processInstance = this.ksession.startProcess("InclusiveWithAdvancedLoop", params);
        this.assertProcessInstanceActive(processInstance);
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.assertProcessInstanceActive(processInstance);
        List<WorkItem> workItems = handler.getWorkItems();
        Assert.assertNotNull(workItems);
        Assert.assertEquals((long)2L, (long)workItems.size());
        WorkItem remainingWork = null;
        for (WorkItem wi : workItems) {
            this.assertProcessInstanceActive(processInstance);
            if (wi.getParameter("NodeName").equals("HT Form2")) {
                this.ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
                continue;
            }
            remainingWork = wi;
        }
        this.assertProcessInstanceActive(processInstance);
        this.ksession.getWorkItemManager().completeWorkItem(remainingWork.getId(), null);
        this.assertProcessInstanceActive(processInstance);
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.assertProcessInstanceCompleted(processInstance);
        Assert.assertEquals((long)13L, (long)nodeInstanceExecutionCounter.size());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("Start")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("HT Form1")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("and1")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("HT Form2")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("xor1")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("xor2")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("HT Form3")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("Koniec")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("xor 3")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("HT Form4")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("xor4")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("Koniec2")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)nodeInstanceExecutionCounter.get("or1")).intValue());
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultiInstanceLoopCharacteristicsProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        ProcessInstance processInstance = this.ksession.startProcess("MultiInstanceLoopCharacteristicsProcess", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcessSequential() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-MultiInstanceLoopCharacteristicsProcessSequential.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("First Item");
        myList.add("Second Item");
        myList.add("Third Item");
        params.put("list", myList);
        ProcessInstance processInstance = this.ksession.startProcess("MultiInstanceLoopCharacteristicsProcess", params);
        Collection nodeInstances = ((WorkflowProcessInstance)processInstance).getNodeInstances();
        Assert.assertEquals((String)"There should be only one node instance active", (long)1L, (long)nodeInstances.size());
        NodeInstance nodeInstance = (NodeInstance)nodeInstances.iterator().next();
        Assert.assertTrue((boolean)(nodeInstance instanceof ForEachNodeInstance));
        List<WorkItem> tasks = workItemHandler.getWorkItems();
        Assert.assertEquals((String)"There should be only one task assigned", (long)1L, (long)tasks.size());
        Assert.assertEquals(myList.get(0), (Object)tasks.get(0).getParameter("data"));
        this.ksession.getWorkItemManager().completeWorkItem(tasks.get(0).getId(), null);
        tasks = workItemHandler.getWorkItems();
        Assert.assertEquals((String)"There should be only one task assigned", (long)1L, (long)tasks.size());
        Assert.assertEquals(myList.get(1), (Object)tasks.get(0).getParameter("data"));
        this.ksession.getWorkItemManager().completeWorkItem(tasks.get(0).getId(), null);
        tasks = workItemHandler.getWorkItems();
        Assert.assertEquals((String)"There should be only one task assigned", (long)1L, (long)tasks.size());
        Assert.assertEquals(myList.get(2), (Object)tasks.get(0).getParameter("data"));
        this.ksession.getWorkItemManager().completeWorkItem(tasks.get(0).getId(), null);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsTaskSequential() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-MultiInstanceLoopCharacteristicsTaskSequential.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        ProcessInstance processInstance = this.ksession.startProcess("MultiInstanceLoopCharacteristicsTask", params);
        List<WorkItem> tasks = workItemHandler.getWorkItems();
        Assert.assertEquals((String)"There should be only one task assigned", (long)1L, (long)tasks.size());
        Assert.assertEquals(myList.get(0), (Object)tasks.get(0).getParameter("Item"));
        this.ksession.getWorkItemManager().completeWorkItem(tasks.get(0).getId(), null);
        tasks = workItemHandler.getWorkItems();
        Assert.assertEquals((String)"There should be only one task assigned", (long)1L, (long)tasks.size());
        Assert.assertEquals(myList.get(1), (Object)tasks.get(0).getParameter("Item"));
        this.ksession.getWorkItemManager().completeWorkItem(tasks.get(0).getId(), null);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsTaskCmpCondSequential() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-MultiInstanceLoopCharacteristicsTaskWithOutputCmpCondSequential.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        ProcessInstance processInstance = this.ksession.startProcess("MultiInstanceLoopCharacteristicsTask", params);
        List<WorkItem> tasks = workItemHandler.getWorkItems();
        Assert.assertEquals((String)"There should be only one task assigned", (long)1L, (long)tasks.size());
        Assert.assertEquals(myList.get(0), (Object)tasks.get(0).getParameter("Item"));
        this.ksession.getWorkItemManager().completeWorkItem(tasks.get(0).getId(), null);
        tasks = workItemHandler.getWorkItems();
        Assert.assertEquals((String)"There should be no more task assigned", (long)0L, (long)tasks.size());
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMultiInstanceLoopNumberTest() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultiInstanceLoop-Numbering.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap params = new HashMap();
        final HashMap nodeIdNodeNameMap = new HashMap();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                String nodeName;
                NodeInstance nodeInstance = event.getNodeInstance();
                String uniqId = ((NodeInstanceImpl)nodeInstance).getUniqueId();
                String prevNodeName = nodeIdNodeNameMap.put(uniqId, nodeName = ((NodeInstanceImpl)nodeInstance).getNode().getName());
                if (prevNodeName != null) {
                    Assert.assertEquals((String)(uniqId + " is used for more than one node instance: "), (Object)prevNodeName, (Object)nodeName);
                }
            }
        });
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("Test.MultipleInstancesBug", params);
        List<WorkItem> workItems = handler.getWorkItems();
        logger.debug("COMPLETING TASKS.");
        this.ksession.getWorkItemManager().completeWorkItem(workItems.remove(0).getId(), null);
        this.ksession.getWorkItemManager().completeWorkItem(workItems.remove(0).getId(), null);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcess2() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-MultiInstanceProcessWithOutputOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        List myOutList = null;
        myList.add("John");
        myList.add("Mary");
        params.put("miinput", myList);
        ProcessInstance processInstance = this.ksession.startProcess("miprocess", params);
        List<WorkItem> workItems = handler.getWorkItems();
        Assert.assertNotNull(workItems);
        Assert.assertEquals((long)2L, (long)workItems.size());
        myOutList = (List)this.ksession.execute((Command)new GetProcessVariableCommand(processInstance.getId(), "mioutput"));
        Assert.assertNull((Object)myOutList);
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("reply", "Hello John");
        this.ksession.getWorkItemManager().completeWorkItem(workItems.get(0).getId(), results);
        myOutList = (List)this.ksession.execute((Command)new GetProcessVariableCommand(processInstance.getId(), "mioutput"));
        Assert.assertNull((Object)myOutList);
        results = new HashMap();
        results.put("reply", "Hello Mary");
        this.ksession.getWorkItemManager().completeWorkItem(workItems.get(1).getId(), results);
        myOutList = (List)this.ksession.execute((Command)new GetProcessVariableCommand(processInstance.getId(), "mioutput"));
        Assert.assertNotNull((Object)myOutList);
        Assert.assertEquals((long)2L, (long)myOutList.size());
        Assert.assertTrue((boolean)myOutList.contains("Hello John"));
        Assert.assertTrue((boolean)myOutList.contains("Hello Mary"));
        this.ksession.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcessWithOutput() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-MultiInstanceLoopCharacteristicsProcessWithOutput.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        ArrayList myListOut = new ArrayList();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        params.put("listOut", myListOut);
        Assert.assertEquals((long)0L, (long)myListOut.size());
        ProcessInstance processInstance = this.ksession.startProcess("MultiInstanceLoopCharacteristicsProcessWithOutput", params);
        this.assertProcessInstanceCompleted(processInstance);
        Assert.assertEquals((long)2L, (long)myListOut.size());
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcessWithOutputCompletionCondition() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-MultiInstanceLoopCharacteristicsProcessWithOutputCmpCond.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        ArrayList myListOut = new ArrayList();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        params.put("listOut", myListOut);
        Assert.assertEquals((long)0L, (long)myListOut.size());
        ProcessInstance processInstance = this.ksession.startProcess("MultiInstanceLoopCharacteristicsProcessWithOutput", params);
        this.assertProcessInstanceCompleted(processInstance);
        Assert.assertEquals((long)1L, (long)myListOut.size());
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcessWithOutputAndScripts() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-MultiInstanceLoopCharacteristicsProcessWithOutputAndScripts.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        ArrayList myListOut = new ArrayList();
        ArrayList scriptList = new ArrayList();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        params.put("listOut", myListOut);
        params.put("scriptList", scriptList);
        Assert.assertEquals((long)0L, (long)myListOut.size());
        ProcessInstance processInstance = this.ksession.startProcess("MultiInstanceLoopCharacteristicsProcessWithOutput", params);
        this.assertProcessInstanceCompleted(processInstance);
        Assert.assertEquals((long)2L, (long)myListOut.size());
        Assert.assertEquals((long)2L, (long)scriptList.size());
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsTaskWithOutput() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-MultiInstanceLoopCharacteristicsTaskWithOutput.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        ArrayList myListOut = new ArrayList();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        params.put("listOut", myListOut);
        Assert.assertEquals((long)0L, (long)myListOut.size());
        ProcessInstance processInstance = this.ksession.startProcess("MultiInstanceLoopCharacteristicsTask", params);
        this.assertProcessInstanceCompleted(processInstance);
        Assert.assertEquals((long)2L, (long)myListOut.size());
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsTaskWithOutputCompletionCondition() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-MultiInstanceLoopCharacteristicsTaskWithOutputCmpCond.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        ArrayList myListOut = new ArrayList();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        params.put("listOut", myListOut);
        Assert.assertEquals((long)0L, (long)myListOut.size());
        ProcessInstance processInstance = this.ksession.startProcess("MultiInstanceLoopCharacteristicsTask", params);
        this.assertProcessInstanceCompleted(processInstance);
        Assert.assertEquals((long)1L, (long)myListOut.size());
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsTaskWithOutputCompletionCondition2() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-MultiInstanceLoopCharacteristicsTaskWithOutputCmpCond2.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        ArrayList myListOut = new ArrayList();
        myList.add("approved");
        myList.add("rejected");
        myList.add("approved");
        myList.add("approved");
        myList.add("rejected");
        params.put("list", myList);
        params.put("listOut", myListOut);
        Assert.assertEquals((long)0L, (long)myListOut.size());
        ProcessInstance processInstance = this.ksession.startProcess("MultiInstanceLoopCharacteristicsTask", params);
        this.assertProcessInstanceCompleted(processInstance);
        Assert.assertEquals((long)3L, (long)myListOut.size());
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsTask() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-MultiInstanceLoopCharacteristicsTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        ProcessInstance processInstance = this.ksession.startProcess("MultiInstanceLoopCharacteristicsTask", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMultipleInOutgoingSequenceFlows() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 1);
        System.setProperty("jbpm.enable.multi.con", "true");
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleInOutgoingSequenceFlows.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
            }
        });
        Assert.assertEquals((long)0L, (long)list.size());
        countDownListener.waitTillCompleted();
        Assert.assertEquals((long)1L, (long)list.size());
        System.clearProperty("jbpm.enable.multi.con");
    }

    @Test
    public void testMultipleIncomingFlowToEndNode() throws Exception {
        System.setProperty("jbpm.enable.multi.con", "true");
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleFlowEndNode.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("MultipleFlowEndNode");
        this.assertProcessInstanceCompleted(processInstance);
        System.clearProperty("jbpm.enable.multi.con");
    }

    @Test
    public void testMultipleEnabledOnSingleConditionalSequenceFlow() throws Exception {
        System.setProperty("jbpm.enable.multi.con", "true");
        KieBase kbase = this.createKnowledgeBase("BPMN2-MultiConnEnabled.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        final ArrayList list = new ArrayList();
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                if ("Task2".equals(event.getNodeInstance().getNodeName())) {
                    list.add(event.getNodeInstance().getNodeId());
                }
            }
        });
        Assert.assertEquals((long)0L, (long)list.size());
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-MultiConnEnabled");
        this.assertProcessInstanceActive(processInstance);
        this.ksession.signalEvent("signal", null, processInstance.getId());
        this.assertProcessInstanceCompleted(processInstance);
        Assert.assertEquals((long)1L, (long)list.size());
        System.clearProperty("jbpm.enable.multi.con");
    }

    @Test
    public void testMultipleInOutgoingSequenceFlowsDisable() throws Exception {
        try {
            KieBase kbase = this.createKnowledgeBase("BPMN2-MultipleInOutgoingSequenceFlows.bpmn2");
            Assert.fail((String)"Should fail as multiple outgoing and incoming connections are disabled by default");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"This type of node [ScriptTask_1, Script Task] cannot have more than one outgoing connection!", (Object)e.getMessage());
        }
    }

    @Test
    public void testConditionalFlow() throws Exception {
        System.setProperty("jbpm.enable.multi.con", "true");
        String processId = "designer.conditional-flow";
        KieBase kbase = this.createKnowledgeBase("BPMN2-ConditionalFlowWithoutGateway.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        WorkflowProcessInstance wpi = (WorkflowProcessInstance)this.ksession.startProcess(processId);
        this.assertProcessInstanceFinished((ProcessInstance)wpi, this.ksession);
        this.assertNodeTriggered(wpi.getId(), "start", "script", "end1");
        System.clearProperty("jbpm.enable.multi.con");
    }

    @Test
    public void testLane() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-Lane.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("UserTask");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("ActorId", "mary");
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), results);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        workItem = workItemHandler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        Assert.assertEquals((Object)"mary", (Object)workItem.getParameter("SwimlaneActorId"));
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testExclusiveSplitDefaultNoCondition() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-ExclusiveSplitDefaultNoCondition.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = ksession.startProcess("com.sample.test");
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
    }

    @Test
    public void testMultipleGatewaysProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-MultipleGatewaysProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){
            ProcessInstance pi;

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                if (event.getNodeInstance().getNodeName().equals("CreateAgent")) {
                    this.pi.signalEvent("Signal_1", null);
                }
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                logger.info("Before Node triggered event received for node: {}", (Object)event.getNodeInstance().getNodeName());
            }

            public void beforeProcessStarted(ProcessStartedEvent event) {
                this.pi = event.getProcessInstance();
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "CreateAgent");
        ProcessInstance processInstance = this.ksession.startProcess("multiplegateways", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testTimerAndGateway() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 1);
        KieBase kbase = this.createKnowledgeBase("timer/BPMN2-ParallelSplitWithTimerProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler handler1 = new TestWorkItemHandler();
        TestWorkItemHandler handler2 = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("task1", (WorkItemHandler)handler1);
        this.ksession.getWorkItemManager().registerWorkItemHandler("task2", (WorkItemHandler)handler2);
        ProcessInstance instance = this.ksession.createProcessInstance("timer-process", new HashMap());
        this.ksession.startProcessInstance(instance.getId());
        WorkItem workItem1 = handler1.getWorkItem();
        Assert.assertNotNull((Object)workItem1);
        Assert.assertNull((Object)handler1.getWorkItem());
        this.ksession.getWorkItemManager().completeWorkItem(workItem1.getId(), null);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)countDownListener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("task1", (WorkItemHandler)handler1);
        this.ksession.getWorkItemManager().registerWorkItemHandler("task2", (WorkItemHandler)handler2);
        countDownListener.waitTillCompleted();
        WorkItem workItem2 = handler2.getWorkItem();
        Assert.assertNotNull((Object)workItem2);
        Assert.assertNull((Object)handler2.getWorkItem());
        this.ksession.getWorkItemManager().completeWorkItem(workItem2.getId(), null);
        this.assertProcessInstanceCompleted(instance);
    }

    private static class GetProcessVariableCommand
    implements ExecutableCommand<Object> {
        private long processInstanceId;
        private String variableName;

        public GetProcessVariableCommand(long processInstanceId, String variableName) {
            this.processInstanceId = processInstanceId;
            this.variableName = variableName;
        }

        public Object execute(Context context) {
            KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
            org.jbpm.process.instance.ProcessInstance processInstance = (org.jbpm.process.instance.ProcessInstance)ksession.getProcessInstance(this.processInstanceId);
            VariableScopeInstance variableScope = (VariableScopeInstance)processInstance.getContextInstance("VariableScope");
            Object variable = variableScope.getVariable(this.variableName);
            return variable;
        }
    }
}

